/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.courseware;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiahulian.common.permission.AppPermissions;
import com.baijiayun.bjyutils.TimeUtilsKt;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.FileUtils;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.widgets.view.StateTextView;
import com.baijiayun.livecore.models.LPDocModel;
import com.baijiayun.livecore.models.LPDocTranslateProgressModel;
import com.baijiayun.livecore.models.LPUploadDocumentUserModel;
import com.baijiayun.livecore.models.courseware.LPCoursewareModel;
import com.baijiayun.livecore.models.file.cloudfile.LPCloudFileModel;
import com.baijiayun.livecore.models.file.homework.LPHomeworkModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseUIConstant;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.widgets.common.ProgressCircleView;
import com.baijiayun.liveuibase.widgets.courseware.HomeworkSaveUtil;
import com.baijiayun.liveuibase.widgets.courseware.models.DownloadHomeworkModel;
import com.baijiayun.liveuibase.widgets.courseware.models.UploadDocModel;
import com.baijiayun.liveuibase.widgets.popupwindow.ErrorDesPopupWindow;
import io.reactivex.disposables.Disposable;
import java.io.File;
import java.io.IOException;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class BaseCourseWareFileViewHolder
extends RecyclerView.ViewHolder {
    private static final String TAG = BaseCourseWareFileViewHolder.class.getSimpleName();
    private final int undefinedFileSize = -1;
    private View vSticky;
    private ImageView ivFileIcon;
    private TextView tvFileName;
    private TextView tvFileCommonUploadTime;
    private Context mContext;
    private View mView;
    private boolean mIsTeacherOrAssistant;
    private boolean mIsNewSmallGroup;
    private IOnDocItemClickListener onItemClickListener;
    private boolean isAnim;
    private boolean isPort;
    private boolean isPublicFile = false;
    private DownloadHomeworkModel downloadHomeworkModel;
    private RelativeLayout docContainer;
    private ImageView ivDocRelate;
    private ImageView ivDocDelete;
    private ImageView ivDocPlay;
    private TextView tvDocSize;
    private TextView tvDocUserName;
    private ImageView ivDocMore;
    private ImageView ivDocPreview;
    private ViewGroup uploadContainer;
    private StateTextView tvUploadFileState;
    private ImageView ivUploadDelete;
    private ImageView ivUploadReUpload;
    private ImageView ivUploadByNormal;
    private TextView tvUploadFailDir;
    private TextView tvUploadCancel;
    private boolean canReUpload = false;
    private LPDocTranslateProgressModel errorModel;
    private ErrorDesPopupWindow errorDesPopupWindow;
    private BaseUIConstant.FileUploadState mNowState;
    RelativeLayout cloudContainer;
    private ImageView ivCloudDelete;
    private TextView tvCloudSize;
    private TextView tvCloudTime;
    private ImageView ivCloudPlay;
    private ImageView ivCloudMore;
    boolean isCloudDirectory;
    private RelativeLayout homeworkContainer;
    private ImageView ivHomeworkDelete;
    private ImageView ivHomeworkOpenFile;
    private ImageView ivHomeworkDownload;
    private ProgressCircleView ivHomeworkDownloadProgress;
    private ImageView ivHomeworkPlay;
    private TextView tvHomeworkUploadTime;
    private TextView tvHomeworkUserName;
    private TextView tvHomeworkSize;
    private ImageView ivHomeworkMore;
    private ImageView ivHomeworkPreview;
    private LPHomeworkModel mHomeworkModel;
    public Disposable disposableOfPermission;
    private BaseUIConstant.HomeworkDownloadState homeworkDownloadState = BaseUIConstant.HomeworkDownloadState.NotExit;

    public BaseCourseWareFileViewHolder(View itemView, boolean isTeacherOrAssistant, boolean isNewSmallGroup) {
        super(itemView);
        this.mContext = itemView.getContext();
        this.mView = itemView;
        this.mIsTeacherOrAssistant = isTeacherOrAssistant;
        this.mIsNewSmallGroup = isNewSmallGroup;
        this.vSticky = this.findView(R.id.base_course_file_item_sticky_icon);
        this.ivFileIcon = (ImageView)this.findView(R.id.base_course_file_item_icon);
        this.tvFileName = (TextView)this.findView(R.id.base_course_file_item_name);
        this.tvFileCommonUploadTime = (TextView)this.findView(R.id.base_course_common_upload_time);
        this.isPort = this.mContext.getResources().getConfiguration().orientation == 1;
        this.initDocView();
        this.initUploadingView();
        this.initHomeworkView();
        this.initCloudView();
    }

    public void initDocModel(LPCoursewareModel coursewareModel) {
        this.docContainer.setVisibility(0);
        this.uploadContainer.setVisibility(8);
        this.homeworkContainer.setVisibility(8);
        this.cloudContainer.setVisibility(8);
        this.initUploadSrc(coursewareModel.bindSource == 0);
        this.ivDocDelete.setEnabled(coursewareModel.bindSource == 0);
        if (this.mIsNewSmallGroup && this.mIsTeacherOrAssistant) {
            this.ivDocPreview.setVisibility(FileUtils.checkPreviewFileValid((String)coursewareModel.name) || FileUtils.isImageFile((String)coursewareModel.name) ? 0 : 4);
        }
        if (coursewareModel.coursewareType == LPCoursewareModel.LPCoursewareType.DOC) {
            LPDocModel docModel = (LPDocModel)coursewareModel;
            this.setIsAnim(!TextUtils.isEmpty((CharSequence)docModel.pptUrl));
            if (docModel.isEnableRecord) {
                this.setNameAndType(coursewareModel.name);
                this.ivDocPlay.setEnabled(false);
                this.ivDocPlay.setAlpha(0.3f);
                this.ivDocPreview.setVisibility(4);
                this.setFileSize(this.tvDocSize, -1L);
                return;
            }
        } else {
            this.setIsAnim(false);
        }
        this.setFileName(coursewareModel.name);
        String ext = coursewareModel.ext;
        int indexOf = coursewareModel.name.lastIndexOf(".");
        if (indexOf != -1) {
            ext = coursewareModel.name.substring(indexOf);
        }
        this.setFileType(ext);
        this.ivDocPlay.setEnabled(true);
        this.ivDocPlay.setAlpha(1.0f);
        this.setFileUserName(this.tvDocUserName, coursewareModel.userModel);
        this.setFileSize(this.tvDocSize, coursewareModel.size);
        this.setTextView(this.tvFileCommonUploadTime, TimeUtilsKt.formatDataFromSecond((long)coursewareModel.lastModified));
    }

    public void initDocModel(UploadDocModel uploadDocModel) {
        this.docContainer.setVisibility(8);
        this.uploadContainer.setVisibility(0);
        this.homeworkContainer.setVisibility(8);
        this.cloudContainer.setVisibility(8);
        this.setIsAnim(uploadDocModel.isAnim());
        try {
            String[] fragments = uploadDocModel.getPath().split("/");
            this.setNameAndType(fragments[fragments.length - 1]);
        }
        catch (Exception e) {
            this.setFileName("\u672a\u77e5\u6587\u4ef6");
            this.setFileType("");
        }
        this.setFileState(uploadDocModel.getNowState());
        this.errorModel = uploadDocModel.getErrorModel();
        if (this.errorModel != null) {
            this.checkErrorType(this.errorModel.errorType);
            this.ivUploadReUpload.setVisibility(this.canReUpload ? 0 : 8);
            this.ivUploadByNormal.setVisibility(this.canReUpload && this.isAnim ? 0 : 8);
        }
    }

    public void initDocModel(LPHomeworkModel homeworkModel) {
        boolean needSticky;
        this.docContainer.setVisibility(8);
        this.uploadContainer.setVisibility(8);
        this.homeworkContainer.setVisibility(0);
        this.cloudContainer.setVisibility(8);
        this.setFileName(homeworkModel.getName());
        this.setFileType(homeworkModel.getFext());
        this.setIsAnim(homeworkModel.isAnim());
        this.setFileSize(this.tvHomeworkSize, homeworkModel.getSize());
        this.setTextView(this.tvHomeworkUserName, homeworkModel.getUserModel().getUserName());
        this.setTextView(this.tvHomeworkUploadTime, TimeUtilsKt.formatDataFromSecond((long)homeworkModel.getLastModifiedTime()));
        this.setTextView(this.tvFileCommonUploadTime, TimeUtilsKt.formatDataFromSecond((long)homeworkModel.getLastModifiedTime()));
        this.ivHomeworkPlay.setVisibility(!DisplayUtils.isPortrait((Context)this.mContext) && homeworkModel.isCanPreview() ? 0 : 4);
        boolean bl = needSticky = homeworkModel.getBindSource() == 1 || homeworkModel.getUserModel().getUserType() == LPConstants.LPUserType.Teacher || homeworkModel.getUserModel().getUserType() == LPConstants.LPUserType.Assistant;
        if (needSticky) {
            this.vSticky.setVisibility(0);
            this.mView.setBackground((Drawable)new ColorDrawable(ContextCompat.getColor((Context)this.mContext, (int)R.color.base_divider_line_other)));
        }
        this.ivHomeworkDelete.setEnabled(homeworkModel.getBindSource() == 0);
        this.mHomeworkModel = homeworkModel;
        if (!this.mIsTeacherOrAssistant) {
            this.ivHomeworkDelete.setVisibility(8);
            this.ivHomeworkPlay.setVisibility(8);
        }
        if (this.mIsNewSmallGroup && this.mIsTeacherOrAssistant) {
            boolean isCanPreview = !(!FileUtils.checkPreviewFileValid((String)homeworkModel.getName()) && !FileUtils.isImageFile((String)homeworkModel.getName()) || homeworkModel.getUserModel().userType != LPConstants.LPUserType.Teacher && homeworkModel.getBindSource() != 1 && homeworkModel.getUserModel().userType != LPConstants.LPUserType.Assistant || !homeworkModel.isCanPreview());
            this.ivHomeworkPreview.setVisibility(isCanPreview ? 0 : 4);
        }
    }

    public void initDocModel(LPCloudFileModel cloudFileModel) {
        this.docContainer.setVisibility(8);
        this.uploadContainer.setVisibility(8);
        this.homeworkContainer.setVisibility(8);
        this.cloudContainer.setVisibility(0);
        this.setFileName(cloudFileModel.getName());
        this.isCloudDirectory = cloudFileModel.isDirectory();
        if (cloudFileModel.isDirectory()) {
            this.setIcon(R.drawable.base_course_ware_type_directory);
            this.setTextView(this.tvCloudSize, "-");
            if (this.isPort) {
                this.ivCloudMore.setVisibility(8);
            } else {
                this.ivCloudPlay.setVisibility(4);
                this.ivCloudDelete.setVisibility(4);
            }
        } else {
            String ext = cloudFileModel.getFExt();
            int indexOf = cloudFileModel.getName().lastIndexOf(".");
            if (indexOf != -1) {
                ext = cloudFileModel.getName().substring(indexOf);
            }
            this.setFileType(ext);
            this.setIsAnim(cloudFileModel.getFileType() == LPConstants.LPFileType.Anim);
            long size = 0L;
            try {
                size = cloudFileModel.getSize();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.setFileSize(this.tvCloudSize, size);
            if (this.isPort) {
                this.ivCloudMore.setVisibility(0);
                this.isPublicFile = cloudFileModel.isPublicFile();
            } else {
                this.ivCloudPlay.setVisibility(0);
                this.ivCloudDelete.setVisibility(cloudFileModel.isPublicFile() ? 4 : 0);
            }
        }
        this.setTextView(this.tvCloudTime, TimeUtilsKt.formatDataFromSecond((long)cloudFileModel.getCreateTime()));
        this.setTextView(this.tvFileCommonUploadTime, TimeUtilsKt.formatDataFromSecond((long)cloudFileModel.getCreateTime()));
    }

    public void resetView() {
        if (this.downloadHomeworkModel != null) {
            this.downloadHomeworkModel.setItemView(null);
            this.downloadHomeworkModel = null;
        }
        this.updateDownloadProgress(0.0f);
        this.vSticky.setVisibility(8);
        this.mView.setBackground(null);
        this.initUploadSrc(true);
        this.resetDownLoadProgress();
        this.setIsAnim(false);
    }

    public void setOnItemClickListener(IOnDocItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setFileState(BaseUIConstant.FileUploadState state) {
        this.mNowState = state;
        this.ivUploadDelete.setVisibility(state == BaseUIConstant.FileUploadState.Uploading ? 4 : 0);
        this.ivUploadReUpload.setVisibility(state.isFailed() ? 0 : 4);
        this.tvUploadFailDir.setVisibility(state.isFailed() ? 0 : 4);
        this.ivUploadByNormal.setVisibility(state.isFailed() && this.isAnim ? 0 : 4);
        this.tvUploadFileState.setEnabled(!state.isFailed());
        this.tvUploadCancel.setVisibility(state == BaseUIConstant.FileUploadState.Uploading ? 0 : 8);
        switch (state) {
            case UploadSuccess: {
                this.setTextView((TextView)this.tvUploadFileState, this.mContext.getString(R.string.base_course_manage_upload_state_ok));
                break;
            }
            case Translating: {
                this.setTextView((TextView)this.tvUploadFileState, this.mContext.getString(R.string.base_course_manage_upload_state_translating));
                break;
            }
            case Uploading: {
                this.setTextView((TextView)this.tvUploadFileState, this.mContext.getString(R.string.base_course_manage_upload_state_uploading));
                break;
            }
            case TranslateFailed: {
                this.setTextView((TextView)this.tvUploadFileState, this.mContext.getString(R.string.base_course_manage_upload_state_translate_failed));
                break;
            }
            case UploadFailed: {
                this.setTextView((TextView)this.tvUploadFileState, this.mContext.getString(R.string.base_course_manage_upload_state_upload_failed));
                break;
            }
        }
    }

    public void setDownloadHomeworkModel(DownloadHomeworkModel downloadHomeworkModel) {
        this.downloadHomeworkModel = downloadHomeworkModel;
    }

    public void updateDownloadProgress(float progress) {
        if (progress > 0.0f) {
            this.ivHomeworkDownloadProgress.setVisibility(0);
        }
        this.ivHomeworkDownloadProgress.setRatio(progress);
    }

    public void showDownLoadFailed() {
        File file = this.checkHomeworkFile(this.mHomeworkModel);
        if (this.homeworkDownloadState == BaseUIConstant.HomeworkDownloadState.Downloading) {
            boolean rst = file.delete();
            if (rst) {
                this.checkHomeworkFile(this.mHomeworkModel);
                this.updateDownloadProgress(0.0f);
                this.ivHomeworkDownloadProgress.setVisibility(4);
                this.ivHomeworkDownload.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.base_ic_course_ware_download_fail));
            }
            this.homeworkDownloadState = BaseUIConstant.HomeworkDownloadState.DownloadFailed;
            this.updateMoreVisibility();
        }
    }

    public void resetDownLoadProgress() {
        this.ivHomeworkDownload.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.base_ic_course_ware_download));
        this.updateDownloadProgress(0.0f);
    }

    private void setFileSize(TextView tv, long kbSize) {
        if (kbSize == -1L) {
            this.setTextView(tv, "-");
        } else {
            float size = (float)kbSize / 1024.0f;
            DecimalFormat df = new DecimalFormat("0.00");
            df.setRoundingMode(RoundingMode.HALF_UP);
            if (size < 1024.0f) {
                this.setTextView(tv, df.format(size) + "K");
            } else {
                this.setTextView(tv, df.format(size / 1024.0f) + "M");
            }
        }
    }

    private void setFileUserName(TextView tv, LPUploadDocumentUserModel userModel) {
        if (userModel == null) {
            this.setTextView(tv, "");
        } else {
            this.setTextView(tv, userModel.userName);
        }
    }

    private void setFileName(String fileName) {
        this.setTextView(this.tvFileName, fileName);
    }

    private void initUploadSrc(boolean uploadByLocal) {
        this.ivDocRelate.setVisibility(uploadByLocal ? 8 : 0);
    }

    private void setFileType(String ext) {
        if (TextUtils.isEmpty((CharSequence)ext) || !ext.contains(".")) {
            this.setIcon(R.drawable.base_course_ware_type_error);
        } else {
            switch (ext.toLowerCase()) {
                case ".ppt": 
                case ".pptx": {
                    if (this.isAnim) {
                        this.setIcon(R.drawable.base_course_ware_type_ppt_anim);
                        break;
                    }
                    this.setIcon(R.drawable.base_course_ware_type_ppt_static);
                    break;
                }
                case ".txt": {
                    this.setIcon(R.drawable.base_course_ware_type_txt);
                    break;
                }
                case ".xls": {
                    this.setIcon(R.drawable.base_course_ware_type_xls);
                    break;
                }
                case ".doc": 
                case ".docx": {
                    this.setIcon(R.drawable.base_course_ware_type_doc);
                    break;
                }
                case ".pdf": {
                    this.setIcon(R.drawable.base_course_ware_type_pdf);
                    break;
                }
                case ".zip": 
                case ".bjon": {
                    this.setIcon(R.drawable.base_course_ware_type_zip);
                    break;
                }
                case ".png": 
                case ".jpg": 
                case ".jpeg": 
                case ".webp": 
                case ".bmp": {
                    this.setIcon(R.drawable.base_course_ware_type_img);
                    break;
                }
                case ".mp3": 
                case ".wav": 
                case ".wma": 
                case ".aac": 
                case ".flac": 
                case ".m4a": 
                case ".oga": 
                case ".opus": {
                    this.setIcon(R.drawable.base_course_ware_type_audio);
                    break;
                }
                case ".mp4": 
                case ".3gp": 
                case ".mpg": 
                case ".mpeg": 
                case ".3g2": 
                case ".avi": 
                case ".flv": 
                case ".wmv": 
                case ".h264": 
                case ".m4v": 
                case ".mj2": 
                case ".mov": 
                case ".ogg": 
                case ".ogv": 
                case ".rm": 
                case ".rmvb": 
                case ".qt": 
                case ".webm": {
                    this.setIcon(R.drawable.base_course_ware_type_video);
                    break;
                }
                case ".html": {
                    this.setIcon(R.drawable.base_course_ware_type_h5);
                    break;
                }
                case ".bds": {
                    this.setIcon(R.drawable.base_course_ware_type_bds);
                    break;
                }
                default: {
                    this.setIcon(R.drawable.base_course_ware_type_error);
                }
            }
        }
    }

    private void setIcon(int resId) {
        this.ivFileIcon.setImageResource(resId);
    }

    private void setIsAnim(boolean isAnim) {
        this.isAnim = isAnim;
        if (isAnim) {
            this.ivFileIcon.setImageResource(R.drawable.base_course_ware_type_ppt_anim);
        }
    }

    private void setTextView(TextView textView, String string2) {
        if (textView != null) {
            textView.setText((CharSequence)string2);
        }
    }

    private void setNameAndType(String wholeName) {
        String[] values = wholeName.split("\\.");
        if (values.length > 0) {
            this.setFileName(wholeName.substring(0, wholeName.length() - values[values.length - 1].length() - 1));
            this.setFileType("." + values[values.length - 1]);
        }
    }

    private String checkErrorType(int errorType) {
        if (errorType != 10012 && errorType != 10011 && errorType != -1) {
            this.canReUpload = true;
        }
        switch (errorType) {
            case -1: {
                return this.errorModel.errMsg;
            }
            case 10001: {
                return "\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25";
            }
            case 10002: {
                return "office\u8f6cPDF\u5931\u8d25";
            }
            case 10003: {
                return "pdf\u8f6cpng\u5931\u8d25";
            }
            case 10005: {
                return "\u52a8\u753b\u8f6chtml\u5931\u8d25";
            }
            case 10004: {
                return "\u4e0a\u4f20\u9759\u6001\u6587\u4ef6\u5931\u8d25";
            }
            case 10006: {
                return "\u6253\u5305\u52a8\u753b\u6587\u4ef6\u5931\u8d25";
            }
            case 10007: {
                return "\u538b\u7f29\u52a8\u753b\u6587\u4ef6\u5931\u8d25";
            }
            case 10008: {
                return "\u4e0a\u4f20\u52a8\u753b\u538b\u7f29\u6587\u4ef6\u5931\u8d25";
            }
            case 10009: {
                return "\u4e0a\u4f20\u52a8\u753bhtml\u5931\u8d25";
            }
            case 10010: {
                return "\u8f6c\u7801\u5931\u8d25";
            }
            case 10011: {
                return "\u6587\u4ef6\u88ab\u52a0\u5bc6\uff0c\u8bf7\u4e0a\u4f20\u975e\u52a0\u5bc6\u6587\u4ef6";
            }
            case 10012: {
                return "\u8bf7\u5220\u9664\u9690\u85cf\u9875\u6216\u53e6\u5b58\u4e3apptx\u683c\u5f0f\u6587\u4ef6";
            }
        }
        return "\u672a\u77e5\u9519\u8bef";
    }

    void initDocView() {
        this.docContainer = (RelativeLayout)this.findView(R.id.base_course_file_item_doc_container);
        this.ivDocPlay = (ImageView)this.findView(R.id.base_course_file_item_doc_play);
        this.ivDocDelete = (ImageView)this.findView(R.id.base_course_file_item_doc_delete);
        this.ivDocRelate = (ImageView)this.findView(R.id.base_course_file_item_doc_is_relate);
        this.tvDocSize = (TextView)this.findView(R.id.base_course_file_item_doc_size);
        this.tvDocUserName = (TextView)this.findView(R.id.base_course_file_item_doc_user_name);
        this.ivDocMore = (ImageView)this.findView(R.id.base_course_file_item_doc_more);
        this.ivDocPreview = (ImageView)this.findView(R.id.base_course_file_item_doc_preview);
        this.ivDocPlay.setOnClickListener(v -> {
            if (this.onItemClickListener != null) {
                this.onItemClickListener.onPlay();
            }
        });
        this.ivDocDelete.setOnClickListener(v -> {
            if (this.onItemClickListener != null) {
                this.onItemClickListener.onDelete(this.errorModel == null ? "" : this.errorModel.fid);
            }
        });
        this.ivDocPreview.setOnClickListener(v -> {
            if (this.onItemClickListener != null) {
                this.onItemClickListener.onPreview();
            }
        });
        this.ivDocMore.setOnClickListener(v -> this.showDocMorePopupWindow());
        this.ivDocPreview.setVisibility(this.mIsNewSmallGroup && this.mIsTeacherOrAssistant ? 0 : 8);
    }

    protected void showDocMorePopupWindow() {
        View view = View.inflate((Context)this.mContext, (int)R.layout.popup_window_courseware_item_more_layout, null);
        view.setBackground(ThemeDataUtil.getPopWindowBg((Context)this.mContext));
        PopupWindow createPopupWindow = new PopupWindow(view);
        view.findViewById(R.id.window_course_ware_play).setOnClickListener(v -> {
            createPopupWindow.dismiss();
            this.ivDocPlay.performClick();
        });
        view.findViewById(R.id.window_course_ware_delete).setOnClickListener(v -> {
            createPopupWindow.dismiss();
            this.ivDocDelete.performClick();
        });
        view.findViewById(R.id.window_course_ware_download).setVisibility(8);
        view.findViewById(R.id.popup_window_divider_line).setVisibility(8);
        createPopupWindow.setWidth(UtilsKt.getDp((int)120));
        createPopupWindow.setHeight(-2);
        createPopupWindow.setFocusable(true);
        createPopupWindow.showAsDropDown((View)this.ivDocMore);
        this.updateWindowPositionWithoutEnoughHeight(createPopupWindow, (View)this.ivDocMore);
    }

    void initUploadingView() {
        this.uploadContainer = (ViewGroup)this.findView(R.id.base_course_file_item_uploading_container);
        this.tvUploadFileState = (StateTextView)this.findView(R.id.base_course_file_item_state);
        this.ivUploadDelete = (ImageView)this.findView(R.id.base_course_file_item_delete_uploading);
        this.ivUploadReUpload = (ImageView)this.findView(R.id.base_course_file_item_re_upload);
        this.ivUploadByNormal = (ImageView)this.findView(R.id.base_course_file_item_upload_by_normal);
        this.tvUploadFailDir = (TextView)this.findView(R.id.base_course_file_item_fail_dir);
        this.tvUploadCancel = (TextView)this.findView(R.id.base_course_file_item_upload_cancel);
        this.tvUploadCancel.setOnClickListener(v -> ((IOnUploadItemClickListener)this.onItemClickListener).onCancelUpload());
        this.ivUploadDelete.setOnClickListener(v -> {
            if (this.onItemClickListener != null) {
                if (this.mNowState == BaseUIConstant.FileUploadState.Translating) {
                    ((IOnUploadItemClickListener)this.onItemClickListener).onCancelTransfer();
                } else if (this.errorModel != null) {
                    this.onItemClickListener.onDelete(this.errorModel.fid);
                }
            }
        });
        this.tvUploadFailDir.setOnClickListener(v -> {
            if (this.errorModel == null) {
                return;
            }
            if (this.errorDesPopupWindow == null) {
                this.errorDesPopupWindow = new ErrorDesPopupWindow(this.mContext);
            }
            this.errorDesPopupWindow.updateErrorMsg(this.checkErrorType(this.errorModel.errorType));
            this.errorDesPopupWindow.show((View)this.tvUploadFailDir);
        });
        this.ivUploadByNormal.setOnClickListener(v -> {
            if (this.onItemClickListener instanceof IOnUploadItemClickListener) {
                ((IOnUploadItemClickListener)this.onItemClickListener).onUploadByNormal();
            }
        });
        this.ivUploadReUpload.setOnClickListener(v -> {
            if (this.onItemClickListener instanceof IOnUploadItemClickListener && this.errorModel != null) {
                ((IOnUploadItemClickListener)this.onItemClickListener).onReUpload(this.errorModel.fid);
            }
        });
    }

    void initCloudView() {
        this.cloudContainer = (RelativeLayout)this.findView(R.id.base_course_file_item_cloud_container);
        this.ivCloudPlay = (ImageView)this.findView(R.id.base_course_file_item_cloud_play);
        this.ivCloudDelete = (ImageView)this.findView(R.id.base_course_file_item_cloud_delete);
        this.tvCloudSize = (TextView)this.findView(R.id.base_course_file_item_cloud_size);
        this.tvCloudTime = (TextView)this.findView(R.id.base_course_file_item_cloud_upload_time);
        this.ivCloudMore = (ImageView)this.findView(R.id.base_course_file_item_cloud_more);
        this.ivCloudPlay.setOnClickListener(v -> this.onItemClickListener.onPlay());
        this.ivCloudDelete.setOnClickListener(v -> this.onItemClickListener.onDelete(""));
        this.ivCloudMore.setOnClickListener(v -> this.showCloudMorePopupWindow());
        this.mView.setOnClickListener(v -> {
            if (this.isCloudDirectory && this.onItemClickListener instanceof IOnCloudItemClickListener) {
                ((IOnCloudItemClickListener)this.onItemClickListener).onClickDirectory();
            }
        });
    }

    protected void showCloudMorePopupWindow() {
        View view = View.inflate((Context)this.mContext, (int)R.layout.popup_window_courseware_item_more_layout, null);
        view.setBackground(ThemeDataUtil.getPopWindowBg((Context)this.mContext));
        PopupWindow createPopupWindow = new PopupWindow(view);
        view.findViewById(R.id.window_course_ware_play).setOnClickListener(v -> {
            createPopupWindow.dismiss();
            this.ivCloudPlay.performClick();
        });
        view.findViewById(R.id.window_course_ware_delete).setOnClickListener(v -> {
            createPopupWindow.dismiss();
            this.ivCloudDelete.performClick();
        });
        view.findViewById(R.id.window_course_ware_download).setVisibility(8);
        view.findViewById(R.id.popup_window_divider_line).setVisibility(8);
        view.findViewById(R.id.window_course_ware_delete).setVisibility(this.isPublicFile ? 8 : 0);
        view.findViewById(R.id.popup_window_divider_line_2).setVisibility(this.isPublicFile ? 8 : 0);
        createPopupWindow.setWidth(UtilsKt.getDp((int)120));
        createPopupWindow.setHeight(-2);
        createPopupWindow.setFocusable(true);
        createPopupWindow.showAsDropDown((View)this.ivCloudMore);
        this.updateWindowPositionWithoutEnoughHeight(createPopupWindow, (View)this.ivCloudMore);
    }

    void initHomeworkView() {
        this.homeworkContainer = (RelativeLayout)this.findView(R.id.base_course_file_item_homework_container);
        this.ivHomeworkDelete = (ImageView)this.findView(R.id.base_course_file_item_delete_homework);
        this.ivHomeworkOpenFile = (ImageView)this.findView(R.id.base_course_file_item_open_file);
        this.ivHomeworkDownload = (ImageView)this.findView(R.id.base_course_file_item_download);
        this.ivHomeworkDownloadProgress = (ProgressCircleView)((Object)this.findView(R.id.base_course_file_item_download_progress));
        this.updateDownloadProgress(0.0f);
        this.ivHomeworkPlay = (ImageView)this.findView(R.id.base_course_file_item_play_homework);
        this.tvHomeworkUploadTime = (TextView)this.findView(R.id.base_course_file_item_homework_upload_time);
        this.tvHomeworkUserName = (TextView)this.findView(R.id.base_course_file_item_homework_upload_user_name);
        this.tvHomeworkSize = (TextView)this.findView(R.id.base_course_file_item_size_homework);
        this.ivHomeworkMore = (ImageView)this.findView(R.id.base_course_file_item_homework_more);
        this.ivHomeworkPreview = (ImageView)this.findView(R.id.base_course_file_item_preview_homework);
        this.ivHomeworkPlay.setOnClickListener(v -> {
            if (this.onItemClickListener != null) {
                this.onItemClickListener.onPlay();
            }
        });
        this.ivHomeworkDelete.setOnClickListener(v -> {
            if (this.onItemClickListener != null) {
                this.onItemClickListener.onDelete(this.mHomeworkModel.getHomeworkId());
            }
        });
        String[] permissions = Build.VERSION.SDK_INT >= 33 ? new String[]{"android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO", "android.permission.READ_MEDIA_AUDIO"} : new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
        this.ivHomeworkOpenFile.setOnClickListener(v -> {
            if (this.mContext instanceof Activity) {
                RxUtils.dispose((Disposable)this.disposableOfPermission);
                this.disposableOfPermission = AppPermissions.newPermissions((Activity)((Activity)this.mContext)).request(permissions).subscribe(aBoolean -> {
                    if (aBoolean.booleanValue()) {
                        this.openFile();
                    } else {
                        ToastCompat.showToast((Context)this.mContext, (CharSequence)this.mContext.getString(R.string.live_no_write_permission), (int)0);
                    }
                });
            } else {
                this.openFile();
            }
        });
        this.ivHomeworkDownload.setOnClickListener(v -> this.ivHomeworkDownloadProgress.performClick());
        this.ivHomeworkDownloadProgress.setOnClickListener(v -> {
            if (this.mContext instanceof Activity) {
                RxUtils.dispose((Disposable)this.disposableOfPermission);
                this.disposableOfPermission = AppPermissions.newPermissions((Activity)((Activity)this.mContext)).request(permissions).subscribe(aBoolean -> {
                    if (aBoolean.booleanValue()) {
                        this.download();
                    } else {
                        ToastCompat.showToast((Context)this.mContext, (CharSequence)this.mContext.getString(R.string.live_no_write_permission), (int)0);
                    }
                });
            } else {
                this.download();
            }
        });
        this.ivHomeworkMore.setOnClickListener(v -> this.showHomeworkMorePopupWindow());
        this.ivHomeworkPreview.setOnClickListener(v -> {
            if (this.onItemClickListener != null) {
                this.onItemClickListener.onPreview();
            }
        });
        this.ivHomeworkPreview.setVisibility(this.mIsNewSmallGroup && this.mIsTeacherOrAssistant ? 0 : 8);
        this.ivHomeworkMore.post(this::updateMoreVisibility);
    }

    private void updateMoreVisibility() {
        int visibility = !this.isPort || this.mHomeworkModel == null || !this.mHomeworkModel.isCanPreview() && this.homeworkDownloadState == BaseUIConstant.HomeworkDownloadState.HasDownload && !this.mIsTeacherOrAssistant ? 4 : 0;
        this.ivHomeworkMore.setVisibility(visibility);
    }

    private void openFile() {
        File file = this.checkHomeworkFile(this.mHomeworkModel);
        if (file == null || this.homeworkDownloadState != BaseUIConstant.HomeworkDownloadState.HasDownload) {
            this.updateDownloadProgress(0.0f);
        } else {
            BaseUtilsKt.openFileInSystem(this.mContext, file);
        }
    }

    private void download() {
        File file;
        if (this.homeworkDownloadState == BaseUIConstant.HomeworkDownloadState.DownloadFailed) {
            this.resetDownLoadProgress();
        }
        if ((file = this.checkHomeworkFile(this.mHomeworkModel)) == null || this.homeworkDownloadState == BaseUIConstant.HomeworkDownloadState.HasDownload) {
            return;
        }
        if (this.homeworkDownloadState == BaseUIConstant.HomeworkDownloadState.Downloading) {
            ((IOnHomeworkItemClickListener)this.onItemClickListener).onCancelDownload(file);
        } else {
            try {
                boolean createRst = file.createNewFile();
                if (createRst && this.onItemClickListener instanceof IOnHomeworkItemClickListener) {
                    this.updateDownloadProgress(0.01f);
                    ((IOnHomeworkItemClickListener)this.onItemClickListener).onDownload(file);
                } else {
                    LPLogger.d((String)TAG, (String)"\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
                }
            }
            catch (IOException e) {
                LPLogger.d((String)TAG, (String)("\u6587\u4ef6\u521b\u5efa\u5931\u8d25 : " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    protected void showHomeworkMorePopupWindow() {
        View view = View.inflate((Context)this.mContext, (int)R.layout.popup_window_courseware_item_more_layout, null);
        view.setBackground(ThemeDataUtil.getPopWindowBg((Context)this.mContext));
        PopupWindow createPopupWindow = new PopupWindow(view);
        view.findViewById(R.id.window_course_ware_play).setOnClickListener(v -> {
            createPopupWindow.dismiss();
            this.ivHomeworkPlay.performClick();
        });
        view.findViewById(R.id.window_course_ware_delete).setOnClickListener(v -> {
            createPopupWindow.dismiss();
            this.ivHomeworkDelete.performClick();
        });
        view.findViewById(R.id.window_course_ware_download).setOnClickListener(v -> {
            createPopupWindow.dismiss();
            this.ivHomeworkDownloadProgress.performClick();
        });
        boolean isPlay = this.mIsTeacherOrAssistant && this.mHomeworkModel.isCanPreview();
        boolean isDelete = this.mIsTeacherOrAssistant;
        boolean isDownloaded = this.homeworkDownloadState == BaseUIConstant.HomeworkDownloadState.HasDownload;
        view.findViewById(R.id.window_course_ware_play).setVisibility(isPlay ? 0 : 8);
        view.findViewById(R.id.window_course_ware_delete).setVisibility(isDelete ? 0 : 8);
        view.findViewById(R.id.window_course_ware_download).setVisibility(isDownloaded ? 8 : 0);
        view.findViewById(R.id.popup_window_divider_line).setVisibility(isPlay ? 0 : 8);
        view.findViewById(R.id.popup_window_divider_line_2).setVisibility(isDelete && !isDownloaded ? 0 : 8);
        createPopupWindow.setWidth(UtilsKt.getDp((int)120));
        createPopupWindow.setHeight(-2);
        createPopupWindow.setFocusable(true);
        createPopupWindow.showAsDropDown((View)this.ivHomeworkMore);
        this.updateWindowPositionWithoutEnoughHeight(createPopupWindow, (View)this.ivHomeworkMore);
    }

    private void updateWindowPositionWithoutEnoughHeight(PopupWindow window2, View dropView) {
        window2.getContentView().measure(0, 0);
        int screenHeight = DisplayUtils.getScreenHeightPixels((Context)this.mContext);
        int[] location = new int[2];
        dropView.getLocationOnScreen(location);
        int realWindowHeight = window2.getContentView().getMeasuredHeight();
        if (location[1] + realWindowHeight > screenHeight) {
            window2.update(dropView, 0, -realWindowHeight - dropView.getHeight(), -1, -1);
        }
    }

    public File checkHomeworkFile(LPHomeworkModel homeworkModel) {
        if (homeworkModel == null) {
            return null;
        }
        this.homeworkDownloadState = BaseUIConstant.HomeworkDownloadState.NotExit;
        String fileName = HomeworkSaveUtil.getHomeworkFileName(homeworkModel);
        File dir = new File(BaseUIConstant.HOMEWORK_DIR_PATH);
        boolean createRst = false;
        if (!dir.exists()) {
            createRst = dir.mkdirs();
        }
        if (!dir.exists() && !createRst) {
            return null;
        }
        File homeworkFile = new File(BaseUIConstant.HOMEWORK_DIR_PATH + fileName + homeworkModel.getFext());
        if (homeworkFile.exists()) {
            this.ivHomeworkDownloadProgress.setVisibility(8);
            if (!this.isPort) {
                this.ivHomeworkDownload.setVisibility(4);
            }
            this.ivHomeworkOpenFile.setVisibility(0);
            this.homeworkDownloadState = BaseUIConstant.HomeworkDownloadState.HasDownload;
            this.updateMoreVisibility();
            return homeworkFile;
        }
        if (TextUtils.isEmpty((CharSequence)homeworkModel.getFext())) {
            return null;
        }
        File homeworkFileDownloading = new File(BaseUIConstant.HOMEWORK_DIR_PATH + fileName);
        if (homeworkFileDownloading.exists()) {
            this.ivHomeworkDownloadProgress.setVisibility(0);
            if (!this.isPort) {
                this.ivHomeworkDownload.setVisibility(0);
            }
            this.ivHomeworkOpenFile.setVisibility(8);
            this.homeworkDownloadState = BaseUIConstant.HomeworkDownloadState.Downloading;
        } else {
            this.ivHomeworkDownloadProgress.setVisibility(8);
            if (!this.isPort) {
                this.ivHomeworkDownload.setVisibility(0);
            }
            this.ivHomeworkOpenFile.setVisibility(8);
        }
        this.updateMoreVisibility();
        return homeworkFileDownloading;
    }

    public BaseUIConstant.HomeworkDownloadState getHomeworkDownloadState() {
        return this.homeworkDownloadState;
    }

    private <T extends View> T findView(int id2) {
        return (T)this.mView.findViewById(id2);
    }

    public static interface IOnCloudItemClickListener
    extends IOnDocItemClickListener {
        public void onClickDirectory();
    }

    public static interface IOnHomeworkItemClickListener
    extends IOnDocItemClickListener {
        public void onDownload(File var1);

        public void onCancelDownload(File var1);
    }

    public static interface IOnUploadItemClickListener
    extends IOnDocItemClickListener {
        public void onUploadByNormal();

        public void onReUpload(String var1);

        public void onCancelUpload();

        public void onCancelTransfer();
    }

    public static interface IOnDocItemClickListener {
        public void onPlay();

        public void onDelete(String var1);

        public void onPreview();
    }
}

