/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.chat;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.glide.load.resource.gif.GifDrawable;
import com.baijiayun.glide.request.target.SimpleTarget;
import com.baijiayun.glide.request.transition.Transition;
import com.baijiayun.liveuibase.widgets.chat.ChatImageUtil;
import org.jetbrains.annotations.Nullable;

public class GifCropTarget
extends SimpleTarget<GifDrawable> {
    private final ImageView imageView;
    private final int width;
    private final int height;

    public GifCropTarget(ImageView imageView, int width, int height) {
        this.imageView = imageView;
        this.width = width;
        this.height = height;
    }

    public void onResourceReady(@NonNull GifDrawable resource, @androidx.annotation.Nullable @Nullable Transition<? super GifDrawable> transition) {
        Bitmap bitmap = resource.getFirstFrame();
        int bitmapWidth = 0;
        int bitmapHeight = 0;
        if (bitmap != null) {
            bitmapWidth = bitmap.getWidth();
            bitmapHeight = bitmap.getHeight();
        }
        int[] size = new int[]{bitmapWidth, bitmapHeight};
        if (bitmapWidth != 0 && bitmapHeight != 0) {
            ChatImageUtil.calculateImageSize(size, UtilsKt.getDp((int)this.width), UtilsKt.getDp((int)this.height));
        } else {
            size[0] = UtilsKt.getDp((int)this.width);
            size[1] = UtilsKt.getDp((int)this.height);
        }
        ViewGroup.LayoutParams layoutParams = this.imageView.getLayoutParams();
        layoutParams.width = size[0];
        layoutParams.height = size[1];
        this.imageView.setLayoutParams(layoutParams);
        this.imageView.setImageDrawable((Drawable)resource);
        resource.start();
    }
}

