/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.chat;

import android.content.Context;
import android.text.Spannable;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;

public class ControlClickSpanTextView
extends AppCompatTextView {
    private long mTime;

    public ControlClickSpanTextView(@NonNull Context context2) {
        super(context2);
    }

    public ControlClickSpanTextView(@NonNull Context context2, @Nullable AttributeSet attrs) {
        super(context2, attrs);
    }

    public ControlClickSpanTextView(@NonNull Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
    }

    public boolean onTouchEvent(MotionEvent event) {
        CharSequence text = this.getText();
        if (text == null) {
            return super.onTouchEvent(event);
        }
        if (text instanceof Spannable) {
            Spannable spannable = (Spannable)text;
            int end = text.length();
            ClickableSpan[] clickableSpans = (ClickableSpan[])spannable.getSpans(0, end, ClickableSpan.class);
            if (clickableSpans == null || clickableSpans.length == 0) {
                return super.onTouchEvent(event);
            }
            if (event.getAction() == 0) {
                this.mTime = System.currentTimeMillis();
            } else if (event.getAction() == 1 && System.currentTimeMillis() - this.mTime > (long)ViewConfiguration.getLongPressTimeout()) {
                return true;
            }
        }
        return super.onTouchEvent(event);
    }
}

