/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.os.Build;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageView;
import com.baijiayun.liveuibase.R;

public class RadiusImageView
extends AppCompatImageView {
    private float width;
    private float height;
    private int leftTopRadius;
    private int rightTopRadius;
    private int rightBottomRadius;
    private int leftBottomRadius;

    public RadiusImageView(Context context2) {
        this(context2, null);
        this.init(context2, null);
    }

    public RadiusImageView(Context context2, AttributeSet attrs) {
        this(context2, attrs, 0);
        this.init(context2, attrs);
    }

    public RadiusImageView(Context context2, AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.init(context2, attrs);
    }

    private void init(Context context2, AttributeSet attrs) {
        if (Build.VERSION.SDK_INT < 18) {
            this.setLayerType(1, null);
        }
        TypedArray array2 = context2.obtainStyledAttributes(attrs, R.styleable.RoundCornerImageView);
        int radius = array2.getDimensionPixelOffset(R.styleable.RoundCornerImageView_radius, 0);
        this.leftTopRadius = array2.getDimensionPixelOffset(R.styleable.RoundCornerImageView_left_top_radius, 0);
        this.rightTopRadius = array2.getDimensionPixelOffset(R.styleable.RoundCornerImageView_right_top_radius, 0);
        this.rightBottomRadius = array2.getDimensionPixelOffset(R.styleable.RoundCornerImageView_right_bottom_radius, 0);
        this.leftBottomRadius = array2.getDimensionPixelOffset(R.styleable.RoundCornerImageView_left_bottom_radius, 0);
        if (0 == this.leftTopRadius) {
            this.leftTopRadius = radius;
        }
        if (0 == this.rightTopRadius) {
            this.rightTopRadius = radius;
        }
        if (0 == this.rightBottomRadius) {
            this.rightBottomRadius = radius;
        }
        if (0 == this.leftBottomRadius) {
            this.leftBottomRadius = radius;
        }
        array2.recycle();
    }

    public void setLeftTopRadius(int leftTopRadius) {
        this.leftTopRadius = leftTopRadius;
    }

    public void setRightTopRadius(int rightTopRadius) {
        this.rightTopRadius = rightTopRadius;
    }

    public void setRightBottomRadius(int rightBottomRadius) {
        this.rightBottomRadius = rightBottomRadius;
    }

    public void setLeftBottomRadius(int leftBottomRadius) {
        this.leftBottomRadius = leftBottomRadius;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    protected void onDraw(Canvas canvas) {
        int maxLeft = Math.max(this.leftTopRadius, this.leftBottomRadius);
        int maxRight = Math.max(this.rightTopRadius, this.rightBottomRadius);
        int minWidth = maxLeft + maxRight;
        int maxTop = Math.max(this.leftTopRadius, this.rightTopRadius);
        int maxBottom = Math.max(this.leftBottomRadius, this.rightBottomRadius);
        int minHeight = maxTop + maxBottom;
        if (this.width >= (float)minWidth && this.height > (float)minHeight) {
            Path path = new Path();
            path.moveTo((float)this.leftTopRadius, 0.0f);
            path.lineTo(this.width - (float)this.rightTopRadius, 0.0f);
            path.quadTo(this.width, 0.0f, this.width, (float)this.rightTopRadius);
            path.lineTo(this.width, this.height - (float)this.rightBottomRadius);
            path.quadTo(this.width, this.height, this.width - (float)this.rightBottomRadius, this.height);
            path.lineTo((float)this.leftBottomRadius, this.height);
            path.quadTo(0.0f, this.height, 0.0f, this.height - (float)this.leftBottomRadius);
            path.lineTo(0.0f, (float)this.leftTopRadius);
            path.quadTo(0.0f, 0.0f, (float)this.leftTopRadius, 0.0f);
            canvas.clipPath(path);
        }
        super.onDraw(canvas);
    }
}

