/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import com.baijiayun.bjyutils.kt.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0012\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/baijiayun/liveuibase/widgets/GravityCompoundDrawable;", "Landroid/graphics/drawable/Drawable;", "drawable", "(Landroid/graphics/drawable/Drawable;)V", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "setContext", "(Landroid/content/Context;)V", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "sizeLength", "", "getSizeLength", "()Ljava/lang/Integer;", "setSizeLength", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "liveuibase_release"})
public final class GravityCompoundDrawable
extends Drawable {
    @NotNull
    private final Drawable drawable;
    @Nullable
    private Integer sizeLength;
    @Nullable
    private Context context;

    public GravityCompoundDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        this.drawable = drawable2;
    }

    @NotNull
    public final Drawable getDrawable() {
        return this.drawable;
    }

    @Nullable
    public final Integer getSizeLength() {
        return this.sizeLength;
    }

    public final void setSizeLength(@Nullable Integer n) {
        this.sizeLength = n;
    }

    @Nullable
    public final Context getContext() {
        return this.context;
    }

    public final void setContext(@Nullable Context context2) {
        this.context = context2;
    }

    public void setAlpha(int alpha) {
    }

    public int getOpacity() {
        return -3;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getIntrinsicWidth() {
        Integer n = this.sizeLength;
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    public int getIntrinsicHeight() {
        Integer n = this.sizeLength;
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        float halfCanvas = (float)canvas.getHeight() / 2.0f;
        float halfDrawable = (float)this.getIntrinsicHeight() / 2.0f;
        halfDrawable -= halfDrawable / 3.0f;
        canvas.save();
        int paddingTop = UtilsKt.getDp((int)6);
        canvas.translate(0.0f, -halfCanvas + halfDrawable + (float)paddingTop);
        this.drawable.draw(canvas);
        canvas.restore();
    }
}

