/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.baijiayun.liveuibase.R;

public class BJYDrawableTextView
extends AppCompatTextView {
    public static final int DRAWABLE_POSITION_LEFT = 0;
    public static final int DRAWABLE_POSITION_TOP = 1;
    public static final int DRAWABLE_POSITION_RIGHT = 2;
    public static final int DRAWABLE_POSITION_BOTTOM = 3;
    public static final int SIZE_WIDTH = 0;
    public static final int SIZE_HEIGHT = 1;
    private Drawable[] drawableList;
    private int[][] drawableSizeList = new int[4][2];

    public BJYDrawableTextView(Context context2) {
        this(context2, null);
    }

    public BJYDrawableTextView(Context context2, AttributeSet attrs) {
        this(context2, attrs, 0);
    }

    public BJYDrawableTextView(Context context2, AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.init(context2, attrs);
    }

    public void setCompoundDrawablesRelativeWithIntrinsicBounds(@Nullable Drawable start2, @Nullable Drawable top, @Nullable Drawable end, @Nullable Drawable bottom) {
        super.setCompoundDrawablesRelativeWithIntrinsicBounds(start2, top, end, bottom);
        Log.d((String)"textview", (String)("setCompoundDrawablesRelativeWithIntrinsicBounds start=" + start2));
        this.initPaddingDrawable(start2, top, end, bottom);
    }

    public void setCompoundDrawablesWithIntrinsicBounds(@Nullable Drawable left, @Nullable Drawable top, @Nullable Drawable right, @Nullable Drawable bottom) {
        super.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
        this.initPaddingDrawable(left, top, right, bottom);
    }

    private void initPaddingDrawable(@Nullable Drawable left, @Nullable Drawable top, @Nullable Drawable right, @Nullable Drawable bottom) {
        if (this.drawableList == null) {
            this.drawableList = new Drawable[4];
        }
        Log.d((String)"textview", (String)("left=" + left));
        this.drawableList[0] = left;
        this.drawableList[1] = top;
        this.drawableList[2] = right;
        this.drawableList[3] = bottom;
    }

    private void init(Context context2, AttributeSet attrs) {
        TypedArray ta = context2.obtainStyledAttributes(attrs, R.styleable.BJYDrawableTextView);
        int globalWidth = ta.getDimensionPixelOffset(R.styleable.BJYDrawableTextView_bjy_base_drawableWidth, (int)this.getTextSize());
        int globalHeight = ta.getDimensionPixelOffset(R.styleable.BJYDrawableTextView_bjy_base_drawableHeight, (int)this.getTextSize());
        this.drawableSizeList[0][0] = ta.getDimensionPixelOffset(R.styleable.BJYDrawableTextView_bjy_base_drawableLeftWidth, globalWidth);
        this.drawableSizeList[0][1] = ta.getDimensionPixelOffset(R.styleable.BJYDrawableTextView_bjy_base_drawableLeftHeight, globalHeight);
        this.drawableSizeList[2][0] = ta.getDimensionPixelOffset(R.styleable.BJYDrawableTextView_bjy_base_drawableRightWidth, globalWidth);
        this.drawableSizeList[2][1] = ta.getDimensionPixelOffset(R.styleable.BJYDrawableTextView_bjy_base_drawableRightHeight, globalHeight);
        this.drawableSizeList[1][0] = ta.getDimensionPixelOffset(R.styleable.BJYDrawableTextView_bjy_base_drawableTopWidth, globalWidth);
        this.drawableSizeList[1][1] = ta.getDimensionPixelOffset(R.styleable.BJYDrawableTextView_bjy_base_drawableTopHeight, globalHeight);
        this.drawableSizeList[3][0] = ta.getDimensionPixelOffset(R.styleable.BJYDrawableTextView_bjy_base_drawableBottomWidth, globalWidth);
        this.drawableSizeList[3][1] = ta.getDimensionPixelOffset(R.styleable.BJYDrawableTextView_bjy_base_drawableBottomHeight, globalHeight);
        ta.recycle();
        this.setDrawableSize();
    }

    public void setDrawableSize() {
        if (this.drawableList == null) {
            this.drawableList = new Drawable[4];
        }
        if (this.drawableList[0] != null) {
            Log.d((String)"textview", (String)("width=" + this.drawableSizeList[0][0] + ", height=" + this.drawableSizeList[0][1]));
            this.drawableList[0].setBounds(0, 0, this.drawableSizeList[0][0], this.drawableSizeList[0][1]);
        }
        if (this.drawableList[1] != null) {
            this.drawableList[1].setBounds(0, 0, this.drawableSizeList[1][0], this.drawableSizeList[1][1]);
        }
        if (this.drawableList[2] != null) {
            this.drawableList[2].setBounds(0, 0, this.drawableSizeList[0][0], this.drawableSizeList[2][1]);
        }
        if (this.drawableList[3] != null) {
            this.drawableList[3].setBounds(0, 0, this.drawableSizeList[3][0], this.drawableSizeList[3][1]);
        }
        this.setCompoundDrawables(this.drawableList[0], this.drawableList[1], this.drawableList[2], this.drawableList[3]);
    }

    public void setDrawableSize(int position, int width, int height) {
        if (width < 0 || height < 0) {
            return;
        }
        if (this.drawableSizeList[position][0] == width && this.drawableSizeList[position][1] == height) {
            return;
        }
        this.drawableSizeList[position][0] = width;
        this.drawableSizeList[position][1] = height;
        this.setDrawableSize();
    }
}

