/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.viewmodel;

import androidx.lifecycle.MutableLiveData;
import com.baijiayun.bjyrtcengine.BJYRtcEventObserver;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseViewModel;
import com.baijiayun.liveuibase.viewmodel.TopMenuViewModel;
import com.uber.autodispose.AutoDispose;
import com.uber.autodispose.ObservableSubscribeProxy;
import com.uber.autodispose.ScopeProvider;
import io.reactivex.Observable;
import io.reactivex.ObservableConverter;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u001fH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u000e0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R,\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00070\u000e0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\t\"\u0004\b\u001a\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/baijiayun/liveuibase/viewmodel/TopMenuViewModel;", "Lcom/baijiayun/liveuibase/base/BaseViewModel;", "liveRoom", "Lcom/baijiayun/livecore/context/LiveRoom;", "(Lcom/baijiayun/livecore/context/LiveRoom;)V", "classStartTime", "Landroidx/lifecycle/MutableLiveData;", "", "getClassStartTime", "()Landroidx/lifecycle/MutableLiveData;", "disposableOfCount", "Lio/reactivex/disposables/Disposable;", "disposableOfTimer", "downLinkLossRate", "Lkotlin/Pair;", "", "getDownLinkLossRate", "setDownLinkLossRate", "(Landroidx/lifecycle/MutableLiveData;)V", "isDownLinkChanged", "", "isUpLinkChanged", "getLiveRoom", "()Lcom/baijiayun/livecore/context/LiveRoom;", "upLinkLossRate", "getUpLinkLossRate", "setUpLinkLossRate", "getNetworkQualityColor", "lossRate", "", "startCount", "", "t", "", "subscribe", "liveuibase_release"})
public final class TopMenuViewModel
extends BaseViewModel {
    @NotNull
    private final LiveRoom liveRoom;
    @NotNull
    private final MutableLiveData<Integer> classStartTime;
    @NotNull
    private MutableLiveData<Pair<String, Integer>> upLinkLossRate;
    @NotNull
    private MutableLiveData<Pair<String, Integer>> downLinkLossRate;
    @Nullable
    private Disposable disposableOfCount;
    @Nullable
    private Disposable disposableOfTimer;
    private boolean isUpLinkChanged;
    private boolean isDownLinkChanged;

    public TopMenuViewModel(@NotNull LiveRoom liveRoom2) {
        Intrinsics.checkNotNullParameter((Object)liveRoom2, (String)"liveRoom");
        this.liveRoom = liveRoom2;
        this.classStartTime = new MutableLiveData();
        this.upLinkLossRate = new MutableLiveData();
        this.downLinkLossRate = new MutableLiveData();
    }

    @NotNull
    public final LiveRoom getLiveRoom() {
        return this.liveRoom;
    }

    @NotNull
    public final MutableLiveData<Integer> getClassStartTime() {
        return this.classStartTime;
    }

    @NotNull
    public final MutableLiveData<Pair<String, Integer>> getUpLinkLossRate() {
        return this.upLinkLossRate;
    }

    public final void setUpLinkLossRate(@NotNull MutableLiveData<Pair<String, Integer>> mutableLiveData) {
        Intrinsics.checkNotNullParameter(mutableLiveData, (String)"<set-?>");
        this.upLinkLossRate = mutableLiveData;
    }

    @NotNull
    public final MutableLiveData<Pair<String, Integer>> getDownLinkLossRate() {
        return this.downLinkLossRate;
    }

    public final void setDownLinkLossRate(@NotNull MutableLiveData<Pair<String, Integer>> mutableLiveData) {
        Intrinsics.checkNotNullParameter(mutableLiveData, (String)"<set-?>");
        this.downLinkLossRate = mutableLiveData;
    }

    @Override
    public void subscribe() {
        Observable observable = this.liveRoom.getObservableOfRealStartTime().observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"liveRoom.observableOfRea\u2026dSchedulers.mainThread())");
        Observable $this$autoDispose$iv = observable;
        boolean $i$f$autoDispose = false;
        Object object = $this$autoDispose$iv.as((ObservableConverter)AutoDispose.autoDisposable((ScopeProvider)((ScopeProvider)this)));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.`as`(AutoDispose.autoDisposable(provider))");
        ((ObservableSubscribeProxy)object).subscribe(arg_0 -> TopMenuViewModel.subscribe$lambda$0((Function1)new Function1<Long, Unit>(this){
            final /* synthetic */ TopMenuViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Long it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                TopMenuViewModel.access$startCount(this.this$0, it);
            }
        }, arg_0));
        Observable observable2 = this.liveRoom.getObservableOfClassEnd().observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkNotNullExpressionValue((Object)observable2, (String)"liveRoom.observableOfCla\u2026dSchedulers.mainThread())");
        $this$autoDispose$iv = observable2;
        $i$f$autoDispose = false;
        Object object2 = $this$autoDispose$iv.as((ObservableConverter)AutoDispose.autoDisposable((ScopeProvider)((ScopeProvider)this)));
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"this.`as`(AutoDispose.autoDisposable(provider))");
        ((ObservableSubscribeProxy)object2).subscribe(arg_0 -> TopMenuViewModel.subscribe$lambda$1((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ TopMenuViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Integer it) {
                RxUtils.Companion.dispose(TopMenuViewModel.access$getDisposableOfCount$p(this.this$0));
                RxUtils.Companion.dispose(TopMenuViewModel.access$getDisposableOfTimer$p(this.this$0));
                if (this.this$0.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher || this.this$0.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant) {
                    this.this$0.getLiveRoom().requestCloudRecord(LPConstants.CloudRecordStatus.Stopped);
                }
                this.this$0.getClassStartTime().setValue((Object)-2);
            }
        }, arg_0));
        Observable observable3 = this.liveRoom.getObservableOfClassStart().observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkNotNullExpressionValue((Object)observable3, (String)"liveRoom.observableOfCla\u2026dSchedulers.mainThread())");
        $this$autoDispose$iv = observable3;
        $i$f$autoDispose = false;
        Object object3 = $this$autoDispose$iv.as((ObservableConverter)AutoDispose.autoDisposable((ScopeProvider)((ScopeProvider)this)));
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"this.`as`(AutoDispose.autoDisposable(provider))");
        ((ObservableSubscribeProxy)object3).subscribe(arg_0 -> TopMenuViewModel.subscribe$lambda$2((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ TopMenuViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Integer it) {
                Integer n = (Integer)this.this$0.getClassStartTime().getValue();
                int n2 = -1;
                if (n != null && n == n2) {
                    this.this$0.getClassStartTime().setValue((Object)0);
                }
            }
        }, arg_0));
        this.classStartTime.setValue((Object)(this.liveRoom.isClassStarted() ? Integer.valueOf(0) : Integer.valueOf(-1)));
        Observable observable4 = this.liveRoom.getRecorder().getObservableOfUpPacketLossRate().toObservable().observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkNotNullExpressionValue((Object)observable4, (String)"liveRoom.recorder.observ\u2026dSchedulers.mainThread())");
        $this$autoDispose$iv = observable4;
        $i$f$autoDispose = false;
        Object object4 = $this$autoDispose$iv.as((ObservableConverter)AutoDispose.autoDisposable((ScopeProvider)((ScopeProvider)this)));
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"this.`as`(AutoDispose.autoDisposable(provider))");
        ((ObservableSubscribeProxy)object4).subscribe(arg_0 -> TopMenuViewModel.subscribe$lambda$3((Function1)new Function1<BJYRtcEventObserver.LocalStreamStats, Unit>(this){
            final /* synthetic */ TopMenuViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(BJYRtcEventObserver.LocalStreamStats it) {
                boolean isVideoOn = this.this$0.getLiveRoom().getRecorder().isVideoAttached();
                double lossRate = isVideoOn ? it.videoPacketsLostRateSent : it.audioPacketsLostRateSent;
                MutableLiveData<Pair<String, Integer>> mutableLiveData = this.this$0.getUpLinkLossRate();
                StringBuilder stringBuilder = new StringBuilder();
                Locale locale = Locale.getDefault();
                String string2 = "%.2f";
                Object[] objectArray = new Object[]{lossRate};
                String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
                mutableLiveData.setValue((Object)TuplesKt.to((Object)stringBuilder.append(string3).append('%').toString(), (Object)TopMenuViewModel.access$getNetworkQualityColor(this.this$0, lossRate)));
                TopMenuViewModel.access$setUpLinkChanged$p(this.this$0, true);
            }
        }, arg_0));
        $this$autoDispose$iv = this.liveRoom.getPlayer().getObservableOfDownLinkLossRate().buffer(1L, TimeUnit.SECONDS).filter(arg_0 -> TopMenuViewModel.subscribe$lambda$4(subscribe.5.INSTANCE, arg_0)).toObservable().observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkNotNullExpressionValue((Object)$this$autoDispose$iv, (String)"liveRoom.player.observab\u2026dSchedulers.mainThread())");
        $i$f$autoDispose = false;
        Object object5 = $this$autoDispose$iv.as((ObservableConverter)AutoDispose.autoDisposable((ScopeProvider)((ScopeProvider)this)));
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"this.`as`(AutoDispose.autoDisposable(provider))");
        ((ObservableSubscribeProxy)object5).subscribe(arg_0 -> TopMenuViewModel.subscribe$lambda$5((Function1)new Function1<List<BJYRtcEventObserver.RemoteStreamStats>, Unit>(this){
            final /* synthetic */ TopMenuViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(List<BJYRtcEventObserver.RemoteStreamStats> it) {
                double sum = 0.0;
                for (BJYRtcEventObserver.RemoteStreamStats streamStats : it) {
                    sum += streamStats.receivedVideoLostRate;
                }
                double lossRate = sum / (double)it.size();
                MutableLiveData<Pair<String, Integer>> mutableLiveData = this.this$0.getDownLinkLossRate();
                StringBuilder stringBuilder = new StringBuilder();
                Locale locale = Locale.getDefault();
                String string2 = "%.2f";
                Object[] objectArray = new Object[]{lossRate};
                String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
                mutableLiveData.setValue((Object)TuplesKt.to((Object)stringBuilder.append(string3).append('%').toString(), (Object)TopMenuViewModel.access$getNetworkQualityColor(this.this$0, lossRate)));
                TopMenuViewModel.access$setDownLinkChanged$p(this.this$0, true);
            }
        }, arg_0));
        RxUtils.Companion.dispose(this.disposableOfTimer);
        Observable observable5 = Observable.interval((long)5L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkNotNullExpressionValue((Object)observable5, (String)"interval(5, TimeUnit.SEC\u2026dSchedulers.mainThread())");
        $this$autoDispose$iv = observable5;
        $i$f$autoDispose = false;
        Object object6 = $this$autoDispose$iv.as((ObservableConverter)AutoDispose.autoDisposable((ScopeProvider)((ScopeProvider)this)));
        Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"this.`as`(AutoDispose.autoDisposable(provider))");
        this.disposableOfTimer = ((ObservableSubscribeProxy)object6).subscribe(arg_0 -> TopMenuViewModel.subscribe$lambda$6((Function1)new Function1<Long, Unit>(this){
            final /* synthetic */ TopMenuViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Long it) {
                Object[] objectArray;
                String string2;
                Locale locale;
                if (!TopMenuViewModel.access$isDownLinkChanged$p(this.this$0)) {
                    MutableLiveData<Pair<String, Integer>> mutableLiveData = this.this$0.getDownLinkLossRate();
                    StringBuilder stringBuilder = new StringBuilder();
                    locale = Locale.getDefault();
                    string2 = "%.2f";
                    objectArray = new Object[]{0.0};
                    String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
                    mutableLiveData.setValue((Object)TuplesKt.to((Object)stringBuilder.append(string3).append('%').toString(), (Object)TopMenuViewModel.access$getNetworkQualityColor(this.this$0, 0.0)));
                }
                if (!TopMenuViewModel.access$isUpLinkChanged$p(this.this$0)) {
                    MutableLiveData<Pair<String, Integer>> mutableLiveData = this.this$0.getUpLinkLossRate();
                    StringBuilder stringBuilder = new StringBuilder();
                    locale = Locale.getDefault();
                    string2 = "%.2f";
                    objectArray = new Object[]{0.0};
                    String string4 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(locale, format, *args)");
                    mutableLiveData.setValue((Object)TuplesKt.to((Object)stringBuilder.append(string4).append('%').toString(), (Object)TopMenuViewModel.access$getNetworkQualityColor(this.this$0, 0.0)));
                }
                TopMenuViewModel.access$setDownLinkChanged$p(this.this$0, false);
                TopMenuViewModel.access$setUpLinkChanged$p(this.this$0, false);
            }
        }, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void startCount(long t) {
        void $this$autoDispose$iv;
        long hasPast = (System.currentTimeMillis() - t) / (long)1000;
        RxUtils.Companion.dispose(this.disposableOfCount);
        Observable observable = Observable.interval((long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS).filter(arg_0 -> TopMenuViewModel.startCount$lambda$7((Function1)new Function1<Long, Boolean>(this){
            final /* synthetic */ TopMenuViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.getLiveRoom().isClassStarted();
            }
        }, arg_0)).observeOn(AndroidSchedulers.mainThread());
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"private fun startCount(t\u2026Int()\n            }\n    }");
        boolean $i$f$autoDispose = false;
        Object object = $this$autoDispose$iv.as((ObservableConverter)AutoDispose.autoDisposable((ScopeProvider)((ScopeProvider)this)));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.`as`(AutoDispose.autoDisposable(provider))");
        this.disposableOfCount = ((ObservableSubscribeProxy)object).subscribe(arg_0 -> TopMenuViewModel.startCount$lambda$8((Function1)new Function1<Long, Unit>(hasPast, this){
            final /* synthetic */ long $hasPast;
            final /* synthetic */ TopMenuViewModel this$0;
            {
                this.$hasPast = $hasPast;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Long it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                long past = this.$hasPast + it;
                if (past < 0L) {
                    past = 0L;
                }
                this.this$0.getClassStartTime().setValue((Object)((int)past));
            }
        }, arg_0));
    }

    private final int getNetworkQualityColor(double lossRate) {
        int n;
        List packetLossRateLevel = this.liveRoom.getPartnerConfig().packetLossRate.packetLossRateLevel;
        if (packetLossRateLevel.isEmpty() || packetLossRateLevel.size() < 3) {
            return R.color.bjy_base_class_net_normal;
        }
        Integer n2 = (Integer)packetLossRateLevel.get(0);
        Double d = n2 != null ? Double.valueOf(n2.intValue()) : null;
        if (lossRate < d) {
            n = R.color.bjy_base_class_net_good;
        } else {
            Integer n3 = (Integer)packetLossRateLevel.get(1);
            Double d2 = n3 != null ? Double.valueOf(n3.intValue()) : null;
            if (lossRate < d2) {
                n = R.color.bjy_base_class_net_normal;
            } else {
                Integer n4 = (Integer)packetLossRateLevel.get(2);
                n = lossRate < (n4 != null ? Double.valueOf(n4.intValue()) : null) ? R.color.bjy_base_class_net_bad : R.color.bjy_base_class_net_terrible;
            }
        }
        return n;
    }

    private static final void subscribe$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void subscribe$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void subscribe$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void subscribe$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean subscribe$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void subscribe$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void subscribe$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean startCount$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void startCount$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$startCount(TopMenuViewModel $this, long t) {
        $this.startCount(t);
    }

    public static final /* synthetic */ Disposable access$getDisposableOfCount$p(TopMenuViewModel $this) {
        return $this.disposableOfCount;
    }

    public static final /* synthetic */ Disposable access$getDisposableOfTimer$p(TopMenuViewModel $this) {
        return $this.disposableOfTimer;
    }

    public static final /* synthetic */ int access$getNetworkQualityColor(TopMenuViewModel $this, double lossRate) {
        return $this.getNetworkQualityColor(lossRate);
    }

    public static final /* synthetic */ void access$setUpLinkChanged$p(TopMenuViewModel $this, boolean bl) {
        $this.isUpLinkChanged = bl;
    }

    public static final /* synthetic */ void access$setDownLinkChanged$p(TopMenuViewModel $this, boolean bl) {
        $this.isDownLinkChanged = bl;
    }

    public static final /* synthetic */ boolean access$isDownLinkChanged$p(TopMenuViewModel $this) {
        return $this.isDownLinkChanged;
    }

    public static final /* synthetic */ boolean access$isUpLinkChanged$p(TopMenuViewModel $this) {
        return $this.isUpLinkChanged;
    }
}

