/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.utils;

import android.content.Context;
import com.baijiahulian.common.permission.PermissionTipsView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.livebase.R;
import com.baijiayun.liveuibase.R;

public class PermissionTipBuilderFactory {
    public static PermissionTipsView createPermissionTipsView(Context context2, String permission2) {
        switch (permission2) {
            case "android.permission.CAMERA": {
                return PermissionTipBuilderFactory.createCameraPermissionTipsView(context2);
            }
            case "android.permission.RECORD_AUDIO": {
                return PermissionTipBuilderFactory.createMicPermissionTipsView(context2);
            }
            case "android.permission.BLUETOOTH_CONNECT": {
                return PermissionTipBuilderFactory.createBluetoothPermissionTipsView(context2);
            }
            case "android.permission.READ_EXTERNAL_STORAGE": 
            case "android.permission.WRITE_EXTERNAL_STORAGE": {
                return PermissionTipBuilderFactory.createExternalStoragePermissionTipsView(context2);
            }
            case "android.permission.POST_NOTIFICATIONS": {
                return PermissionTipBuilderFactory.createNoticationPermissionTipsView(context2);
            }
        }
        throw new IllegalArgumentException("Invalid dialog type: " + permission2);
    }

    private static PermissionTipsView createCameraPermissionTipsView(Context context2) {
        PermissionTipsView.Builder builder = new PermissionTipsView.Builder(context2);
        return builder.setIcon(R.drawable.bjy_base_permission_camera).setTitle(context2.getResources().getString(R.string.bjy_base_setting_type_camera)).setMessage(context2.getResources().getString(R.string.bjy_base_camera_permission_tips)).setOrientation(!UtilsKt.isOrientationLandscape((Context)context2)).build();
    }

    private static PermissionTipsView createMicPermissionTipsView(Context context2) {
        PermissionTipsView.Builder builder = new PermissionTipsView.Builder(context2);
        return builder.setIcon(R.drawable.bjy_base_permission_mic).setTitle(context2.getResources().getString(R.string.bjy_base_setting_type_mic)).setMessage(context2.getResources().getString(R.string.bjy_base_mic_permission_tips)).setOrientation(!UtilsKt.isOrientationLandscape((Context)context2)).build();
    }

    private static PermissionTipsView createBluetoothPermissionTipsView(Context context2) {
        PermissionTipsView.Builder builder = new PermissionTipsView.Builder(context2);
        return builder.setIcon(R.drawable.bjy_base_permission_bluetooth).setTitle(context2.getResources().getString(R.string.bjy_base_bluetooth)).setMessage(context2.getResources().getString(R.string.bjy_base_bluetooth_permission_tips)).setOrientation(!UtilsKt.isOrientationLandscape((Context)context2)).build();
    }

    private static PermissionTipsView createExternalStoragePermissionTipsView(Context context2) {
        PermissionTipsView.Builder builder = new PermissionTipsView.Builder(context2);
        return builder.setIcon(R.drawable.bjy_base_permission_write_external_storage).setTitle(context2.getResources().getString(R.string.bjy_base_external_storage)).setMessage(context2.getResources().getString(R.string.bjy_base_external_storage_permission_tips)).setOrientation(!UtilsKt.isOrientationLandscape((Context)context2)).build();
    }

    private static PermissionTipsView createNoticationPermissionTipsView(Context context2) {
        PermissionTipsView.Builder builder = new PermissionTipsView.Builder(context2);
        return builder.setIcon(R.drawable.bjy_base_ic_launcher).setTitle(context2.getResources().getString(R.string.bjy_base_notification_permission)).setMessage(context2.getResources().getString(R.string.bjy_base_notification_permission_tips)).setOrientation(!UtilsKt.isOrientationLandscape((Context)context2)).build();
    }
}

