/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.rollcall;

import com.baijiayun.livecore.listener.OnPhoneRollCallListener;
import com.baijiayun.liveuibase.toolbox.rollcall.RollCallDialogContract;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public class RollCallDialogPresenter
implements RollCallDialogContract.Presenter {
    private RollCallDialogContract.View view;
    private Disposable countDownSubscription;
    private int maxTime;
    private OnPhoneRollCallListener.RollCall rollCallListener;

    public RollCallDialogPresenter(RollCallDialogContract.View view) {
        this.view = view;
    }

    public void setRollCallInfo(int maxTime, OnPhoneRollCallListener.RollCall rollCallConfirmListener) {
        this.maxTime = maxTime;
        this.rollCallListener = rollCallConfirmListener;
        this.subscribe();
    }

    public void subscribe() {
        if (this.countDownSubscription == null) {
            this.countDownSubscription = Observable.interval((long)0L, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
                int timePassed = aLong.intValue();
                if (timePassed >= this.maxTime) {
                    this.view.timerDown(0);
                } else {
                    this.view.timerDown(this.maxTime - timePassed);
                }
            });
        }
    }

    public void unSubscribe() {
        if (this.countDownSubscription != null && !this.countDownSubscription.isDisposed()) {
            this.countDownSubscription.dispose();
            this.countDownSubscription = null;
        }
    }

    public void destroy() {
        this.view = null;
    }

    @Override
    public void rollCallConfirm() {
        if (this.rollCallListener != null) {
            this.rollCallListener.call();
        }
    }

    @Override
    public void timeOut() {
        if (this.view != null) {
            this.view.timeOutSoDismiss();
        }
    }
}

