/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.answerer;

import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livecore.models.LPAnswerModel;
import com.baijiayun.livecore.models.LPAnswerSheetOptionModel;
import com.baijiayun.liveuibase.base.RouterListener;
import com.baijiayun.liveuibase.toolbox.answerer.AnswererContract;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public class AnswererPresenter
implements AnswererContract.Presenter {
    private AnswererContract.View view;
    private Disposable countDownDisposable;
    private Disposable closeDisposable;
    private CompositeDisposable disposables;
    private LPAnswerModel lpAnswerModel;
    private RouterListener routerListener;
    private long remainTime;
    private boolean hasShowAnswer = false;
    private boolean hasSubmit = false;
    private static final int CLOSE_DELAY = 5;

    public AnswererPresenter(AnswererContract.View view, RouterListener routerListener2) {
        this.view = view;
        this.routerListener = routerListener2;
        this.disposables = new CompositeDisposable();
    }

    @Override
    public void closeWindow() {
        this.routerListener.onDismissAnswerer();
    }

    @Override
    public void setAnswererDatas(LPAnswerModel lpAnswerModel) {
        this.lpAnswerModel = lpAnswerModel;
        this.remainTime = lpAnswerModel.duration;
        this.subscribe();
    }

    @Override
    public LPAnswerModel getAnswerDatas() {
        return this.lpAnswerModel;
    }

    @Override
    public boolean submitAnswers() {
        this.hasSubmit = this.routerListener.getLiveRoom().getToolBoxVM().submitAnswers(this.lpAnswerModel);
        return this.hasSubmit;
    }

    @Override
    public boolean hasShowAnswer() {
        return this.hasShowAnswer;
    }

    @Override
    public boolean isVote() {
        if (this.lpAnswerModel == null) {
            return false;
        }
        return this.lpAnswerModel.isVote;
    }

    @Override
    public boolean reset() {
        int size = this.lpAnswerModel.options.size();
        for (int i = 0; i < size; ++i) {
            LPAnswerSheetOptionModel lpAnswerSheetOptionModel = (LPAnswerSheetOptionModel)this.lpAnswerModel.options.get(i);
            lpAnswerSheetOptionModel.isActive = false;
        }
        this.view.onReset(this.lpAnswerModel);
        return true;
    }

    public void subscribe() {
        this.startTimer();
        this.disposables.add(this.routerListener.getLiveRoom().getToolBoxVM().getObservableOfAnswerEnd().observeOn(AndroidSchedulers.mainThread()).subscribe(lpAnswerEndModel -> {
            if (this.view == null) {
                return;
            }
            this.view.onAnswerEnd();
            if (this.lpAnswerModel.isVote) {
                this.closeWindow();
                return;
            }
            if (lpAnswerEndModel.isRevoke) {
                this.closeWindow();
            } else if (this.lpAnswerModel.isShowAnswer) {
                if (!this.hasShowAnswer) {
                    if (!this.hasSubmit) {
                        this.reset();
                    }
                    this.view.onShowAnswer(this.lpAnswerModel);
                    this.hasShowAnswer = true;
                    if (this.routerListener.getLiveRoom().getPartnerConfig().autoCloseAnswerResult) {
                        this.startCloseTimer();
                    }
                }
            } else {
                this.closeWindow();
            }
        }));
        this.disposables.add(this.routerListener.getLiveRoom().getToolBoxVM().getObservableOfAnswerStart().observeOn(AndroidSchedulers.mainThread()).subscribe(answerModel -> {
            this.hasSubmit = false;
            if (this.view != null) {
                this.view.onReset((LPAnswerModel)answerModel);
            }
            this.lpAnswerModel = answerModel;
            this.remainTime = answerModel.duration;
            if (this.view != null) {
                this.view.timeDown(this.remainTime);
            }
            this.startTimer();
        }));
    }

    private void startCloseTimer() {
        int delay;
        RxUtils.dispose((Disposable)this.closeDisposable);
        RxUtils.dispose((Disposable)this.countDownDisposable);
        int n = delay = this.hasShowAnswer ? 10 : 5;
        if (this.view != null) {
            this.view.doOnClose();
            this.view.timeDown(0L);
            this.view.timeDownClose(delay);
        }
        this.closeDisposable = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).take((long)(delay + 1)).map(aLong -> aLong + 1L).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            if (this.view == null) {
                return;
            }
            this.view.timeDownClose((long)delay - aLong);
            if (aLong == (long)(delay + 1)) {
                if (this.hasShowAnswer) {
                    this.closeWindow();
                } else {
                    this.view.endAnswer();
                }
                RxUtils.dispose((Disposable)this.closeDisposable);
            }
        });
    }

    private void startTimer() {
        this.view.initView(this.lpAnswerModel);
        this.hasShowAnswer = false;
        RxUtils.dispose((Disposable)this.closeDisposable);
        RxUtils.dispose((Disposable)this.countDownDisposable);
        this.countDownDisposable = Observable.interval((long)1L, (long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            if (this.view == null) {
                return;
            }
            if (this.remainTime <= 0L) {
                if (this.lpAnswerModel.isVote) {
                    this.view.endAnswer();
                    RxUtils.dispose((Disposable)this.countDownDisposable);
                    return;
                }
                if (this.lpAnswerModel.isShowAnswer) {
                    if (!this.hasShowAnswer) {
                        this.view.onShowAnswer(this.lpAnswerModel);
                        this.hasShowAnswer = true;
                        if (this.routerListener.getLiveRoom().getPartnerConfig().autoCloseAnswerResult) {
                            this.startCloseTimer();
                        }
                    }
                } else {
                    this.view.endAnswer();
                    RxUtils.dispose((Disposable)this.countDownDisposable);
                    return;
                }
            }
            --this.remainTime;
            this.view.timeDown(this.remainTime);
        });
    }

    @Override
    public void destroy() {
        RxUtils.dispose((Disposable)this.countDownDisposable);
        RxUtils.dispose((Disposable)this.closeDisposable);
        RxUtils.dispose((Disposable)this.disposables);
        this.routerListener = null;
        this.view = null;
    }
}

