/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.speaklist;

import android.text.TextUtils;
import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.liveuibase.speaklist.Playable;
import com.baijiayun.liveuibase.speaklist.SpeakItem;
import com.baijiayun.liveuibase.speaklist.SpeakItemType;
import com.baijiayun.liveuibase.speaklist.Switchable;
import com.baijiayun.liveuibase.speaklist.SwitchableStatus;
import com.baijiayun.liveuibase.speaklist.item.LocalItem;
import com.baijiayun.liveuibase.speaklist.item.RemoteItem;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ItemPositionHelper {
    private List<SpeakItem> speakItems = new ArrayList<SpeakItem>();
    private List<ItemAction> itemActions = new ArrayList<ItemAction>();
    private Switchable pptItem;
    private RouterViewModel routerViewModel;

    public void setRouterListener(RouterViewModel routerListener2) {
        this.routerViewModel = routerListener2;
        this.pptItem = routerListener2.getPpt();
        this.speakItems.add(0, this.pptItem);
    }

    public List<ItemAction> processItemActions(SpeakItem speakItem) {
        this.itemActions.clear();
        if (speakItem instanceof RemoteItem) {
            this.handleRemoteItem((RemoteItem)speakItem);
        } else if (speakItem instanceof LocalItem) {
            this.handleLocalItem((LocalItem)speakItem);
        } else if (speakItem.getItemType() == SpeakItemType.PPT) {
            this.handlePPTItem(speakItem);
        }
        this.printAllSpeakItemInfo();
        return this.itemActions;
    }

    public List<ItemAction> processPresenterChangeItemActions(SpeakItem newPresenter) {
        this.itemActions.clear();
        SpeakItem oldPresenter = null;
        if (newPresenter == null) {
            Iterator<SpeakItem> iterator = this.speakItems.iterator();
            while (iterator.hasNext()) {
                SpeakItem item = iterator.next();
                if (item.getItemType() != SpeakItemType.Presenter) continue;
                iterator.remove();
                this.itemActions.add(new ItemAction(item, ActionType.CLEAR));
            }
        } else {
            for (SpeakItem item : this.speakItems) {
                if (item == null || item.getItemType() != SpeakItemType.Presenter || item == newPresenter) continue;
                oldPresenter = item;
                break;
            }
            if (newPresenter instanceof RemoteItem) {
                ((RemoteItem)newPresenter).refreshItemType();
            }
            if (oldPresenter instanceof RemoteItem) {
                ((RemoteItem)oldPresenter).refreshItemType();
            }
            if (newPresenter instanceof LocalItem) {
                ((LocalItem)newPresenter).refreshItemType();
            }
            if (oldPresenter instanceof LocalItem) {
                ((LocalItem)oldPresenter).refreshItemType();
            }
            if (newPresenter.getItemType() != SpeakItemType.Presenter) {
                return this.itemActions;
            }
            if (oldPresenter == null) {
                if (this.speakItems.contains(newPresenter)) {
                    this.speakItems.remove(newPresenter);
                    int addPosition = this.getLastPositionOfItemType(SpeakItemType.Presenter);
                    this.speakItems.add(addPosition, newPresenter);
                    this.itemActions.add(new ItemAction(newPresenter, ActionType.REMOVE));
                    this.itemActions.add(new ItemAction(newPresenter, ActionType.ADD, this.getRealViewPosition(addPosition)));
                } else {
                    int addPosition = this.getLastPositionOfItemType(SpeakItemType.Presenter);
                    this.speakItems.add(addPosition, newPresenter);
                    this.itemActions.add(new ItemAction(newPresenter, ActionType.ADD, this.getRealViewPosition(addPosition)));
                }
            } else if (oldPresenter instanceof Switchable && newPresenter instanceof Switchable) {
                if (this.speakItems.remove(oldPresenter) && oldPresenter instanceof Playable) {
                    int addPosition;
                    Playable oldPlayable = (Playable)oldPresenter;
                    boolean isKeepAlive = false;
                    if (oldPlayable instanceof RemoteItem) {
                        isKeepAlive = ((RemoteItem)oldPlayable).isKeepAlive();
                    }
                    if (oldPlayable.isVideoStreaming()) {
                        addPosition = this.getLastPositionOfItemType(SpeakItemType.Video);
                        this.speakItems.add(addPosition, oldPlayable);
                    } else if (oldPlayable.hasAudio() || oldPlayable.hasVideo()) {
                        addPosition = this.getLastPositionOfItemType(SpeakItemType.Audio);
                        this.speakItems.add(addPosition, oldPlayable);
                    } else if (isKeepAlive) {
                        this.speakItems.add(oldPlayable);
                    } else if (BaseUtilsKt.isInDiscussMode(this.routerViewModel)) {
                        this.itemActions.add(new ItemAction(oldPresenter, ActionType.REMOVE));
                    }
                }
                this.speakItems.remove(newPresenter);
                int addPosition = this.getLastPositionOfItemType(SpeakItemType.Presenter);
                this.speakItems.add(addPosition, newPresenter);
                this.itemActions.add(new ItemAction(newPresenter, ActionType.ADD, this.getRealViewPosition(addPosition)));
            }
        }
        for (SpeakItem item : this.speakItems) {
            if (item instanceof RemoteItem) {
                ((RemoteItem)item).refreshNameTable();
                if (item == newPresenter) {
                    ((RemoteItem)item).showWaterMark();
                }
                if (item != oldPresenter) continue;
                ((RemoteItem)item).hideWaterMark();
                continue;
            }
            if (!(item instanceof LocalItem)) continue;
            ((LocalItem)item).refreshNameTable();
        }
        this.printAllSpeakItemInfo();
        return this.itemActions;
    }

    public List<ItemAction> removeSpeakItem(SpeakItem speakItem) {
        this.speakItems.remove(speakItem);
        return Collections.singletonList(new ItemAction(speakItem, ActionType.CLEAR));
    }

    public List<ItemAction> addSpeakItem(SpeakItem speakItem) {
        this.speakItems.add(speakItem);
        return Collections.singletonList(new ItemAction(speakItem, ActionType.ADD));
    }

    public List<ItemAction> removeAllItem() {
        ArrayList<ItemAction> actionList = new ArrayList<ItemAction>();
        for (SpeakItem speakItem : this.speakItems) {
            actionList.add(new ItemAction(speakItem, ActionType.CLEAR));
        }
        this.speakItems.clear();
        if (this.pptItem != null) {
            this.speakItems.add(0, this.pptItem);
        }
        return actionList;
    }

    public List<ItemAction> processUnActiveLocalPresenterItemActions(SpeakItem speakItem) {
        this.itemActions.clear();
        SpeakItem oldPresenter = null;
        for (SpeakItem item : this.speakItems) {
            if (item.getItemType() != SpeakItemType.Presenter) continue;
            oldPresenter = item;
            break;
        }
        if (oldPresenter instanceof RemoteItem) {
            ((RemoteItem)oldPresenter).refreshItemType();
        }
        if (speakItem instanceof LocalItem) {
            ((LocalItem)speakItem).refreshItemType();
        }
        this.speakItems.remove(speakItem);
        int addPosition = this.getLastPositionOfItemType(SpeakItemType.Presenter);
        this.speakItems.add(addPosition, speakItem);
        this.itemActions.add(new ItemAction(speakItem, ActionType.ADD, this.getRealViewPosition(addPosition)));
        return this.itemActions;
    }

    private void printAllSpeakItemInfo() {
    }

    private void handlePPTItem(SpeakItem speakItem) {
        int addPosition = this.getLastPositionOfItemType(SpeakItemType.Presenter);
        this.itemActions.add(new ItemAction(speakItem, ActionType.ADD, this.getRealViewPosition(addPosition)));
    }

    private void handleLocalItem(LocalItem localItem) {
        if (this.speakItems.contains(localItem)) {
            if (!localItem.hasVideo()) {
                if (BaseUtilsKt.isMainVideoItem(localItem) || localItem.isForceKeepAlive()) {
                    return;
                }
                if (this.routerViewModel.getSpeakApplyStatusValue() == 2) {
                    return;
                }
                this.speakItems.remove(localItem);
                this.itemActions.add(new ItemAction(localItem, ActionType.CLEAR));
            }
        } else if (localItem.hasVideo() || this.routerViewModel.getSpeakApplyStatusValue() == 2) {
            int position = this.getLastPositionOfItemType(SpeakItemType.Record);
            this.speakItems.add(position, localItem);
            this.itemActions.add(new ItemAction(localItem, ActionType.ADD, this.getRealViewPosition(position)));
        }
    }

    @MainThread
    private void handleRemoteItem(RemoteItem remoteItem) {
        if (this.speakItems.contains(remoteItem)) {
            if (!remoteItem.hasVideo() && !remoteItem.hasAudio()) {
                boolean isPresenter;
                boolean bl = isPresenter = remoteItem.isPresenterVideo() && remoteItem.getMediaSourceType() == LPConstants.MediaSourceType.MainCamera;
                if (isPresenter || remoteItem.isKeepAlive()) {
                    return;
                }
                this.itemActions.add(new ItemAction(remoteItem, ActionType.CLEAR));
                this.speakItems.remove(remoteItem);
            } else {
                if (remoteItem.isPresenterVideo() && remoteItem.getMediaSourceType() == LPConstants.MediaSourceType.MainCamera) {
                    return;
                }
                if (remoteItem.hasVideo()) {
                    if (!remoteItem.isVideoStreaming()) {
                        this.speakItems.remove(remoteItem);
                        int addPosition = this.getLastPositionOfItemType(remoteItem.getItemType());
                        this.speakItems.add(addPosition, remoteItem);
                        this.itemActions.add(new ItemAction(remoteItem, ActionType.REMOVE));
                        this.itemActions.add(new ItemAction(remoteItem, ActionType.ADD, this.getRealViewPosition(addPosition)));
                    }
                } else {
                    this.speakItems.remove(remoteItem);
                    int addPosition = this.getLastPositionOfItemType(remoteItem.getItemType());
                    this.speakItems.add(addPosition, remoteItem);
                    this.itemActions.add(new ItemAction(remoteItem, ActionType.REMOVE));
                    this.itemActions.add(new ItemAction(remoteItem, ActionType.ADD, this.getRealViewPosition(addPosition)));
                }
            }
        } else {
            if (!(remoteItem.hasVideo() || remoteItem.hasAudio() || remoteItem.getMediaSourceType() != LPConstants.MediaSourceType.ExtScreenShare && remoteItem.getMediaSourceType() != LPConstants.MediaSourceType.ExtMedia)) {
                return;
            }
            boolean isPresenter = remoteItem.isPresenterVideo();
            if (!(remoteItem.hasVideo() || remoteItem.hasAudio() || isPresenter || remoteItem.isKeepAlive())) {
                return;
            }
            int addPosition = this.getLastPositionOfItemType(remoteItem.getItemType());
            this.speakItems.add(addPosition, remoteItem);
            this.itemActions.add(new ItemAction(remoteItem, ActionType.ADD, this.getRealViewPosition(addPosition)));
        }
    }

    public List<ItemAction> processUserCloseAction(RemoteItem remoteItem) {
        this.itemActions.clear();
        SpeakItemType preItemType = remoteItem.getItemType();
        remoteItem.refreshItemType();
        SpeakItemType postItemType = remoteItem.getItemType();
        if (preItemType != postItemType) {
            this.speakItems.remove(remoteItem);
            int position = this.getLastPositionOfItemType(postItemType);
            this.speakItems.add(position, remoteItem);
            this.itemActions.add(new ItemAction(remoteItem, ActionType.REMOVE));
            this.itemActions.add(new ItemAction(remoteItem, ActionType.ADD, this.getRealViewPosition(position)));
        }
        return this.itemActions;
    }

    public SpeakItem getSpeakItemByIdentity(String identity) {
        for (SpeakItem item : this.speakItems) {
            if (item == null || !TextUtils.equals((CharSequence)item.getIdentity(), (CharSequence)identity)) continue;
            return item;
        }
        return null;
    }

    public Playable getPlayableItemByUserNumber(String userNumber) {
        for (SpeakItem item : this.speakItems) {
            if (!(item instanceof Playable) || !userNumber.equals(((Playable)item).getUser().getNumber())) continue;
            return (Playable)item;
        }
        return null;
    }

    public List<SpeakItem> getSpeakItems() {
        return this.speakItems;
    }

    private int getRealViewPosition(int dataPosition) {
        for (int i = 0; i < dataPosition; ++i) {
            SpeakItem item = this.speakItems.get(i);
            if (!(item instanceof Switchable) || ((Switchable)item).getSwitchableStatus() != SwitchableStatus.MaxScreen) continue;
            return dataPosition - 1;
        }
        return dataPosition;
    }

    public int getLastPositionOfItemType(SpeakItemType type) {
        for (SpeakItem item : this.speakItems) {
            if (item instanceof Switchable && type.ordinal() >= item.getItemType().ordinal()) continue;
            return this.speakItems.indexOf(item);
        }
        return this.speakItems.size();
    }

    public int getItemSwitchBackPosition(SpeakItem speakItem) {
        return this.speakItems.indexOf(speakItem);
    }

    public static enum ActionType {
        ADD,
        REMOVE,
        FULLSCREEN,
        CLEAR;

    }

    public static class ItemAction {
        public SpeakItem speakItem;
        public ActionType action;
        public int value;

        public ItemAction(SpeakItem speakItem, ActionType action, int value) {
            this.speakItem = speakItem;
            this.action = action;
            this.value = value;
        }

        public ItemAction(SpeakItem speakItem, ActionType action) {
            this.speakItem = speakItem;
            this.action = action;
        }

        @VisibleForTesting
        public ActionType getAction() {
            return this.action;
        }

        @VisibleForTesting
        public int getValue() {
            return this.value;
        }
    }
}

