/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.skin;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.skin.AttrFactory;
import com.baijiayun.liveuibase.skin.SkinAttr;
import com.baijiayun.liveuibase.skin.SkinItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SkinInflateFactory
implements LayoutInflater.Factory {
    private List<SkinItem> mSkinItems = new ArrayList<SkinItem>();

    public View onCreateView(String name, Context context2, AttributeSet attrs) {
        ArrayList<SkinAttr> viewAttrs = new ArrayList<SkinAttr>();
        View view = this.createView(context2, name, attrs);
        for (int i = 0; i < attrs.getAttributeCount(); ++i) {
            String attrName = attrs.getAttributeName(i);
            String attrValue = attrs.getAttributeValue(i);
            if (!AttrFactory.isSupportedAttr(attrName) || !attrValue.startsWith("?") && !attrValue.startsWith("@drawable/")) continue;
            try {
                int id2 = Integer.parseInt(attrValue.substring(1));
                String entryName = context2.getResources().getResourceEntryName(id2);
                String typeName = context2.getResources().getResourceTypeName(id2);
                SkinAttr mSkinAttr = AttrFactory.get(attrName, id2, entryName, typeName);
                if (mSkinAttr != null) {
                    viewAttrs.add(mSkinAttr);
                }
                SkinItem skinItem = new SkinItem();
                skinItem.view = view;
                skinItem.attrs = viewAttrs;
                if (ThemeDataUtil.getThemeConfig() == null) {
                    this.mSkinItems.add(skinItem);
                    continue;
                }
                skinItem.apply(ThemeDataUtil.getThemeConfig());
                continue;
            }
            catch (Resources.NotFoundException | NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return view;
    }

    private View createView(Context context2, String name, AttributeSet attrs) {
        View view = null;
        try {
            if (-1 == name.indexOf(46)) {
                if ("View".equals(name)) {
                    view = LayoutInflater.from((Context)context2).createView(name, "android.view.", attrs);
                }
                if (view == null) {
                    view = LayoutInflater.from((Context)context2).createView(name, "android.widget.", attrs);
                }
                if (view == null) {
                    view = LayoutInflater.from((Context)context2).createView(name, "android.webkit.", attrs);
                }
            } else {
                view = LayoutInflater.from((Context)context2).createView(name, null, attrs);
            }
        }
        catch (Exception e) {
            view = null;
        }
        return view;
    }

    public void updateTheme(HashMap<Integer, Integer> themeConfig) {
        if (themeConfig == null) {
            return;
        }
        for (SkinItem skinItem : this.mSkinItems) {
            skinItem.apply(themeConfig);
        }
        this.mSkinItems.clear();
    }

    public void destroy() {
        this.mSkinItems.clear();
    }
}

