/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.chat.privatechat;

import android.text.TextUtils;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.liveuibase.chat.privatechat.ChatUsersContract;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.List;

public class ChatUsersPresenter
implements ChatUsersContract.Presenter {
    private ChatUsersContract.View view;
    private Disposable subscriptionOfUserDataChange;
    private boolean isLoading = false;
    private List<IUserModel> iChatUserModels;
    private List<IUserModel> filterUserList;
    private RouterViewModel routerViewModel;
    private String filter = "";
    private boolean chooseAtUser;

    public ChatUsersPresenter(ChatUsersContract.View view) {
        this.view = view;
    }

    public ChatUsersPresenter(ChatUsersContract.View view, boolean chooseAtUser) {
        this.view = view;
        this.chooseAtUser = chooseAtUser;
    }

    @Override
    public void setRouter(RouterViewModel routerViewModel2) {
        this.routerViewModel = routerViewModel2;
    }

    public void subscribe() {
        this.subscriptionOfUserDataChange = this.routerViewModel.getLiveRoom().getOnlineUserVM().getObservableOfOnlineUser().observeOn(AndroidSchedulers.mainThread()).subscribe(iUserModels -> {
            this.onChatUsersChanged();
            if (this.isLoading) {
                this.isLoading = false;
            }
            if (!this.isPrivateChatUserAvailable()) {
                this.routerViewModel.getPrivateChatUser().setValue(null);
                this.view.showPrivateChatLabel(null);
            }
            this.view.notifyDataChanged();
        });
        this.view.notifyDataChanged();
    }

    public void unSubscribe() {
        RxUtils.dispose((Disposable)this.subscriptionOfUserDataChange);
    }

    public void destroy() {
        this.view = null;
    }

    private void onChatUsersChanged() {
        List userModels = this.routerViewModel.getLiveRoom().getOnlineUserVM().getPrivateUser();
        if (this.iChatUserModels == null) {
            this.iChatUserModels = new ArrayList<IUserModel>();
        }
        this.iChatUserModels.clear();
        block4: for (int index = 0; index < userModels.size(); ++index) {
            IUserModel model = (IUserModel)userModels.get(index);
            if (this.routerViewModel.getLiveRoom().isTeacherOrAssistant()) {
                this.iChatUserModels.addAll(userModels);
                break;
            }
            if (this.routerViewModel.getLiveRoom().isGroupTeacherOrAssistant()) {
                if (this.routerViewModel.getLiveRoom().getOnlineUserVM().enableGroupUserPublic()) {
                    this.iChatUserModels.addAll(userModels);
                    break;
                }
                if ((model.getGroup() != 0 || model.getType() != LPConstants.LPUserType.Teacher && model.getType() != LPConstants.LPUserType.Assistant) && model.getGroup() != this.routerViewModel.getLiveRoom().getCurrentUser().getGroup()) continue;
                this.iChatUserModels.add(model);
                continue;
            }
            int chatRole = this.chooseAtUser ? 0 : this.routerViewModel.getLiveRoom().getChatVM().getWhatRoleStudentCanPrivateChatWith();
            switch (chatRole) {
                case 1: {
                    if (model.getType() == LPConstants.LPUserType.Teacher) break;
                    continue block4;
                }
                case 2: {
                    if (model.getType() == LPConstants.LPUserType.Assistant) break;
                    continue block4;
                }
                default: {
                    if (model.getType() != LPConstants.LPUserType.Teacher && model.getType() != LPConstants.LPUserType.Assistant) continue block4;
                }
            }
            if (this.routerViewModel.getLiveRoom().getOnlineUserVM().enableGroupUserPublic()) {
                this.iChatUserModels.add(model);
                continue;
            }
            if (model.getGroup() != 0 && model.getGroup() != this.routerViewModel.getLiveRoom().getCurrentUser().getGroup()) continue;
            this.iChatUserModels.add(model);
        }
        this.view.privateChatUserChanged(this.iChatUserModels.isEmpty());
    }

    private boolean isPrivateChatUserAvailable() {
        return this.iChatUserModels.contains(this.routerViewModel.getPrivateChatUser().getValue());
    }

    @Override
    public void chooseOneToChat(String chatName, boolean isEnter) {
        this.view.showPrivateChatLabel(chatName);
    }

    @Override
    public void setPrivateChatUser(IUserModel iUserModel) {
        this.routerViewModel.getPrivateChatUser().setValue((Object)iUserModel);
        this.view.notifyDataChanged();
    }

    @Override
    public IUserModel getPrivateChatUser() {
        return (IUserModel)this.routerViewModel.getPrivateChatUser().getValue();
    }

    @Override
    public int getCount() {
        int count = this.iChatUserModels.size();
        if (this.chooseAtUser && BaseUtilsKt.isAdmin(this.routerViewModel.liveRoom)) {
            ++count;
        }
        if (!TextUtils.isEmpty((CharSequence)this.filter)) {
            count = this.filterUserList.size();
        }
        return this.isLoading ? count + 1 : count;
    }

    @Override
    public IUserModel getUser(int position) {
        if (TextUtils.isEmpty((CharSequence)this.filter)) {
            if (this.chooseAtUser && BaseUtilsKt.isAdmin(this.routerViewModel.liveRoom)) {
                if (position == 0) {
                    LPUserModel userModel = new LPUserModel();
                    userModel.userId = "@";
                    return userModel;
                }
                return this.getOriginUser(position - 1);
            }
            return this.getOriginUser(position);
        }
        return this.getFilterUser(position);
    }

    private IUserModel getOriginUser(int position) {
        if (!this.isLoading) {
            return this.iChatUserModels.get(position);
        }
        IUserModel iUserModel = this.iChatUserModels.size() == position ? null : this.iChatUserModels.get(position);
        return iUserModel;
    }

    private IUserModel getFilterUser(int position) {
        if (!this.isLoading) {
            return this.filterUserList.get(position);
        }
        IUserModel iUserModel = this.filterUserList.size() == position ? null : this.filterUserList.get(position);
        return iUserModel;
    }

    @Override
    public void loadMore() {
        this.isLoading = true;
        if (this.routerViewModel.getLiveRoom().getOnlineUserVM().enableGroupUserPublic()) {
            this.routerViewModel.getLiveRoom().getOnlineUserVM().loadMoreUser(this.routerViewModel.getLiveRoom().getCurrentUser().getGroup());
        } else {
            this.routerViewModel.getLiveRoom().getOnlineUserVM().loadMoreUser();
        }
        this.onChatUsersChanged();
    }

    @Override
    public boolean isLoading() {
        return this.isLoading;
    }

    @Override
    public String getTeacherLabel() {
        return this.routerViewModel.getLiveRoom().getCustomizeTeacherLabel();
    }

    @Override
    public String getAssistantLabel() {
        return this.routerViewModel.getLiveRoom().getCustomizeAssistantLabel();
    }

    private void filterUserList(String filter) {
        this.filterUserList = new ArrayList<IUserModel>();
        filter = filter.toLowerCase();
        for (IUserModel userModel : this.iChatUserModels) {
            if (!userModel.getName().toLowerCase().contains(filter)) continue;
            this.filterUserList.add(userModel);
        }
    }

    @Override
    public void searchByName(String filter) {
        this.filter = filter;
        this.filterUserList(filter);
        this.loadMore();
    }

    @Override
    public RouterViewModel getRouter() {
        return this.routerViewModel;
    }
}

