/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.base;

import android.app.Activity;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.inputmethod.InputMethodManager;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.baijiayun.livebase.models.LPJoinCodeEnterRoomModel;
import com.baijiayun.livebase.models.LPSignEnterRoomModel;
import com.baijiayun.livecore.LiveSDK;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.utils.ExtensionKt;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import java.io.Serializable;

public abstract class LiveRoomBaseActivity
extends AppCompatActivity {
    protected boolean isForeground = true;
    protected DialogFragment tempDialogFragment;
    protected LPJoinCodeEnterRoomModel joinCodeEnterRoomModel;
    protected LPSignEnterRoomModel signEnterRoomModel;
    protected boolean showLoading = true;
    private final String FRAGMENTS_TAG = "android:support:fragments";

    public LiveRoomBaseActivity() {
        this.getSavedStateRegistry().unregisterSavedStateProvider("android:support:fragments");
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.getWindow().setFlags(0x1000000, 0x1000000);
        this.getWindow().addFlags(128);
        if (savedInstanceState != null) {
            savedInstanceState.remove("android:support:fragments");
            Bundle bundle = savedInstanceState.getBundle("androidx.lifecycle.BundlableSavedStateRegistry.key");
            if (bundle != null) {
                bundle.remove("android:support:fragments");
            }
        }
        super.onCreate(savedInstanceState);
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
        LiveSDK.AUTO_PLAY_SHARING_SCREEN_AND_MEDIA = true;
        if (Build.CPU_ABI.contains("x86")) {
            ExtensionKt.showToastMessage((Activity)this, this.getString(R.string.live_room_x86_not_supported));
            super.finish();
        }
        if (savedInstanceState == null) {
            this.joinCodeEnterRoomModel = (LPJoinCodeEnterRoomModel)this.getIntent().getSerializableExtra("code");
            this.signEnterRoomModel = (LPSignEnterRoomModel)this.getIntent().getSerializableExtra("sign");
            this.showLoading = this.getIntent().getBooleanExtra("show_loading", true);
        } else {
            this.joinCodeEnterRoomModel = (LPJoinCodeEnterRoomModel)savedInstanceState.getSerializable("code");
            this.signEnterRoomModel = (LPSignEnterRoomModel)savedInstanceState.getSerializable("sign");
            String domain = savedInstanceState.getString("custom_domain");
            if (!TextUtils.isEmpty((CharSequence)domain)) {
                LiveSDK.customEnvironmentPrefix = domain;
            }
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("code", (Serializable)this.joinCodeEnterRoomModel);
        outState.putSerializable("sign", (Serializable)this.signEnterRoomModel);
        outState.putString("custom_domain", LiveSDK.customEnvironmentPrefix);
    }

    public abstract RouterViewModel getRouterListener();

    protected void addFragment(int layoutId, Fragment fragment, boolean addToBackStack, String fragmentTag) {
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        if (fragmentTag == null) {
            transaction.add(layoutId, fragment);
        } else {
            transaction.add(layoutId, fragment, fragmentTag);
        }
        transaction.commitAllowingStateLoss();
    }

    protected void addFragment(int layoutId, Fragment fragment, boolean addToBackStack) {
        this.addFragment(layoutId, fragment, addToBackStack, null);
    }

    protected void addFragment(int layoutId, Fragment fragment, String tag) {
        this.addFragment(layoutId, fragment, false, tag);
    }

    protected void addFragment(int layoutId, Fragment fragment) {
        this.addFragment(layoutId, fragment, false);
    }

    protected Fragment findFragment(int layoutId) {
        FragmentManager fm = this.getSupportFragmentManager();
        return fm.findFragmentById(layoutId);
    }

    protected void removeFragment(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        transaction.remove(fragment);
        transaction.commitAllowingStateLoss();
    }

    protected void removeAllFragment() {
        for (Fragment fragment : this.getSupportFragmentManager().getFragments()) {
            if (fragment == null) continue;
            this.getSupportFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
        }
    }

    protected void hideFragment(Fragment fragment) {
        if (!fragment.isAdded()) {
            return;
        }
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        transaction.hide(fragment);
        transaction.commitAllowingStateLoss();
    }

    protected void replaceFragment(int layoutId, Fragment fragment) {
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        transaction.replace(layoutId, fragment);
        transaction.commitAllowingStateLoss();
    }

    protected void showFragment(Fragment fragment) {
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        transaction.show(fragment);
        transaction.commitAllowingStateLoss();
    }

    protected void switchFragment(Fragment from, Fragment to, int layoutId) {
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        if (to.isAdded()) {
            transaction.hide(from).show(to).commit();
        } else {
            transaction.hide(from).add(layoutId, to).commit();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (null != this.getCurrentFocus()) {
            InputMethodManager mInputMethodManager = (InputMethodManager)this.getSystemService("input_method");
            return mInputMethodManager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 0);
        }
        return super.onTouchEvent(event);
    }

    protected boolean showDialogFragment(DialogFragment dialogFragment) {
        if (this.isFinishing() || this.isDestroyed()) {
            return false;
        }
        this.closeExistSameDialog(dialogFragment);
        if (!this.isForeground) {
            this.tempDialogFragment = dialogFragment;
            return false;
        }
        try {
            dialogFragment.showNow(this.getSupportFragmentManager(), dialogFragment.getClass().getSimpleName());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void closeExistSameDialog(DialogFragment dialogFragment) {
        Fragment fragment = this.getSupportFragmentManager().findFragmentByTag(dialogFragment.getClass().getSimpleName());
        if (fragment instanceof DialogFragment) {
            ((DialogFragment)fragment).dismissAllowingStateLoss();
        }
    }

    protected void onPause() {
        super.onPause();
        this.isForeground = false;
    }

    protected void onResume() {
        super.onResume();
        this.isForeground = true;
        if (this.tempDialogFragment != null) {
            this.showDialogFragment(this.tempDialogFragment);
            this.tempDialogFragment = null;
        }
    }
}

