/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.base;

import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseWindow;
import com.baijiayun.liveuibase.base.LiveRoomBaseActivity;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;

public abstract class BaseComplexWindow
extends BaseWindow {
    protected FragmentManager mFragmentManager;
    protected RouterViewModel mRouterViewModel;
    protected FrameLayout complexContainer;
    protected boolean isLiveEE;
    protected boolean isPortrait;

    public BaseComplexWindow(Context context2, FragmentManager fragmentManager) {
        super(context2);
        this.mFragmentManager = fragmentManager;
        if (context2 instanceof LiveRoomBaseActivity) {
            this.mRouterViewModel = ((LiveRoomBaseActivity)context2).getRouterListener();
        }
        this.isLiveEE = this.mRouterViewModel.isLiveEE();
        this.isPortrait = DisplayUtils.isPortrait((Context)context2);
        if (this.isLiveEE) {
            this.view.setBackground(ThemeDataUtil.getBiggerHalfCornerWindowBg((Context)context2, (!DisplayUtils.isPortrait((Context)context2) ? 1 : 0) != 0));
        } else {
            this.view.setBackground(ThemeDataUtil.getCommonWindowBg((Context)context2));
        }
        this.init();
        this.onCreateContainerView(context2);
        this.initView();
    }

    @Override
    protected View onCreateView(Context context2) {
        this.setNeedShowShadow(true);
        return View.inflate((Context)context2, (int)R.layout.bjy_ee_base_complex_window, null);
    }

    protected void setBackBtnVisibility(int visibility) {
        if (this.isLiveEE) {
            this.$.id(R.id.iv_complex_window_back).visibility(visibility);
        }
    }

    protected void setRefreshBtnVisibility(int visibility) {
        if (this.isLiveEE) {
            this.$.id(R.id.iv_complex_window_refresh).visibility(visibility);
        }
    }

    protected void setTitle(String title) {
        if (this.isLiveEE) {
            this.$.id(R.id.tv_complex_window_title).text((CharSequence)title);
        }
    }

    protected void setTitle(int resId) {
        this.setTitle(this.getString(resId));
    }

    private void init() {
        this.complexContainer = (FrameLayout)this.view.findViewById(R.id.complex_window_container);
        this.setBackBtnVisibility(this.isShowBackBtn() ? 0 : 8);
        this.setRefreshBtnVisibility(this.isShowRefreshBtn() ? 0 : 8);
        this.$.id(R.id.tv_complex_window_title).text((CharSequence)this.getDefaultWindowTitle());
        this.setBackListener();
        this.setRefreshListener();
        this.setExitListener();
    }

    protected void setBackListener() {
    }

    protected void setRefreshListener() {
    }

    protected abstract void setExitListener();

    protected abstract String getDefaultWindowTitle();

    protected abstract boolean isShowRefreshBtn();

    protected abstract boolean isShowBackBtn();

    protected abstract void onCreateContainerView(Context var1);

    protected abstract void initView();

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mRouterViewModel = null;
    }

    protected void showFragment(Fragment fragment) {
        FragmentTransaction transaction = this.mFragmentManager.beginTransaction();
        transaction.replace(R.id.complex_window_container, fragment).commit();
    }

    protected void removeFragment(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        FragmentTransaction transaction = this.mFragmentManager.beginTransaction();
        transaction.remove(fragment);
        transaction.commitAllowingStateLoss();
    }
}

