/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.base;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.baijiayun.liveuibase.base.ViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAdapter<T>
extends android.widget.BaseAdapter {
    protected Context mContext;
    protected List<T> mDatas;
    protected int mItemLayoutId;

    public BaseAdapter(Context context2, int itemLayoutId) {
        this(context2, itemLayoutId, null);
    }

    public BaseAdapter(Context context2, int itemLayoutId, List<T> datas) {
        this.mContext = context2;
        this.mItemLayoutId = itemLayoutId;
        this.mDatas = datas == null ? new ArrayList() : datas;
    }

    public int getCount() {
        return this.mDatas.size();
    }

    public T getItem(int position) {
        return this.mDatas.get(position);
    }

    public void setNewData(List<T> datas) {
        if (datas == null) {
            return;
        }
        this.mDatas = datas;
        this.notifyDataSetChanged();
    }

    public void addAll(List<T> datas) {
        this.mDatas.addAll(datas);
        this.notifyDataSetChanged();
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = this.getViewHolder(convertView, parent);
        this.convert(viewHolder, this.getItem(position), position);
        return viewHolder.getConvertView();
    }

    public abstract void convert(ViewHolder var1, T var2, int var3);

    private ViewHolder getViewHolder(View convertView, ViewGroup parent) {
        return ViewHolder.get(this.mContext, convertView, parent, this.mItemLayoutId);
    }
}

