/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.announcement.modelui;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.widget.TextView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.livebase.base.BaseFragment;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.imodels.IAnnouncementModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.announcement.modelui.DoubleAnnContract;

public class DoubleAnnFragment
extends BaseFragment
implements DoubleAnnContract.View {
    private IAnnouncementModel mIAnnouncementModel;
    private boolean isTeacher = true;

    public int getLayoutId() {
        return R.layout.bjy_fragment_announcement_double_ann;
    }

    public void setPresenter(DoubleAnnContract.Presenter presenter2) {
        this.setBasePresenter(presenter2);
    }

    protected void init(Bundle savedInstanceState) {
        super.init(savedInstanceState);
        TextView text1 = (TextView)this.$.id(R.id.tv_announcement_notice_info).view();
        TextView text2 = (TextView)this.$.id(R.id.tv_announcement_notice_group_info).view();
        text1.setMovementMethod(ScrollingMovementMethod.getInstance());
        text2.setMovementMethod(ScrollingMovementMethod.getInstance());
        if (this.mIAnnouncementModel != null) {
            this.setNoticeInfo(this.mIAnnouncementModel);
        }
    }

    @Override
    public void setType(int type, int groupId) {
        if (type == 1001) {
            this.$.id(R.id.tv_announcement_double_group_title2).visibility(4);
            this.$.id(R.id.tv_announcement_notice_group_info).visibility(4);
            this.$.id(R.id.tv_double_ann_info).visibility(8);
            this.$.id(R.id.iv_double_ann_down).visibility(8);
        } else if (type == 1002) {
            this.isTeacher = true;
            this.showDownUI(false);
        } else {
            this.isTeacher = false;
            this.showDownUI(false);
        }
        if (groupId == 0) {
            this.$.id(R.id.tv_announcement_double_group_delimiter).visibility(8);
            this.$.id(R.id.tv_announcement_double_group_title2).visibility(8);
            this.$.id(R.id.tv_announcement_notice_group_info).visibility(8);
            this.$.id(R.id.tv_announcement_double_info_tips).visibility(8);
        }
    }

    @Override
    public void setNoticeInfo(IAnnouncementModel iAnnouncementModel) {
        String link;
        View linkTipsView;
        View view;
        if (this.$ == null) {
            this.mIAnnouncementModel = iAnnouncementModel;
            return;
        }
        int themeTextColor = ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_window_main_text_color);
        if ("0".equals(iAnnouncementModel.getGroup()) || TextUtils.isEmpty((CharSequence)iAnnouncementModel.getGroup())) {
            view = this.$.id(R.id.tv_announcement_notice_info).view();
            linkTipsView = this.$.id(R.id.tv_announcement_notice_info_tips).view();
            TextView textView = (TextView)view;
            textView.setTextColor(themeTextColor);
            if (TextUtils.isEmpty((CharSequence)iAnnouncementModel.getContent())) {
                textView.setTextColor(Color.parseColor((String)"#FF999999"));
                this.$.id(R.id.tv_announcement_notice_info).text((CharSequence)this.getResources().getString(R.string.live_announcement_none));
                link = null;
            } else {
                this.$.id(R.id.tv_announcement_notice_info).text((CharSequence)iAnnouncementModel.getContent());
                link = iAnnouncementModel.getLink();
            }
        } else {
            view = this.$.id(R.id.tv_announcement_notice_group_info).view();
            linkTipsView = this.$.id(R.id.tv_announcement_double_info_tips).view();
            TextView textView = (TextView)view;
            textView.setTextColor(themeTextColor);
            if ("notice_change".equals(iAnnouncementModel.getMessageType())) {
                if (TextUtils.isEmpty((CharSequence)iAnnouncementModel.getContent())) {
                    textView.setTextColor(Color.parseColor((String)"#FF999999"));
                    this.$.id(R.id.tv_announcement_notice_group_info).text((CharSequence)this.getResources().getString(R.string.string_notice_group_none));
                    link = null;
                } else {
                    this.$.id(R.id.tv_announcement_notice_group_info).text((CharSequence)iAnnouncementModel.getContent());
                    link = iAnnouncementModel.getLink();
                }
            } else if (iAnnouncementModel.getSGroup() != null && !TextUtils.isEmpty((CharSequence)iAnnouncementModel.getSGroup().content)) {
                this.$.id(R.id.tv_announcement_notice_group_info).text((CharSequence)iAnnouncementModel.getSGroup().content);
                link = iAnnouncementModel.getSGroup().link;
            } else {
                textView.setTextColor(Color.parseColor((String)"#FF999999"));
                this.$.id(R.id.tv_announcement_notice_group_info).text((CharSequence)this.getResources().getString(R.string.string_notice_group_none));
                link = null;
            }
        }
        this.setTipsLinkViewInfo(linkTipsView, link);
        this.setUrl(view, link);
    }

    private void setTipsLinkViewInfo(View view, String link) {
        if (view == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)link)) {
            ((TextView)view).setText((CharSequence)"");
        } else {
            ((TextView)view).setText((CharSequence)this.getResources().getString(R.string.string_notice_link_tips));
        }
    }

    private void showDownUI(boolean isShow) {
        if (isShow) {
            this.$.id(R.id.tv_double_ann_info).visibility(8);
            this.$.id(R.id.iv_double_ann_down).visibility(8);
        } else if (this.isTeacher) {
            this.$.id(R.id.tv_double_ann_info).visibility(0);
            this.$.id(R.id.iv_double_ann_down).visibility(0);
        } else {
            this.$.id(R.id.tv_double_ann_info).visibility(8);
            this.$.id(R.id.iv_double_ann_down).visibility(8);
        }
    }

    private void setUrl(View view, String url) {
        if (view == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            view.setOnClickListener(null);
        } else {
            view.setOnClickListener(v -> UtilsKt.startActivityByUrl((Context)this.getContext(), (String)url));
        }
    }
}

