/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.announcement;

import android.text.TextUtils;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.models.imodels.IAnnouncementModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.announcement.AnnouncementContract;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;

public class AnnouncementPresenter
implements AnnouncementContract.Presenter {
    private final String TAG = AnnouncementPresenter.class.getName();
    private AnnouncementContract.View view;
    private RouterViewModel routerViewModel;
    private Disposable subscriptionOfAnnouncementChange;

    public AnnouncementPresenter(AnnouncementContract.View view) {
        this.view = view;
    }

    @Override
    public void setRouter(RouterViewModel liveRoomRouterListener) {
        this.routerViewModel = liveRoomRouterListener;
    }

    @Override
    public RouterViewModel getRouter() {
        return this.routerViewModel;
    }

    @Override
    public boolean canOperateNotice() {
        return this.routerViewModel.getLiveRoom().getCurrentUser().getType() != LPConstants.LPUserType.Assistant || this.routerViewModel.getLiveRoom().getAdminAuth() == null || this.routerViewModel.getLiveRoom().getAdminAuth().notice;
    }

    public void subscribe() {
        this.subscriptionOfAnnouncementChange = this.routerViewModel.getLiveRoom().getObservableOfAnnouncementChange().observeOn(AndroidSchedulers.mainThread()).subscribe(iAnnouncementModel -> {
            if (iAnnouncementModel == null) {
                return;
            }
            if (this.routerViewModel.getLiveRoom().isTeacherOrAssistant() && TextUtils.isEmpty((CharSequence)iAnnouncementModel.getContent())) {
                this.view.showBlankTips();
                return;
            }
            this.view.setNoticeInfo((IAnnouncementModel)iAnnouncementModel);
        });
        this.switchUI();
    }

    @Override
    public void switchUI() {
        int groupId = this.routerViewModel.getLiveRoom().getCurrentUser().getGroup();
        if (this.routerViewModel.getLiveRoom().isTeacherOrAssistant()) {
            this.view.editButtonEnable(true, R.string.live_edit);
            this.view.showCurrUI(1001, groupId);
        } else if (this.routerViewModel.getLiveRoom().isGroupTeacherOrAssistant()) {
            this.view.editButtonEnable(true, R.string.string_notice_group);
            this.view.showCurrUI(1002, groupId);
        } else {
            this.view.editButtonEnable(false, 0);
            this.view.showCurrUI(1003, groupId);
        }
        if (this.routerViewModel.getLiveRoom().isTeacherOrAssistant()) {
            this.routerViewModel.getLiveRoom().requestAnnouncement(0);
        } else {
            this.routerViewModel.getLiveRoom().requestAnnouncement(0);
            this.routerViewModel.getLiveRoom().requestAnnouncement(this.routerViewModel.getLiveRoom().getCurrentUser().getGroup());
        }
    }

    public void unSubscribe() {
        RxUtils.dispose((Disposable)this.subscriptionOfAnnouncementChange);
    }

    public void destroy() {
        this.routerViewModel = null;
        this.view = null;
    }

    @Override
    public void saveAnnouncement(String text, String url) {
        if (!(TextUtils.isEmpty((CharSequence)url) || url.startsWith("http://") || url.startsWith("https://"))) {
            url = "http://" + url;
        }
        int group = 0;
        group = this.routerViewModel.getLiveRoom().isTeacherOrAssistant() ? 0 : this.routerViewModel.getLiveRoom().getCurrentUser().getGroup();
        this.routerViewModel.getLiveRoom().changeRoomAnnouncement(group, text, url);
    }
}

