/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.chat.privatechat;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.load.Transformation;
import com.baijiayun.glide.load.resource.bitmap.CircleCrop;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.widgets.view.RoundImageView;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.chat.privatechat.ChatUsersContract;
import com.baijiayun.liveuibase.utils.ColorUtil;
import com.baijiayun.liveuibase.utils.DatabindingUtils;

public class ChatUserAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int VIEW_TYPE_USER = 0;
    private static final int VIEW_TYPE_LOADING = 1;
    private ChatUsersContract.Presenter presenter;
    private Context context;
    private ItemClickListener itemClickListener;

    public ChatUserAdapter(Context context2, ChatUsersContract.Presenter presenter2) {
        this.context = context2;
        this.presenter = presenter2;
    }

    public void setItemClickListener(ItemClickListener itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    public int getItemViewType(int position) {
        return this.presenter.getUser(position) == null ? 1 : 0;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_item_chat_user, parent, false);
            return new ChatUserViewHolder(view);
        }
        if (viewType == 1) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_item_chat_user_loadmore, parent, false);
            return new LoadingViewHolder(view);
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof ChatUserViewHolder) {
            IUserModel userModel = this.presenter.getUser(position);
            String teacherLabel = this.presenter.getTeacherLabel();
            String assistantLabel = this.presenter.getAssistantLabel();
            ChatUserViewHolder userViewHolder = (ChatUserViewHolder)holder;
            if (this.presenter.getPrivateChatUser() != null && userModel.getUserId().equals(this.presenter.getPrivateChatUser().getUserId())) {
                userViewHolder.privateChatUser.setBackgroundColor(this.context.getResources().getColor(R.color.base_main_color_layer_20));
            } else {
                userViewHolder.privateChatUser.setBackgroundColor(this.context.getResources().getColor(R.color.base_transparent));
            }
            if (userModel.getType() == LPConstants.LPUserType.Teacher) {
                userViewHolder.teacherTag.setVisibility(0);
                userViewHolder.teacherTag.setText((CharSequence)(TextUtils.isEmpty((CharSequence)teacherLabel) ? this.context.getString(R.string.live_teacher) : teacherLabel));
            } else {
                userViewHolder.teacherTag.setVisibility(8);
            }
            if (userModel.getType() == LPConstants.LPUserType.Assistant) {
                userViewHolder.assistantTag.setVisibility(0);
                userViewHolder.assistantTag.setText((CharSequence)(TextUtils.isEmpty((CharSequence)assistantLabel) ? this.context.getString(R.string.live_assistant) : assistantLabel));
            } else {
                userViewHolder.assistantTag.setVisibility(8);
            }
            if ("@".equals(userModel.getUserId())) {
                userViewHolder.name.setText((CharSequence)this.context.getString(R.string.bjy_base_at_all));
                Glide.with((Context)this.context).load(Integer.valueOf(R.drawable.bjy_base_ic_at_all)).apply(RequestOptions.bitmapTransform((Transformation)new CircleCrop())).into((ImageView)userViewHolder.avatar);
                if (userModel instanceof LPUserModel) {
                    ((LPUserModel)userModel).number = "all";
                    ((LPUserModel)userModel).name = this.context.getString(R.string.bjy_base_at_all);
                }
            } else {
                userViewHolder.name.setText((CharSequence)UtilsKt.getEncodePhoneNumber((String)userModel.getName()));
                String avatar = userModel.getAvatar().startsWith("//") ? "https:" + userModel.getAvatar() : userModel.getAvatar();
                DatabindingUtils.loadImg((ImageView)userViewHolder.avatar, avatar);
                userViewHolder.avatar.setCircleBackgroundColor(Color.HSVToColor((float[])ColorUtil.getColor(userModel.getNumber())));
            }
            userViewHolder.privateChatUser.setOnClickListener(view -> {
                if (this.itemClickListener != null) {
                    view.setBackgroundColor(this.context.getResources().getColor(R.color.base_main_color_layer_20));
                    this.itemClickListener.onItemClick(position, userModel, (View)userViewHolder.privateChatUser);
                }
            });
            userViewHolder.privateChatUser.setOnLongClickListener(view -> {
                view.setBackgroundColor(this.context.getResources().getColor(R.color.base_main_color_layer_20));
                return false;
            });
        } else if (holder instanceof LoadingViewHolder) {
            LoadingViewHolder loadingViewHolder = (LoadingViewHolder)holder;
            loadingViewHolder.progressBar.setIndeterminate(true);
        }
    }

    public int getItemCount() {
        return this.presenter.getCount();
    }

    public static interface ItemClickListener {
        public void onItemClick(int var1, IUserModel var2, View var3);
    }

    private static class ChatUserViewHolder
    extends RecyclerView.ViewHolder {
        TextView name;
        TextView teacherTag;
        TextView assistantTag;
        RoundImageView avatar;
        RelativeLayout privateChatUser;

        ChatUserViewHolder(View itemView) {
            super(itemView);
            this.name = (TextView)itemView.findViewById(R.id.item_chat_user_name);
            this.avatar = (RoundImageView)itemView.findViewById(R.id.item_chat_user_avatar);
            this.teacherTag = (TextView)itemView.findViewById(R.id.item_chat_user_teacher_tag);
            this.teacherTag.setBackground(ThemeDataUtil.getUserTagBg((Context)itemView.getContext()));
            this.assistantTag = (TextView)itemView.findViewById(R.id.item_chat_user_assist_tag);
            this.assistantTag.setBackground(ThemeDataUtil.getUserTagBg((Context)itemView.getContext()));
            this.privateChatUser = (RelativeLayout)itemView.findViewById(R.id.item_private_chat_user);
        }
    }

    private static class LoadingViewHolder
    extends RecyclerView.ViewHolder {
        ProgressBar progressBar;

        private LoadingViewHolder(View itemView) {
            super(itemView);
            this.progressBar = (ProgressBar)itemView.findViewById(R.id.item_chat_user_progress);
        }
    }
}

