/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.R;

public class CircleTextView
extends AppCompatTextView {
    private float ratio = 1.0f;
    private Paint mPaint;
    private RectF oval;

    public CircleTextView(Context context2) {
        super(context2);
        this.init();
    }

    public CircleTextView(Context context2, @Nullable AttributeSet attrs) {
        super(context2, attrs);
        this.init();
    }

    public CircleTextView(Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(4.0f);
        this.mPaint.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_live_product_color));
        this.oval = new RectF();
    }

    public void setCircleBackgroundColor(@ColorInt int color2) {
        this.mPaint.setColor(color2);
    }

    protected void onDraw(Canvas canvas) {
        int x = this.getWidth();
        int y = this.getHeight();
        int radius = y / 2;
        this.oval.set((float)x / 2.0f - (float)radius, (float)y / 2.0f - (float)radius, (float)x / 2.0f + (float)radius, (float)y / 2.0f + (float)radius);
        canvas.drawArc(this.oval, -90.0f, 360.0f * this.ratio, false, this.mPaint);
        super.onDraw(canvas);
    }

    public void setRatio(float ratio) {
        this.ratio = ratio;
    }

    public float getRatio() {
        return this.ratio;
    }
}

