/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.redpacket.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livecore.models.LPRedPacketModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.toolbox.redpacket.widget.DrawHandler;
import com.baijiayun.liveuibase.toolbox.redpacket.widget.DrawInterface;
import com.baijiayun.liveuibase.toolbox.redpacket.widget.MoveModel;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class TransparentSurfaceView
extends SurfaceView
implements DrawInterface {
    private final String TAG = TransparentSurfaceView.class.getName();
    private final int MAX_RED_PACKET_NUMBER = 10;
    private final int OPEN_SHOW_TIME = 500;
    private final int COUNT_OPEN_BITMAP = 14;
    private final int OPEN_SHOW_OPEN_TIME = 50;
    private final float RED_POCKET_DROP_TIME = 3.0f;
    private OnClickRedPacketListener onClickRedPacketListener;
    private DrawHandler drawHandler;
    private int width;
    private int height;
    private Bitmap bitmap;
    private Bitmap[] bitmapOpen;
    private int bitmapWidth;
    private int bitmapHeight;
    private int bitmapWidthOpen;
    private int bitmapHeightOpen;
    private Paint mPaintTitle;
    private Paint mPaintContext;
    private boolean isRobEnable = false;
    private List<MoveModel> moveList = new CopyOnWriteArrayList<MoveModel>();
    private List<RedPointF> pointFList = new CopyOnWriteArrayList<RedPointF>();
    private Paint bitmapPaint;
    private Paint strokePaint;
    private Paint fillPaint;
    private Paint debugPaint;
    private Path drawingPath;
    private boolean isPause;
    private Disposable disposableOfInterval;
    private int visibleCountOfScreen;
    private int totalCountOfScreen;
    private int totalDropCount;
    private RectF bitmapRect = new RectF();
    private RectF coinRect = new RectF();
    private int redPacketId = 1;

    public TransparentSurfaceView(Context context2) {
        this(context2, null);
        this.init(context2);
    }

    public TransparentSurfaceView(Context context2, AttributeSet attrs) {
        this(context2, attrs, -1);
        this.init(context2);
    }

    public TransparentSurfaceView(Context context2, AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.init(context2);
    }

    private void init(Context context2) {
        SurfaceHolder holder = this.getHolder();
        this.setZOrderOnTop(true);
        holder.setFormat(-3);
        this.mPaintTitle = new Paint();
        this.mPaintTitle.setAntiAlias(true);
        this.mPaintTitle.setColor(-1);
        this.mPaintTitle.setTextSize((float)UtilsKt.getDp((int)10));
        this.mPaintContext = new Paint();
        this.mPaintContext.setAntiAlias(true);
        this.mPaintContext.setColor(Color.parseColor((String)"#FFDBDB"));
        this.mPaintContext.setTextSize((float)UtilsKt.getDp((int)14));
        HandlerThread drawThread = new HandlerThread("redPacket");
        drawThread.start();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        this.drawHandler = new DrawHandler(drawThread.getLooper(), this);
        this.bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_packet_down, (BitmapFactory.Options)options);
        this.bitmapWidth = UtilsKt.getDp((int)59);
        this.bitmapHeight = UtilsKt.getDp((int)118);
        this.bitmapOpen = new Bitmap[14];
        this.bitmapOpen[0] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_1, (BitmapFactory.Options)options);
        this.bitmapOpen[1] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_2, (BitmapFactory.Options)options);
        this.bitmapOpen[2] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_3, (BitmapFactory.Options)options);
        this.bitmapOpen[3] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_4, (BitmapFactory.Options)options);
        this.bitmapOpen[4] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_5, (BitmapFactory.Options)options);
        this.bitmapOpen[5] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_6, (BitmapFactory.Options)options);
        this.bitmapOpen[6] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_7, (BitmapFactory.Options)options);
        this.bitmapOpen[7] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_8, (BitmapFactory.Options)options);
        this.bitmapOpen[8] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_9, (BitmapFactory.Options)options);
        this.bitmapOpen[9] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_10, (BitmapFactory.Options)options);
        this.bitmapOpen[10] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_11, (BitmapFactory.Options)options);
        this.bitmapOpen[11] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_12, (BitmapFactory.Options)options);
        this.bitmapOpen[12] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_13, (BitmapFactory.Options)options);
        this.bitmapOpen[13] = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.bjy_base_iv_lp_ui_red_open_14, (BitmapFactory.Options)options);
        this.bitmapHeightOpen = this.bitmapWidthOpen = UtilsKt.getDp((int)120);
        this.bitmapPaint = new Paint();
        this.bitmapPaint.setAntiAlias(true);
        this.strokePaint = new Paint();
        this.strokePaint.setAntiAlias(true);
        this.strokePaint.setColor(Color.parseColor((String)"#F7B500"));
        this.strokePaint.setStrokeWidth(3.0f);
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.fillPaint = new Paint();
        this.fillPaint.setAntiAlias(true);
        this.fillPaint.setColor(-1);
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.debugPaint = new Paint();
        this.debugPaint.setAntiAlias(true);
        this.debugPaint.setColor(-65536);
        this.debugPaint.setTextSize(40.0f);
        this.drawingPath = new Path();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.width = this.getMeasuredWidth();
        this.height = this.getMeasuredHeight();
    }

    public void start(LPRedPacketModel redPacketModel) {
        this.isPause = false;
        this.moveList.clear();
        this.totalDropCount = 0;
        this.disposableOfInterval = Observable.interval((long)0L, (long)3L, (TimeUnit)TimeUnit.SECONDS).filter(aLong -> (float)aLong.longValue() < (float)redPacketModel.duration / 3.0f).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            for (int i = 0; i < 10; ++i) {
                this.generateModel();
            }
        });
        this.drawHandler.sendEmptyMessage(1);
    }

    public void pause() {
        if (!this.isPause) {
            this.drawHandler.sendEmptyMessage(2);
        }
        this.isPause = true;
        RxUtils.dispose((Disposable)this.disposableOfInterval);
    }

    public void setOnClickRedPacketListener(OnClickRedPacketListener listener2) {
        this.onClickRedPacketListener = listener2;
    }

    @Override
    public void startDraw() {
        SurfaceHolder holder = this.getHolder();
        Canvas canvas = holder.lockCanvas();
        if (null == canvas) {
            this.drawHandler.sendEmptyMessage(1);
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.visibleCountOfScreen = 0;
        this.totalCountOfScreen = 0;
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        for (MoveModel moveModel : this.moveList) {
            this.bitmapRect.set(moveModel.x, moveModel.y, moveModel.x + (float)this.bitmapWidth, moveModel.y + (float)this.bitmapHeight);
            if (moveModel.y >= (float)(-this.bitmapHeight)) {
                if (!moveModel.isOpen) {
                    if (moveModel.firstShowTime == 0L) {
                        moveModel.firstShowTime = System.currentTimeMillis();
                    }
                    canvas.drawBitmap(this.bitmap, null, this.bitmapRect, this.bitmapPaint);
                    ++this.visibleCountOfScreen;
                }
                ++this.totalCountOfScreen;
            }
            if (moveModel.y >= (float)this.height) {
                ++this.totalDropCount;
                this.moveList.remove(moveModel);
            } else {
                float second = (float)(timestamp - moveModel.createTime) / 1000.0f;
                float pixelPerSecond = (float)(this.height + this.bitmapHeight) / 3.0f;
                moveModel.y = pixelPerSecond * second + moveModel.initY;
            }
            if (!moveModel.isOpen) continue;
            if (moveModel.openedY == 0.0f) {
                moveModel.openedY = moveModel.y;
            }
            if (moveModel.hasShowCoinAnim || moveModel.scoreAmount <= 0) {
                moveModel.hasShowCoinAnim = true;
                continue;
            }
            if (moveModel.openTime == 0L) {
                moveModel.openTime = timestamp;
            }
            if (timestamp - moveModel.openTime < 500L) {
                float x = moveModel.x + (float)(this.bitmapWidth >> 1) - (float)(this.bitmapWidthOpen >> 1);
                float y = moveModel.openedY + (float)(this.bitmapHeight >> 1) - (float)(this.bitmapHeightOpen >> 1);
                int index = (int)((timestamp - moveModel.openTime) / 50L);
                if (index > 13) {
                    index = 13;
                }
                if (index < 0 || index >= this.bitmapOpen.length) continue;
                this.coinRect.set(x, y, x + (float)this.bitmapWidthOpen, y + (float)this.bitmapHeightOpen);
                canvas.drawBitmap(this.bitmapOpen[index], null, this.coinRect, this.bitmapPaint);
                int moveY = (int)(y + (float)(this.bitmapHeightOpen / 3) - (float)(index * (this.bitmapHeightOpen / 3 * 2) / 14));
                canvas.drawText("+" + moveModel.scoreAmount, x + (this.coinRect.right - this.coinRect.left) / 8.0f * 3.0f, (float)moveY, this.mPaintContext);
                continue;
            }
            moveModel.hasShowCoinAnim = true;
        }
        this.computePath(canvas, this.pointFList, 8.0f);
        if (holder.getSurface().isValid()) {
            holder.unlockCanvasAndPost(canvas);
        }
        this.drawHandler.sendEmptyMessage(1);
    }

    @Override
    public void stopDraw() {
        this.drawHandler.removeMessages(1);
        this.totalDropCount += this.totalCountOfScreen;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isRobEnable || this.isPause) {
            return true;
        }
        switch (event.getActionMasked()) {
            case 0: {
                this.pointFList.add(new RedPointF(event.getX(), event.getY()));
                this.checkInRect();
                break;
            }
            case 2: {
                int index = 0;
                for (int i = 0; i < this.pointFList.size(); ++i) {
                    if (System.currentTimeMillis() - this.pointFList.get((int)i).timeStamp > 200L) continue;
                    index = i;
                    break;
                }
                this.pointFList.removeAll(this.pointFList.subList(0, index));
                this.pointFList.add(new RedPointF(event.getX(), event.getY()));
                this.checkInRect();
                break;
            }
            case 1: 
            case 3: {
                this.pointFList.clear();
                break;
            }
        }
        return true;
    }

    private void computePath(Canvas canvas, List<RedPointF> points, float lineWidth) {
        int i;
        RedPointF[] pointArray = points.toArray(new RedPointF[0]);
        if (pointArray == null || pointArray.length <= 2) {
            return;
        }
        ArrayList<PointF> upPoints = new ArrayList<PointF>();
        ArrayList<PointF> downPoints = new ArrayList<PointF>();
        float x0 = pointArray[pointArray.length - 1].x;
        float y0 = pointArray[pointArray.length - 1].y;
        for (i = pointArray.length - 2; i > 0; --i) {
            float x1 = pointArray[i].x;
            float y1 = pointArray[i].y;
            float x2 = pointArray[i - 1].x;
            float y2 = pointArray[i - 1].y;
            float startLen = (float)Math.sqrt((y2 - y0) * (y2 - y0) + (x0 - x2) * (x0 - x2));
            float infLen = (float)Math.sqrt((y1 - y0) * (y1 - y0) + (x0 - x1) * (x0 - x1));
            float startX = (y2 - y0) / startLen;
            float startY = (x0 - x2) / startLen;
            float infX = (y1 - y0) / infLen;
            float infY = (x0 - x1) / infLen;
            float cta = infX * startX + infY * startY;
            int index = pointArray.length - 2 - i;
            float f = (float)(1.0 / (0.04 * (double)index * (double)index + 0.09 * (double)index + 1.0));
            float l = lineWidth * f;
            float verticalX = l / cta * startX;
            float verticalY = l / cta * startY;
            if (Math.abs(verticalX) > lineWidth) {
                float f2 = verticalX = verticalX > 0.0f ? lineWidth : -lineWidth;
            }
            if (Math.abs(verticalY) > lineWidth) {
                verticalY = verticalY > 0.0f ? lineWidth : -lineWidth;
            }
            upPoints.add(new PointF(x1 + verticalX, y1 + verticalY));
            downPoints.add(new PointF(x1 - verticalX, y1 - verticalY));
            x0 = x1;
            y0 = y1;
        }
        this.drawingPath.reset();
        this.drawingPath.moveTo(((PointF)upPoints.get((int)0)).x, ((PointF)upPoints.get((int)0)).y);
        for (i = 1; i < upPoints.size(); ++i) {
            this.drawingPath.lineTo(((PointF)upPoints.get((int)i)).x, ((PointF)upPoints.get((int)i)).y);
        }
        this.drawingPath.lineTo(pointArray[0].x, pointArray[0].y);
        Collections.reverse(downPoints);
        for (i = 0; i < downPoints.size(); ++i) {
            this.drawingPath.lineTo(((PointF)downPoints.get((int)i)).x, ((PointF)downPoints.get((int)i)).y);
        }
        this.drawingPath.close();
        canvas.drawPath(this.drawingPath, this.strokePaint);
        canvas.drawPath(this.drawingPath, this.fillPaint);
    }

    private void checkInRect() {
        if (this.onClickRedPacketListener == null) {
            return;
        }
        for (PointF pointF : this.pointFList) {
            for (MoveModel moveModel : this.moveList) {
                Rect rect = new Rect((int)moveModel.x, (int)moveModel.y, (int)moveModel.x + this.bitmapWidth, (int)moveModel.y + this.bitmapHeight);
                if (moveModel.isRob || !rect.contains((int)pointF.x, (int)pointF.y)) continue;
                this.onClickRedPacketListener.onClick(moveModel);
                return;
            }
        }
    }

    private void generateModel() {
        Random random = new Random();
        MoveModel moveModel = new MoveModel();
        moveModel.moveId = this.redPacketId++;
        moveModel.x = (float)random.nextInt(11) * ((float)(this.width - this.bitmapWidth) / 10.0f);
        moveModel.initY = moveModel.y = (float)(-this.bitmapHeight - random.nextInt(this.height));
        moveModel.createTime = System.currentTimeMillis();
        this.moveList.add(moveModel);
    }

    public void setRobEnable(boolean robEnable) {
        this.isRobEnable = robEnable;
    }

    public void destroy() {
        if (null != this.drawHandler) {
            this.drawHandler.removeCallbacksAndMessages(null);
            this.drawHandler.getLooper().quit();
        }
        this.moveList.clear();
        if (this.bitmap != null) {
            this.bitmap.recycle();
            this.bitmap = null;
        }
        if (this.bitmapOpen != null) {
            for (int i = 0; i < this.bitmapOpen.length; ++i) {
                this.bitmapOpen[i].recycle();
                this.bitmapOpen[i] = null;
            }
            this.bitmapOpen = null;
        }
    }

    public static interface OnClickRedPacketListener {
        public void onClick(MoveModel var1);
    }

    static class RedPointF
    extends PointF {
        public long timeStamp = System.currentTimeMillis();

        public RedPointF(float x, float y) {
            super(x, y);
        }
    }
}

