/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.browser;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.baijiayun.bjyutils.keyboard.KeyboardUtils;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.widgets.SimpleTextWatcher;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.widgets.view.webview.BJWebViewImpl;
import com.baijiayun.livecore.models.LPKVModel;
import com.baijiayun.livecore.models.LPWebPageInfoModel;
import com.baijiayun.livecore.models.animppt.LPAnimPPTBaseModel;
import com.baijiayun.livecore.utils.CommonUtils;
import com.baijiayun.livecore.utils.LPJsonUtils;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseTitleWindow2;
import com.baijiayun.liveuibase.base.BaseWindow;
import com.baijiayun.liveuibase.toolbox.browser.Tuple;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class BrowserWindow
extends BaseTitleWindow2 {
    private final String TAG = BrowserWindow.class.getCanonicalName();
    private static final String BJY_EXPLORER_PAGE_INFO = "bjy_explorer_page_info";
    private static final String WEB_PAGE_INFO = "web_page_info";
    private static final String TEMPLATE_LOAD_SUCCESS = "template_load_success";
    private static final String BROADCAST_SEND = "broadcast_send";
    private static final String BROADCAST_CACHE_REQ = "broadcast_cache_req";
    private LinearLayout flSearch;
    private ImageView ivRefresh;
    private EditText etUrl;
    private Button btnPublish;
    private TextView tvTips;
    private BJWebViewImpl webView;
    private CheckBox allowOperateCb;
    private boolean isPublished;
    public boolean isAdd;
    private CompositeDisposable disposables;
    private boolean templateLoadSuccess;
    private String url = "";
    private final Map<String, LPKVModel> caches = new ConcurrentHashMap<String, LPKVModel>();
    private boolean enableOpenWebPageWithIframe;

    public BrowserWindow(Context context2) {
        super(context2);
        this.initView(context2);
        this.initListener(context2);
        this.subscribe(context2);
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "ClickableViewAccessibility"})
    private void initView(final Context context2) {
        this.templateLoadSuccess = false;
        this.enableOpenWebPageWithIframe = this.routerListener.getLiveRoom().getPartnerConfig().enableOpenWebPageWithIframe && !TextUtils.isEmpty((CharSequence)this.routerListener.getLiveRoom().getPartnerConfig().toolboxOpenUrlTemplateWebpage);
        this.ivRefresh = (ImageView)this.$.id(R.id.window_publish_browser_iv_refresh).view();
        this.flSearch = (LinearLayout)this.$.id(R.id.window_publish_browser_layout_search).view();
        this.webView = (BJWebViewImpl)this.$.id(R.id.window_publish_browser_web_view).view();
        this.btnPublish = (Button)this.$.id(R.id.window_publish_browser_btn_publish).view();
        this.tvTips = (TextView)this.$.id(R.id.window_publish_browser_tv_tips).view();
        this.etUrl = (EditText)this.$.id(R.id.window_publish_browser_et_url).view();
        this.allowOperateCb = (CheckBox)this.$.id(R.id.window_publish_browser_cb).view();
        this.$.id(R.id.window_publish_browser_clear).clicked(v -> this.etUrl.setText((CharSequence)""));
        this.webView.clearCache(true);
        this.webView.clearHistory();
        this.webView.enableJavaScript((Object)this, "bridge");
        this.webView.getSettings().setMixedContentMode(0);
        String userAgentString = this.webView.getSettings().getUserAgentString();
        if (!userAgentString.contains("Mobile")) {
            String replace = userAgentString.replace("Safari", "Mobile Safari");
            this.webView.getSettings().setUserAgentString(replace);
        }
        if (this.enableOpenWebPageWithIframe) {
            this.webView.loadUrl(this.routerListener.getLiveRoom().getPartnerConfig().toolboxOpenUrlTemplateWebpage);
        }
        this.allowOperateCb.setVisibility(this.routerListener.getLiveRoom().getPartnerConfig().enableStudentOperateWebpage ? 0 : 8);
        this.webView.setOnTouchListener((v, event) -> this.canTouch());
        this.webView.setWebViewClient((WebViewClient)new BJWebViewImpl.BJWebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                try {
                    if (!request.getUrl().toString().startsWith("http")) {
                        context2.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)request.getUrl().toString())));
                    }
                    BrowserWindow.this.webView.loadUrl(request.getUrl().toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.e((String)BrowserWindow.this.TAG, (String)("shouldOverrideUrlLoading: " + e.getLocalizedMessage()));
                }
                return true;
            }

            public void onPageFinished(WebView view, String url) {
                try {
                    if (!BrowserWindow.this.enableOpenWebPageWithIframe) {
                        BrowserWindow.this.etUrl.setText((CharSequence)url);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.e((String)BrowserWindow.this.TAG, (String)("onPageFinished : " + e.getLocalizedMessage()));
                }
            }
        });
        LPWebPageInfoModel webPageInfo = this.routerListener.getLiveRoom().getToolBoxVM().getWebPageInfo();
        if (this.hasTeacherOrAssistantAuth()) {
            this.flSearch.setVisibility(0);
            if (webPageInfo != null) {
                this.btnPublish.setText((CharSequence)(webPageInfo.isOpenStatus() ? context2.getString(R.string.bjy_base_browser_take_back) : context2.getString(R.string.bjy_base_browser_publish)));
                if (webPageInfo.isOpenStatus()) {
                    this.isPublished = true;
                    this.openUrl(webPageInfo.url);
                    this.btnPublish.setEnabled(true);
                    this.flSearch.setVisibility(8);
                    this.tvTips.setVisibility(8);
                }
            }
        } else {
            this.rlFooterContainer.setVisibility(8);
            this.showSync(false);
            this.showFull(false);
            this.showClose(false);
            if (webPageInfo != null && webPageInfo.isOpenStatus()) {
                this.openUrl(webPageInfo.url);
            }
        }
        this.title(context2.getString(R.string.bjy_base_browser_title));
        this.$.id(R.id.window_publish_browser_tips).text((this.isPublished || !this.hasTeacherOrAssistantAuth()) && this.enableOpenWebPageWithIframe ? R.string.string_gc_user_loading : R.string.bjy_base_browser_not_open_tips);
    }

    private boolean canTouch() {
        LPWebPageInfoModel webPageInfo = this.routerListener.getLiveRoom().getToolBoxVM().getWebPageInfo();
        return webPageInfo != null && webPageInfo.allowOperate != 1 && this.routerListener.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void subscribe(Context context2) {
        this.disposables = new CompositeDisposable();
        this.disposables.add(RxUtils.clicks((View)this.allowOperateCb).throttleFirst(500L, TimeUnit.MILLISECONDS).subscribe(unit -> {
            LPWebPageInfoModel webPageInfo = this.routerListener.getLiveRoom().getToolBoxVM().getWebPageInfo();
            if (webPageInfo == null) {
                return;
            }
            webPageInfo.allowOperate = this.allowOperateCb.isChecked() ? 1 : 0;
            webPageInfo.actionType = 1;
            this.routerListener.getLiveRoom().getToolBoxVM().requestOpenWebPage(webPageInfo);
        }));
        this.disposables.add(this.routerListener.getLiveRoom().getToolBoxVM().getObservableOfWebPageInfo().observeOn(AndroidSchedulers.mainThread()).subscribe(webPageInfoModel -> {
            if (webPageInfoModel.actionType == 0) {
                if (this.hasTeacherOrAssistantAuth()) {
                    this.btnPublish.setText((CharSequence)(webPageInfoModel.isOpenStatus() ? context2.getString(R.string.bjy_base_browser_take_back) : context2.getString(R.string.bjy_base_browser_publish)));
                    this.btnPublish.setEnabled(true);
                    if (webPageInfoModel.isOpenStatus()) {
                        this.openUrl(webPageInfoModel.url);
                        this.flSearch.setVisibility(8);
                        this.tvTips.setVisibility(8);
                    } else {
                        this.webView.stopLoading();
                        this.isPublished = false;
                        this.flSearch.setVisibility(0);
                        this.tvTips.setVisibility(0);
                        this.closeWebPage();
                    }
                }
            } else {
                this.allowOperateCb.setChecked(webPageInfoModel.allowOperate == 1);
                this.webView.setOnTouchListener((v, event) -> this.canTouch());
            }
        }));
        if (this.enableOpenWebPageWithIframe) {
            this.disposables.add(this.routerListener.getLiveRoom().getObservableOfBroadcast().mergeWith((ObservableSource)this.routerListener.getLiveRoom().getObservableOfBroadcastCache()).observeOn(AndroidSchedulers.mainThread()).subscribe(lpkvModel -> {
                if (BJY_EXPLORER_PAGE_INFO.equals(lpkvModel.key)) {
                    JsonObject jsonObject;
                    if (lpkvModel.value instanceof JsonPrimitive) {
                        JsonPrimitive jsonPrimitive = (JsonPrimitive)lpkvModel.value;
                        String json = jsonPrimitive.getAsString();
                        lpkvModel.value = LPJsonUtils.parseString((String)json, Object.class);
                    }
                    if (lpkvModel.value != null && (jsonObject = LPJsonUtils.toJsonObject((Object)lpkvModel.value)).has("currentPage")) {
                        this.receive((LPKVModel)lpkvModel);
                    }
                }
            }));
        }
    }

    protected void closeWebPage() {
    }

    public void clearBroadcastCache() {
        this.routerListener.getLiveRoom().sendBroadcast(BJY_EXPLORER_PAGE_INFO, new Object(), true);
    }

    private void initListener(Context context2) {
        if (this.hasTeacherOrAssistantAuth()) {
            this.setOnWindowRepositionListener(new BaseWindow.OnWindowRepositionListener(){

                @Override
                public void onWindowMove(int x, int y) {
                    if (BrowserWindow.this.isMaxInFull || !BrowserWindow.this.hasTeacherOrAssistantAuth()) {
                        return;
                    }
                    BrowserChangeListener browserChangeListener2 = BrowserWindow.this.getBrowserChangeListener();
                    if (browserChangeListener2 != null) {
                        browserChangeListener2.onRepositionWebpage(new Tuple("move", BrowserWindow.this.getId(), x, y));
                    }
                }

                @Override
                public void OnWindowScale(int newWidth, int newHeight) {
                    if (BrowserWindow.this.isMaxInFull || !BrowserWindow.this.hasTeacherOrAssistantAuth()) {
                        return;
                    }
                    BrowserChangeListener browserChangeListener2 = BrowserWindow.this.getBrowserChangeListener();
                    if (browserChangeListener2 != null) {
                        browserChangeListener2.onRepositionWebpage(new Tuple("scale", BrowserWindow.this.getId(), newWidth, newHeight));
                    }
                }
            });
        }
        this.ivClose.setOnClickListener(v -> {
            BrowserChangeListener browserChangeListener2 = this.getBrowserChangeListener();
            if (!this.hasTeacherOrAssistantAuth() || browserChangeListener2 == null) {
                return;
            }
            if (this.isPublished) {
                browserChangeListener2.onCloseBrowser();
            } else {
                browserChangeListener2.onOpenBrowser(false);
            }
        });
        this.ivRefresh.setOnClickListener(v -> this.openUrl(this.etUrl.getText().toString().trim()));
        this.etUrl.addTextChangedListener((TextWatcher)new SimpleTextWatcher());
        this.etUrl.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == 2) {
                this.openUrl(v.getText().toString().trim());
                KeyboardUtils.hideSoftInput((View)this.etUrl);
                this.ivRefresh.setEnabled(true);
                this.btnPublish.setEnabled(true);
                return true;
            }
            return false;
        });
        this.btnPublish.setOnClickListener(v -> {
            LPWebPageInfoModel webPageInfoModel = this.routerListener.getLiveRoom().getToolBoxVM().getWebPageInfo();
            if (null == webPageInfoModel) {
                webPageInfoModel = new LPWebPageInfoModel();
            }
            int n = webPageInfoModel.allowOperate = this.allowOperateCb.isChecked() ? 1 : 0;
            if (TextUtils.isEmpty((CharSequence)webPageInfoModel.id)) {
                webPageInfoModel.id = this.routerListener.getLiveRoom().getCurrentUser().getNumber();
            }
            if (this.isPublished) {
                webPageInfoModel.status = 0;
                this.isPublished = false;
                this.isAdd = false;
            } else {
                webPageInfoModel.status = 1;
                String webpageUrl = this.etUrl.getText().toString().trim();
                if (!webpageUrl.startsWith("http://") && !webpageUrl.startsWith("https://")) {
                    webpageUrl = "https://" + webpageUrl;
                }
                webPageInfoModel.url = webpageUrl;
                this.isPublished = true;
                this.isAdd = true;
            }
            webPageInfoModel.actionType = 0;
            this.routerListener.getLiveRoom().getToolBoxVM().requestOpenWebPage(webPageInfoModel);
            BrowserChangeListener browserChangeListener2 = this.getBrowserChangeListener();
            if (browserChangeListener2 != null) {
                browserChangeListener2.onOpenWebpage(this);
            }
            LPLogger.d((String)this.TAG, (String)("requestOpen : " + webPageInfoModel.url));
        });
    }

    private void openUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = "https://" + url;
        }
        if (this.enableOpenWebPageWithIframe) {
            if (!this.templateLoadSuccess) {
                this.url = url;
                return;
            }
            this.etUrl.setText((CharSequence)url);
            IUserModel currentUserInfo = this.routerListener.getLiveRoom().getCurrentUser();
            StringBuilder urlBuilder = new StringBuilder(url);
            if (url.contains("?")) {
                urlBuilder.append("&");
            } else {
                urlBuilder.append("?");
            }
            urlBuilder.append("userNumber=").append(currentUserInfo.getNumber()).append("&userName=").append(CommonUtils.encodeUTF8((String)currentUserInfo.getName())).append("&classId=").append(this.routerListener.getLiveRoom().getRoomInfo().roomId).append("&userType=").append(currentUserInfo.getType().getType());
            url = CommonUtils.encodeUTF8((String)urlBuilder.toString());
            JsonObject valueObj = new JsonObject();
            valueObj.addProperty("url", url);
            LPKVModel lpkvModel = new LPKVModel();
            lpkvModel.key = WEB_PAGE_INFO;
            lpkvModel.value = valueObj;
            this.receive(lpkvModel);
        } else {
            this.webView.loadUrl(url);
        }
        if (this.webView.getVisibility() == 8) {
            this.webView.setVisibility(0);
        }
    }

    private void receive(LPKVModel lpkvModel) {
        if (this.webView == null) {
            return;
        }
        if (!this.templateLoadSuccess) {
            this.caches.put(lpkvModel.key, lpkvModel);
            return;
        }
        this.webView.post(() -> {
            if (this.webView != null) {
                LPAnimPPTBaseModel lpAnimPPTBaseModel = new LPAnimPPTBaseModel();
                lpAnimPPTBaseModel.name = "rs_receive";
                lpAnimPPTBaseModel.data = LPJsonUtils.toJsonObject((Object)lpkvModel);
                this.webView.loadUrl("javascript:bridge.receive(" + LPJsonUtils.toString((Object)lpAnimPPTBaseModel) + ")");
            }
        });
    }

    private void sendInMainThread(String json) {
        JsonObject jsonObject = LPJsonUtils.toJsonObject((String)json);
        if (jsonObject.has("name")) {
            String name = jsonObject.get("name").getAsString();
            JsonObject data = jsonObject.get("data").getAsJsonObject();
            LPKVModel lpkvModel = (LPKVModel)LPJsonUtils.parseJsonObject((JsonObject)data, LPKVModel.class);
            switch (name) {
                case "template_load_success": {
                    if (this.templateLoadSuccess) {
                        for (LPKVModel kvModel : this.caches.values()) {
                            this.receive(kvModel);
                        }
                        this.caches.clear();
                    }
                    this.templateLoadSuccess = true;
                    if (TextUtils.isEmpty((CharSequence)this.url)) break;
                    this.openUrl(this.url);
                    this.url = "";
                    break;
                }
                case "broadcast_send": {
                    if (lpkvModel == null || TextUtils.isEmpty((CharSequence)lpkvModel.key) || !this.hasTeacherOrAssistantAuth()) break;
                    this.routerListener.getLiveRoom().sendBroadcast(BJY_EXPLORER_PAGE_INFO, lpkvModel.value, true);
                    break;
                }
                case "broadcast_cache_req": {
                    if (!this.enableOpenWebPageWithIframe || lpkvModel == null || TextUtils.isEmpty((CharSequence)lpkvModel.key)) break;
                    this.routerListener.getLiveRoom().requestBroadcastCache(BJY_EXPLORER_PAGE_INFO);
                    break;
                }
            }
        }
    }

    @JavascriptInterface
    public void send(String json) {
        if (this.webView == null) {
            return;
        }
        this.webView.post(() -> {
            if (this.webView != null) {
                this.sendInMainThread(json);
            }
        });
    }

    @Override
    public void scaleTo(int width, int height) {
        super.scaleTo(width, height);
    }

    @Override
    public String getId() {
        LPWebPageInfoModel webPageInfo = this.routerListener.getLiveRoom().getToolBoxVM().getWebPageInfo();
        if (webPageInfo == null || TextUtils.isEmpty((CharSequence)webPageInfo.id)) {
            return this.routerListener.getLiveRoom().getCurrentUser().getNumber();
        }
        return webPageInfo.id;
    }

    @Override
    protected void onCreateContentView(Context context2) {
        LayoutInflater.from((Context)context2).inflate(R.layout.window_publish_browser, (ViewGroup)this.rlContentContainer);
    }

    @Override
    protected void onCreateFooterView(Context context2) {
        LayoutInflater.from((Context)context2).inflate(R.layout.bjy_base_broswer_fotter, (ViewGroup)this.rlFooterContainer);
    }

    @Override
    public void onDestroy() {
        if (this.disposables != null) {
            this.disposables.clear();
        }
        if (this.webView != null) {
            this.webView.removeAllViews();
            ((ViewGroup)this.webView.getParent()).removeView((View)this.webView);
            this.webView.setTag(null);
            this.webView.destroy();
            this.webView = null;
        }
        super.onDestroy();
    }

    private BrowserChangeListener getBrowserChangeListener() {
        if (this.windowChangeListener instanceof BrowserChangeListener) {
            return (BrowserChangeListener)this.windowChangeListener;
        }
        return null;
    }

    public void setBrowserChangeListener(BrowserChangeListener browserChangeListener2) {
        this.windowChangeListener = browserChangeListener2;
    }

    public static interface BrowserChangeListener
    extends BaseTitleWindow2.WindowChangeListener {
        public void onOpenBrowser(boolean var1);

        public void onCloseBrowser();

        public void onRepositionWebpage(Tuple var1);

        public void onOpenWebpage(BrowserWindow var1);
    }
}

