/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.ppt.quickswitchppt;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.glide.Glide;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.base.BasePresenter;
import com.baijiayun.livebase.utils.AliCloudImageUtil;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPDocModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.ppt.quickswitchppt.SwitchPPTContract;
import com.baijiayun.liveuibase.widgets.dialog.ThemeMaterialDialogBuilder;
import java.util.ArrayList;
import java.util.List;

public class QuickSwitchPPTFragment
extends BaseDialogFragment
implements SwitchPPTContract.View {
    private SwitchPPTContract.Presenter presenter;
    private final List<LPDocModel> mBoardList = new ArrayList<LPDocModel>();
    private final List<LPDocModel> mPPTList = new ArrayList<LPDocModel>();
    private boolean isOpen = false;
    private QuickSwitchPPTAdapter adapter;
    private QuickSwitchPPTAdapter mPPTAdapter;
    private boolean isStudent = false;
    private boolean enableMultiWhiteboard = false;
    private int maxIndex;
    private int currentIndex;
    private int lastIndex;
    private boolean isChangePage = false;

    public static QuickSwitchPPTFragment newInstance(Bundle args) {
        QuickSwitchPPTFragment quickSwitchPPTFragment = new QuickSwitchPPTFragment();
        quickSwitchPPTFragment.setArguments(args);
        return quickSwitchPPTFragment;
    }

    protected int getLayoutId() {
        return R.layout.bjy_dialog_ppt_switch;
    }

    protected void init(Bundle savedInstanceState, Bundle arguments) {
        super.hideTitleBar();
        this.initView();
        LinearLayoutManager manager = new LinearLayoutManager((Context)this.getActivity());
        manager.setOrientation(0);
        this.adapter = new QuickSwitchPPTAdapter(this.mBoardList);
        ((RecyclerView)this.$.id(R.id.dialog_switch_ppt_rv).view()).setLayoutManager((RecyclerView.LayoutManager)manager);
        ((RecyclerView)this.$.id(R.id.dialog_switch_ppt_rv).view()).setAdapter((RecyclerView.Adapter)this.adapter);
        LinearLayoutManager managerPPT = new LinearLayoutManager((Context)this.getActivity());
        managerPPT.setOrientation(0);
        this.mPPTAdapter = new QuickSwitchPPTAdapter(this.mPPTList);
        ((RecyclerView)this.$.id(R.id.dialog_switch_ppt).view()).setLayoutManager((RecyclerView.LayoutManager)managerPPT);
        ((RecyclerView)this.$.id(R.id.dialog_switch_ppt).view()).setAdapter((RecyclerView.Adapter)this.mPPTAdapter);
        this.maxIndex = this.getArguments() != null ? this.getArguments().getInt("maxIndex") : 0;
        this.lastIndex = this.currentIndex = this.getArguments().getInt("currentIndex");
    }

    private void initView() {
        if (!this.presenter.getRouter().getLiveRoom().isTeacherOrAssistant()) {
            this.$.id(R.id.stu_tips_ll).visibility(0);
        }
        this.$.id(R.id.iv_ppt_switch).clicked(v -> this.switchPPTState());
        this.$.id(R.id.iv_board_add).clicked(v -> {
            if (this.presenter.isBroadcasting()) {
                this.showToast(this.getString(R.string.bjy_live_broadcast_operate_tip));
                return;
            }
            if (!this.presenter.canOperateDocumentControl()) {
                this.showToast(this.getString(R.string.live_room_document_control_permission_forbid));
                return;
            }
            this.isChangePage = true;
            this.presenter.addPage();
        });
        this.$.id(R.id.tv_ppt_ok).clicked(v -> {
            if (!this.presenter.canOperateDocumentControl()) {
                this.showToast(this.getString(R.string.live_room_document_control_permission_forbid));
                return;
            }
            this.switchEditStatus(false);
        });
        if (this.getContext() != null) {
            this.$.id(R.id.tv_ppt_ok).background(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_live_product_color)).cornerRadius(UtilsKt.getDp((int)6)).build());
        }
    }

    private void switchPPTState() {
        Drawable drawable2;
        RelativeLayout.LayoutParams params;
        int dpHeight;
        if (this.getContext() == null) {
            return;
        }
        int n = dpHeight = this.presenter.getRouter().getLiveRoom().isTeacherOrAssistant() ? 76 : 96;
        if (this.isOpen) {
            params = new RelativeLayout.LayoutParams(UtilsKt.getDp((int)58), UtilsKt.getDp((int)dpHeight));
            params.addRule(11, R.id.rl_ppt_switch);
            drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.iv_back_left);
        } else {
            params = new RelativeLayout.LayoutParams(-1, UtilsKt.getDp((int)dpHeight));
            params.leftMargin = UtilsKt.getDp((int)80);
            drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.iv_back_right);
        }
        this.isOpen = !this.isOpen;
        this.$.id(R.id.ll_ppt).view().setLayoutParams((ViewGroup.LayoutParams)params);
        this.$.id(R.id.iv_ppt_switch).background(drawable2);
    }

    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        windowParams.height = -2;
        windowParams.width = -1;
        windowParams.gravity = 0x800055;
        windowParams.windowAnimations = R.style.BJYBaseSendMsgDialogAnim;
    }

    public void setPresenter(SwitchPPTContract.Presenter presenter2) {
        this.presenter = presenter2;
        super.setBasePresenter((BasePresenter)presenter2);
    }

    @Override
    public void setIndex(int index) {
        this.lastIndex = this.currentIndex;
        if (index >= 0 && this.currentIndex != index) {
            this.currentIndex = index;
        }
        if (index >= 0 && this.maxIndex != index) {
            this.maxIndex = this.presenter.getRouter().getLiveRoom().getDocListVM().isDisableOverTeacherMaxPage() ? index : this.presenter.getRouter().getLiveRoom().getDocListVM().getDocList().size();
            this.presenter.changeDocList();
        }
        if (this.currentIndex < this.mBoardList.size()) {
            ((RecyclerView)this.$.id(R.id.dialog_switch_ppt_rv).view()).scrollToPosition(this.currentIndex);
            this.notifyOnIndexChange(true);
        } else {
            ((RecyclerView)this.$.id(R.id.dialog_switch_ppt).view()).scrollToPosition(this.currentIndex - this.mBoardList.size());
            this.isOpen = false;
            this.switchPPTState();
            this.notifyOnIndexChange(false);
        }
    }

    @Override
    public void setMaxIndex(int updateMaxIndex) {
    }

    @Override
    public void setType(boolean isStudent, boolean enableMultiWhiteboard) {
        this.isStudent = isStudent;
        this.enableMultiWhiteboard = enableMultiWhiteboard;
        if (isStudent || enableMultiWhiteboard) {
            this.$.id(R.id.ll_add_page).visibility(8);
        } else {
            this.$.id(R.id.ll_add_page).visibility(0);
        }
    }

    @Override
    public void docListChanged(List<LPDocModel> docModelList) {
        this.mBoardList.clear();
        this.mPPTList.clear();
        if (this.isStudent) {
            for (int i = 0; i < docModelList.size() && this.maxIndex >= i; ++i) {
                LPDocModel model = docModelList.get(i);
                if ("0".equals(model.docId)) {
                    this.mBoardList.add(model);
                    continue;
                }
                this.mPPTList.add(model);
            }
        } else {
            for (int i = 0; i < docModelList.size(); ++i) {
                LPDocModel model = docModelList.get(i);
                if ("0".equals(model.docId)) {
                    this.mBoardList.add(model);
                    continue;
                }
                this.mPPTList.add(model);
            }
            if (this.isChangePage && this.mBoardList.size() > 0) {
                this.presenter.changePage(this.mBoardList.get((int)(this.mBoardList.size() - 1)).pageId);
            }
            this.isChangePage = false;
        }
        if (this.mPPTList.size() <= 0) {
            this.$.id(R.id.ll_ppt).visibility(8);
        } else {
            this.$.id(R.id.ll_ppt).visibility(0);
        }
        this.mPPTAdapter.setDeviation(this.mBoardList.size());
        this.mPPTAdapter.setBoardTag(false);
        this.adapter.notifyDataSetChanged();
        this.mPPTAdapter.notifyDataSetChanged();
    }

    @Override
    public void close() {
        this.dismissAllowingStateLoss();
    }

    private void switchEditStatus(boolean isEdit) {
        if (isEdit) {
            this.$.id(R.id.ll_ppt_ok).visibility(0);
            this.adapter.setEditState(true);
        } else {
            this.$.id(R.id.ll_ppt_ok).visibility(4);
            this.adapter.setEditState(false);
        }
        this.adapter.notifyDataSetChanged();
        this.isOpen = true;
        this.switchPPTState();
    }

    private void notifyOnIndexChange(boolean isBoard) {
        if (isBoard) {
            this.adapter.notifyDataSetChanged();
            if (this.lastIndex >= this.mBoardList.size()) {
                this.mPPTAdapter.notifyDataSetChanged();
            }
        } else {
            if (this.lastIndex < this.mBoardList.size()) {
                this.adapter.notifyDataSetChanged();
            }
            this.mPPTAdapter.notifyDataSetChanged();
        }
    }

    private void deleteBoard(int pageId) {
        if (pageId < 0 || this.getActivity() == null) {
            return;
        }
        new ThemeMaterialDialogBuilder((Context)this.getActivity()).title(this.getString(R.string.live_exit_hint_title)).content((CharSequence)this.getString(R.string.string_board_del_info)).positiveText((CharSequence)this.getString(R.string.live_confirm)).negativeColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getActivity(), (int)R.attr.base_theme_dialog_negative_text_color)).negativeText((CharSequence)this.getString(R.string.base_cancel)).onPositive((materialDialog, dialogAction) -> this.presenter.delPage(pageId)).onNegative((materialDialog, dialogAction) -> materialDialog.dismiss()).build().show();
    }

    private class QuickSwitchPPTAdapter
    extends RecyclerView.Adapter<SwitchHolder> {
        private final List<LPDocModel> list;
        private int deviation = 0;
        private boolean isBoard = true;
        private boolean isEdit = false;

        public QuickSwitchPPTAdapter(List<LPDocModel> list) {
            this.list = list;
        }

        public void setBoardTag(boolean isBoard) {
            this.isBoard = isBoard;
        }

        public void setEditState(boolean isEdit) {
            this.isEdit = isEdit;
        }

        public void setDeviation(int deviation) {
            this.deviation = deviation;
        }

        @NonNull
        public SwitchHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new SwitchHolder(LayoutInflater.from((Context)QuickSwitchPPTFragment.this.getActivity()).inflate(R.layout.bjy_item_switch_ppt, parent, false));
        }

        public void onBindViewHolder(@NonNull SwitchHolder holder, int position) {
            if (QuickSwitchPPTFragment.this.getContext() != null) {
                if (this.list.get((int)position).isH5Doc) {
                    Glide.with((Context)QuickSwitchPPTFragment.this.getContext()).load(ContextCompat.getDrawable((Context)QuickSwitchPPTFragment.this.getContext(), (int)R.drawable.lp_h5_ppt_cover)).into(holder.PPTView);
                } else {
                    Glide.with((Context)QuickSwitchPPTFragment.this.getContext()).load(AliCloudImageUtil.getScaledUrl((String)this.list.get((int)position).url, (String)"m_mfit", (int)200, (int)200)).into(holder.PPTView);
                    if (TextUtils.equals((CharSequence)"0", (CharSequence)this.list.get((int)position).docId)) {
                        holder.PPTView.setImageTintList(ColorStateList.valueOf((int)ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)QuickSwitchPPTFragment.this.getContext(), (int)R.attr.base_theme_blackboard_color)));
                    }
                }
                if (this.isBoard) {
                    holder.PPTOrder.setText((CharSequence)(QuickSwitchPPTFragment.this.getResources().getString(R.string.string_board_title) + (position + 1)));
                    holder.PPTRl.setSelected(QuickSwitchPPTFragment.this.currentIndex == position);
                } else {
                    holder.PPTOrder.setText((CharSequence)String.valueOf(position + 1));
                    holder.PPTRl.setSelected(position == QuickSwitchPPTFragment.this.currentIndex - QuickSwitchPPTFragment.this.mBoardList.size());
                }
                if (this.isEdit) {
                    holder.mIvPptDelete.setVisibility(0);
                    holder.mIvPptDelete.setTag((Object)this.list.get((int)position).pageId);
                    holder.mIvPptDelete.setOnClickListener(v -> QuickSwitchPPTFragment.this.deleteBoard(this.list.get((int)position).pageId));
                } else {
                    holder.mIvPptDelete.setVisibility(4);
                }
            }
            holder.PPTRl.setOnClickListener(v -> {
                if (!QuickSwitchPPTFragment.this.presenter.canOperateDocumentControl()) {
                    QuickSwitchPPTFragment.this.showToast(QuickSwitchPPTFragment.this.getString(R.string.live_room_document_control_permission_forbid));
                    return;
                }
                QuickSwitchPPTFragment.this.lastIndex = QuickSwitchPPTFragment.this.currentIndex;
                QuickSwitchPPTFragment.this.notifyOnIndexChange(this.isBoard);
                QuickSwitchPPTFragment.this.currentIndex = position + Math.max(this.deviation, 0);
                QuickSwitchPPTFragment.this.presenter.setSwitchPosition(position + Math.max(this.deviation, 0));
            });
            holder.PPTRl.setBackground((Drawable)new StateListDrawableBuilder().normal(new DrawableBuilder().strokeColor(ContextCompat.getColor((Context)QuickSwitchPPTFragment.this.getContext(), (int)R.color.base_bg_stroke)).strokeWidth(UtilsKt.getDp((int)1)).build()).selected(new DrawableBuilder().strokeColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)QuickSwitchPPTFragment.this.getContext(), (int)R.attr.base_theme_live_product_color)).strokeWidth(UtilsKt.getDp((int)1)).build()).build());
            holder.PPTRl.setOnLongClickListener(v -> {
                if (!QuickSwitchPPTFragment.this.presenter.canOperateDocumentControl()) {
                    QuickSwitchPPTFragment.this.showToast(QuickSwitchPPTFragment.this.getString(R.string.live_room_document_control_permission_forbid));
                    return false;
                }
                if (!this.isBoard || QuickSwitchPPTFragment.this.isStudent || QuickSwitchPPTFragment.this.enableMultiWhiteboard) {
                    return false;
                }
                QuickSwitchPPTFragment.this.switchEditStatus(true);
                return true;
            });
        }

        public int getItemCount() {
            return this.list.size();
        }
    }

    static class SwitchHolder
    extends RecyclerView.ViewHolder {
        ImageView PPTView;
        TextView PPTOrder;
        RelativeLayout PPTRl;
        ImageView mIvPptDelete;

        SwitchHolder(View itemView) {
            super(itemView);
            this.PPTView = (ImageView)itemView.findViewById(R.id.item_ppt_view);
            this.PPTOrder = (TextView)itemView.findViewById(R.id.item_ppt_order);
            this.PPTRl = (RelativeLayout)itemView.findViewById(R.id.item_ppt_rl);
            this.mIvPptDelete = (ImageView)itemView.findViewById(R.id.iv_ppt_delete);
        }
    }
}

