/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.chat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.core.view.GestureDetectorCompat;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.text.HyperLinkHelper;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.load.engine.DiskCacheStrategy;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.AliCloudImageUtil;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.utils.URLImageParser;
import com.baijiayun.livebase.widgets.view.RoundImageView;
import com.baijiayun.livecore.models.LPGroupItem;
import com.baijiayun.livecore.models.LPMessageAtUserModel;
import com.baijiayun.livecore.models.LPMessageModel;
import com.baijiayun.livecore.models.LPMessageReferenceModel;
import com.baijiayun.livecore.models.imodels.IMessageModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.chat.ChatMessageAdapter;
import com.baijiayun.liveuibase.chat.ChatOptMenuHelper;
import com.baijiayun.liveuibase.chat.ChatViewModel;
import com.baijiayun.liveuibase.databinding.ItemPadChatBinding;
import com.baijiayun.liveuibase.utils.ExtensionKt;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import com.baijiayun.liveuibase.widgets.chat.BitmapCropTarget;
import com.baijiayun.liveuibase.widgets.chat.CenterImageSpan;
import com.baijiayun.liveuibase.widgets.chat.ChatImageUtil;
import com.baijiayun.liveuibase.widgets.chat.ChatMessageView;
import com.baijiayun.liveuibase.widgets.chat.GifCropTarget;
import com.baijiayun.liveuibase.widgets.chat.RadiusBackgroundSpan;
import com.baijiayun.liveuibase.widgets.courseware.models.UploadingImageModel;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 V2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0004VWXYB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\n \r*\u0004\u0018\u00010'0'H\u0002J\u0010\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010$\u001a\u00020%J\u0010\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020.H\u0016J\u000e\u00101\u001a\u00020'2\u0006\u0010$\u001a\u00020%J.\u00102\u001a\u0002032\u0006\u00104\u001a\u00020'2\u0006\u00105\u001a\u0002062\n\b\u0002\u00107\u001a\u0004\u0018\u0001082\n\b\u0002\u00109\u001a\u0004\u0018\u00010%J\b\u0010:\u001a\u00020)H\u0002J\b\u0010;\u001a\u00020)H\u0002J\u000e\u0010<\u001a\u00020'2\u0006\u0010$\u001a\u00020%J\b\u0010=\u001a\u00020)H\u0002J\u0016\u0010>\u001a\u0002032\u0006\u0010$\u001a\u00020%2\u0006\u00105\u001a\u000206J\u000e\u0010?\u001a\u00020'2\u0006\u0010$\u001a\u00020%J\u000e\u0010@\u001a\u00020'2\u0006\u00104\u001a\u00020'J\"\u0010A\u001a\u0002032\u0006\u0010B\u001a\u00020'2\b\u00109\u001a\u0004\u0018\u00010%2\u0006\u0010C\u001a\u000203H\u0002J\u0018\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u00020\u00022\u0006\u00100\u001a\u00020.H\u0017J\u0018\u0010F\u001a\u00020\u00022\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020.H\u0016J\u0010\u0010J\u001a\u00020!2\u0006\u0010K\u001a\u00020\u0002H\u0016J\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020.H\u0002J0\u0010O\u001a\u00020!2\u0006\u0010P\u001a\u00020.2\u0006\u0010Q\u001a\u00020.2\u0006\u0010R\u001a\u00020S2\u0006\u00109\u001a\u00020%2\u0006\u0010T\u001a\u00020MH\u0016J\u0018\u0010U\u001a\u00020!2\u0006\u0010E\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,H\u0002R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0018\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006Z"}, d2={"Lcom/baijiayun/liveuibase/chat/ChatMessageAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lcom/baijiayun/liveuibase/widgets/chat/ChatMessageView$IChatMessageListener;", "context", "Landroid/content/Context;", "chatViewModel", "Lcom/baijiayun/liveuibase/chat/ChatViewModel;", "routerViewModel", "Lcom/baijiayun/liveuibase/viewmodel/RouterViewModel;", "(Landroid/content/Context;Lcom/baijiayun/liveuibase/chat/ChatViewModel;Lcom/baijiayun/liveuibase/viewmodel/RouterViewModel;)V", "atPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getChatViewModel", "()Lcom/baijiayun/liveuibase/chat/ChatViewModel;", "getContext", "()Landroid/content/Context;", "emojiPattern", "failedColorDrawable", "Landroid/graphics/drawable/ColorDrawable;", "getFailedColorDrawable", "()Landroid/graphics/drawable/ColorDrawable;", "failedColorDrawable$delegate", "Lkotlin/Lazy;", "getRouterViewModel", "()Lcom/baijiayun/liveuibase/viewmodel/RouterViewModel;", "simpleDataFormat", "Ljava/text/SimpleDateFormat;", "getSimpleDataFormat", "()Ljava/text/SimpleDateFormat;", "simpleDataFormat$delegate", "bindData", "", "dataBinding", "Lcom/baijiayun/liveuibase/databinding/ItemPadChatBinding;", "message", "Lcom/baijiayun/livecore/models/imodels/IMessageModel;", "currentUserId", "", "getClientTypeRes", "Landroid/graphics/drawable/Drawable;", "getEncodedName", "userModel", "Lcom/baijiayun/livebase/models/imodels/IUserModel;", "getItemCount", "", "getItemViewType", "position", "getMessageTime", "getMixText", "Landroid/text/SpannableStringBuilder;", "srcContent", "textView", "Landroid/widget/TextView;", "textViewHolder", "Lcom/baijiayun/liveuibase/chat/ChatMessageAdapter$TextViewHolder;", "iMessageModel", "getMsgWallBG", "getMySelfMsgBG", "getNameFromMessage", "getOtherMsgBG", "getRewardText", "getRoleFromMessage", "getTranslateText", "handleAtUser", "content", "ssb", "onBindViewHolder", "viewHolder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onViewRecycled", "holder", "showGroupName", "", "group", "showMenu", "x", "y", "parentView", "Landroid/view/View;", "isImage", "showOptMenu", "Companion", "ImageViewHolder", "PressListener", "TextViewHolder", "liveuibase_release"})
public final class ChatMessageAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ChatMessageView.IChatMessageListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final ChatViewModel chatViewModel;
    @NotNull
    private final RouterViewModel routerViewModel;
    @NotNull
    private final Lazy simpleDataFormat$delegate;
    @NotNull
    private final Pattern emojiPattern;
    private final Pattern atPattern;
    @NotNull
    private final Lazy failedColorDrawable$delegate;
    private static final int MESSAGE_TYPE_TEXT = 0;
    private static final int MESSAGE_TYPE_IMAGE = 1;

    public ChatMessageAdapter(@NotNull Context context2, @NotNull ChatViewModel chatViewModel, @NotNull RouterViewModel routerViewModel2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)chatViewModel), (String)"chatViewModel");
        Intrinsics.checkNotNullParameter((Object)((Object)routerViewModel2), (String)"routerViewModel");
        this.context = context2;
        this.chatViewModel = chatViewModel;
        this.routerViewModel = routerViewModel2;
        this.simpleDataFormat$delegate = LazyKt.lazy((Function0)simpleDataFormat.2.INSTANCE);
        Pattern pattern = Pattern.compile("\\[[a-zA-Z0-9\u4e00-\u9fa5]+]");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"\\\\[[a-zA-Z0-9\\u4e00-\\u9fa5]+]\")");
        this.emojiPattern = pattern;
        this.atPattern = Pattern.compile("@[^\\t^@]*\\t");
        this.failedColorDrawable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ColorDrawable>(this){
            final /* synthetic */ ChatMessageAdapter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ColorDrawable invoke() {
                return new ColorDrawable(ContextCompat.getColor((Context)this.this$0.getContext(), (int)R.color.live_half_transparent));
            }
        }));
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final ChatViewModel getChatViewModel() {
        return this.chatViewModel;
    }

    @NotNull
    public final RouterViewModel getRouterViewModel() {
        return this.routerViewModel;
    }

    private final SimpleDateFormat getSimpleDataFormat() {
        Lazy lazy = this.simpleDataFormat$delegate;
        return (SimpleDateFormat)lazy.getValue();
    }

    private final ColorDrawable getFailedColorDrawable() {
        Lazy lazy = this.failedColorDrawable$delegate;
        return (ColorDrawable)lazy.getValue();
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ViewDataBinding viewDataBinding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)parent.getContext()), (int)R.layout.item_pad_chat, (ViewGroup)parent, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)viewDataBinding, (String)"inflate(\n            Lay\u2026          false\n        )");
        ItemPadChatBinding dataBinding = (ItemPadChatBinding)viewDataBinding;
        FrameLayout frameLayout = dataBinding.chatContainer;
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"dataBinding.chatContainer");
        FrameLayout messageContainer = frameLayout;
        switch (viewType) {
            case 0: {
                LayoutInflater.from((Context)this.context).inflate(R.layout.item_pad_chat_text, (ViewGroup)messageContainer);
                View view = dataBinding.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"dataBinding.root");
                viewHolder = new TextViewHolder(dataBinding, view);
                break;
            }
            case 1: {
                LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_item_chat_image, (ViewGroup)messageContainer);
                View view = dataBinding.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"dataBinding.root");
                viewHolder = new ImageViewHolder(dataBinding, view);
                break;
            }
            default: {
                View view = dataBinding.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"dataBinding.root");
                viewHolder = new TextViewHolder(dataBinding, view);
            }
        }
        return viewHolder;
    }

    public int getItemCount() {
        return this.chatViewModel.getCount();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @SuppressLint(value={"ClickableViewAccessibility", "RecyclerView"})
    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int position) {
        block39: {
            block38: {
                Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
                if (position < 0 || position >= this.getItemCount()) {
                    return;
                }
                if (position == this.chatViewModel.getCount() - 1) {
                    this.chatViewModel.getShowMessageReminder().setValue((Object)false);
                }
                message = this.chatViewModel.getMessage(position);
                v0 = message.getFrom();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"message.from");
                this.showOptMenu(viewHolder, v0);
                ssb = new SpannableStringBuilder();
                if (!this.chatViewModel.isPrivateChatMode() && message.isPrivateChat()) {
                    if (!this.routerViewModel.getLiveRoom().getChatVM().canWhisper()) {
                        return;
                    }
                    spanText = null;
                    isFromMe = Intrinsics.areEqual((Object)message.getFrom().getUserId(), (Object)this.currentUserId());
                    isToMe = Intrinsics.areEqual((Object)message.getTo(), (Object)this.currentUserId());
                    if (message.getToUser() == null) {
                        v1 = message.getTo();
                    } else {
                        v2 = message.getToUser();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"message.toUser");
                        v1 = toName = this.getEncodedName(v2);
                    }
                    if (isFromMe) {
                        source = "\u79c1\u804a  ";
                        spanText = new SpannableString((CharSequence)(source + (String)toName));
                        spanText.setSpan((Object)new ForegroundColorSpan(ContextCompat.getColor((Context)this.context, (int)R.color.base_white)), source.length(), source.length() + toName.length(), 17);
                        ssb.append((CharSequence)spanText).append((CharSequence)"\n");
                    }
                    if (isToMe) {
                        source = "\u79c1\u804a  ";
                        spanText = new SpannableString((CharSequence)(source + '\u6211'));
                        spanText.setSpan((Object)new ForegroundColorSpan(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color)), source.length(), (source + '\u6211').length(), 17);
                        ssb.append((CharSequence)spanText).append((CharSequence)"\n");
                    }
                }
                if (!((var5_5 = viewHolder) instanceof TextViewHolder)) break block38;
                this.bindData(((TextViewHolder)viewHolder).getDataBinding(), message);
                if (this.showGroupName(message.getFrom().getGroup())) {
                    ((TextViewHolder)viewHolder).getDataBinding().chatGroupName.setVisibility(0);
                    v3 = ((TextViewHolder)viewHolder).getDataBinding().chatGroupName;
                    v4 = this.context.getString(R.string.live_chat_group);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"context.getString(R.string.live_chat_group)");
                    isToMe = v4;
                    toName = new Object[1];
                    v5 = this.routerViewModel.getLiveRoom().getOnlineUserVM().getGroupMap();
                    source = v5 != null && (v5 = (LPGroupItem)v5.get(message.getFrom().getGroup())) != null && (v5 = v5.groupItemModel) != null ? v5.name : null;
                    toName[0] = source == null ? "" : source;
                    v6 = String.format(isToMe, Arrays.copyOf(toName, toName.length));
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"format(format, *args)");
                    v3.setText((CharSequence)v6);
                } else {
                    ((TextViewHolder)viewHolder).getDataBinding().chatGroupName.setVisibility(8);
                }
                $this$onBindViewHolder_u24lambda_u242 = ((TextViewHolder)viewHolder).getChatMessageView();
                $i$a$-with-ChatMessageAdapter$onBindViewHolder$1 = false;
                $this$onBindViewHolder_u24lambda_u242.setChatMessageListener(this);
                if (message.getMessageType() == LPConstants.MessageType.Reward) {
                    v7 = $this$onBindViewHolder_u24lambda_u242.getTextView();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"textView");
                    ssb.append((CharSequence)this.getRewardText(message, v7));
                } else {
                    v8 = message.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"message.content");
                    v9 = $this$onBindViewHolder_u24lambda_u242.getTextView();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"textView");
                    ssb.append((CharSequence)this.getMixText(v8, v9, (TextViewHolder)viewHolder, message));
                }
                if (!TextUtils.isEmpty((CharSequence)((CharSequence)ssb))) {
                    ssb.setSpan((Object)$this$onBindViewHolder_u24lambda_u242.getLineHeightSpan(), 0, ssb.length() - 1, 34);
                }
                $this$onBindViewHolder_u24lambda_u242.getTextView().setText((CharSequence)ssb);
                v10 = showMsgWall = message.getWallState() == 1 && (this.routerViewModel.getLiveRoom().isTeacherOrAssistant() != false || TextUtils.equals((CharSequence)this.routerViewModel.getLiveRoom().getCurrentUser().getNumber(), (CharSequence)message.getFrom().getNumber()) != false);
                if (showMsgWall) {
                    $this$onBindViewHolder_u24lambda_u242.setMessageContainerBackground(this.getMsgWallBG(), true);
                    $this$onBindViewHolder_u24lambda_u242.setTextColor(ContextCompat.getColor((Context)$this$onBindViewHolder_u24lambda_u242.getContext(), (int)R.color.base_white));
                } else {
                    $this$onBindViewHolder_u24lambda_u242.setMessageContainerBackground(Intrinsics.areEqual((Object)message.getFrom().getNumber(), (Object)this.routerViewModel.getLiveRoom().getCurrentUser().getNumber()) != false ? this.getMySelfMsgBG() : this.getOtherMsgBG(), false);
                    if (Intrinsics.areEqual((Object)message.getFrom().getNumber(), (Object)this.routerViewModel.getLiveRoom().getCurrentUser().getNumber())) {
                        $this$onBindViewHolder_u24lambda_u242.setTextColor(ContextCompat.getColor((Context)$this$onBindViewHolder_u24lambda_u242.getContext(), (int)R.color.base_white));
                    } else {
                        $this$onBindViewHolder_u24lambda_u242.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)$this$onBindViewHolder_u24lambda_u242.getContext(), (int)R.attr.base_theme_window_main_text_color));
                    }
                }
                $this$onBindViewHolder_u24lambda_u242.setDivideLineColor(Intrinsics.areEqual((Object)message.getFrom().getNumber(), (Object)this.routerViewModel.getLiveRoom().getCurrentUser().getNumber()) != false ? ContextCompat.getColor((Context)$this$onBindViewHolder_u24lambda_u242.getContext(), (int)R.color.base_divider_line_myself) : ContextCompat.getColor((Context)$this$onBindViewHolder_u24lambda_u242.getContext(), (int)R.color.base_divider_line_other));
                $this$onBindViewHolder_u24lambda_u242.getTextView().setFocusable(false);
                $this$onBindViewHolder_u24lambda_u242.getTextView().setClickable(false);
                $this$onBindViewHolder_u24lambda_u242.getTextView().setLongClickable(false);
                $this$onBindViewHolder_u24lambda_u242.enableTranslation(this.routerViewModel.getLiveRoom().getPartnerConfig().isEnableChatTranslation() != false && message.getMessageType() != LPConstants.MessageType.Emoji && message.getMessageType() != LPConstants.MessageType.EmojiWithName && message.getMessageType() != LPConstants.MessageType.Reward);
                $this$onBindViewHolder_u24lambda_u242.setMessageModel(message);
                v11 = message.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"message.content");
                if (!(((CharSequence)this.getTranslateText(v11)).length() > 0)) ** GOTO lbl-1000
                v12 = message.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"message.content");
                if (!UtilsKt.isOnlyEmojis((String)v12)) {
                    v13 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v13 = false;
                }
                $this$onBindViewHolder_u24lambda_u242.setTranslateButtonVisibility(v13);
                $this$onBindViewHolder_u24lambda_u242.removeReference();
                if (message.getReference() != null) {
                    $this$onBindViewHolder_u24lambda_u242.addReferenceMessage();
                    referenceMessage = message.getReference().content;
                    referenceMessageSsb = new SpannableStringBuilder();
                    if (message.getReference().getMessageType() == LPConstants.MessageType.Reward) {
                        v14 = message.getReference();
                        Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"message.reference");
                        v15 = (IMessageModel)v14;
                        v16 = $this$onBindViewHolder_u24lambda_u242.getTvReference();
                        Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"tvReference");
                        referenceMessageSsb.append((CharSequence)this.getRewardText(v15, v16));
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)referenceMessage, (String)"referenceMessage");
                        v17 = $this$onBindViewHolder_u24lambda_u242.getTvReference();
                        Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"tvReference");
                        referenceMessageSsb.append((CharSequence)ChatMessageAdapter.getMixText$default(this, referenceMessage, v17, (TextViewHolder)viewHolder, null, 8, null));
                        if (!TextUtils.isEmpty((CharSequence)referenceMessage)) {
                            referenceMessageSsb.setSpan((Object)$this$onBindViewHolder_u24lambda_u242.getLineHeightSpan(), 0, referenceMessage.length() - 1, 34);
                        }
                    }
                    if (Intrinsics.areEqual((Object)message.getFrom().getNumber(), (Object)this.routerViewModel.getLiveRoom().getCurrentUser().getNumber())) {
                        $this$onBindViewHolder_u24lambda_u242.getTvReference().setTextColor(ContextCompat.getColor((Context)$this$onBindViewHolder_u24lambda_u242.getContext(), (int)R.color.bjy_base_assistant_reference_text_color_self));
                    } else {
                        $this$onBindViewHolder_u24lambda_u242.getTvReference().setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)$this$onBindViewHolder_u24lambda_u242.getContext(), (int)R.attr.base_theme_window_assistant_text_color));
                    }
                    $this$onBindViewHolder_u24lambda_u242.getTvReference().setText((CharSequence)referenceMessageSsb);
                }
                $this$onBindViewHolder_u24lambda_u242.removeTranslate();
                $this$onBindViewHolder_u24lambda_u242.addTranslateMessage(this.chatViewModel.getTranslateResult(position));
                $this$onBindViewHolder_u24lambda_u242.setOnProgressListener((ChatMessageView.OnProgressListener)LambdaMetafactory.metafactory(null, null, null, ()V, onBindViewHolder$lambda$2$lambda$1(com.baijiayun.liveuibase.chat.ChatMessageAdapter com.baijiayun.livecore.models.imodels.IMessageModel com.baijiayun.liveuibase.widgets.chat.ChatMessageView ), ()V)((ChatMessageAdapter)this, (IMessageModel)message, (ChatMessageView)$this$onBindViewHolder_u24lambda_u242));
                if (message.getFrom().getType() == LPConstants.LPUserType.Teacher || message.getFrom().getType() == LPConstants.LPUserType.Assistant) {
                    v18 = $this$onBindViewHolder_u24lambda_u242.getTextView();
                    Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"textView");
                    HyperLinkHelper.INSTANCE.applyUrlSpan(v18);
                    v19 = this.routerViewModel.getLiveRoom();
                    v20 = $this$onBindViewHolder_u24lambda_u242.getTextView();
                    Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"textView");
                    ExtensionKt.reportProductLinkEvent(v19, v20);
                } else {
                    $this$onBindViewHolder_u24lambda_u242.getTextView().setAutoLinkMask(0);
                }
                break block39;
            }
            if (var5_5 instanceof ImageViewHolder) {
                this.bindData(((ImageViewHolder)viewHolder).getDataBinding(), message);
                if (this.showGroupName(message.getFrom().getGroup())) {
                    ((ImageViewHolder)viewHolder).getDataBinding().chatGroupName.setVisibility(0);
                    v21 = ((ImageViewHolder)viewHolder).getDataBinding().chatGroupName;
                    v22 = this.context.getString(R.string.live_chat_group);
                    Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"context.getString(R.string.live_chat_group)");
                    $this$onBindViewHolder_u24lambda_u242 = v22;
                    $i$a$-with-ChatMessageAdapter$onBindViewHolder$1 /* !! */  = new Object[1];
                    v23 = this.routerViewModel.getLiveRoom().getOnlineUserVM().getGroupMap();
                    showMsgWall = v23 != null && (v23 = (LPGroupItem)v23.get(message.getFrom().getGroup())) != null && (v23 = v23.groupItemModel) != null ? v23.name : null;
                    $i$a$-with-ChatMessageAdapter$onBindViewHolder$1 /* !! */ [0] = showMsgWall == null ? "" : showMsgWall;
                    v24 = String.format($this$onBindViewHolder_u24lambda_u242, Arrays.copyOf($i$a$-with-ChatMessageAdapter$onBindViewHolder$1 /* !! */ , $i$a$-with-ChatMessageAdapter$onBindViewHolder$1 /* !! */ .length));
                    Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"format(format, *args)");
                    v21.setText((CharSequence)v24);
                } else {
                    ((ImageViewHolder)viewHolder).getDataBinding().chatGroupName.setVisibility(8);
                }
                ((ImageViewHolder)viewHolder).getIvImg().setOnClickListener(null);
                if (message instanceof UploadingImageModel) {
                    options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeFile((String)message.getUrl(), (BitmapFactory.Options)options);
                    $i$a$-with-ChatMessageAdapter$onBindViewHolder$1 /* !! */  = new int[2];
                    $i$a$-with-ChatMessageAdapter$onBindViewHolder$1 /* !! */ [0] = options.outWidth;
                    $i$a$-with-ChatMessageAdapter$onBindViewHolder$1 /* !! */ [1] = options.outHeight;
                    size /* !! */  = $i$a$-with-ChatMessageAdapter$onBindViewHolder$1 /* !! */ ;
                    ChatImageUtil.calculateImageSize((int[])size /* !! */ , UtilsKt.getDp((int)100), UtilsKt.getDp((int)50));
                    requestOptions = new RequestOptions();
                    v25 = requestOptions.override((int)size /* !! */ [0], (int)size /* !! */ [1]).placeholder((Drawable)this.getFailedColorDrawable()).error((Drawable)this.getFailedColorDrawable());
                    Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"requestOptions.override(\u2026rror(failedColorDrawable)");
                    requestOptions = v25;
                    Glide.with((Context)this.context).load(new File(message.getUrl())).apply(requestOptions).into(((ImageViewHolder)viewHolder).getIvImg());
                    switch (((UploadingImageModel)message).getStatus()) {
                        case 0: {
                            ((ImageViewHolder)viewHolder).getTvMask().setVisibility(0);
                            ((ImageViewHolder)viewHolder).getTvExclamation().setVisibility(8);
                            break;
                        }
                        case 1: {
                            ((ImageViewHolder)viewHolder).getTvMask().setVisibility(8);
                            ((ImageViewHolder)viewHolder).getTvExclamation().setVisibility(0);
                            ((ImageViewHolder)viewHolder).getIvImg().setOnClickListener((View.OnClickListener)LambdaMetafactory.metafactory(null, null, null, (Landroid/view/View;)V, onBindViewHolder$lambda$3(com.baijiayun.liveuibase.chat.ChatMessageAdapter android.view.View ), (Landroid/view/View;)V)((ChatMessageAdapter)this));
                        }
                    }
                } else {
                    requestOptions = new RequestOptions();
                    v26 = requestOptions.override(300, 300).placeholder((Drawable)this.getFailedColorDrawable()).error((Drawable)this.getFailedColorDrawable());
                    Intrinsics.checkNotNullExpressionValue((Object)v26, (String)"requestOptions.override(\u2026rror(failedColorDrawable)");
                    requestOptions = v26;
                    v27 = message.getUrl();
                    Intrinsics.checkNotNullExpressionValue((Object)v27, (String)"message.url");
                    if (StringsKt.endsWith$default((String)v27, (String)".gif", (boolean)false, (int)2, null)) {
                        Glide.with((Context)this.context).asGif().apply(requestOptions.diskCacheStrategy(DiskCacheStrategy.RESOURCE)).load(message.getUrl()).into((Target)new GifCropTarget(((ImageViewHolder)viewHolder).getIvImg(), 100, 50));
                    } else {
                        Glide.with((Context)this.context).asBitmap().load(AliCloudImageUtil.getScaledUrl((String)message.getUrl(), (String)"m_mfit", (int)300, (int)300)).apply(requestOptions).into((Target)new BitmapCropTarget(((ImageViewHolder)viewHolder).getIvImg(), 100, 50));
                    }
                    $this$onBindViewHolder_u24lambda_u244 = (ImageViewHolder)viewHolder;
                    $i$a$-with-ChatMessageAdapter$onBindViewHolder$3 = false;
                    $this$onBindViewHolder_u24lambda_u244.getTvMask().setVisibility(8);
                    $this$onBindViewHolder_u24lambda_u244.getTvExclamation().setVisibility(8);
                    gestureDetectorCompat = new GestureDetectorCompat(this.context, (GestureDetector.OnGestureListener)new PressListener(message, viewHolder, true));
                    ((ImageViewHolder)viewHolder).getIvImg().setOnTouchListener((View.OnTouchListener)LambdaMetafactory.metafactory(null, null, null, (Landroid/view/View;Landroid/view/MotionEvent;)Z, onBindViewHolder$lambda$5(androidx.core.view.GestureDetectorCompat android.view.View android.view.MotionEvent ), (Landroid/view/View;Landroid/view/MotionEvent;)Z)((GestureDetectorCompat)gestureDetectorCompat));
                }
            }
        }
    }

    public void onViewRecycled(@NotNull RecyclerView.ViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super.onViewRecycled(holder);
        if (holder instanceof TextViewHolder) {
            ((TextViewHolder)holder).clearGifCache();
        }
    }

    private final boolean showGroupName(int group) {
        if (this.routerViewModel.getLiveRoom().getPartnerConfig().liveChatShowGroupName == 1 && group != 0) {
            return this.routerViewModel.getLiveRoom().isTeacherOrAssistant() ? true : (this.routerViewModel.getLiveRoom().isGroupTeacherOrAssistant() ? (this.routerViewModel.getLiveRoom().getOnlineUserVM().enableMyGroupUsersPublish() ? this.routerViewModel.getLiveRoom().getCurrentUser().getGroup() == group : true) : false);
        }
        return false;
    }

    private final Drawable getOtherMsgBG() {
        return new DrawableBuilder().solidColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_main_color_layer_20)).cornerRadius(UtilsKt.getDp((int)8)).build();
    }

    private final Drawable getMySelfMsgBG() {
        return new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color)).cornerRadius(UtilsKt.getDp((int)8)).build();
    }

    private final Drawable getMsgWallBG() {
        return new DrawableBuilder().solidColor(Color.parseColor((String)"#CC1E5EFF")).cornerRadius(UtilsKt.getDp((int)8)).build();
    }

    private final void showOptMenu(RecyclerView.ViewHolder viewHolder, IUserModel userModel) {
        if (!(userModel instanceof LPUserModel)) {
            return;
        }
        ((TextView)viewHolder.itemView.findViewById(R.id.chat_user_name)).setOnClickListener(arg_0 -> ChatMessageAdapter.showOptMenu$lambda$6(this, userModel, arg_0));
        ((RoundImageView)viewHolder.itemView.findViewById(R.id.chat_user_avatar)).setOnClickListener(arg_0 -> ChatMessageAdapter.showOptMenu$lambda$7(this, userModel, arg_0));
    }

    public int getItemViewType(int position) {
        int n;
        LPConstants.MessageType messageType = this.chatViewModel.getMessage(position).getMessageType();
        switch (messageType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n = 0;
                break;
            }
            case 5: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private final void bindData(ItemPadChatBinding dataBinding, IMessageModel message) {
        dataBinding.setMessage(message);
        dataBinding.setAdapter(this);
    }

    private final String currentUserId() {
        return this.routerViewModel.getLiveRoom().getCurrentUser().getUserId();
    }

    private final String getEncodedName(IUserModel userModel) {
        return UtilsKt.getEncodePhoneNumber((String)userModel.getName());
    }

    @Nullable
    public final Drawable getClientTypeRes(@NotNull IMessageModel message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Drawable clientIcon = null;
        LPConstants.LPEndType lPEndType = message.getFrom().getEndType();
        switch (lPEndType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[lPEndType.ordinal()]) {
            case 1: {
                clientIcon = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_chat_client_pc);
                break;
            }
            case 2: {
                clientIcon = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_chat_client_phone_h5);
                break;
            }
            case 3: {
                clientIcon = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_chat_client_pc_web);
                break;
            }
            case 4: {
                clientIcon = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_chat_client_mac);
                break;
            }
            case 5: {
                clientIcon = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_chat_client_android);
                break;
            }
            case 6: {
                clientIcon = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_chat_client_ios);
                break;
            }
            default: {
                clientIcon = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ic_chat_client_unkown);
            }
        }
        return clientIcon;
    }

    @NotNull
    public final String getRoleFromMessage(@NotNull IMessageModel message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String role = "";
        if (message.getFrom().getType() == LPConstants.LPUserType.Teacher) {
            String string2;
            if (TextUtils.isEmpty((CharSequence)this.routerViewModel.getLiveRoom().getCustomizeTeacherLabel())) {
                String string3 = this.context.getString(R.string.live_teacher);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.live_teacher)");
            } else {
                String string4 = this.routerViewModel.getLiveRoom().getCustomizeTeacherLabel();
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"routerViewModel.liveRoom.customizeTeacherLabel");
            }
            role = string2;
        }
        if (message.getFrom().getType() == LPConstants.LPUserType.Assistant) {
            String string5;
            if (TextUtils.isEmpty((CharSequence)this.routerViewModel.getLiveRoom().getCustomizeAssistantLabel())) {
                String string6 = this.context.getString(R.string.live_assistant);
                string5 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"context.getString(R.string.live_assistant)");
            } else {
                String string7 = this.routerViewModel.getLiveRoom().getCustomizeAssistantLabel();
                string5 = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"routerViewModel.liveRoom.customizeAssistantLabel");
            }
            role = string5;
        }
        return ((CharSequence)role).length() > 0 ? "[ " + role + " ]" : "";
    }

    @NotNull
    public final String getTranslateText(@NotNull String srcContent) {
        Intrinsics.checkNotNullParameter((Object)srcContent, (String)"srcContent");
        String content = srcContent;
        Matcher m = this.emojiPattern.matcher(content);
        while (m.find()) {
            String group = m.group();
            if (!this.chatViewModel.getExpressions().containsKey(group)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)group, (String)"group");
            content = StringsKt.replace$default((String)content, (String)group, (String)"", (boolean)false, (int)4, null);
        }
        return content;
    }

    @NotNull
    public final SpannableStringBuilder getMixText(@NotNull String srcContent, @NotNull TextView textView, @Nullable TextViewHolder textViewHolder, @Nullable IMessageModel iMessageModel) {
        Intrinsics.checkNotNullParameter((Object)srcContent, (String)"srcContent");
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        SpannableStringBuilder ssb = SpannableStringBuilder.valueOf((CharSequence)srcContent);
        Matcher emojiMatcher = this.emojiPattern.matcher(ssb.toString());
        List cacheDrawables = null;
        List imageParserList = null;
        while (emojiMatcher.find()) {
            String group = emojiMatcher.group();
            if (!this.chatViewModel.getExpressions().containsKey(group)) continue;
            URLImageParser urlImageParser = new URLImageParser(textView, textView.getTextSize());
            Drawable drawable2 = urlImageParser.getDrawable(this.chatViewModel.getExpressions().get(group));
            CenterImageSpan centerImageSpan = new CenterImageSpan(drawable2, 1);
            ssb.setSpan((Object)centerImageSpan, emojiMatcher.start(), emojiMatcher.end(), 34);
            ssb.removeSpan((Object)group);
            if (textViewHolder == null || !(drawable2 instanceof URLImageParser.GlideGifDrawable)) continue;
            if (cacheDrawables == null) {
                cacheDrawables = new ArrayList();
            }
            cacheDrawables.add(drawable2);
            if (imageParserList == null) {
                imageParserList = new ArrayList();
            }
            imageParserList.add(urlImageParser);
        }
        Intrinsics.checkNotNullExpressionValue((Object)ssb, (String)"ssb");
        this.handleAtUser(srcContent, iMessageModel, ssb);
        if (cacheDrawables != null && imageParserList != null && textViewHolder != null) {
            textViewHolder.setGifCache(cacheDrawables, imageParserList);
        }
        return ssb;
    }

    public static /* synthetic */ SpannableStringBuilder getMixText$default(ChatMessageAdapter chatMessageAdapter, String string2, TextView textView, TextViewHolder textViewHolder, IMessageModel iMessageModel, int n, Object object) {
        if ((n & 4) != 0) {
            textViewHolder = null;
        }
        if ((n & 8) != 0) {
            iMessageModel = null;
        }
        return chatMessageAdapter.getMixText(string2, textView, textViewHolder, iMessageModel);
    }

    private final SpannableStringBuilder handleAtUser(String content, IMessageModel iMessageModel, SpannableStringBuilder ssb) {
        if (iMessageModel != null && iMessageModel.getAtUserList() != null && this.routerViewModel.getLiveRoom().getChatVM().enableUserAtUser()) {
            boolean showHighlight = false;
            boolean isFromMe = Intrinsics.areEqual((Object)iMessageModel.getFrom().getNumber(), (Object)this.routerViewModel.getLiveRoom().getCurrentUser().getNumber());
            if (isFromMe) {
                List list = iMessageModel.getAtUserList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"iMessageModel.atUserList");
                showHighlight = !((Collection)list).isEmpty();
            } else {
                for (LPMessageAtUserModel message : iMessageModel.getAtUserList()) {
                    if (!Intrinsics.areEqual((Object)"all", (Object)message.number) && !TextUtils.equals((CharSequence)this.routerViewModel.getLiveRoom().getCurrentUser().getNumber(), (CharSequence)message.number)) continue;
                    showHighlight = true;
                    break;
                }
            }
            if (showHighlight) {
                ArrayList<String> userNameList = new ArrayList<String>();
                List list = iMessageModel.getAtUserList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"iMessageModel.atUserList");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LPMessageAtUserModel it = (LPMessageAtUserModel)element$iv;
                    boolean bl = false;
                    userNameList.add('@' + it.name + '\t');
                }
                Matcher atMatcher = this.atPattern.matcher(content);
                while (atMatcher.find()) {
                    String group = atMatcher.group();
                    boolean checked = (isFromMe || StringsKt.equals((String)group, (String)('@' + this.context.getString(R.string.bjy_base_at_all) + '\t'), (boolean)true) || Intrinsics.areEqual((Object)group, (Object)('@' + this.routerViewModel.getLiveRoom().getCurrentUser().getName() + '\t'))) && userNameList.contains(group);
                    if (!checked) continue;
                    int bgColor = isFromMe ? ContextCompat.getColor((Context)this.context, (int)R.color.base_white) : ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color);
                    int textColor = isFromMe ? ContextCompat.getColor((Context)this.context, (int)R.color.base_theme_live_product) : ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_dialog_positive_text_color);
                    int start2 = atMatcher.start();
                    int end = atMatcher.end();
                    RadiusBackgroundSpan bgSpan = new RadiusBackgroundSpan(bgColor, textColor, (int)UtilsKt.getDp((float)2.0f));
                    ssb.setSpan((Object)bgSpan, start2, end - 1, 34);
                }
            }
        }
        return ssb;
    }

    @NotNull
    public final SpannableStringBuilder getRewardText(@NotNull IMessageModel message, @NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        SpannableStringBuilder ssb = new SpannableStringBuilder();
        String string2 = this.context.getString(R.string.bjy_live_reward_gift_prefix);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026_live_reward_gift_prefix)");
        String giftPrefix = string2;
        String string3 = this.context.getString(R.string.bjy_live_reward_cash_prefix);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.stri\u2026_live_reward_cash_prefix)");
        String cashPrefix = string3;
        String string4 = this.context.getResources().getString(R.string.bjy_live_reward_cash_suffix);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.resources.getStr\u2026_live_reward_cash_suffix)");
        String cashSuffix = string4;
        if (TextUtils.isEmpty((CharSequence)message.getData().giftName)) {
            ssb.append((CharSequence)cashPrefix).append((CharSequence)" ").append((CharSequence)"\uffe5").append((CharSequence)message.getData().price).append((CharSequence)" ").append((CharSequence)cashSuffix).setSpan((Object)new StyleSpan(1), cashPrefix.length() + 1, cashPrefix.length() + message.getData().price.length() + 2, 34);
        } else {
            ssb.append((CharSequence)giftPrefix).append((CharSequence)message.getData().giftName).setSpan((Object)new StyleSpan(1), giftPrefix.length(), giftPrefix.length() + message.getData().giftName.length(), 34);
            ssb.append((CharSequence)" ").append((CharSequence)cashSuffix);
            URLImageParser urlImageParser = new URLImageParser(textView, textView.getTextSize());
            Drawable drawable2 = urlImageParser.getDrawable(message.getData().giftImg);
            CenterImageSpan centerImageSpan = new CenterImageSpan(drawable2, 1);
            ssb.setSpan((Object)centerImageSpan, giftPrefix.length() + message.getData().giftName.length() + 1, giftPrefix.length() + message.getData().giftName.length() + cashSuffix.length() + 1, 34);
            ssb.removeSpan((Object)cashSuffix);
        }
        return ssb;
    }

    @NotNull
    public final String getMessageTime(@NotNull IMessageModel message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string2 = this.getSimpleDataFormat().format(message.getTimestamp());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"simpleDataFormat.format(message.timestamp)");
        return string2;
    }

    @NotNull
    public final String getNameFromMessage(@NotNull IMessageModel message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return UtilsKt.getEncodePhoneNumber((String)message.getFrom().getName());
    }

    @Override
    public void showMenu(int x, int y, @NotNull View parentView, @NotNull IMessageModel iMessageModel, boolean isImage) {
        ListView listView;
        Intrinsics.checkNotNullParameter((Object)parentView, (String)"parentView");
        Intrinsics.checkNotNullParameter((Object)iMessageModel, (String)"iMessageModel");
        Context $this$showMenu_u24lambda_u2411 = this.context;
        boolean bl = false;
        PopupWindow popupWindow = new PopupWindow($this$showMenu_u24lambda_u2411);
        popupWindow.setFocusable(true);
        popupWindow.setWidth(UtilsKt.getDp((int)80));
        popupWindow.setHeight(-2);
        popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        ArrayList<String> items = new ArrayList<String>();
        int recallStatus = this.chatViewModel.getRecallStatus(iMessageModel);
        if (recallStatus == 1) {
            items.add($this$showMenu_u24lambda_u2411.getString(R.string.live_chat_recall));
        }
        if (recallStatus == 2) {
            items.add($this$showMenu_u24lambda_u2411.getString(R.string.live_chat_delete));
        }
        items.add($this$showMenu_u24lambda_u2411.getString(R.string.live_chat_copy));
        if (this.routerViewModel.getLiveRoom().isTeacherOrAssistant() || this.routerViewModel.getLiveRoom().isGroupTeacherOrAssistant()) {
            if (this.chatViewModel.containsMessageInSticky(iMessageModel)) {
                items.add($this$showMenu_u24lambda_u2411.getString(R.string.live_chat_sticky_cancel));
            } else {
                items.add($this$showMenu_u24lambda_u2411.getString(R.string.live_chat_sticky));
            }
        }
        IUserModel iUserModel = iMessageModel.getFrom();
        IUserModel iUserModel2 = this.routerViewModel.getLiveRoom().getCurrentUser();
        if (!Intrinsics.areEqual((Object)(iUserModel != null ? iUserModel.getNumber() : null), (Object)(iUserModel2 != null ? iUserModel2.getNumber() : null))) {
            items.add($this$showMenu_u24lambda_u2411.getString(R.string.bjy_base_chat_report));
        }
        if (this.routerViewModel.getPrivateChatUser().getValue() == null && !iMessageModel.isPrivateChat() && iMessageModel.getMessageType() != LPConstants.MessageType.Image) {
            items.add($this$showMenu_u24lambda_u2411.getString(R.string.bjy_base_chat_reference));
        }
        ListView $this$showMenu_u24lambda_u2411_u24lambda_u2410 = listView = new ListView(this.context);
        boolean bl2 = false;
        GradientDrawable bgDrawable = new GradientDrawable();
        bgDrawable.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)$this$showMenu_u24lambda_u2411_u24lambda_u2410.getContext(), (int)R.attr.base_theme_window_bg_color));
        bgDrawable.setStroke(1, ContextCompat.getColor((Context)$this$showMenu_u24lambda_u2411_u24lambda_u2410.getContext(), (int)R.color.base_bg_stroke));
        bgDrawable.setCornerRadius((float)$this$showMenu_u24lambda_u2411_u24lambda_u2410.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius));
        $this$showMenu_u24lambda_u2411_u24lambda_u2410.setBackground((Drawable)bgDrawable);
        Context context2 = $this$showMenu_u24lambda_u2411_u24lambda_u2410.getContext();
        Collection $this$toTypedArray$iv = items;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        $this$showMenu_u24lambda_u2411_u24lambda_u2410.setAdapter((ListAdapter)new ArrayAdapter(context2, R.layout.bjy_menu_chat_message, objectArray));
        $this$showMenu_u24lambda_u2411_u24lambda_u2410.setDividerHeight(0);
        $this$showMenu_u24lambda_u2411_u24lambda_u2410.setPadding(0, UtilsKt.getDp((int)2), 0, UtilsKt.getDp((int)2));
        $this$showMenu_u24lambda_u2411_u24lambda_u2410.setOnItemClickListener((arg_0, arg_1, arg_2, arg_3) -> ChatMessageAdapter.showMenu$lambda$11$lambda$10$lambda$9(items, $this$showMenu_u24lambda_u2411_u24lambda_u2410, isImage, iMessageModel, $this$showMenu_u24lambda_u2411, this, popupWindow, arg_0, arg_1, arg_2, arg_3));
        popupWindow.setContentView((View)listView);
        popupWindow.showAtLocation(parentView, 0, x - popupWindow.getWidth() / 2, y - popupWindow.getHeight());
    }

    private static final void onBindViewHolder$lambda$2$lambda$1(ChatMessageAdapter this$0, IMessageModel $message, ChatMessageView $this_with) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)((Object)$this_with), (String)"$this_with");
        String fromLanguage = "auto";
        CharSequence charSequence2 = this$0.chatViewModel.getLanguageTranslateTo();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = "zh";
        } else {
            charSequence = charSequence2;
        }
        String toLanguage = (String)charSequence;
        LPMessageModel messageModel = (LPMessageModel)$message;
        if (Intrinsics.areEqual((Object)messageModel.translateLanguage, (Object)toLanguage) && $this_with.isTranslate()) {
            $this_with.removeTranslate();
            this$0.chatViewModel.removeTranslateResult($message);
        } else {
            messageModel.translateLanguage = toLanguage;
            ChatViewModel chatViewModel = this$0.chatViewModel;
            String string2 = ((LPMessageModel)$message).content;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message.content");
            chatViewModel.translateMessage(this$0.getTranslateText(string2), ((LPMessageModel)$message).from.userId + ((LPMessageModel)$message).getTimestamp().getTime(), fromLanguage, toLanguage);
        }
    }

    private static final void onBindViewHolder$lambda$3(ChatMessageAdapter this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.chatViewModel.continueUploadQueue();
    }

    private static final boolean onBindViewHolder$lambda$5(GestureDetectorCompat $gestureDetectorCompat, View view, MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)$gestureDetectorCompat, (String)"$gestureDetectorCompat");
        $gestureDetectorCompat.onTouchEvent(event);
        return true;
    }

    private static final void showOptMenu$lambda$6(ChatMessageAdapter this$0, IUserModel $userModel, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userModel, (String)"$userModel");
        Context context2 = this$0.context;
        RouterViewModel routerViewModel2 = this$0.routerViewModel;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        ChatOptMenuHelper.Companion.showOptMenu(context2, routerViewModel2, it, (LPUserModel)$userModel, true);
    }

    private static final void showOptMenu$lambda$7(ChatMessageAdapter this$0, IUserModel $userModel, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userModel, (String)"$userModel");
        Context context2 = this$0.context;
        RouterViewModel routerViewModel2 = this$0.routerViewModel;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        ChatOptMenuHelper.Companion.showOptMenu(context2, routerViewModel2, it, (LPUserModel)$userModel, true);
    }

    private static final void showMenu$lambda$11$lambda$10$lambda$9(ArrayList $items, ListView $this_with, boolean $isImage, IMessageModel $iMessageModel, Context $this_run, ChatMessageAdapter this$0, PopupWindow $popupWindow, AdapterView adapterView, View view, int position, long l) {
        Intrinsics.checkNotNullParameter((Object)$items, (String)"$items");
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        Intrinsics.checkNotNullParameter((Object)$iMessageModel, (String)"$iMessageModel");
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$popupWindow, (String)"$popupWindow");
        String string2 = (String)$items.get(position);
        if (Intrinsics.areEqual((Object)string2, (Object)$this_with.getResources().getString(R.string.live_chat_copy))) {
            if ($isImage) {
                Context context2 = $this_with.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
                UtilsKt.copy((Context)context2, (String)("[img:" + $iMessageModel.getUrl() + ']'));
            } else {
                Context context3 = $this_with.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context");
                String string3 = $iMessageModel.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"iMessageModel.content");
                UtilsKt.copy((Context)context3, (String)string3);
            }
        } else if (Intrinsics.areEqual((Object)string2, (Object)$this_run.getString(R.string.live_chat_sticky))) {
            this$0.chatViewModel.addSticky($iMessageModel);
        } else if (Intrinsics.areEqual((Object)string2, (Object)$this_run.getString(R.string.live_chat_sticky_cancel))) {
            this$0.chatViewModel.cancelSticky($iMessageModel);
        } else if (Intrinsics.areEqual((Object)string2, (Object)$this_run.getString(R.string.bjy_base_chat_report))) {
            this$0.routerViewModel.getAction2Report().postValue((Object)$iMessageModel);
        } else if (Intrinsics.areEqual((Object)string2, (Object)$this_run.getString(R.string.bjy_base_chat_reference))) {
            this$0.routerViewModel.getActionShowSendMessageFragment().setValue((Object)"");
            LPMessageReferenceModel referenceModel = new LPMessageReferenceModel();
            referenceModel.setReferenceModel($iMessageModel);
            this$0.chatViewModel.getReferenceModel().setValue((Object)referenceModel);
        } else {
            this$0.chatViewModel.reCallMessage($iMessageModel);
        }
        $popupWindow.dismiss();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/baijiayun/liveuibase/chat/ChatMessageAdapter$PressListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "iMessageModel", "Lcom/baijiayun/livecore/models/imodels/IMessageModel;", "holder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "isImage", "", "(Lcom/baijiayun/liveuibase/chat/ChatMessageAdapter;Lcom/baijiayun/livecore/models/imodels/IMessageModel;Landroidx/recyclerview/widget/RecyclerView$ViewHolder;Z)V", "parent", "Landroid/view/View;", "position", "", "onLongPress", "", "e", "Landroid/view/MotionEvent;", "onSingleTapConfirmed", "liveuibase_release"})
    public final class PressListener
    extends GestureDetector.SimpleOnGestureListener {
        @Nullable
        private final IMessageModel iMessageModel;
        private boolean isImage;
        @Nullable
        private View parent;
        private int position;

        public PressListener(@NotNull IMessageModel iMessageModel, RecyclerView.ViewHolder holder, boolean isImage) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.iMessageModel = iMessageModel;
            this.isImage = isImage;
            this.parent = holder.itemView;
            this.position = holder.getAdapterPosition();
        }

        public void onLongPress(@NotNull MotionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.onLongPress(e);
            if (this.parent == null || this.iMessageModel == null) {
                return;
            }
            int n = (int)e.getRawX();
            int n2 = (int)e.getRawY();
            View view = this.parent;
            Intrinsics.checkNotNull((Object)view);
            ChatMessageAdapter.this.showMenu(n, n2, view, this.iMessageModel, this.isImage);
        }

        public boolean onSingleTapConfirmed(@NotNull MotionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!this.isImage || this.iMessageModel == null) {
                return true;
            }
            ChatMessageAdapter.this.getChatViewModel().getShowBigChatPicture().setValue((Object)this.iMessageModel.getUrl());
            return true;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/baijiayun/liveuibase/chat/ChatMessageAdapter$TextViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "dataBinding", "Lcom/baijiayun/liveuibase/databinding/ItemPadChatBinding;", "itemView", "Landroid/view/View;", "(Lcom/baijiayun/liveuibase/databinding/ItemPadChatBinding;Landroid/view/View;)V", "chatMessageView", "Lcom/baijiayun/liveuibase/widgets/chat/ChatMessageView;", "getChatMessageView", "()Lcom/baijiayun/liveuibase/widgets/chat/ChatMessageView;", "getDataBinding", "()Lcom/baijiayun/liveuibase/databinding/ItemPadChatBinding;", "gifDrawables", "", "Lcom/baijiayun/livebase/utils/URLImageParser$GlideGifDrawable;", "imageParserList", "Lcom/baijiayun/livebase/utils/URLImageParser;", "clearGifCache", "", "setGifCache", "drawables", "liveuibase_release"})
    public static final class TextViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ItemPadChatBinding dataBinding;
        @NotNull
        private final ChatMessageView chatMessageView;
        @Nullable
        private List<? extends URLImageParser.GlideGifDrawable> gifDrawables;
        @Nullable
        private List<? extends URLImageParser> imageParserList;

        public TextViewHolder(@NotNull ItemPadChatBinding dataBinding, @NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)((Object)dataBinding), (String)"dataBinding");
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            this.dataBinding = dataBinding;
            View view = itemView.findViewById(R.id.chat_message_content);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.chat_message_content)");
            this.chatMessageView = (ChatMessageView)view;
        }

        @NotNull
        public final ItemPadChatBinding getDataBinding() {
            return this.dataBinding;
        }

        @NotNull
        public final ChatMessageView getChatMessageView() {
            return this.chatMessageView;
        }

        public final void setGifCache(@NotNull List<? extends URLImageParser.GlideGifDrawable> drawables, @NotNull List<? extends URLImageParser> imageParserList) {
            Intrinsics.checkNotNullParameter(drawables, (String)"drawables");
            Intrinsics.checkNotNullParameter(imageParserList, (String)"imageParserList");
            this.gifDrawables = drawables;
            this.imageParserList = imageParserList;
        }

        public final void clearGifCache() {
            if (this.gifDrawables != null) {
                List<? extends URLImageParser.GlideGifDrawable> list = this.gifDrawables;
                Intrinsics.checkNotNull(list);
                for (URLImageParser.GlideGifDrawable glideGifDrawable : list) {
                    glideGifDrawable.onDestroy();
                }
            }
            if (this.imageParserList != null) {
                List<? extends URLImageParser> list = this.imageParserList;
                Intrinsics.checkNotNull(list);
                for (URLImageParser uRLImageParser : list) {
                    uRLImageParser.onDestroy();
                }
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/baijiayun/liveuibase/chat/ChatMessageAdapter$ImageViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "dataBinding", "Lcom/baijiayun/liveuibase/databinding/ItemPadChatBinding;", "itemView", "Landroid/view/View;", "(Lcom/baijiayun/liveuibase/databinding/ItemPadChatBinding;Landroid/view/View;)V", "getDataBinding", "()Lcom/baijiayun/liveuibase/databinding/ItemPadChatBinding;", "ivImg", "Landroid/widget/ImageView;", "getIvImg", "()Landroid/widget/ImageView;", "tvExclamation", "Landroid/widget/TextView;", "getTvExclamation", "()Landroid/widget/TextView;", "tvMask", "getTvMask", "tvName", "liveuibase_release"})
    public static final class ImageViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ItemPadChatBinding dataBinding;
        @NotNull
        private final TextView tvName;
        @NotNull
        private final TextView tvExclamation;
        @NotNull
        private final ImageView ivImg;
        @NotNull
        private final TextView tvMask;

        public ImageViewHolder(@NotNull ItemPadChatBinding dataBinding, @NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)((Object)dataBinding), (String)"dataBinding");
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            this.dataBinding = dataBinding;
            View view = itemView.findViewById(R.id.item_chat_image_name);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.item_chat_image_name)");
            this.tvName = (TextView)view;
            View view2 = itemView.findViewById(R.id.item_chat_image_exclamation);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView.findViewById(R.\u2026m_chat_image_exclamation)");
            this.tvExclamation = (TextView)view2;
            View view3 = itemView.findViewById(R.id.item_chat_image);
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"itemView.findViewById(R.id.item_chat_image)");
            this.ivImg = (ImageView)view3;
            View view4 = itemView.findViewById(R.id.item_chat_image_mask);
            Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"itemView.findViewById(R.id.item_chat_image_mask)");
            this.tvMask = (TextView)view4;
            this.tvName.setVisibility(8);
        }

        @NotNull
        public final ItemPadChatBinding getDataBinding() {
            return this.dataBinding;
        }

        @NotNull
        public final TextView getTvExclamation() {
            return this.tvExclamation;
        }

        @NotNull
        public final ImageView getIvImg() {
            return this.ivImg;
        }

        @NotNull
        public final TextView getTvMask() {
            return this.tvMask;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/baijiayun/liveuibase/chat/ChatMessageAdapter$Companion;", "", "()V", "MESSAGE_TYPE_IMAGE", "", "MESSAGE_TYPE_TEXT", "liveuibase_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LPConstants.MessageType.values().length];
            try {
                nArray[LPConstants.MessageType.Text.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPConstants.MessageType.Emoji.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPConstants.MessageType.EmojiWithName.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPConstants.MessageType.Reward.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPConstants.MessageType.Image.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LPConstants.LPEndType.values().length];
            try {
                nArray[LPConstants.LPEndType.PC_Client.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPConstants.LPEndType.PC_H5.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPConstants.LPEndType.PC_HTML.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPConstants.LPEndType.PC_MAC_Client.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPConstants.LPEndType.Android.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPConstants.LPEndType.iOS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

