/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbox.timer;

import android.content.Context;
import android.media.SoundPool;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.widgets.SimpleTextWatcher;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.window.BaseTitledWindow;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPTimerModel;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public class TeacherTimerWindow
extends BaseTitledWindow {
    private CompositeDisposable disposables;
    private Disposable timeDisposable;
    private boolean isPublish;
    private long remainSeconds;
    private long timeDuration;
    private EditText etMinHigh;
    private EditText etMinLow;
    private EditText etSecondHigh;
    private EditText etSecondLow;
    private TextView tvPublish;
    private long[] lastTimerSetting;
    private SoundPool soundPool;
    private TextWatcher textWatcher = new SimpleTextWatcher(){

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (TeacherTimerWindow.this.isPublish) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)s)) {
                TeacherTimerWindow.this.tvPublish.setSelected(false);
                TeacherTimerWindow.this.tvPublish.setEnabled(false);
            } else {
                boolean isEmpty = TextUtils.isEmpty((CharSequence)TeacherTimerWindow.this.etMinHigh.getText()) || TextUtils.isEmpty((CharSequence)TeacherTimerWindow.this.etMinLow.getText()) || TextUtils.isEmpty((CharSequence)TeacherTimerWindow.this.etSecondHigh.getText()) || !TeacherTimerWindow.this.isLegal();
                TeacherTimerWindow.this.tvPublish.setSelected(!isEmpty);
                TeacherTimerWindow.this.tvPublish.setEnabled(!isEmpty);
            }
        }
    };

    public TeacherTimerWindow(Context context) {
        super(context);
        this.init(context);
    }

    public TeacherTimerWindow(Context context, LPTimerModel lpTimerModel) {
        super(context);
        this.timeDuration = lpTimerModel.value.duration;
        this.init(context);
    }

    private void init(Context context) {
        this.title(context.getResources().getString(R.string.bjysc_tool_box_timer)).showClose(true).showFull(false).showSync(false).showScaleIcon(false);
        this.disposables = new CompositeDisposable();
        this.tvPublish = (TextView)this.$.id(R.id.tv_publish).view();
        this.tvPublish.setSelected(true);
        this.etMinHigh = (EditText)this.$.id(R.id.et_min_high).view();
        this.etMinLow = (EditText)this.$.id(R.id.et_min_low).view();
        this.etSecondHigh = (EditText)this.$.id(R.id.et_second_high).view();
        this.etSecondLow = (EditText)this.$.id(R.id.et_second_low).view();
        this.etMinLow.setText((CharSequence)String.valueOf(5));
        this.etMinHigh.addTextChangedListener(this.textWatcher);
        this.etMinLow.addTextChangedListener(this.textWatcher);
        this.etSecondHigh.addTextChangedListener(this.textWatcher);
        this.etSecondLow.addTextChangedListener(this.textWatcher);
        ((TextView)this.$.id(R.id.tv_risk).view()).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_window_main_text_color));
        this.disposables.add(this.iRouter.getLiveRoom().getToolBoxVM().getObservableOfTimerStart().observeOn(AndroidSchedulers.mainThread()).subscribe(lpTimerModel -> {
            if (this.isAdmin() && !this.isSelf(lpTimerModel.userId)) {
                this.timeDuration = this.remainSeconds = lpTimerModel.value.duration;
                this.publish(this.timeDuration);
            }
        }));
        this.disposables.add(this.iRouter.getLiveRoom().getToolBoxVM().getObservableOfTimerRevoke().observeOn(AndroidSchedulers.mainThread()).subscribe(lpDataUserModel -> {
            if (this.isAdmin() && !this.isSelf(lpDataUserModel.userId)) {
                this.revoke();
            }
        }));
        this.ivClose.setOnClickListener(v -> {
            this.sendRequestComponentDestroy();
            this.sendRequestTimerRevoke();
            this.closeSelf();
        });
        this.disposables.add(this.$.id(R.id.tv_publish).clicks().throttleFirst(500L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> {
            if (!this.tvPublish.isEnabled()) {
                this.showToastMessage("\u8bf7\u586b\u5165\u65f6\u95f4\uff0c\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            if (this.tvPublish.isSelected()) {
                this.saveTimerSetting();
                this.timeDuration = this.getTimerSeconds();
                this.publish(this.timeDuration);
                this.sendRequestTimerStart(this.remainSeconds);
            } else {
                this.sendRequestTimerRevoke();
                this.revoke();
            }
        }));
        if (this.timeDuration > 0L) {
            this.publish(this.timeDuration);
        }
    }

    private void saveTimerSetting() {
        this.lastTimerSetting = new long[]{Long.parseLong(this.etMinHigh.getText().toString()), Long.parseLong(this.etMinLow.getText().toString()), Long.parseLong(this.etSecondHigh.getText().toString()) * 10L, Long.parseLong(this.etSecondLow.getText().toString())};
    }

    public long[] getLastTimerSetting() {
        return this.lastTimerSetting;
    }

    public void recoverTimerSetting(long[] lastTimerSetting) {
        if (lastTimerSetting == null || lastTimerSetting.length != 4) {
            return;
        }
        this.etMinHigh.setText((CharSequence)String.valueOf(lastTimerSetting[0]));
        this.etMinLow.setText((CharSequence)String.valueOf(lastTimerSetting[1]));
        this.etSecondHigh.setText((CharSequence)String.valueOf(lastTimerSetting[2]));
        this.etSecondLow.setText((CharSequence)String.valueOf(lastTimerSetting[3]));
    }

    private boolean isSelf(String userId) {
        return TextUtils.equals((CharSequence)this.iRouter.getLiveRoom().getCurrentUser().getUserId(), (CharSequence)userId);
    }

    private void closeSelf() {
        this.iRouter.getSubjectByKey(EventKey.TeacherTimerWindow).onNext((Object)false);
    }

    private void publish(long duration) {
        this.remainSeconds = this.timeDuration = duration;
        this.showViewState(this.remainSeconds != 60L);
        this.isPublish = true;
        this.setTimer(this.timeDuration);
        this.showEditable(false);
        this.tvPublish.setSelected(false);
        this.tvPublish.setText((CharSequence)this.getString(R.string.bjysc_revoke));
        this.startTime();
    }

    private void revoke() {
        RxUtils.dispose((Disposable)this.timeDisposable);
        this.isPublish = false;
        this.setTimer(this.timeDuration);
        this.showEditable(true);
        this.showViewState(true);
        this.tvPublish.setSelected(true);
        this.tvPublish.setText((CharSequence)this.getString(R.string.bjysc_timer_publish));
    }

    private void startTime() {
        RxUtils.dispose((Disposable)this.timeDisposable);
        this.timeDisposable = Observable.interval((long)1L, (long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            if (this.remainSeconds == 0L) {
                if (this.soundPool != null) {
                    this.soundPool.release();
                }
                this.soundPool = UtilsKt.playAudio((Context)this.context, (int)R.raw.timer_end);
                RxUtils.dispose((Disposable)this.timeDisposable);
                this.showViewState(false);
            }
            if (this.remainSeconds > 0L) {
                --this.remainSeconds;
                this.setTimer(this.remainSeconds);
                if (this.remainSeconds <= 60L && this.timeDuration >= 60L) {
                    this.showViewState(false);
                }
            }
        });
    }

    private boolean isLegal() {
        return this.getTimerSeconds() > 0L;
    }

    private void setTimer(long remainSeconds) {
        long min = remainSeconds / 60L;
        long second = remainSeconds % 60L;
        this.etMinHigh.setText((CharSequence)String.valueOf(min / 10L));
        this.etMinLow.setText((CharSequence)String.valueOf(min % 10L));
        this.etSecondHigh.setText((CharSequence)String.valueOf(second / 10L));
        this.etSecondLow.setText((CharSequence)String.valueOf(second % 10L));
    }

    private void showEditable(boolean canEditable) {
        this.etMinHigh.setFocusable(canEditable);
        this.etMinLow.setFocusable(canEditable);
        this.etSecondHigh.setFocusable(canEditable);
        this.etSecondLow.setFocusable(canEditable);
        this.etMinHigh.setFocusableInTouchMode(canEditable);
        this.etMinLow.setFocusableInTouchMode(canEditable);
        this.etSecondHigh.setFocusableInTouchMode(canEditable);
        this.etSecondLow.setFocusableInTouchMode(canEditable);
        this.etMinHigh.setCursorVisible(canEditable);
        this.etMinLow.setCursorVisible(canEditable);
        this.etSecondHigh.setCursorVisible(canEditable);
        this.etSecondLow.setCursorVisible(canEditable);
    }

    private void showViewState(boolean isWarning) {
        this.etMinHigh.setEnabled(isWarning);
        this.etMinLow.setEnabled(isWarning);
        this.etSecondHigh.setEnabled(isWarning);
        this.etSecondLow.setEnabled(isWarning);
        if (isWarning) {
            ((TextView)this.$.id(R.id.tv_risk).view()).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color));
        } else {
            ((TextView)this.$.id(R.id.tv_risk).view()).setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_warning_color));
        }
    }

    private void sendRequestTimerStart(long seconds) {
        LPTimerModel timerModel = new LPTimerModel();
        LPTimerModel.ValueBean valueBean = new LPTimerModel.ValueBean();
        valueBean.duration = seconds;
        timerModel.value = valueBean;
        this.iRouter.getLiveRoom().getToolBoxVM().requestTimerStart(timerModel);
    }

    private void sendRequestTimerRevoke() {
        this.iRouter.getLiveRoom().getToolBoxVM().requestTimerRevoke();
    }

    private void sendRequestComponentDestroy() {
        this.iRouter.getLiveRoom().getToolBoxVM().requestComponentDestroy(LPConstants.ComponentType.Timer);
    }

    private long getTimerSeconds() {
        long min = 0L;
        long second = 0L;
        try {
            min = Long.parseLong(this.etMinHigh.getText().toString()) * 10L + Long.parseLong(this.etMinLow.getText().toString());
            second = Long.parseLong(this.etSecondHigh.getText().toString()) * 10L + Long.parseLong(this.etSecondLow.getText().toString());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        long seconds = min * 60L + second;
        return seconds;
    }

    @Override
    public void onDestroy() {
        if (this.disposables != null) {
            this.disposables.dispose();
        }
        RxUtils.dispose((Disposable)this.timeDisposable);
        this.etMinHigh.removeTextChangedListener(this.textWatcher);
        this.etMinLow.removeTextChangedListener(this.textWatcher);
        this.etSecondHigh.removeTextChangedListener(this.textWatcher);
        this.etSecondLow.removeTextChangedListener(this.textWatcher);
        super.onDestroy();
        if (this.soundPool != null) {
            this.soundPool.release();
            this.soundPool = null;
        }
    }

    @Override
    protected void onCreateContentView(Context context) {
        View.inflate((Context)context, (int)R.layout.bjy_group_window_timer_teacher_content, (ViewGroup)this.rlContentContainer);
    }
}

