/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbox.smallblackboard;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.content.res.AppCompatResources;
import com.baijiahulian.common.cropperv2.uikit.CircleColorView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.model.SbbStatusModel;
import com.baijiayun.livebase.models.LPUserModel;
import java.util.ArrayList;
import java.util.List;

public class SbbExpandableListViewAdapter
extends BaseExpandableListAdapter {
    private List<SbbStatusModel> sbbActiveStatusModelList = new ArrayList<SbbStatusModel>();
    private List<SbbStatusModel> sbbUnActiveStatusModelList = new ArrayList<SbbStatusModel>();

    public int getGroupCount() {
        return 2;
    }

    public int getChildrenCount(int groupPosition) {
        if (groupPosition == 0) {
            return this.sbbActiveStatusModelList.size();
        }
        return this.sbbUnActiveStatusModelList.size();
    }

    public Object getGroup(int groupPosition) {
        return groupPosition;
    }

    public Object getChild(int groupPosition, int childPosition) {
        if (groupPosition == 0) {
            return this.sbbActiveStatusModelList.get(childPosition);
        }
        return this.sbbUnActiveStatusModelList.get(childPosition);
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return Long.parseLong(((SbbStatusModel)this.getChild((int)groupPosition, (int)childPosition)).user.getUserId());
    }

    public boolean hasStableIds() {
        return true;
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        GroupViewHolder groupViewHolder;
        if (convertView == null) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_sbb_group_title, null);
            groupViewHolder = new GroupViewHolder();
            groupViewHolder.groupTextView = (TextView)view.findViewById(R.id.sbb_group_title_tv);
            groupViewHolder.itemStateIv = (ImageView)view.findViewById(R.id.sbb_group_state_iv);
            convertView = view;
            convertView.setTag((Object)groupViewHolder);
        } else {
            groupViewHolder = (GroupViewHolder)convertView.getTag();
        }
        if (isExpanded) {
            groupViewHolder.itemStateIv.setImageDrawable(AppCompatResources.getDrawable((Context)parent.getContext(), (int)R.drawable.iv_lp_ui_down));
        } else {
            groupViewHolder.itemStateIv.setImageDrawable(AppCompatResources.getDrawable((Context)parent.getContext(), (int)R.drawable.iv_lp_ui_group_close));
        }
        if (groupPosition == 0) {
            groupViewHolder.groupTextView.setText((CharSequence)parent.getContext().getResources().getString(R.string.sbb_active_group, new Object[]{this.sbbActiveStatusModelList.size()}));
        } else {
            groupViewHolder.groupTextView.setText((CharSequence)parent.getContext().getResources().getString(R.string.sbb_unactive_group, new Object[]{this.sbbUnActiveStatusModelList.size()}));
        }
        return convertView;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        SbbCommitStatusViewHolder holder;
        if (convertView == null) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_sbb_commit_status, null);
            holder = new SbbCommitStatusViewHolder();
            holder.checkIv = (ImageView)view.findViewById(R.id.sbb_commit_item_check_iv);
            holder.commitStudentTv = (TextView)view.findViewById(R.id.sbb_commit_student_name);
            holder.redDotIv = (ImageView)view.findViewById(R.id.sbb_red_dot);
            holder.circleColorView = (CircleColorView)view.findViewById(R.id.view_group_color);
            convertView = view;
            convertView.setTag((Object)holder);
        } else {
            holder = (SbbCommitStatusViewHolder)convertView.getTag();
        }
        List<SbbStatusModel> statusModelList = groupPosition == 0 ? this.sbbActiveStatusModelList : this.sbbUnActiveStatusModelList;
        SbbStatusModel statusModel = statusModelList.get(childPosition);
        if (statusModel != null) {
            LPUserModel lpUserModel = (LPUserModel)statusModel.user;
            if (lpUserModel.groupId != 0 && lpUserModel.groupItem != null) {
                holder.circleColorView.setVisibility(0);
                holder.circleColorView.setColor(Color.parseColor((String)lpUserModel.groupItem.color));
            } else {
                holder.circleColorView.setVisibility(8);
            }
            switch (statusModel.sbbStatus) {
                case NORMAL: {
                    holder.checkIv.setVisibility(8);
                    holder.redDotIv.setVisibility(8);
                    break;
                }
                case COMMIT: {
                    holder.checkIv.setVisibility(0);
                    holder.redDotIv.setVisibility(0);
                    break;
                }
                case READ: {
                    holder.checkIv.setVisibility(0);
                    holder.redDotIv.setVisibility(8);
                    break;
                }
            }
        }
        holder.commitStudentTv.setText((CharSequence)UtilsKt.getEncodePhoneNumber((String)statusModelList.get((int)childPosition).user.getName()));
        return convertView;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    public void setData(List<SbbStatusModel> activeList, List<SbbStatusModel> unActiveList) {
        this.sbbActiveStatusModelList = activeList;
        this.sbbUnActiveStatusModelList = unActiveList;
    }

    public int getActiveGroupCount() {
        return this.sbbActiveStatusModelList.size();
    }

    static class SbbCommitStatusViewHolder {
        ImageView checkIv;
        TextView commitStudentTv;
        ImageView redDotIv;
        CircleColorView circleColorView;

        SbbCommitStatusViewHolder() {
        }
    }

    static class GroupViewHolder {
        TextView groupTextView;
        ImageView itemStateIv;

        GroupViewHolder() {
        }
    }
}

