/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbox.browser;

import android.content.Context;
import android.text.TextUtils;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.global.RouterListener;
import com.baijiayun.groupclassui.window.video.VideoContainerWindow;
import com.baijiayun.groupclassui.window.video.VideoWindow;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.models.imodels.IMediaModel;
import com.baijiayun.liveuibase.toolbox.browser.BrowserWindow;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;

public class BrowserWindow2
extends BrowserWindow {
    private Disposable disposableOfMediaPublish;
    private VideoContainerWindow videoWindowWrapper;
    private boolean isMediaPublish = false;

    public BrowserWindow2(Context context) {
        super(context);
        this.subscribe();
    }

    private void subscribe() {
        Observable observableOfActiveUserTeacherExtStream = this.routerListener.getLiveRoom().getSpeakQueueVM().getObservableOfActiveUsers().flatMap(Observable::fromIterable).filter(iMediaModel -> iMediaModel.getExtraStreams() != null).flatMap(iMediaModel -> Observable.fromIterable((Iterable)iMediaModel.getExtraStreams()));
        this.disposableOfMediaPublish = this.routerListener.getLiveRoom().getSpeakQueueVM().getObservableOfMediaPublish().mergeWith((ObservableSource)observableOfActiveUserTeacherExtStream).filter(iMediaModel -> this.routerListener.getLiveRoom().getToolBoxVM().getWebPageInfo() != null).filter(iMediaModel -> TextUtils.equals((CharSequence)iMediaModel.getUser().getNumber(), (CharSequence)this.routerListener.getLiveRoom().getToolBoxVM().getWebPageInfo().id)).filter(iMediaModel -> {
            if (this.routerListener.getLiveRoom().getToolBoxVM().getWebPageInfo().isOpenStatus()) {
                return this.routerListener.getLiveRoom().getToolBoxVM().getWebPageInfo().isScreenShare && iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.MainScreenShare;
            }
            return iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.MainScreenShare;
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(this::handleExtStream);
    }

    private void handleExtStream(IMediaModel iMediaModel) {
        IRouter router = null;
        if (this.context instanceof RouterListener) {
            router = ((RouterListener)this.context).getRouter();
        }
        if (router != null) {
            if (iMediaModel.isVideoOn() && router.getLiveRoom().getToolBoxVM().getWebPageInfo() != null && router.getLiveRoom().getToolBoxVM().getWebPageInfo().isOpenStatus()) {
                router.getSubjectByKey(EventKey.CloseDuplicateStream).onNext((Object)iMediaModel.getMediaId());
                this.isMediaPublish = true;
                VideoWindow videoWindow = VideoWindow.newInstance(this.context, router);
                videoWindow.setAspectRatio(LPConstants.LPAspectRatio.Fit);
                videoWindow.setBottomVisibility(8);
                this.videoWindowWrapper = new VideoContainerWindow(this.context, videoWindow, false);
                this.videoWindowWrapper.initMediaModel(iMediaModel);
                this.videoWindowWrapper.getVideoWindow().changeVideoState(iMediaModel);
                this.rlContentContainer.addView(this.videoWindowWrapper.getView());
            } else {
                this.isMediaPublish = false;
                if (this.videoWindowWrapper != null) {
                    if (this.videoWindowWrapper.getVideoWindow() != null) {
                        this.videoWindowWrapper.getVideoWindow().changeVideoState(iMediaModel);
                    }
                    this.rlContentContainer.removeView(this.videoWindowWrapper.getView());
                }
            }
        }
    }

    public boolean isMediaPublish() {
        return this.isMediaPublish;
    }

    protected void closeWebPage() {
        super.closeWebPage();
        this.isMediaPublish = false;
        if (this.videoWindowWrapper != null) {
            this.rlContentContainer.removeView(this.videoWindowWrapper.getView());
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.videoWindowWrapper != null) {
            this.videoWindowWrapper.onDestroy();
        }
        RxUtils.dispose((Disposable)this.disposableOfMediaPublish);
    }
}

