/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.livecore.models.LPPlayerViewUpdateModel;
import com.baijiayun.liveuibase.widgets.DragScaleRelativeLayout;

public abstract class BaseTitledWindow
extends InteractiveBaseWindow {
    protected static int DEFAULT_MIN_SIZE = 100;
    protected int minSize;
    protected float otherSizeRatio = 2.0f;
    protected TextView tvTitle;
    protected ImageView ivClose;
    protected ImageView ivMaxFull;
    protected ImageView ivMaxSync;
    protected ImageView ivScale;
    protected ImageView minIv;
    protected FrameLayout rlTitleContainer;
    protected FrameLayout rlContentContainer;
    protected FrameLayout rlFooterContainer;
    protected FrameLayout contentOuterContainer;
    protected DragScaleRelativeLayout dragScaleRelativeLayout;
    protected ViewGroup.LayoutParams layoutParamsSmall;
    private ViewGroup.LayoutParams lastLayoutParams;
    protected boolean isMaxInSync;
    protected boolean isMaxInFull;
    protected boolean isReceiveOrder;
    protected boolean isLastMaxInSync;
    protected boolean isMinInSync;
    protected boolean isPPTWindow;
    protected boolean canScale = true;
    protected Drawable fullDrawable;
    protected Drawable fullResetDrawable;
    protected Drawable maxDrawable;
    protected Drawable maxResetDrawable;
    protected int maxDrawableId;
    protected int maxResetDrawableId;
    protected int fullDrawableId;
    protected int fullResetDrawableId;
    int downWidth;
    int downHeight;
    int downX;
    int downY;
    int measuredParentWidth;
    int measuredParentHeight;
    boolean scaling = false;

    protected BaseTitledWindow(Context context) {
        super(context);
    }

    protected View onCreateView(Context context) {
        this.minSize = UtilsKt.getDp((int)DEFAULT_MIN_SIZE);
        this.setNeedShowShadow(true);
        this.dragScaleRelativeLayout = (DragScaleRelativeLayout)LayoutInflater.from((Context)context).inflate(R.layout.bjy_base_window_titled, null);
        this.initViews();
        this.onCreateTopView(context);
        this.onCreateContentView(context);
        this.onCreateFooterView(context);
        this.initTopTitleView();
        this.initDrawableIds();
        this.initDrawables();
        return this.dragScaleRelativeLayout;
    }

    protected void initTopTitleView() {
        this.tvTitle = (TextView)this.dragScaleRelativeLayout.findViewById(R.id.window_titled_title);
        this.ivClose = (ImageView)this.dragScaleRelativeLayout.findViewById(R.id.window_titled_close);
        this.ivMaxFull = (ImageView)this.dragScaleRelativeLayout.findViewById(R.id.window_titled_max_in_full_layer);
        this.ivMaxSync = (ImageView)this.dragScaleRelativeLayout.findViewById(R.id.window_titled_max_in_sync_layer);
        this.ivMaxFull.setOnClickListener(l -> {
            this.isReceiveOrder = false;
            if (this.isMaxInFull) {
                this.resetInFull();
            } else {
                this.maxInFull();
            }
        });
        this.ivMaxSync.setOnClickListener(l -> {
            this.isReceiveOrder = false;
            if (this.isMaxInSync) {
                this.resetInSync();
            } else {
                this.maxInSync();
            }
        });
    }

    private void initViews() {
        this.ivScale = (ImageView)this.dragScaleRelativeLayout.findViewById(R.id.window_titled_scale_icon);
        this.rlTitleContainer = (FrameLayout)this.dragScaleRelativeLayout.findViewById(R.id.window_titled_top_container);
        this.rlFooterContainer = (FrameLayout)this.dragScaleRelativeLayout.findViewById(R.id.window_titled_footer_container);
        this.rlContentContainer = (FrameLayout)this.dragScaleRelativeLayout.findViewById(R.id.window_titled_content);
        this.contentOuterContainer = (FrameLayout)this.dragScaleRelativeLayout.findViewById(R.id.window_titled_content_container);
        this.dragScaleRelativeLayout.setDragThreshold(UtilsKt.getDp((int)128), UtilsKt.getDp((int)40));
        if (!this.isAdmin()) {
            this.ivScale.setVisibility(8);
        }
    }

    protected void initDrawableIds() {
        this.maxDrawableId = R.drawable.ic_max_in_sync_layer;
        this.maxResetDrawableId = R.drawable.ic_max_reset_to_sync_layer;
        this.fullDrawableId = R.drawable.ic_full_to_full_layer;
        this.fullResetDrawableId = R.drawable.ic_full_reset_to_sync_layer;
    }

    private void initDrawables() {
        this.fullDrawable = ContextCompat.getDrawable((Context)this.context, (int)this.fullDrawableId);
        this.fullResetDrawable = ContextCompat.getDrawable((Context)this.context, (int)this.fullResetDrawableId);
        this.maxDrawable = ContextCompat.getDrawable((Context)this.context, (int)this.maxDrawableId);
        this.maxResetDrawable = ContextCompat.getDrawable((Context)this.context, (int)this.maxResetDrawableId);
    }

    public void maxInSync() {
        if (this.view == null) {
            return;
        }
        ViewGroup viewGroup = this.getParentViewGroup();
        if (viewGroup == null || this.isMaxInSync) {
            return;
        }
        this.isMaxInSync = true;
        this.dragScaleRelativeLayout.bringToFront();
        if (!this.isMaxInFull && !this.isPPTWindow) {
            this.layoutParamsSmall = this.dragScaleRelativeLayout.getLayoutParams();
        }
        this.isMaxInFull = false;
        this.maximize();
        this.iRouter.getSubjectByKey(EventKey.SetMaximumWindowOn).onNext((Object)this);
        this.ivMaxSync.setImageDrawable(this.maxResetDrawable);
    }

    public void resetInSync() {
        if (this.view == null) {
            return;
        }
        ViewGroup viewGroup = this.getParentViewGroup();
        if (viewGroup == null) {
            return;
        }
        this.ivMaxSync.setImageDrawable(this.maxDrawable);
        this.dragScaleRelativeLayout.setLayoutParams(this.layoutParamsSmall);
        this.iRouter.getSubjectByKey(EventKey.SetMaximumWindowOff).onNext((Object)this);
        this.isMaxInSync = false;
    }

    public void maxInFull() {
        if (this.view == null || this.isMaxInFull) {
            return;
        }
        this.isMaxInFull = true;
        if (!this.isMaxInSync && !this.isPPTWindow) {
            this.layoutParamsSmall = this.dragScaleRelativeLayout.getLayoutParams();
        }
        this.lastLayoutParams = this.dragScaleRelativeLayout.getLayoutParams();
        this.isLastMaxInSync = this.isMaxInSync;
        this.isMaxInSync = false;
        this.ivMaxSync.setVisibility(8);
        this.ivMaxFull.setImageDrawable(this.fullResetDrawable);
        this.iRouter.getSubjectByKey(EventKey.SetFullScreenWindowOn).onNext((Object)this);
    }

    public void resetInFull() {
        if (this.view == null) {
            return;
        }
        this.isMaxInFull = false;
        this.isMaxInSync = this.isLastMaxInSync && !this.isPPTWindow;
        this.ivMaxSync.setImageDrawable(this.isMaxInSync ? this.maxResetDrawable : this.maxDrawable);
        this.ivMaxSync.setVisibility(0);
        this.ivMaxFull.setImageDrawable(this.fullDrawable);
        this.dragScaleRelativeLayout.setLayoutParams(this.lastLayoutParams == null ? this.layoutParamsSmall : this.lastLayoutParams);
        this.iRouter.getSubjectByKey(EventKey.SetFullScreenWindowOff).onNext((Object)this);
    }

    public void minInSync() {
        this.contentOuterContainer.setVisibility(8);
        this.rlFooterContainer.setVisibility(8);
        this.ivScale.setVisibility(8);
        this.minIv.setVisibility(8);
        this.ivClose.setVisibility(8);
        this.ivMaxSync.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.bjy_base_window_ic_reset));
        this.dragScaleRelativeLayout.setCanScaleOrDrag(false);
        if (!this.isMaxInFull) {
            this.lastLayoutParams = this.dragScaleRelativeLayout.getLayoutParams();
        }
        this.iRouter.getSubjectByKey(EventKey.MinimizeWindowOn).onNext((Object)this);
        this.isMinInSync = true;
    }

    public void resetMinInSync() {
        if (this.isMinInSync) {
            this.contentOuterContainer.setVisibility(0);
            this.rlFooterContainer.setVisibility(0);
            this.minIv.setVisibility(0);
            this.ivScale.setVisibility(0);
            this.ivClose.setVisibility(0);
        }
        this.iRouter.getSubjectByKey(EventKey.MinimizeWindowOff).onNext((Object)this);
        this.ivMaxSync.setImageDrawable(this.maxDrawable);
        if (this.isMaxInSync) {
            this.maxInSync();
            this.ivMaxSync.setImageDrawable(this.maxResetDrawable);
        } else if (this.isMaxInFull) {
            this.resetInFull();
        }
        this.isMinInSync = false;
    }

    public ViewGroup.LayoutParams getLayoutParamsSmall() {
        return this.layoutParamsSmall;
    }

    public ViewGroup.LayoutParams getLastLayoutParams() {
        return this.lastLayoutParams;
    }

    public void setReceiveOrder(boolean isReceiveOrder) {
        this.isReceiveOrder = isReceiveOrder;
    }

    public boolean isReceiveOrder() {
        return this.isReceiveOrder;
    }

    public void moveTo(int x, int y) {
        if (this.isMaxInFull || this.isMaxInSync) {
            return;
        }
        super.moveTo(x, y);
    }

    public void scaleTo(int width, int height) {
        if (this.isMaxInFull || this.isMaxInSync) {
            return;
        }
        super.scaleTo(width, height);
    }

    public boolean isMaxInSync() {
        return this.isMaxInSync;
    }

    public boolean isMaxInFull() {
        return this.isMaxInFull;
    }

    public boolean isMinInSync() {
        return this.isMinInSync;
    }

    protected abstract void onCreateContentView(Context var1);

    protected void onCreateFooterView(Context context) {
    }

    protected void onCreateTopView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_window_top, (ViewGroup)this.rlTitleContainer);
    }

    public BaseTitledWindow title(String title) {
        this.tvTitle.setText((CharSequence)title);
        return this;
    }

    public BaseTitledWindow showClose(boolean isShow) {
        this.ivClose.setVisibility(isShow ? 0 : 8);
        return this;
    }

    public void showTopContainer(boolean isShow) {
        this.rlTitleContainer.setVisibility(isShow ? 0 : 8);
    }

    public void showScaleIcon(boolean isShow) {
        this.ivScale.setVisibility(isShow ? 0 : 8);
    }

    protected void setCanScale(boolean canScale) {
        this.canScale = canScale;
        this.showScaleIcon(canScale);
    }

    protected void hideContentMask() {
        this.$.id(R.id.window_titled_content_layer).invisible();
    }

    public BaseTitledWindow showFull(boolean isShow) {
        this.ivMaxFull.setVisibility(isShow ? 0 : 8);
        return this;
    }

    public BaseTitledWindow showSync(boolean isShow) {
        this.ivMaxSync.setVisibility(isShow ? 0 : 8);
        return this;
    }

    protected boolean onTouchEvent(View v, MotionEvent event) {
        if (this.gestureDetector.onTouchEvent(event)) {
            return true;
        }
        if (this.isMinInSync) {
            return true;
        }
        if (event.getAction() == 0 && this.dragScaleRelativeLayout.isDownActionInScaleThreshold(event) && !this.isMaxInSync && !this.isMaxInFull && this.canScale) {
            this.scaling = true;
        }
        if (!this.scaling || !this.allowTouch) {
            return super.onTouchEvent(v, event);
        }
        this.handleScaleTouchEvent(v, event);
        return true;
    }

    protected void handleScaleTouchEvent(View v, MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        switch (event.getAction()) {
            case 0: {
                this.downX = x;
                this.downY = y;
                ViewGroup.LayoutParams layoutParams = this.dragScaleRelativeLayout.getLayoutParams();
                this.downWidth = layoutParams.width;
                this.downHeight = layoutParams.height;
                if (v.getParent() == null || !(v.getParent() instanceof ViewGroup)) break;
                ViewGroup viewGroup = (ViewGroup)v.getParent();
                this.measuredParentHeight = viewGroup.getMeasuredHeight();
                this.measuredParentWidth = viewGroup.getMeasuredWidth();
                break;
            }
            case 2: {
                int width;
                int height;
                int offX = x - this.downX;
                int offY = y - this.downY;
                if (v.getLeft() + this.downWidth + offX >= this.measuredParentWidth) {
                    offX = this.measuredParentWidth - this.downWidth - v.getLeft();
                }
                if (v.getTop() + this.downHeight + offY >= this.measuredParentHeight) {
                    offY = this.measuredParentHeight - this.downHeight - v.getTop();
                }
                if (this.otherSizeRatio > 0.0f) {
                    height = Math.max(this.downHeight + offY, this.minSize);
                    width = Math.max(this.downWidth + offX, (int)((float)this.minSize * this.otherSizeRatio));
                } else {
                    height = Math.max(this.downHeight + offY, (int)((float)this.minSize * -this.otherSizeRatio));
                    width = Math.max(this.downWidth + offX, this.minSize);
                }
                this.scaleTo(width, height);
                if (this.onWindowRepositionListener == null) break;
                this.onWindowRepositionListener.OnWindowScale(width, height);
                break;
            }
            case 1: {
                this.scaling = false;
                break;
            }
        }
    }

    protected LPPlayerViewUpdateModel.PlayerPosition getPlayerPosition() {
        LPPlayerViewUpdateModel.PlayerPosition playerPosition = new LPPlayerViewUpdateModel.PlayerPosition();
        playerPosition.x = String.valueOf(1.0f * (float)this.getView().getLeft() / (float)this.getParentViewGroup().getMeasuredWidth());
        playerPosition.y = String.valueOf(1.0f * (float)this.getView().getTop() / (float)this.getParentViewGroup().getMeasuredHeight());
        playerPosition.width = String.valueOf(1.0f * (float)this.getView().getMeasuredWidth() / (float)this.getParentViewGroup().getMeasuredWidth());
        playerPosition.height = String.valueOf(1.0f * (float)this.getView().getMeasuredHeight() / (float)this.getParentViewGroup().getMeasuredHeight());
        if (this.isMaxInFull()) {
            playerPosition.full = 1;
        } else if (this.isMaxInSync()) {
            playerPosition.max = 1;
        }
        return playerPosition;
    }
}

