/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livecore.context.LiveRoom;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class InteractiveUtils {
    public static String formatTime(int timeInSeconds) {
        if (timeInSeconds < 10) {
            return String.valueOf(timeInSeconds);
        }
        if (timeInSeconds < 60) {
            return "00:" + timeInSeconds;
        }
        if (timeInSeconds < 3600) {
            return timeInSeconds / 60 < 10 ? "0" + timeInSeconds / 60 + ":" + timeInSeconds % 60 : timeInSeconds / 60 + ":" + timeInSeconds % 60;
        }
        return timeInSeconds / 3600 + ":" + timeInSeconds % 3600 / 60 + ":" + timeInSeconds % 3600 % 60;
    }

    public static String formatTimeByLong(long time) {
        time = Math.abs(time);
        long sec = time % 60L;
        long min = time % 3600L / 60L;
        long hou = time / 3600L;
        return InteractiveUtils.fillZeroToSize_2(hou) + ":" + InteractiveUtils.fillZeroToSize_2(min) + ":" + InteractiveUtils.fillZeroToSize_2(sec);
    }

    private static String fillZeroToSize_2(long value) {
        if (value < 10L) {
            return "0" + value;
        }
        return String.valueOf(value);
    }

    public static void saveViewCapture(View view, String dir) {
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        view.draw(canvas);
        File f = new File(dir, "bjy_capture_" + System.currentTimeMillis() + ".png");
        try {
            FileOutputStream out = new FileOutputStream(f);
            bitmap.compress(Bitmap.CompressFormat.PNG, 80, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean hasDrawingAuth(LiveRoom liveRoom, IUserModel userModel) {
        Set list;
        if (userModel == null) {
            return false;
        }
        boolean hasDrawingAuth = userModel.getType() == LPConstants.LPUserType.Teacher || userModel.getType() == LPConstants.LPUserType.Assistant ? true : (list = liveRoom.getSpeakQueueVM().getStudentsDrawingAuthSet()) != null && list.contains(userModel.getNumber());
        return hasDrawingAuth;
    }

    public static boolean hasPPTAuth(LiveRoom liveRoom, IUserModel userModel) {
        if (liveRoom == null) {
            return false;
        }
        List userNumbers = (List)liveRoom.getDocListVM().getPublishSubjectOfStudentPPTAuth().getValue();
        return liveRoom.isTeacherOrAssistant() || userNumbers != null && userNumbers.contains(userModel.getNumber());
    }

    public static boolean hasScreenShareAuth(LiveRoom liveRoom, IUserModel userModel) {
        if (liveRoom == null) {
            return false;
        }
        List userNumbers = liveRoom.getMediaVM().getStudentScreenShareList();
        return liveRoom.isTeacherOrAssistant() || userNumbers != null && userNumbers.contains(userModel.getNumber());
    }

    public static String formatDuration(int duration) {
        int _duration = Math.abs(duration);
        int hour = _duration / 3600;
        int temp = _duration % 3600;
        int minutes = temp / 60;
        int seconds = (temp %= 60) % 60;
        String res = hour > 0 ? String.format(Locale.ENGLISH, "%02d:%02d:%02d", hour, minutes, seconds) : String.format(Locale.ENGLISH, "%02d:%02d", minutes, seconds);
        return duration >= 0 ? res : "- " + res;
    }

    public static String getEndTypeName(LPConstants.LPEndType endType) {
        switch (endType) {
            case iOS: {
                return "\u82f9\u679c\u624b\u673a";
            }
            case PC_H5: {
                return "\u7f51\u9875";
            }
            case PC_HTML: {
                return "\u7535\u8111\u7f51\u9875";
            }
            case PC_Client: {
                return "\u7535\u8111\u5ba2\u6237\u7aef";
            }
            case Android: {
                return "Android\u624b\u673a";
            }
            case PC_MAC_Client: {
                return "Mac\u5ba2\u6237\u7aef";
            }
        }
        return "\u7535\u8111";
    }
}

