/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.user;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.enums.ResStateType;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventCode;
import com.baijiayun.groupclassui.global.GroupClassActivity;
import com.baijiayun.groupclassui.user.AllOnlineUserListFragment;
import com.baijiayun.groupclassui.user.HandsUpUserListFragment;
import com.baijiayun.groupclassui.user.IUserInteractionListener;
import com.baijiayun.groupclassui.user.OnlineUserPresenter;
import com.baijiayun.groupclassui.user.ReplaceUserWithStatus;
import com.baijiayun.groupclassui.util.ReplaceWindowGenerateUtil;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.google.android.material.tabs.TabLayout;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.Objects;

public class OnlineUserWindow
extends InteractiveBaseWindow
implements IUserInteractionListener {
    private TextView handsUpTabTv;
    private TextView onlineUserTabTv;
    private Context context;
    private TabLayout.Tab onlineUserTab;
    private TabLayout.Tab handsUpTab;
    private View handsupTip;
    private ViewPager viewPager;
    private boolean hasCheck;
    private boolean startHandsUpList;
    private OnlineUserPresenter onlineUserPresenter;
    private AllOnlineUserListFragment onlineUserListFragment;
    private ReplaceUserWithStatus userWhenFullActiveAdd;
    private Disposable disposableOfSeatFull;
    private Disposable disposableOfSeatFullUserAdd;

    public OnlineUserWindow(Context context) {
        super(context);
    }

    protected View onCreateView(Context context) {
        View view = View.inflate((Context)context, (int)R.layout.bjy_group_dialog_online_user, null);
        view.setBackground(ThemeDataUtil.getCommonWindowBg((Context)context));
        this.context = context;
        RxUtils.dispose((Disposable)this.disposableOfSeatFull);
        RxUtils.dispose((Disposable)this.disposableOfSeatFullUserAdd);
        this.disposableOfSeatFull = this.iRouter.getPublishSubjectByKey(EventCode.NotifyCurrentSeatFull).ofType(Boolean.class).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> this.notifyCurrentSeatFull());
        this.disposableOfSeatFullUserAdd = this.iRouter.getPublishSubjectByKey(EventCode.UserWhenFullActiveAdd).ofType(ReplaceUserWithStatus.class).subscribe(userWhenFullActiveAdd -> {
            this.userWhenFullActiveAdd = userWhenFullActiveAdd;
        });
        return view;
    }

    private void initView(View view) {
        this.setAllowTouch(false);
        final HandsUpUserListFragment handsUpUserListFragment = HandsUpUserListFragment.newInstance();
        this.onlineUserListFragment = AllOnlineUserListFragment.newInstance();
        this.viewPager = (ViewPager)view.findViewById(R.id.online_user_viewpager);
        TabLayout tabLayout = (TabLayout)view.findViewById(R.id.user_tab);
        this.onlineUserPresenter = new OnlineUserPresenter(this);
        this.onlineUserPresenter.setRouter(this.iRouter);
        if (!(this.context instanceof FragmentActivity)) {
            return;
        }
        FragmentActivity activity = (FragmentActivity)this.context;
        this.viewPager.setAdapter((PagerAdapter)new FragmentPagerAdapter(activity.getSupportFragmentManager()){

            public Fragment getItem(int i) {
                return i == 0 ? OnlineUserWindow.this.onlineUserListFragment : handsUpUserListFragment;
            }

            public int getCount() {
                return 2;
            }
        });
        this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int i, float v, int i1) {
            }

            public void onPageSelected(int i) {
                if (i == 1) {
                    OnlineUserWindow.this.hasCheck = true;
                }
                if (OnlineUserWindow.this.onlineUserPresenter.getHandsUpUserCount() > 0 && !OnlineUserWindow.this.hasCheck) {
                    OnlineUserWindow.this.handsupTip.setVisibility(0);
                } else {
                    OnlineUserWindow.this.handsupTip.setVisibility(8);
                }
            }

            public void onPageScrollStateChanged(int i) {
            }
        });
        tabLayout.setupWithViewPager(this.viewPager);
        this.onlineUserTab = tabLayout.getTabAt(0);
        this.handsUpTab = tabLayout.getTabAt(1);
        Drawable drawable2 = new DrawableBuilder().rectangle().cornerRadii(UtilsKt.getDp((int)2), UtilsKt.getDp((int)2), 0, 0).strokeWidth((int)UtilsKt.getDp((float)0.5f)).strokeColor(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_bg_stroke)).build();
        Drawable selectedDrawable = new DrawableBuilder().rectangle().cornerRadii(UtilsKt.getDp((int)2), UtilsKt.getDp((int)2), 0, 0).solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color)).build();
        ColorStateList tabTextColor = DisplayUtils.getColorStateList((int)ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_dialog_positive_text_color), (int)ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color), (ResStateType)ResStateType.selected);
        if (this.handsUpTab != null) {
            this.handsUpTab.setCustomView(R.layout.user_dialog_tab_left_item);
            this.handsUpTabTv = (TextView)Objects.requireNonNull(this.handsUpTab.getCustomView()).findViewById(R.id.left_tab_tv);
            this.handsupTip = Objects.requireNonNull(this.handsUpTab.getCustomView()).findViewById(R.id.view_tip);
            this.handsUpTabTv.setText((CharSequence)this.context.getString(R.string.hands_up_user, new Object[]{this.onlineUserPresenter.getHandsUpUserCount()}));
            this.handsUpTabTv.setTextColor(tabTextColor);
            this.handsUpTabTv.setBackground((Drawable)new StateListDrawableBuilder().normal(drawable2).selected(selectedDrawable).build());
        }
        if (this.onlineUserTab != null) {
            this.onlineUserTab.setCustomView(R.layout.user_dialog_tab_right_item);
            this.onlineUserTabTv = (TextView)Objects.requireNonNull(this.onlineUserTab.getCustomView()).findViewById(R.id.right_tab_tv);
            this.onlineUserTabTv.setText((CharSequence)this.context.getString(R.string.all_online_user, new Object[]{this.onlineUserPresenter.getAllUserCount()}));
            this.onlineUserTabTv.setTextColor(tabTextColor);
            this.onlineUserTabTv.setBackground((Drawable)new StateListDrawableBuilder().normal(drawable2).selected(selectedDrawable).build());
        }
        ImageView closeIv = (ImageView)view.findViewById(R.id.online_user_close_iv);
        closeIv.setOnClickListener(v -> this.onlineUserPresenter.closeWindow());
        this.onlineUserPresenter.subscribe();
        if (this.startHandsUpList && this.handsUpTab != null) {
            this.handsUpTab.select();
        }
    }

    public void startHandsUpList() {
        if (this.handsUpTab != null) {
            this.handsUpTab.select();
        } else {
            this.startHandsUpList = true;
        }
    }

    public void destroy() {
        if (this.onlineUserPresenter != null) {
            this.onlineUserPresenter.destroy();
        }
        if (this.viewPager != null) {
            this.viewPager.clearOnPageChangeListeners();
        }
        RxUtils.dispose((Disposable)this.disposableOfSeatFull);
        RxUtils.dispose((Disposable)this.disposableOfSeatFullUserAdd);
        this.removeAllFragment();
    }

    @Override
    public void notifyOnlineUserDataSetChange() {
    }

    @Override
    public void notifyOnlineUserCountChange() {
        this.onlineUserTabTv.setText((CharSequence)this.context.getString(R.string.all_online_user, new Object[]{this.onlineUserPresenter.getAllUserCount()}));
    }

    @Override
    public void notifyHandsUpUserDataSetChange() {
        this.hasCheck = this.handsUpTab.isSelected();
        if (this.onlineUserPresenter.getHandsUpUserCount() > 0 && !this.hasCheck) {
            this.handsupTip.setVisibility(0);
        } else {
            this.handsupTip.setVisibility(8);
        }
        this.handsUpTabTv.setText((CharSequence)this.context.getString(R.string.hands_up_user, new Object[]{this.onlineUserPresenter.getHandsUpUserCount()}));
    }

    @Override
    public void notifyActiveUserDataChange() {
    }

    private void removeAllFragment() {
        if (this.context == null) {
            return;
        }
        for (Fragment fragment : ((AppCompatActivity)this.context).getSupportFragmentManager().getFragments()) {
            if (fragment == null) continue;
            ((AppCompatActivity)this.context).getSupportFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
        }
    }

    @Override
    public void notifySpeakApplyResult() {
    }

    @Override
    public void notifyForbidStatus() {
    }

    @Override
    public void notifyUserDataChange() {
    }

    @Override
    public void notifyForbidHandUp(boolean isForbid) {
    }

    @Override
    public void notifyCurrentSeatFull() {
        this.showFullDialog();
    }

    @Override
    public void showBlockedUserFreeAllUI() {
    }

    @Override
    public void notifyStudyRoomSwitch() {
    }

    private void showFullDialog() {
        if (this.context instanceof Activity) {
            Activity activity = (Activity)this.context;
            if (activity.isDestroyed() || activity.isFinishing()) {
                return;
            }
            ReplaceWindowGenerateUtil.generateWindow((FragmentActivity)((GroupClassActivity)activity), this.iRouter, this.userWhenFullActiveAdd);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.onlineUserPresenter != null) {
            this.onlineUserPresenter.destroy();
        }
    }

    @Override
    public boolean onRoomStatusChange(boolean isActive) {
        boolean isWindowInit = super.onRoomStatusChange(isActive);
        if (isWindowInit) {
            if (!isActive) {
                this.destroy();
            } else {
                this.initView(this.view);
            }
        }
        return true;
    }
}

