/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.layer;

import android.content.Context;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import com.baijiayun.bjyrtcengine.Defines.BJYRtcCommon;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.layer.BaseLayerOfProfessionalClass;
import com.baijiayun.groupclassui.layer.VideoDragLayer;
import com.baijiayun.groupclassui.model.NotifyAwardModel;
import com.baijiayun.groupclassui.model.PlayerViewActionModel;
import com.baijiayun.groupclassui.util.LayoutUtils;
import com.baijiayun.groupclassui.window.video.VideoContainerWindow;
import com.baijiayun.groupclassui.window.video.VideoWindow;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.GroupItem;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPAnswerRacerEndModel;
import com.baijiayun.livecore.models.LPAwardUserInfo;
import com.baijiayun.livecore.models.LPGroupItem;
import com.baijiayun.livecore.models.LPMediaModel;
import com.baijiayun.livecore.models.LPPlayerViewUpdateModel;
import com.baijiayun.livecore.models.imodels.IMediaModel;
import com.baijiayun.livecore.models.launch.LPAwardConfig;
import com.baijiayun.livecore.models.roomresponse.LPResRoomActiveUserModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomUserInModel;
import com.baijiayun.liveuibase.base.IWindow;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SeatLayer
extends BaseLayerOfProfessionalClass {
    private static final String TAG = SeatLayer.class.getCanonicalName();
    private FrameLayout.LayoutParams emptyParams;
    protected LinkedHashMap<String, VideoContainerWindow> mSpeakVideos;
    protected List<IMediaModel> mSpeakList;
    protected LiveRoom mLiveRoom;
    private VideoDragLayer videoDragLayer;
    private boolean isBoardLayout = true;
    protected boolean disableOtherStudentVideo = false;
    private HashMap<String, LPAwardUserInfo> awardRecord = new HashMap();
    protected int maxSpeakers;
    private LPMediaModel mySelfUserActiveModel;
    private boolean isInitActiveUserComplete;
    protected boolean hasPlaceHolder;
    protected View emptyView;
    private int margin_1v1 = 8;
    private int menu_size_1v1 = 20;
    protected static final int MAX_SPEAKERS_SIZE = 2;
    private Set<String> drawingAuthList = new HashSet<String>();
    private List<String> pptAuthList = new ArrayList<String>();
    private List<String> assistCameraList = new ArrayList<String>();
    private List<String> screenShareList = new ArrayList<String>();
    protected LPConstants.StudyRoomMode studyRoomMode = LPConstants.StudyRoomMode.None;
    private boolean isOnlineUserCallback;
    private float videoRatio;

    public SeatLayer(@NonNull Context context) {
        super(context);
    }

    public SeatLayer(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public SeatLayer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public SeatLayer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void init() {
        super.init();
        this.emptyParams = new FrameLayout.LayoutParams(-2, -2);
        this.mSpeakVideos = new LinkedHashMap();
        this.mSpeakList = new ArrayList<IMediaModel>();
        this.mLiveRoom = this.router.getLiveRoom();
        if (this.showTeacherPlaceholder()) {
            this.addEmptyView();
        }
    }

    protected void addEmptyView() {
        if (this.hasPlaceHolder) {
            return;
        }
        this.emptyView = this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE ? new View(this.getContext()) : View.inflate((Context)this.getContext(), (int)R.layout.bjysc_layout_video_empty, null);
        int margin = UtilsKt.getDp((int)1);
        this.emptyParams.setMargins(margin, margin, margin, margin);
        this.addView(this.emptyView, 0, (ViewGroup.LayoutParams)this.emptyParams);
        this.hasPlaceHolder = true;
    }

    protected void removeEmptyView() {
        if (this.hasPlaceHolder) {
            this.hasPlaceHolder = false;
            this.removeView(this.emptyView);
        }
    }

    protected boolean showTeacherPlaceholder() {
        return !this.hasPlaceHolder;
    }

    @Override
    public boolean onRoomStatusChange(boolean isRoomActive) {
        boolean isLayerInit = super.onRoomStatusChange(isRoomActive);
        if (isLayerInit) {
            if (isRoomActive) {
                LPLogger.d((String)"wtf2", (String)"seatLayer subscribe");
                this.mLiveRoom = this.router.getLiveRoom();
                this.initView();
            } else {
                UtilsKt.removeViewFromParent((View)this);
                this.onDestroy();
                LPLogger.d((String)"wtf2", (String)"seatLayer destroy");
            }
        }
        return true;
    }

    protected void initView() {
        this.videoRatio = 0.5625f;
        if (!this.mLiveRoom.enableFixChatPanel1v1() && !this.mLiveRoom.enableVideoFillMode1v1()) {
            this.margin_1v1 = 8;
            this.menu_size_1v1 = 20;
        } else {
            this.margin_1v1 = 1;
            this.menu_size_1v1 = 0;
        }
        this.maxSpeakers = this.mLiveRoom.getMaxActiveUsers();
        LPLogger.d((String)TAG, (String)("maxSpeakers=" + this.maxSpeakers));
        Disposable activeUsersDisposable = this.router.getLiveRoom().getSpeakQueueVM().getObservableOfActiveUsers().observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaModels -> {
            this.mSpeakList.clear();
            this.mSpeakList.addAll((Collection<IMediaModel>)iMediaModels);
            block0: for (IMediaModel iMediaModel : iMediaModels) {
                List extraStreams;
                if (iMediaModel.getExtraStreams() == null || iMediaModel.getUser().getType() == LPConstants.LPUserType.Teacher || this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE || (extraStreams = iMediaModel.getExtraStreams()) == null || extraStreams.isEmpty()) continue;
                for (IMediaModel extMediaModel : extraStreams) {
                    if (extMediaModel.getMediaSourceType() != LPConstants.MediaSourceType.MainScreenShare) continue;
                    iMediaModel.setVideoOn(iMediaModel.isVideoOn() || extMediaModel.isVideoOn());
                    continue block0;
                }
            }
            if (this.mySelfUserActiveModel != null) {
                this.mSpeakList.add((IMediaModel)this.mySelfUserActiveModel);
            }
            this.isInitActiveUserComplete = true;
            LPLogger.d((String)TAG, (String)("active users=" + iMediaModels.size() + "....speak list=" + this.mSpeakList.size()));
            if (this.mLiveRoom.getCurrentUser().getType() == LPConstants.LPUserType.Teacher) {
                LPLogger.d((String)TAG, (String)"active users : teacher init...");
                if (!this.mSpeakVideos.containsKey(this.router.getLiveRoom().getCurrentUser().getUserId())) {
                    this.router.getLiveRoom().getOnlineUserVM().requestAddActiveUser(this.router.getLiveRoom().getCurrentUser());
                }
                if (this.router.getLiveRoom().getMaxActiveUsers() < this.router.getLiveRoom().getOnlineUserVM().getActiveUserList().size()) {
                    LPMediaModel mediaModel = new LPMediaModel();
                    mediaModel.user = (LPUserModel)this.router.getLiveRoom().getCurrentUser();
                    mediaModel.audioOn = false;
                    mediaModel.videoOn = this.router.getLiveRoom().isClassStarted();
                    mediaModel.keepAlive = true;
                    this.mSpeakList.add((IMediaModel)mediaModel);
                    this.addVideo((IMediaModel)mediaModel, this.router.getLiveRoom().isClassStarted());
                }
                for (IMediaModel iMediaModel : this.mSpeakList) {
                    if (iMediaModel.getUser().getUserId().equals(this.router.getLiveRoom().getCurrentUser().getUserId()) || !this.router.getLiveRoom().getOnlineUserVM().isActiveUser(iMediaModel.getUser())) continue;
                    this.addVideo(iMediaModel, iMediaModel.isVideoOn() || iMediaModel.isAudioOn());
                }
            } else if (this.mLiveRoom.getCurrentUser().getType() == LPConstants.LPUserType.Assistant) {
                LPLogger.d((String)TAG, (String)"active users : assistant init...");
                for (IMediaModel iMediaModel : this.mSpeakList) {
                    if (iMediaModel.getUser().getUserId().equals(this.router.getLiveRoom().getCurrentUser().getUserId()) || !this.router.getLiveRoom().getOnlineUserVM().isActiveUser(iMediaModel.getUser())) continue;
                    this.addVideo(iMediaModel, iMediaModel.isVideoOn() || iMediaModel.isAudioOn());
                }
            } else {
                LPLogger.d((String)TAG, (String)("active users : student init... " + this.mSpeakList.size()));
                Iterator<Object> iterator = this.mSpeakList.iterator();
                while (iterator.hasNext()) {
                    IMediaModel iMediaModel;
                    this.addVideo(iMediaModel, (iMediaModel = (IMediaModel)iterator.next()).isVideoOn() || iMediaModel.isAudioOn());
                }
            }
            this.sendSyncPlayView(this.mLiveRoom.getMediaVM().getPlayerViewUpdate());
            this.router.getLiveRoom().getOnlineUserVM().loadMoreUser();
        });
        Disposable disposableOfUserMore = this.router.getLiveRoom().getOnlineUserVM().getObservableOfUserMore().observeOn(AndroidSchedulers.mainThread()).subscribe(iUserModels -> {
            if (!this.isOnlineUserCallback) {
                this.requestUpToSeat((List<IUserModel>)iUserModels);
                this.isOnlineUserCallback = true;
            }
        });
        Disposable classStartDisposable = this.router.getLiveRoom().getObservableOfClassStart().observeOn(AndroidSchedulers.mainThread()).filter(integer -> integer == 0).subscribe(integer -> {
            if (this.router.getLiveRoom().getOnlineUserVM().isActiveUser(this.router.getLiveRoom().getCurrentUser()) && !this.mSpeakVideos.containsKey(this.router.getLiveRoom().getCurrentUser().getUserId())) {
                LPMediaModel mediaModel = new LPMediaModel();
                mediaModel.user = (LPUserModel)this.router.getLiveRoom().getCurrentUser();
                mediaModel.audioOn = false;
                mediaModel.videoOn = true;
                mediaModel.keepAlive = true;
                this.mSpeakList.add((IMediaModel)mediaModel);
                this.addVideo((IMediaModel)mediaModel, true);
            }
            for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
                if (!videoContainerWindow.getVideoWindow().isLocalVideo()) continue;
                videoContainerWindow.getVideoWindow().publishLocalStream();
                break;
            }
        });
        Disposable userInDisposable = this.mLiveRoom.getOnlineUserVM().getObservableOfUserIn().observeOn(AndroidSchedulers.mainThread()).subscribe(iUserInModel -> {
            if (this.router.getLiveRoom().getCurrentUser().getType() != LPConstants.LPUserType.Teacher) {
                return;
            }
            if (iUserInModel.getUser().getType() == LPConstants.LPUserType.Assistant) {
                return;
            }
            if (this.mSpeakVideos.size() > this.maxSpeakers) {
                return;
            }
            if (!this.autoOnStage()) {
                return;
            }
            this.router.getLiveRoom().getOnlineUserVM().requestAddActiveUser(iUserInModel.getUser());
        });
        Disposable userOutDisposable = this.mLiveRoom.getOnlineUserVM().getObservableOfUserOut().observeOn(AndroidSchedulers.mainThread()).subscribe(userModel -> {
            LPLogger.d((String)TAG, (String)"user out");
            if (this.mSpeakVideos.get(userModel.getUserId()) == null) {
                return;
            }
            LPLogger.d((String)TAG, (String)("user out" + this.mSpeakVideos.get(userModel.getUserId()).getMediaModel().getUser().getName()));
            for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
                if (!videoContainerWindow.getVideoWindow().getUserId().equals(userModel.getUserId())) continue;
                this.removeVideo(videoContainerWindow.getMediaModel());
                break;
            }
        });
        Disposable mediaStateDisposable = this.mLiveRoom.getSpeakQueueVM().getObservableOfMediaPublish().filter(iMediaModel -> {
            if (iMediaModel.getUser().getType() == LPConstants.LPUserType.Teacher || this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
                return iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.MainCamera;
            }
            return iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.MainCamera || iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.MainScreenShare;
        }).map(iMediaModel -> {
            if (iMediaModel instanceof LPMediaModel) {
                ((LPMediaModel)iMediaModel).mediaId = "";
            } else if (iMediaModel instanceof LPResRoomActiveUserModel) {
                ((LPResRoomActiveUserModel)iMediaModel).mediaId = "";
            }
            return iMediaModel;
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaModel -> {
            iMediaModel.setScreenShareFlag(iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.MainScreenShare || iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.ExtScreenShare);
            IUserModel modelUser = iMediaModel.getUser();
            VideoContainerWindow videoContainerWindow = this.mSpeakVideos.get(modelUser.getUserId());
            LPLogger.d((String)TAG, (String)("media_publish: ...name=" + modelUser.getName() + "...uid=" + modelUser.getUserId() + "....video_on=" + iMediaModel.isVideoOn() + "....audio_on=" + iMediaModel.isAudioOn() + "......keep_alive=" + iMediaModel.isKeepAlive()));
            if (iMediaModel.isAudioOn() || iMediaModel.isVideoOn() || iMediaModel.isKeepAlive()) {
                if (videoContainerWindow == null) {
                    this.mSpeakList.add((IMediaModel)iMediaModel);
                    this.addVideo((IMediaModel)iMediaModel, iMediaModel.isAudioOn() || iMediaModel.isVideoOn());
                } else if (!videoContainerWindow.getVideoWindow().getUserId().equals(this.mLiveRoom.getCurrentUser().getUserId())) {
                    iMediaModel.setScreenShareFlag(iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.MainScreenShare || iMediaModel.getMediaSourceType() == LPConstants.MediaSourceType.ExtScreenShare);
                    videoContainerWindow.setMediaModel((IMediaModel)iMediaModel);
                    videoContainerWindow.getVideoWindow().changeVideoState((IMediaModel)iMediaModel);
                    videoContainerWindow.getVideoWindow().setAudioOn(iMediaModel.isAudioOn());
                    videoContainerWindow.getVideoWindow().setVideoOn(iMediaModel.isVideoOn());
                }
            } else if (videoContainerWindow != null) {
                this.removeVideo(videoContainerWindow.getMediaModel());
            }
        });
        if (!BaseUtilsKt.isTeacher((IUserModel)this.router.getLiveRoom().getCurrentUser())) {
            this.compositeDisposable.add(this.mLiveRoom.getObservableOfDisableOtherStudentVideo().observeOn(AndroidSchedulers.mainThread()).subscribe(model -> {
                if (!model.isFromCache()) {
                    this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getContext().getString(model.isDisable() ? R.string.bjysc_disable_other_student_video_tint : R.string.bjysc_enable_other_student_video_tint));
                }
                if (!BaseUtilsKt.isAdmin((LiveRoom)this.mLiveRoom)) {
                    boolean hideOtherStudentVideo;
                    boolean bl = hideOtherStudentVideo = model.isDisable() || this.router.getSubjectValueByKey(EventKey.HideOtherStudentVideo, Boolean.class, false) != false;
                    if (this.disableOtherStudentVideo == hideOtherStudentVideo) {
                        return;
                    }
                    this.disableOtherStudentVideo = hideOtherStudentVideo;
                    this.requestLayout();
                }
            }));
            this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.HideOtherStudentVideo).ofType(Boolean.class).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
                if (!BaseUtilsKt.isAdmin((LiveRoom)this.mLiveRoom)) {
                    this.disableOtherStudentVideo = aBoolean;
                    this.requestLayout();
                }
            }));
        }
        if (!BaseUtilsKt.isAdmin((LiveRoom)this.mLiveRoom)) {
            this.disableOtherStudentVideo = this.mLiveRoom.getDisableOtherStudentVideoData().isDisable();
            this.requestLayout();
        }
        Disposable groupInfoDisposable = this.mLiveRoom.getOnlineUserVM().getObservableOfOnGroupItem().subscribe(lpGroupItems -> {
            if (lpGroupItems.size() > 0) {
                this.cancelGroup();
                this.setGroup((List<LPGroupItem>)lpGroupItems);
            } else {
                this.cancelGroup();
                for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
                    videoContainerWindow.getVideoWindow().setGroupItem(new GroupItem(0));
                }
            }
        });
        Disposable speakApplyDisposable = this.mLiveRoom.getSpeakQueueVM().getObservableOfSpeakApply().observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaModel -> {
            this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getContext().getString(R.string.bjysc_hans_up_from_student));
            VideoContainerWindow videoContainerWindow = this.mSpeakVideos.get(iMediaModel.getUser().getUserId());
            if (null == videoContainerWindow) {
                return;
            }
            videoContainerWindow.getVideoWindow().showHandsUpIcon(true);
        });
        Disposable speakResponseDisposable = this.mLiveRoom.getSpeakQueueVM().getObservableOfSpeakResponse().mergeWith((ObservableSource)this.mLiveRoom.getSpeakQueueVM().getObservableOfMediaControl().filter(iMediaControlModel -> iMediaControlModel.isAudioOn() && iMediaControlModel.isVideoOn())).observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaControlModel -> {
            LPLogger.d((String)TAG, (String)("speak response: " + iMediaControlModel.isApplyAgreed()));
            if (!iMediaControlModel.isApplyAgreed()) {
                return;
            }
            IUserModel iUserModel = iMediaControlModel.getUser();
            if (iUserModel == null || !iUserModel.getUserId().equals(this.router.getLiveRoom().getCurrentUser().getUserId())) {
                return;
            }
            VideoContainerWindow targetUserWindow = this.mSpeakVideos.get(iUserModel.getUserId());
            if (targetUserWindow != null) {
                targetUserWindow.getVideoWindow().attachAudio();
            } else {
                LPMediaModel mediaModel = new LPMediaModel();
                mediaModel.user = (LPUserModel)iUserModel;
                mediaModel.audioOn = iMediaControlModel.isAudioOn();
                mediaModel.videoOn = iMediaControlModel.isVideoOn();
                mediaModel.isHandUp = true;
                this.addVideo((IMediaModel)mediaModel, true);
                this.mSpeakList.add((IMediaModel)mediaModel);
                if (this.handsAutoAttachAudio()) {
                    this.mLiveRoom.getRecorder().attachAudio();
                }
            }
        });
        Disposable speakApplyDenyDisposable = this.mLiveRoom.getSpeakQueueVM().getObservableOfSpeakApplyDeny().observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaModel -> this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getResources().getString(R.string.bjysc_speak_apply_deny_limit)));
        Disposable awardDisposable = this.mLiveRoom.getToolBoxVM().getObservableOfAward().observeOn(AndroidSchedulers.mainThread()).subscribe(lpInteractionAwardModel -> {
            HashMap awardMap = lpInteractionAwardModel.value.getRecordAward();
            this.awardRecord.putAll(awardMap);
            if (lpInteractionAwardModel.isFromCache) {
                for (Map.Entry entry : awardMap.entrySet()) {
                    VideoContainerWindow videoContainerWindow;
                    IUserModel userModel = this.getSpeakModelWithUserNumber((String)entry.getKey());
                    if (userModel == null || (videoContainerWindow = this.mSpeakVideos.get(userModel.getUserId())) == null) continue;
                    videoContainerWindow.getVideoWindow().setAwardCount(((LPAwardUserInfo)entry.getValue()).count);
                }
            } else if ("-1".equals(lpInteractionAwardModel.value.to)) {
                for (Map.Entry<String, VideoContainerWindow> entry : this.mSpeakVideos.entrySet()) {
                    VideoWindow videoWindow = entry.getValue().getVideoWindow();
                    LPAwardUserInfo awardUserInfo = (LPAwardUserInfo)awardMap.get(videoWindow.getUserModel().getNumber());
                    if (awardUserInfo != null) {
                        videoWindow.setAwardCount(awardUserInfo.count);
                    }
                    if (lpInteractionAwardModel.value.toStudents != null && lpInteractionAwardModel.value.toStudents.size() != 0) continue;
                    this.router.getSubjectByKey(EventKey.ShowAward).onNext((Object)new NotifyAwardModel(true));
                }
            } else {
                IUserModel userModel = this.getSpeakModelWithUserNumber(lpInteractionAwardModel.value.to);
                if (userModel == null) {
                    return;
                }
                VideoContainerWindow videoContainerWindow = this.mSpeakVideos.get(userModel.getUserId());
                if (awardMap.get(lpInteractionAwardModel.value.to) == null) {
                    return;
                }
                LPAwardUserInfo awardUserInfo = (LPAwardUserInfo)awardMap.get(lpInteractionAwardModel.value.to);
                if (awardUserInfo == null) {
                    return;
                }
                int[] location = new int[2];
                if (videoContainerWindow != null && !videoContainerWindow.isJoinedBlackboard()) {
                    videoContainerWindow.getVideoWindow().setAwardCount(awardUserInfo.count);
                    videoContainerWindow.getView().getLocationOnScreen(location);
                    location[0] = location[0] + videoContainerWindow.getView().getMeasuredWidth() / 2;
                    location[1] = location[1] + videoContainerWindow.getView().getMeasuredHeight() / 2;
                    if (awardMap.containsKey(lpInteractionAwardModel.value.to)) {
                        this.router.getSubjectByKey(EventKey.ShowAward).onNext((Object)new NotifyAwardModel(userModel, false, location, lpInteractionAwardModel.value.pictureUrl));
                    }
                } else if (awardMap.containsKey(lpInteractionAwardModel.value.to)) {
                    this.router.getSubjectByKey(EventKey.ShowAwardTransfer).onNext((Object)new NotifyAwardModel(userModel, awardUserInfo.count, location, lpInteractionAwardModel.value.pictureUrl));
                }
            }
        });
        this.compositeDisposable.add(this.router.getLiveRoom().getToolBoxVM().getObservableOfGroupAward().observeOn(AndroidSchedulers.mainThread()).subscribe(lpGroupAwardModel -> {
            int[] location = new int[2];
            if (lpGroupAwardModel.group == 0) {
                LPUserModel userModel = new LPUserModel();
                userModel.name = "\u5168\u4f53\u5956\u52b1";
                this.router.getSubjectByKey(EventKey.ShowAward).onNext((Object)new NotifyAwardModel(3, (IUserModel)userModel, location));
            } else {
                LPUserModel userModel = new LPUserModel();
                userModel.name = lpGroupAwardModel.groupName;
                this.router.getSubjectByKey(EventKey.GroupAward).onNext(lpGroupAwardModel);
                this.router.getSubjectByKey(EventKey.ShowAward).onNext((Object)new NotifyAwardModel(2, (IUserModel)userModel, location));
            }
        }));
        this.compositeDisposable.add(this.mLiveRoom.getToolBoxVM().getObservableOfAnswerRacerEnd().observeOn(AndroidSchedulers.mainThread()).subscribe(lpAnswerRacerEndModel -> {
            LPAnswerRacerEndModel answerRacerEndModel = new LPAnswerRacerEndModel(lpAnswerRacerEndModel);
            if (answerRacerEndModel.winner != null) {
                answerRacerEndModel.winner.name = answerRacerEndModel.winner.name.length() > 3 ? "\"" + answerRacerEndModel.winner.name.substring(0, 3) + "...\"" + this.getResources().getString(R.string.base_responder_success) : "\"" + answerRacerEndModel.winner.name + "\"" + this.getResources().getString(R.string.base_responder_success);
            }
            if (!answerRacerEndModel.isRevoke && answerRacerEndModel.winner != null) {
                IUserModel userModel = this.getSpeakModelWithUserNumber(answerRacerEndModel.winner.getNumber());
                int[] location = new int[2];
                if (userModel == null) {
                    this.router.getSubjectByKey(EventKey.ShowAwardTransfer).onNext((Object)new NotifyAwardModel((IUserModel)answerRacerEndModel.winner, false, location, "praise"));
                    return;
                }
                VideoContainerWindow videoContainerWindow = this.mSpeakVideos.get(userModel.getUserId());
                if (videoContainerWindow != null && !videoContainerWindow.isJoinedBlackboard()) {
                    videoContainerWindow.getView().getLocationOnScreen(location);
                    location[0] = location[0] + videoContainerWindow.getView().getMeasuredWidth() / 2;
                    location[1] = location[1] + videoContainerWindow.getView().getMeasuredHeight() / 2;
                    this.router.getSubjectByKey(EventKey.ShowAward).onNext((Object)new NotifyAwardModel(4, (IUserModel)answerRacerEndModel.winner, location));
                } else {
                    this.router.getSubjectByKey(EventKey.ShowAwardTransfer).onNext((Object)new NotifyAwardModel((IUserModel)answerRacerEndModel.winner, false, location, "praise"));
                }
            }
        }));
        Disposable micOnDisposable = this.router.getLiveRoom().getRecorder().getObservableOfMicOn().observeOn(AndroidSchedulers.mainThread()).subscribe(isMicOn -> {
            for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
                if (!videoContainerWindow.getVideoWindow().isLocalVideo()) continue;
                videoContainerWindow.getVideoWindow().setAudioOn((boolean)isMicOn);
                break;
            }
        });
        Disposable drawAuthDisposable = this.mLiveRoom.getSpeakQueueVM().getPublishSubjectOfDrawingAuth().observeOn(AndroidSchedulers.mainThread()).subscribe(isAuth -> {
            this.drawingAuthList = this.mLiveRoom.getSpeakQueueVM().getStudentsDrawingAuthSet();
            for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
                videoContainerWindow.getVideoWindow().setDrawAuthOn(this.drawingAuthList.contains(videoContainerWindow.getVideoWindow().getUserModel().getNumber()));
            }
        });
        Disposable pptAuthDisposable = this.mLiveRoom.getDocListVM().getPublishSubjectOfStudentPPTAuth().observeOn(AndroidSchedulers.mainThread()).subscribe(pptAuthList -> {
            this.pptAuthList = pptAuthList;
            if (pptAuthList == null || pptAuthList.isEmpty()) {
                for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
                    videoContainerWindow.getVideoWindow().setPPTAuthOn(false);
                }
                return;
            }
            for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
                videoContainerWindow.getVideoWindow().setPPTAuthOn(pptAuthList.contains(videoContainerWindow.getVideoWindow().getUserModel().getNumber()));
            }
        });
        Disposable assistCameraDisposable = this.mLiveRoom.getMediaVM().getPublishSubjectOfStudentExtCamera().observeOn(AndroidSchedulers.mainThread()).subscribe(assistCameraList -> {
            this.assistCameraList = assistCameraList;
            if (assistCameraList == null || assistCameraList.isEmpty()) {
                for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
                    videoContainerWindow.getVideoWindow().setAssistCameraOn(false);
                }
                return;
            }
            for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
                videoContainerWindow.getVideoWindow().setAssistCameraOn(assistCameraList.contains(videoContainerWindow.getVideoWindow().getUserModel().getNumber()));
            }
        });
        Disposable screenShareDisposable = this.mLiveRoom.getMediaVM().getPublishSubjectOfStudentScreenShare().observeOn(AndroidSchedulers.mainThread()).subscribe(screenShareList -> {
            this.screenShareList = screenShareList;
            if (UtilsKt.isEmptyList((List)screenShareList)) {
                for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
                    videoContainerWindow.getVideoWindow().setScreenShareOn(false);
                }
                return;
            }
            for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
                videoContainerWindow.getVideoWindow().setScreenShareOn(screenShareList.contains(videoContainerWindow.getVideoWindow().getUserModel().getNumber()));
            }
        });
        Disposable playerViewRemoveDisposable = this.router.getSubjectByKey(EventKey.PlayerViewRemove).ofType(VideoWindow.class).filter(blackboardVideoWindow -> null != this.mSpeakVideos.get(blackboardVideoWindow.getUserId())).observeOn(AndroidSchedulers.mainThread()).subscribe(blackboardVideoWindow -> {
            VideoContainerWindow videoContainerWindow = this.mSpeakVideos.get(blackboardVideoWindow.getUserId());
            if (videoContainerWindow == null) {
                return;
            }
            videoContainerWindow.getVideoWindow().setZOrderMediaOverlay(false);
            if (this.isBoardLayout()) {
                videoContainerWindow.getVideoWindow().setRemoteVideoStreamType(BJYRtcCommon.DualStreamType.VIDEO_STREAM_LOW);
            }
            if (blackboardVideoWindow.getMediaSourceType() == LPConstants.MediaSourceType.MainCamera || blackboardVideoWindow.isScreenShare()) {
                videoContainerWindow.backToSeat((VideoWindow)blackboardVideoWindow);
            }
        });
        Disposable subscriptionOfUpToSeatContainer = this.router.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserAdd().observeOn(AndroidSchedulers.mainThread()).subscribe(lpResRoomUserInModel -> {
            LPUserModel userModel = (LPUserModel)lpResRoomUserInModel.getUser();
            if (!this.router.getLiveRoom().getOnlineUserVM().isActiveUser((IUserModel)userModel)) {
                return;
            }
            if (userModel.status == LPConstants.LPUserState.Invisible) {
                return;
            }
            if (userModel.equals((Object)this.router.getLiveRoom().getCurrentUser())) {
                this.mySelfUserActiveModel = new LPMediaModel();
                this.mySelfUserActiveModel.user = userModel;
                this.mySelfUserActiveModel.videoOn = this.router.getLiveRoom().isClassStarted();
                this.mySelfUserActiveModel.keepAlive = true;
                if (this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher) {
                    this.mySelfUserActiveModel.audioOn = this.router.getLiveRoom().isClassStarted();
                } else if (this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant) {
                    this.mySelfUserActiveModel.audioOn = false;
                } else {
                    boolean bl = this.mySelfUserActiveModel.audioOn = this.router.getLiveRoom().isClassStarted() && this.router.getLiveRoom().getPartnerConfig().liveStudentDefaultAudioOn == 1;
                }
                if (!this.isInitActiveUserComplete) {
                    return;
                }
            }
            if (this.mSpeakVideos.get(userModel.getUserId()) == null) {
                if (userModel.equals((Object)this.router.getLiveRoom().getCurrentUser())) {
                    this.mSpeakList.add((IMediaModel)this.mySelfUserActiveModel);
                    this.addVideo((IMediaModel)this.mySelfUserActiveModel, this.router.getLiveRoom().isClassStarted());
                } else {
                    LPMediaModel mediaModel = new LPMediaModel();
                    mediaModel.user = userModel;
                    mediaModel.audioOn = false;
                    mediaModel.videoOn = false;
                    mediaModel.keepAlive = true;
                    this.mSpeakList.add((IMediaModel)mediaModel);
                    this.addVideo((IMediaModel)mediaModel, this.router.getLiveRoom().isClassStarted());
                }
            }
            this.router.getLiveRoom().getOnlineUserVM().updateMediaState();
            this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getResources().getString(R.string.bjysc_seat_up_tips, new Object[]{UtilsKt.getEncodePhoneNumber((String)lpResRoomUserInModel.getUser().getName())}));
        });
        Disposable subscriptionOfDownFromSeatContainer = this.router.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserRemove().observeOn(AndroidSchedulers.mainThread()).subscribe(lpResRoomUserInModel -> {
            LPLogger.d((String)TAG, (String)("user_active_remove: " + lpResRoomUserInModel.getUser().getName()));
            IUserModel iUserModel = lpResRoomUserInModel.getUser();
            VideoContainerWindow videoContainerWindow = this.mSpeakVideos.get(lpResRoomUserInModel.getUser().getUserId());
            if (videoContainerWindow != null) {
                if (this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher) {
                    HashMap authPaintColors = this.router.getLiveRoom().getAuthPaintColor();
                    Map<String, String> cachePaintColors = this.router.getMapValueByKey(EventKey.CachePaintColorMap, String.class, String.class);
                    if (authPaintColors == null) {
                        authPaintColors = new HashMap();
                    }
                    for (String color2 : authPaintColors.keySet()) {
                        if (!((String)authPaintColors.get(color2)).equals(videoContainerWindow.getVideoWindow().getUserModel().getNumber())) continue;
                        cachePaintColors.put(color2, videoContainerWindow.getVideoWindow().getUserModel().getNumber());
                        this.router.setObjectByKey(EventKey.CachePaintColorMap, cachePaintColors);
                    }
                }
                videoContainerWindow.getVideoWindow().closeAV();
                this.removeVideo(videoContainerWindow.getMediaModel());
            }
            if (iUserModel.equals(this.router.getLiveRoom().getCurrentUser())) {
                this.mySelfUserActiveModel = null;
            }
            this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getResources().getString(R.string.bjysc_seat_down_tips, new Object[]{UtilsKt.getEncodePhoneNumber((String)lpResRoomUserInModel.getUser().getName())}));
        });
        Disposable userAddDenyDisposable = this.router.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserAddDeny().observeOn(AndroidSchedulers.mainThread()).subscribe(lpResRoomUserInModel -> this.onActiveUserDeny((LPResRoomUserInModel)lpResRoomUserInModel));
        Disposable playerViewUpdateDisposable = this.mLiveRoom.getMediaVM().getObservableOfPlayerViewUpdate().filter(viewUpdateModel -> viewUpdateModel.action != null && !this.mSpeakVideos.isEmpty()).observeOn(AndroidSchedulers.mainThread()).subscribe(viewUpdateModel -> {
            if (viewUpdateModel.action == LPConstants.LPPlayerAction.ADD) {
                VideoContainerWindow videoContainerWindow = this.mSpeakVideos.get(viewUpdateModel.id);
                if (null == videoContainerWindow) {
                    return;
                }
                videoContainerWindow.showPlaceholder();
                this.router.getSubjectByKey(EventKey.PlayerViewAdd).onNext((Object)new PlayerViewActionModel(videoContainerWindow.getMediaModel().getUser().getNumber(), videoContainerWindow.getVideoWindow(), LPPlayerViewUpdateModel.copy((LPPlayerViewUpdateModel)viewUpdateModel)));
            }
        });
        Disposable videoResumeButtonDisposable = this.router.getSubjectByKey(EventKey.ResumeButton).ofType(Boolean.class).observeOn(AndroidSchedulers.mainThread()).subscribe(isShowResumeButton -> {
            VideoContainerWindow teacherWindow;
            if (BaseUtilsKt.isTeacher((IUserModel)this.router.getLiveRoom().getCurrentUser()) && (teacherWindow = this.mSpeakVideos.get(this.mLiveRoom.getCurrentUser().getUserId())) != null) {
                if (isShowResumeButton.booleanValue()) {
                    teacherWindow.showResumeButton();
                } else {
                    teacherWindow.hideResumeButton();
                }
            }
        });
        this.compositeDisposable.add(playerViewUpdateDisposable);
        this.compositeDisposable.add(classStartDisposable);
        this.compositeDisposable.add(disposableOfUserMore);
        this.compositeDisposable.add(activeUsersDisposable);
        this.compositeDisposable.add(userInDisposable);
        this.compositeDisposable.add(userOutDisposable);
        this.compositeDisposable.add(mediaStateDisposable);
        this.compositeDisposable.add(groupInfoDisposable);
        this.compositeDisposable.add(speakApplyDisposable);
        this.compositeDisposable.add(speakResponseDisposable);
        this.compositeDisposable.add(speakApplyDenyDisposable);
        this.compositeDisposable.add(awardDisposable);
        this.compositeDisposable.add(micOnDisposable);
        this.compositeDisposable.add(drawAuthDisposable);
        this.compositeDisposable.add(playerViewRemoveDisposable);
        this.compositeDisposable.add(subscriptionOfUpToSeatContainer);
        this.compositeDisposable.add(subscriptionOfDownFromSeatContainer);
        this.compositeDisposable.add(userAddDenyDisposable);
        this.compositeDisposable.add(pptAuthDisposable);
        this.compositeDisposable.add(assistCameraDisposable);
        this.compositeDisposable.add(screenShareDisposable);
        this.compositeDisposable.add(videoResumeButtonDisposable);
    }

    protected boolean handsAutoAttachAudio() {
        return true;
    }

    protected void onActiveUserDeny(LPResRoomUserInModel lpResRoomUserInModel) {
        this.router.getSubjectByKey(EventKey.ReminderErrorMessage).onNext((Object)this.getContext().getString(R.string.bjy_group_seat_full_tip));
    }

    private void requestUpToSeat(List<IUserModel> iUserModels) {
        if (this.router.getLiveRoom().getCurrentUser().getType() != LPConstants.LPUserType.Teacher) {
            for (IUserModel user : iUserModels) {
                if (user.getType() != LPConstants.LPUserType.Teacher || this.mSpeakVideos.containsKey(user.getUserId())) continue;
                LPMediaModel mediaModel = new LPMediaModel();
                mediaModel.user = (LPUserModel)user;
                mediaModel.audioOn = false;
                mediaModel.videoOn = false;
                mediaModel.keepAlive = true;
                this.mSpeakList.add((IMediaModel)mediaModel);
                this.addVideo((IMediaModel)mediaModel, this.router.getLiveRoom().isClassStarted());
                break;
            }
            return;
        }
        if (!this.autoOnStage()) {
            return;
        }
        if (this.mSpeakVideos.size() > this.maxSpeakers) {
            return;
        }
        int userCount = iUserModels.size();
        int maxCount = Math.min(userCount, this.maxSpeakers) - this.mSpeakVideos.size() + 1;
        int count = 0;
        for (int i = 0; i < userCount; ++i) {
            IUserModel iUserModel = iUserModels.get(i);
            if (iUserModel.getType() != LPConstants.LPUserType.Student || this.mSpeakVideos.containsKey(iUserModel.getUserId()) || count > maxCount) continue;
            this.router.getLiveRoom().getOnlineUserVM().requestAddActiveUser(iUserModel);
            ++count;
            LPLogger.d((String)TAG, (String)("requestUpToSeat: " + iUserModel.getName()));
        }
    }

    protected boolean autoOnStage() {
        if (this.router.getLiveRoom().getMaxBackUpUsers() > 0) {
            return this.router.getLiveRoom().autoOnStage();
        }
        return true;
    }

    private void sendSyncPlayView(LPPlayerViewUpdateModel viewUpdateModel) {
        if (!this.mSpeakList.isEmpty()) {
            if (viewUpdateModel == null) {
                viewUpdateModel = new LPPlayerViewUpdateModel();
                viewUpdateModel.all = new HashSet();
            }
            Set allSet = viewUpdateModel.all;
            this.router.setObjectByKey(EventKey.AllPlayerViewList, allSet);
            if (viewUpdateModel.all.size() > 0) {
                for (LPPlayerViewUpdateModel.PlayerPosition playerPosition : viewUpdateModel.all) {
                    VideoContainerWindow videoContainerWindow;
                    if (this.getIUserModel(playerPosition.id) == null) continue;
                    if (this.mSpeakVideos.get(playerPosition.id) == null) {
                        IMediaModel model = this.getIUserModel(playerPosition.id);
                        this.addVideo(model, false);
                    }
                    if (null == (videoContainerWindow = this.mSpeakVideos.get(playerPosition.id)) || !this.isBoardLayout) continue;
                    LPPlayerViewUpdateModel lpPlayerViewUpdateModel = LPPlayerViewUpdateModel.copy((LPPlayerViewUpdateModel)viewUpdateModel);
                    lpPlayerViewUpdateModel.id = playerPosition.id;
                    videoContainerWindow.showPlaceholder();
                    this.router.getSubjectByKey(EventKey.PlayerViewAdd).onNext((Object)new PlayerViewActionModel(videoContainerWindow.getMediaModel().getUser().getNumber(), videoContainerWindow.getVideoWindow(), lpPlayerViewUpdateModel));
                }
            }
        }
    }

    private IMediaModel getIUserModel(String userId) {
        for (IMediaModel iMediaModel : this.mSpeakList) {
            if (!iMediaModel.getUser().getUserId().equals(userId)) continue;
            return iMediaModel;
        }
        return null;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int selfWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int selfHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(selfWidth, selfHeight);
        int childCount = this.mSpeakVideos.values().size();
        if (this.mLiveRoom.getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
            if (this.hasPlaceHolder && childCount < 2) {
                ++childCount;
            }
            int menuSize = UtilsKt.getDp((int)this.menu_size_1v1);
            int childWidth = selfWidth;
            int childHeight = this.mLiveRoom.enableVideoFillMode1v1() ? (int)((double)selfHeight * 3.0 / 8.0) : (int)((float)childWidth * this.videoRatio + (float)menuSize);
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)Integer.MIN_VALUE);
            int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)Integer.MIN_VALUE);
            for (int i = 0; i < childCount; ++i) {
                View childAt = this.getChildAt(i);
                childAt.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        } else {
            int childWidth;
            int childHeight;
            if (this.hasPlaceHolder) {
                ++childCount;
            }
            if (this.isBoardLayout) {
                int maxEqualWindow = 6;
                childHeight = selfHeight;
                childWidth = childCount <= maxEqualWindow ? (int)((float)childHeight / this.videoRatio) : selfWidth / childCount;
            } else {
                Object[] videoWindows;
                int showWindowCount = this.hasPlaceHolder ? 1 : 0;
                for (Object videoWindow : videoWindows = this.mSpeakVideos.values().toArray()) {
                    boolean hideDifferentGroup;
                    boolean isLocalVideo = ((VideoContainerWindow)videoWindow).getVideoWindow().isLocalVideo();
                    boolean isSameGroup = isLocalVideo || ((VideoContainerWindow)videoWindow).getMediaModel().getUser().getGroup() == this.router.getLiveRoom().getCurrentUser().getGroup();
                    boolean bl = hideDifferentGroup = !isSameGroup && this.router.getLiveRoom().getOnlineUserVM().isMediaGroup() && this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student;
                    if (hideDifferentGroup) continue;
                    ++showWindowCount;
                }
                if (showWindowCount == 0) {
                    childHeight = 0;
                    childWidth = 0;
                } else {
                    childWidth = selfWidth / LayoutUtils.getMaxNumPerLine(showWindowCount);
                    childHeight = selfHeight / LayoutUtils.getLineCount(showWindowCount);
                }
            }
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000);
            int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
            for (int i = 0; i < childCount; ++i) {
                View childAt = this.getChildAt(i);
                childAt.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        Object[] videoWindows = this.mSpeakVideos.values().toArray();
        int childCount = videoWindows.length;
        if (this.mLiveRoom.getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
            if (this.hasPlaceHolder && childCount < 2) {
                ++childCount;
            }
            int margin = UtilsKt.getDp((int)this.margin_1v1);
            if (this.isBoardLayout) {
                for (int i = 0; i < childCount; ++i) {
                    View childAt = this.getChildAt(i);
                    int childTop = top + i * childAt.getMeasuredHeight();
                    int childBottom = top + (i + 1) * childAt.getMeasuredHeight();
                    if (i != 0) {
                        childTop += margin;
                        childBottom += margin;
                    }
                    if (this.mLiveRoom.enableVideoFillMode1v1()) {
                        childAt.layout(left, childTop, right, childBottom);
                        int marginAdjust = (int)((double)childAt.getMeasuredHeight() * 1.0 / 3.0);
                        childAt.layout(left, childTop + marginAdjust, right, childBottom + marginAdjust);
                        continue;
                    }
                    childAt.layout(left, childTop, right, childBottom);
                }
            } else {
                block5: for (int i = 0; i < childCount; ++i) {
                    View childAt = this.getChildAt(i);
                    switch (childCount) {
                        case 1: {
                            childAt.layout(left, top + (this.getMeasuredHeight() - childAt.getMeasuredHeight()) / 2, right, bottom);
                            continue block5;
                        }
                        case 2: {
                            childAt.layout(left + right * i / 2, top + (this.getMeasuredHeight() - childAt.getMeasuredHeight()) / 2 + margin, right * (i + 1) / 2, bottom + margin);
                            continue block5;
                        }
                    }
                }
            }
        } else {
            int placeHolderCount = this.hasPlaceHolder ? 1 : 0;
            childCount = 0;
            for (Object videoWindow : videoWindows) {
                boolean showWindow;
                boolean isTeacherVideo = ((VideoContainerWindow)videoWindow).getMediaModel().getUser().getType() == LPConstants.LPUserType.Teacher || ((VideoContainerWindow)videoWindow).getMediaModel().getUser().getType() == LPConstants.LPUserType.Assistant;
                boolean isLocalVideo = ((VideoContainerWindow)videoWindow).getVideoWindow().isLocalVideo();
                boolean isSameGroup = isLocalVideo || ((VideoContainerWindow)videoWindow).getMediaModel().getUser().getGroup() == this.router.getLiveRoom().getCurrentUser().getGroup();
                boolean hideDifferentGroup = !isSameGroup && this.router.getLiveRoom().getOnlineUserVM().isMediaGroup() && this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student;
                boolean bl = showWindow = !this.disableOtherStudentVideo || isTeacherVideo || isLocalVideo || BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom()) || !this.isBoardLayout;
                if (!showWindow || hideDifferentGroup) continue;
                ++childCount;
            }
            childCount += placeHolderCount;
            int hasAddCount = 0;
            int hideWindowCount = 0;
            for (int i = 0; i < videoWindows.length + placeHolderCount; ++i) {
                int childBottom;
                int childTop;
                int childLeft;
                int childRight;
                View childAt = this.getChildAt(i);
                boolean disableOtherStudentVideo = false;
                boolean hideWindow = false;
                if (!this.hasPlaceHolder || i != 0) {
                    boolean isTeacherOrAssistantVideo = ((VideoContainerWindow)videoWindows[i - placeHolderCount]).getMediaModel().getUser().getType() == LPConstants.LPUserType.Teacher || ((VideoContainerWindow)videoWindows[i - placeHolderCount]).getMediaModel().getUser().getType() == LPConstants.LPUserType.Assistant;
                    boolean isLocalVideo = ((VideoContainerWindow)videoWindows[i - placeHolderCount]).getVideoWindow().isLocalVideo();
                    if (this.disableOtherStudentVideo && !isTeacherOrAssistantVideo && !isLocalVideo) {
                        disableOtherStudentVideo = true;
                    }
                    if (this.router.getLiveRoom().getOnlineUserVM().isMediaGroup() && this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student && ((VideoContainerWindow)videoWindows[i - placeHolderCount]).getMediaModel().getUser().getGroup() != this.router.getLiveRoom().getCurrentUser().getGroup()) {
                        hideWindow = true;
                    }
                }
                if (this.isBoardLayout) {
                    if (disableOtherStudentVideo || hideWindow) {
                        childRight = 0;
                        childLeft = 0;
                    } else {
                        childLeft = (this.getMeasuredWidth() - childAt.getMeasuredWidth() * childCount) / 2 + childAt.getMeasuredWidth() * hasAddCount++;
                        childRight = childLeft + childAt.getMeasuredWidth();
                    }
                    childTop = top;
                    childBottom = bottom;
                } else if (hideWindow) {
                    childRight = 0;
                    childLeft = 0;
                    childBottom = 0;
                    childTop = 0;
                    ++hideWindowCount;
                } else if (childCount == 0) {
                    childRight = 0;
                    childLeft = 0;
                    childBottom = 0;
                    childTop = 0;
                } else {
                    int maxNumPerLine = LayoutUtils.getMaxNumPerLine(childCount);
                    int nowLine = (i - hideWindowCount) / maxNumPerLine;
                    int itemHeight = (int)((double)this.getMeasuredHeight() / Math.ceil((double)childCount / (double)maxNumPerLine));
                    childTop = top + nowLine * itemHeight;
                    boolean isLastLine = (nowLine + 1) * maxNumPerLine >= childCount;
                    childBottom = childTop + itemHeight - (isLastLine ? 0 : 1);
                    int itemWidth = this.getMeasuredWidth() / maxNumPerLine;
                    int nowLineMaxNum = Math.min(childCount - maxNumPerLine * nowLine, maxNumPerLine);
                    int nowLineLeftOffset = (maxNumPerLine - nowLineMaxNum) * itemWidth / 2;
                    childLeft = nowLineLeftOffset + (i - hideWindowCount - maxNumPerLine * nowLine) * itemWidth;
                    boolean isLastItemInNowLine = (i - hideWindowCount + 1) / maxNumPerLine != nowLine;
                    childRight = childLeft + itemWidth - (isLastItemInNowLine ? 0 : 1);
                }
                childAt.layout(childLeft, childTop, childRight, childBottom);
            }
        }
        this.router.getSubjectByKey(EventKey.RepositionVideoMenu).onNext((Object)0);
    }

    public void addWindow(IWindow window) {
        VideoContainerWindow videoContainerWindow = (VideoContainerWindow)window;
        if (videoContainerWindow.getVideoWindow() != null) {
            videoContainerWindow.getVideoWindow().setOnlyInBlackboard(false);
        }
        if (videoContainerWindow.getMediaModel().getUser().getType() == LPConstants.LPUserType.Teacher) {
            this.removeEmptyView();
            this.addView(window.getView(), 0);
        } else if (videoContainerWindow.getMediaModel().getUser().getType() == LPConstants.LPUserType.Assistant) {
            if (this.router.getLiveRoom().getOnlineUserVM().enable1v1TeacherOffStage() && !this.router.getLiveRoom().getOnlineUserVM().isActiveUser(this.router.getLiveRoom().getTeacherUser())) {
                this.removeEmptyView();
                this.addView(window.getView(), 0);
                return;
            }
            int childCount = this.getChildCount();
            int index = -1;
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                Object tag = child.getTag();
                if (!(tag instanceof Boolean) || !((Boolean)tag).booleanValue()) continue;
                index = i;
                break;
            }
            if (index == -1) {
                this.addView(window.getView());
            } else {
                this.addView(window.getView(), index);
            }
        } else {
            View view = window.getView();
            view.setTag((Object)true);
            this.addView(view);
        }
    }

    private void awardUser(IUserModel userModel, String key) {
        String userNumber = userModel.getNumber();
        if (!this.router.getLiveRoom().isClassStarted()) {
            return;
        }
        LPAwardUserInfo userInfo = this.awardRecord.get(userNumber);
        if (userInfo == null) {
            Map<String, Integer> typeCount = this.getTypeCount();
            typeCount.put(key, 1);
            userInfo = new LPAwardUserInfo(1, typeCount);
        } else {
            Integer keyCount;
            ++userInfo.count;
            if (userInfo.typeCount == null) {
                userInfo.typeCount = this.getTypeCount();
            }
            if ((keyCount = (Integer)userInfo.typeCount.get(key)) == null) {
                userInfo.typeCount.put(key, 1);
            } else {
                userInfo.typeCount.put(key, keyCount + 1);
            }
        }
        userInfo.name = userModel.getName();
        this.awardRecord.put(userNumber, userInfo);
        this.router.getLiveRoom().getToolBoxVM().requestAward(userNumber, key, this.awardRecord);
    }

    private Map<String, Integer> getTypeCount() {
        LPAwardConfig[] awardConfigs;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (LPAwardConfig lpAwardConfig : awardConfigs = this.router.getLiveRoom().getToolBoxVM().getAwardConfigs()) {
            if (lpAwardConfig.isEnable != 1) continue;
            map.put(lpAwardConfig.key, 0);
        }
        return map;
    }

    protected void addVideo(IMediaModel iMediaModel, boolean isPlay) {
        LinkedHashMap<String, VideoContainerWindow> temp;
        if (iMediaModel == null || this.mSpeakVideos.containsKey(iMediaModel.getUser().getUserId())) {
            return;
        }
        IUserModel iUserModel = iMediaModel.getUser();
        VideoContainerWindow videoContainerWindow = new VideoContainerWindow(this.getContext(), VideoWindow.newInstance(this.getContext(), this.router), false);
        videoContainerWindow.initMediaModel(iMediaModel);
        videoContainerWindow.bindToSeat(this);
        videoContainerWindow.getVideoWindow().setAwardClickListener(this::awardUser);
        if (iUserModel.getType() == LPConstants.LPUserType.Teacher) {
            temp = new LinkedHashMap<String, VideoContainerWindow>(this.mSpeakVideos);
            this.mSpeakVideos.clear();
            this.mSpeakVideos.put(iUserModel.getUserId(), videoContainerWindow);
            this.mSpeakVideos.putAll(temp);
            LPLogger.d((String)TAG, (String)("addVideo: type= teacher..." + iUserModel.getName() + "...userId=" + iUserModel.getUserId() + "...videoOn=" + iMediaModel.isVideoOn() + "....audioOn=" + iMediaModel.isAudioOn()));
        } else {
            if (iUserModel.getType() == LPConstants.LPUserType.Assistant) {
                temp = new LinkedHashMap();
                boolean hasInsert = false;
                for (VideoContainerWindow videoWindow : this.mSpeakVideos.values()) {
                    if (!hasInsert && videoWindow.getMediaModel().getUser().getType() == LPConstants.LPUserType.Student) {
                        temp.put(iUserModel.getUserId(), videoContainerWindow);
                        hasInsert = true;
                    }
                    temp.put(videoWindow.getMediaModel().getUser().getUserId(), videoWindow);
                }
                if (!hasInsert) {
                    temp.put(iUserModel.getUserId(), videoContainerWindow);
                }
                this.mSpeakVideos.clear();
                this.mSpeakVideos.putAll(temp);
            } else {
                this.mSpeakVideos.put(iUserModel.getUserId(), videoContainerWindow);
            }
            if (this.drawingAuthList != null && this.drawingAuthList.contains(iUserModel.getNumber())) {
                videoContainerWindow.getVideoWindow().setDrawAuthOn(true);
            }
            if (this.pptAuthList != null && this.pptAuthList.contains(iUserModel.getNumber())) {
                videoContainerWindow.getVideoWindow().setPPTAuthOn(true);
            }
            if (this.assistCameraList != null && this.assistCameraList.contains(iUserModel.getNumber())) {
                videoContainerWindow.getVideoWindow().setAssistCameraOn(true);
            }
            if (this.screenShareList != null && this.screenShareList.contains(iUserModel.getNumber())) {
                videoContainerWindow.getVideoWindow().setScreenShareOn(true);
            }
            if (this.awardRecord.get(iUserModel.getNumber()) != null) {
                videoContainerWindow.getVideoWindow().setAwardCount(this.awardRecord.get((Object)iUserModel.getNumber()).count);
            }
            LPLogger.d((String)TAG, (String)("addVideo: type= student..." + iUserModel.getName() + "...userId=" + iUserModel.getUserId() + "...videoOn=" + iMediaModel.isVideoOn() + "....audioOn=" + iMediaModel.isAudioOn()));
        }
        this.addWindow((IWindow)videoContainerWindow);
        if (!isPlay) {
            if (videoContainerWindow.getVideoWindow().getEnablePullAudioOnly()) {
                videoContainerWindow.getVideoWindow().setVideoRemoteClose(1);
            }
            videoContainerWindow.getVideoWindow().setVideoOn(false);
            videoContainerWindow.getVideoWindow().setAudioOn(false);
        } else if (videoContainerWindow.getVideoWindow().isLocalVideo()) {
            this.mSpeakVideos.get(this.router.getLiveRoom().getCurrentUser().getUserId()).getVideoWindow().publishLocalStream(iMediaModel.isHandUp());
            LPLogger.d((String)TAG, (String)"addVideo: has permissions,publish......");
        } else {
            videoContainerWindow.getVideoWindow().changeVideoState(iMediaModel);
        }
        SparseArray groupMap = this.router.getLiveRoom().getOnlineUserVM().getGroupMap();
        LPGroupItem lpGroupItem = (LPGroupItem)groupMap.get(iUserModel.getGroup());
        if (lpGroupItem == null) {
            lpGroupItem = new LPGroupItem(0);
        }
        if (lpGroupItem.groupItemModel == null) {
            lpGroupItem.groupItemModel = new GroupItem(0);
        }
        if (lpGroupItem.id != 0) {
            videoContainerWindow.getVideoWindow().setGroupColor(lpGroupItem.groupItemModel.color, lpGroupItem.groupItemModel.id);
        }
        if (this.router.getLiveRoom().getOnlineUserVM().isMediaGroup()) {
            videoContainerWindow.getVideoWindow().setGroupItem(lpGroupItem.groupItemModel);
        }
    }

    protected void removeVideo(IMediaModel iMediaModel) {
        String uid = iMediaModel.getUser().getUserId();
        VideoContainerWindow videoContainerWindow = this.mSpeakVideos.get(uid);
        if (videoContainerWindow != null) {
            this.mSpeakList.remove(videoContainerWindow.getMediaModel());
            this.mSpeakVideos.remove(uid);
            videoContainerWindow.onDestroy();
            this.removeWindow((IWindow)videoContainerWindow);
            if (iMediaModel.getUser().getType() == LPConstants.LPUserType.Teacher && this.showTeacherPlaceholder()) {
                VideoContainerWindow containerWindow;
                IMediaModel model;
                boolean addEmptyView = true;
                if (!this.mSpeakList.isEmpty() && this.router.getLiveRoom().getOnlineUserVM().enable1v1TeacherOffStage() && (model = this.mSpeakList.get(0)).getUser().getType() == LPConstants.LPUserType.Assistant && (containerWindow = this.mSpeakVideos.get(model.getUser().getUserId())) != null) {
                    addEmptyView = false;
                }
                if (addEmptyView) {
                    this.addView(this.emptyView, 0, (ViewGroup.LayoutParams)this.emptyParams);
                    this.hasPlaceHolder = true;
                }
            }
        }
        this.router.getSubjectByKey(EventKey.HideVideoMenu).onNext((Object)iMediaModel.getUser());
    }

    private boolean hasPermissions(String[] permissions) {
        for (String permission2 : permissions) {
            if (ActivityCompat.checkSelfPermission((Context)this.getContext(), (String)permission2) == 0) continue;
            return false;
        }
        return true;
    }

    private void setGroup(List<LPGroupItem> groups) {
        HashMap<String, VideoContainerWindow> speakNums = new HashMap<String, VideoContainerWindow>();
        for (Map.Entry<String, VideoContainerWindow> entry : this.mSpeakVideos.entrySet()) {
            VideoContainerWindow videoContainerWindow = entry.getValue();
            speakNums.put(videoContainerWindow.getMediaModel().getUser().getNumber(), videoContainerWindow);
        }
        int count = 0;
        for (LPGroupItem lpGroupItem : groups) {
            count += lpGroupItem.count;
        }
        if (count == 0) {
            for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
                videoContainerWindow.getVideoWindow().setGroupItem(new GroupItem(0));
            }
            this.requestLayout();
            return;
        }
        for (LPGroupItem lpGroupItem : groups) {
            List userModelList = lpGroupItem.userModelList;
            for (LPUserModel lpUserModel : userModelList) {
                VideoContainerWindow videoContainerWindow;
                GroupItem groupItemModel;
                if (!speakNums.containsKey(lpUserModel.number) || (groupItemModel = lpGroupItem.groupItemModel) == null || (videoContainerWindow = (VideoContainerWindow)speakNums.remove(lpUserModel.number)) == null) continue;
                videoContainerWindow.getVideoWindow().setGroupColor(groupItemModel.color, groupItemModel.id);
                if (this.router.getLiveRoom().getOnlineUserVM().isMediaGroup()) {
                    videoContainerWindow.getVideoWindow().setGroupItem(groupItemModel);
                    continue;
                }
                if (groupItemModel.id != 0) continue;
                videoContainerWindow.getVideoWindow().setGroupItem(groupItemModel);
            }
        }
        for (VideoContainerWindow videoContainerWindow : speakNums.values()) {
            if (videoContainerWindow == null) continue;
            videoContainerWindow.getVideoWindow().setGroupItem(new GroupItem(0));
        }
        this.requestLayout();
    }

    private void cancelGroup() {
        for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
            videoContainerWindow.getVideoWindow().clearGroupColor();
        }
    }

    public void setVideoDragLayer(VideoDragLayer videoDragLayer) {
        this.videoDragLayer = videoDragLayer;
        this.videoDragLayer.setOnVideoResetListener((uid, videoWindow) -> {
            if (this.mSpeakVideos.containsKey(uid)) {
                this.mSpeakVideos.get(uid).backToSeat(videoWindow);
            }
        });
    }

    public VideoDragLayer getDragLayer() {
        return this.videoDragLayer;
    }

    public void switchLayoutMode(boolean isBoardLayout) {
        this.isBoardLayout = isBoardLayout;
        if (isBoardLayout) {
            if (this.router.getValueByKey(EventKey.AllPlayerViewList, Set.class) == null) {
                return;
            }
            HashSet<LPPlayerViewUpdateModel.PlayerPosition> playerPositionList = new HashSet<LPPlayerViewUpdateModel.PlayerPosition>(this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class));
            for (LPPlayerViewUpdateModel.PlayerPosition playerPosition : playerPositionList) {
                LPPlayerViewUpdateModel model = new LPPlayerViewUpdateModel();
                model.action = LPConstants.LPPlayerAction.ADD;
                model.all = playerPositionList;
                model.id = playerPosition.id;
                model.mediaId = playerPosition.mediaId;
                if (this.mSpeakVideos.isEmpty()) {
                    return;
                }
                VideoContainerWindow videoContainerWindow = this.mSpeakVideos.get(model.id);
                if (null == videoContainerWindow) continue;
                videoContainerWindow.showPlaceholder();
                this.router.getSubjectByKey(EventKey.PlayerViewAdd).onNext((Object)new PlayerViewActionModel(videoContainerWindow.getMediaModel().getUser().getNumber(), videoContainerWindow.getVideoWindow(), model));
            }
        }
        for (int i = 0; i < this.mSpeakVideos.size(); ++i) {
            View bgView = ((VideoContainerWindow)this.mSpeakVideos.values().toArray()[i]).getVideoWindow().getView();
            if (!(bgView.getLayoutParams() instanceof FrameLayout.LayoutParams)) continue;
            FrameLayout.LayoutParams bgParams = (FrameLayout.LayoutParams)bgView.getLayoutParams();
            if (isBoardLayout) {
                bgParams.setMargins(0, 0, 0, 0);
            } else {
                bgParams.setMargins(1, 1, 1, 1);
            }
            bgView.setLayoutParams((ViewGroup.LayoutParams)bgParams);
        }
    }

    public boolean isBoardLayout() {
        return this.isBoardLayout;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.clearSpeakVideo();
        if (this.awardRecord != null) {
            this.awardRecord.clear();
        }
        this.videoDragLayer = null;
        this.mLiveRoom = null;
    }

    private void clearSpeakVideo() {
        if (this.mSpeakVideos == null || this.mSpeakVideos.isEmpty()) {
            return;
        }
        for (VideoContainerWindow videoContainerWindow : this.mSpeakVideos.values()) {
            videoContainerWindow.onDestroy();
        }
        this.mSpeakVideos.clear();
    }

    public IUserModel getSpeakModelWithUserNumber(String userNumber) {
        if (this.router.getLiveRoom().getCurrentUser().getNumber().equals(userNumber)) {
            return this.router.getLiveRoom().getCurrentUser();
        }
        int count = this.mLiveRoom.getOnlineUserVM().getUserCount();
        for (int i = 0; i < count; ++i) {
            if (!userNumber.equals(this.mLiveRoom.getOnlineUserVM().getUser(i).getNumber())) continue;
            return this.mLiveRoom.getOnlineUserVM().getUser(i);
        }
        return null;
    }
}

