/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbox.smallblackboard;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.groupclassui.R;
import com.baijiayun.livebase.utils.ThemeDataUtil;

class SmallBlackboardDialog
extends RelativeLayout {
    private Button confirm;
    private Button cancel;
    private TextView content;

    SmallBlackboardDialog(Context context) {
        this(context, null);
    }

    SmallBlackboardDialog(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    SmallBlackboardDialog(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        Drawable drawable2 = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_window_bg_color)).cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).strokeWidth(UtilsKt.getDp((int)1)).strokeColor(ContextCompat.getColor((Context)context, (int)R.color.bjysc_bg_stroke_10)).build();
        RelativeLayout relativeLayout = new RelativeLayout(this.getContext());
        relativeLayout.setGravity(17);
        relativeLayout.setBackground(drawable2);
        this.content = new TextView(this.getContext());
        this.confirm = new Button(this.getContext());
        this.cancel = new Button(this.getContext());
        this.confirm.setText(R.string.bjysc_confirm);
        this.cancel.setText(R.string.bjysc_cancel);
        this.confirm.setTextSize(12.0f);
        this.cancel.setTextSize(12.0f);
        this.confirm.setGravity(17);
        this.confirm.setPadding(0, 0, 0, 0);
        this.cancel.setGravity(17);
        this.cancel.setPadding(0, 0, 0, 0);
        this.confirm.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_live_product_color)).cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        this.cancel.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_dialog_negative_bg_color)).cornerRadius(context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        this.content.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_window_main_text_color));
        this.confirm.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_dialog_positive_text_color));
        this.cancel.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_dialog_negative_text_color));
        this.content.setGravity(17);
        this.content.setId(View.generateViewId());
        relativeLayout.addView((View)this.content, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(0);
        RelativeLayout.LayoutParams cancelButtonLayout = new RelativeLayout.LayoutParams((int)this.getResources().getDimension(R.dimen.bjysc_sbb_dialog_btn_width), (int)this.getResources().getDimension(R.dimen.bjysc_sbb_dialog_btn_height));
        linearLayout.addView((View)this.cancel, (ViewGroup.LayoutParams)cancelButtonLayout);
        RelativeLayout.LayoutParams confirmButtonLayout = new RelativeLayout.LayoutParams((int)this.getResources().getDimension(R.dimen.bjysc_sbb_dialog_btn_width), (int)this.getResources().getDimension(R.dimen.bjysc_sbb_dialog_btn_height));
        confirmButtonLayout.leftMargin = UtilsKt.getDp((int)24);
        linearLayout.addView((View)this.confirm, (ViewGroup.LayoutParams)confirmButtonLayout);
        RelativeLayout.LayoutParams linearParam = new RelativeLayout.LayoutParams(-2, -2);
        linearParam.addRule(3, this.content.getId());
        linearParam.addRule(14);
        linearParam.topMargin = UtilsKt.getDp((int)16);
        relativeLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)linearParam);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)this.getResources().getDimension(R.dimen.bjysc_sbb_dialog_width), (int)this.getResources().getDimension(R.dimen.bjysc_sbb_dialog_height));
        layoutParams.addRule(13);
        this.addView((View)relativeLayout, (ViewGroup.LayoutParams)layoutParams);
    }

    SmallBlackboardDialog setContent(String s) {
        this.content.setText((CharSequence)s);
        return this;
    }

    SmallBlackboardDialog setOnConfirmClickListener(View.OnClickListener onClickListener) {
        this.confirm.setOnClickListener(onClickListener);
        return this;
    }

    SmallBlackboardDialog setOnCancelClickListener(View.OnClickListener onClickListener) {
        this.cancel.setOnClickListener(onClickListener);
        return this;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return true;
    }
}

