/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.coursewaremanage;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.ListPopupWindow;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.query.QueryPlus;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.util.FECompatUtil;
import com.baijiayun.groupclassui.util.InteractiveUtils;
import com.baijiayun.groupclassui.window.BaseTitledWindow;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.models.LPPlayerViewUpdateModel;
import com.baijiayun.livecore.models.courseware.LPMediaCoursewareModel;
import com.baijiayun.livecore.wrapper.LPPlayer;
import com.baijiayun.livecore.wrapper.impl.LPVideoView;
import com.baijiayun.livecore.wrapper.listener.LPPlayerListener;
import com.baijiayun.livecore.wrapper.listener.LPRTMPPlayerListener;
import com.baijiayun.liveuibase.base.BaseWindow;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MediaCoursewarePlayerWindow
extends BaseTitledWindow {
    private static LoopType LOOP_TYPE = LoopType.LOOP_IN_ORDER;
    private View emptyView;
    private RecyclerView playerListRv;
    private TextView playTimeTv;
    private TextView rateTv;
    private LPMediaCoursewareModel currentMediaCourseware;
    private LPVideoView videoView;
    private ImageView playIv;
    private ImageView loopIv;
    private ImageView menuIv;
    private SeekBar seekBar;
    private List<LPMediaCoursewareModel> mediaCoursewareModelList = new ArrayList<LPMediaCoursewareModel>();
    private Disposable disposableOfInterval;
    private LPPlayer player;
    private boolean isShowPlayList;
    private int selectedItemPosition = -1;
    private float playRate = 1.0f;
    private boolean isPlaying;
    private int currentTime;
    private LPRTMPPlayerListener rtmpPlayerListener;
    private CoursewareListAdapter coursewareListAdapter;
    private boolean showTopBottomMenu = true;

    public MediaCoursewarePlayerWindow(Context context, LPMediaCoursewareModel playMedia) {
        super(context);
        this.currentMediaCourseware = playMedia;
        this.mediaCoursewareModelList.add(this.currentMediaCourseware);
        this.hideContentMask();
        this.setCanScale(false);
        this.initView();
        this.dragScaleRelativeLayout.setCanScaleOrDrag(false);
    }

    @Override
    protected void onCreateTopView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_media_player_top, (ViewGroup)this.rlTitleContainer);
    }

    @Override
    protected void onCreateContentView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_media_player_content, (ViewGroup)this.rlContentContainer);
    }

    @Override
    protected void onCreateFooterView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_media_player_footer, (ViewGroup)this.rlFooterContainer);
    }

    @Override
    protected void initTopTitleView() {
        super.initTopTitleView();
        this.ivMaxSync.setOnClickListener(l -> {
            this.isReceiveOrder = false;
            if (this.isMinInSync) {
                this.resetMinInSync();
            } else if (this.isMaxInSync) {
                this.resetInSync();
            } else {
                this.maxInSync();
            }
        });
        this.minIv = (ImageView)this.dragScaleRelativeLayout.findViewById(R.id.window_titled_min_in_sync_layer);
        this.minIv.setOnClickListener(v -> this.minInSync());
    }

    @Override
    public void minInSync() {
        this.ivMaxFull.setVisibility(8);
        this.ivMaxSync.setVisibility(0);
        this.setOnSingleTapListener(null);
        super.minInSync();
    }

    @Override
    public void resetMinInSync() {
        this.ivMaxFull.setVisibility(0);
        this.setOnSingleTapListener(this.getSingleTapListener());
        super.resetMinInSync();
    }

    private void initView() {
        this.player = this.iRouter.getLiveRoom().getPlayer();
        this.title(this.getString(R.string.bjy_group_media_courseware_player));
        this.setEmptyViewVisibility(this.mediaCoursewareModelList.isEmpty());
        this.playerListRv = (RecyclerView)this.$.id(R.id.media_player_list_rv).view();
        this.videoView = (LPVideoView)this.$.id(R.id.media_player_videoView).view();
        this.playIv = (ImageView)this.$.id(R.id.media_player_play_btn).view();
        this.playTimeTv = (TextView)this.$.id(R.id.media_player_time_tv).view();
        this.rateTv = (TextView)this.$.id(R.id.media_player_rate_tv).view();
        this.loopIv = (ImageView)this.$.id(R.id.media_player_loop_iv).view();
        this.menuIv = (ImageView)this.$.id(R.id.media_player_menu_iv).view();
        this.seekBar = (SeekBar)this.$.id(R.id.media_player_seekbar).view();
        this.playerListRv.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.context, 1));
        this.playerListRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
        this.coursewareListAdapter = new CoursewareListAdapter();
        this.playerListRv.setAdapter((RecyclerView.Adapter)this.coursewareListAdapter);
        switch (LOOP_TYPE) {
            case NO_LOOP: {
                this.loopIv.setImageResource(R.drawable.bjy_group_ic_media_player_no_loop);
                break;
            }
            case LOOP_SELF: {
                this.loopIv.setImageResource(R.drawable.bjy_group_ic_media_player_loop_one);
                break;
            }
            case LOOP_IN_ORDER: {
                this.loopIv.setImageResource(R.drawable.bjy_group_ic_media_player_loop_in_order);
            }
        }
        this.initListener();
        this.startPlay();
    }

    private BaseWindow.OnSingleTapListener getSingleTapListener() {
        return event -> {
            this.showTopBottomMenu = !this.showTopBottomMenu;
            this.rlTitleContainer.setVisibility(this.showTopBottomMenu ? 0 : 8);
            this.rlFooterContainer.setVisibility(this.showTopBottomMenu ? 0 : 8);
            if (!this.showTopBottomMenu) {
                this.playerListRv.setVisibility(8);
            }
        };
    }

    private void initListener() {
        this.setOnWindowRepositionListener(new BaseWindow.OnWindowRepositionListener(){

            public void onWindowMove(int x, int y) {
                MediaCoursewarePlayerWindow.this.iRouter.getSubjectByKey(EventKey.MoveVideoWindow).onNext((Object)MediaCoursewarePlayerWindow.this.getPlayerPosition());
            }

            public void OnWindowScale(int newWidth, int newHeight) {
                MediaCoursewarePlayerWindow.this.iRouter.getSubjectByKey(EventKey.MoveVideoWindow).onNext((Object)MediaCoursewarePlayerWindow.this.getPlayerPosition());
            }
        });
        this.setOnSingleTapListener(this.getSingleTapListener());
        this.rtmpPlayerListener = new LPRTMPPlayerListener(){

            public void onPlayComplete(String mediaId) {
                MediaCoursewarePlayerWindow.this.isPlaying = false;
                int duration = MediaCoursewarePlayerWindow.this.player.getDurationOfRtmpStream(mediaId);
                MediaCoursewarePlayerWindow.this.playTimeTv.setText((CharSequence)MediaCoursewarePlayerWindow.this.context.getString(R.string.bjy_group_media_time, new Object[]{InteractiveUtils.formatDuration(duration), InteractiveUtils.formatDuration(duration)}));
                MediaCoursewarePlayerWindow.this.seekBar.setProgress(duration);
                RxUtils.dispose((Disposable)MediaCoursewarePlayerWindow.this.disposableOfInterval);
                switch (LOOP_TYPE) {
                    case NO_LOOP: {
                        MediaCoursewarePlayerWindow.this.setEmptyViewVisibility(true);
                        MediaCoursewarePlayerWindow.this.seekBar.setProgress(0);
                        MediaCoursewarePlayerWindow.this.playIv.setVisibility(8);
                        MediaCoursewarePlayerWindow.this.playTimeTv.setVisibility(8);
                        MediaCoursewarePlayerWindow.this.coursewareListAdapter.notifyItemChanged(MediaCoursewarePlayerWindow.this.selectedItemPosition);
                        MediaCoursewarePlayerWindow.this.selectedItemPosition = -1;
                        MediaCoursewarePlayerWindow.this.iRouter.getLiveRoom().getMediaVM().sendBroadcastOfCloudVideoStatus(((MediaCoursewarePlayerWindow)MediaCoursewarePlayerWindow.this).currentMediaCourseware.videoInfo.fid, LPConstants.LPCloudVideoStatus.NOT_PLAY);
                        break;
                    }
                    case LOOP_SELF: {
                        MediaCoursewarePlayerWindow.this.iRouter.getLiveRoom().getMediaVM().sendBroadcastOfCloudVideoStatus(((MediaCoursewarePlayerWindow)MediaCoursewarePlayerWindow.this).currentMediaCourseware.videoInfo.fid, LPConstants.LPCloudVideoStatus.NOT_PLAY);
                        MediaCoursewarePlayerWindow.this.startPlay();
                        break;
                    }
                    case LOOP_IN_ORDER: {
                        if (MediaCoursewarePlayerWindow.this.mediaCoursewareModelList.size() == 1) {
                            MediaCoursewarePlayerWindow.this.iRouter.getLiveRoom().getMediaVM().sendBroadcastOfCloudVideoStatus(((MediaCoursewarePlayerWindow)MediaCoursewarePlayerWindow.this).currentMediaCourseware.videoInfo.fid, LPConstants.LPCloudVideoStatus.NOT_PLAY);
                        }
                        int nextIndex = MediaCoursewarePlayerWindow.this.getNextMediaId(((MediaCoursewarePlayerWindow)MediaCoursewarePlayerWindow.this).currentMediaCourseware.videoInfo.fid);
                        MediaCoursewarePlayerWindow.this.coursewareListAdapter.notifyItemChanged(MediaCoursewarePlayerWindow.this.selectedItemPosition);
                        MediaCoursewarePlayerWindow.this.selectedItemPosition = nextIndex;
                        MediaCoursewarePlayerWindow.this.coursewareListAdapter.notifyItemChanged(MediaCoursewarePlayerWindow.this.selectedItemPosition);
                        MediaCoursewarePlayerWindow.this.currentMediaCourseware = (LPMediaCoursewareModel)MediaCoursewarePlayerWindow.this.mediaCoursewareModelList.get(nextIndex);
                        MediaCoursewarePlayerWindow.this.startPlay();
                    }
                }
            }

            public void onBufferingUpdate(String mediaId, int percent) {
            }

            public void onSeekComplete(String mediaId) {
            }

            public void onReadyToPlay(String mediaId) {
                MediaCoursewarePlayerWindow.this.isPlaying = true;
                MediaCoursewarePlayerWindow.this.startInterval();
            }
        };
        this.player.addPlayerListener((LPPlayerListener)this.rtmpPlayerListener);
        this.playIv.setOnClickListener(v -> {
            if (this.isPlaying) {
                RxUtils.dispose((Disposable)this.disposableOfInterval);
                this.player.pauseRtmpStream(this.currentMediaCourseware.videoInfo.fid);
                this.iRouter.getLiveRoom().getMediaVM().sendBroadcastOfCloudVideoStatus(this.currentMediaCourseware.videoInfo.fid, LPConstants.LPCloudVideoStatus.PAUSE);
                this.playIv.setImageResource(R.drawable.bjy_group_ic_media_player_play);
            } else {
                this.player.resumeRtmpStream(this.currentMediaCourseware.videoInfo.fid);
                this.startInterval();
                this.iRouter.getLiveRoom().getMediaVM().sendBroadcastOfCloudVideoStatus(this.currentMediaCourseware.videoInfo.fid, LPConstants.LPCloudVideoStatus.PLAYING);
                this.playIv.setImageResource(R.drawable.bjy_group_ic_media_player_pause);
            }
            this.isPlaying = !this.isPlaying;
        });
        this.ivClose.setOnClickListener(v -> {
            this.mediaCoursewareModelList.clear();
            if (this.isMaxInFull) {
                this.resetInFull();
            }
            this.iRouter.getSubjectByKey(EventKey.closeMediaPlayerWindow).onNext((Object)true);
        });
        this.rateTv.setOnClickListener(v -> {
            ListPopupWindow listPopupWindow = new ListPopupWindow(this.context);
            List<String> rateList = Arrays.asList("0.75x", "1.00x", "1.25x", "1.50x", "2.00x");
            listPopupWindow.setAdapter((ListAdapter)new ArrayAdapter(this.context, R.layout.bjy_group_media_player_rate_item_layout, rateList));
            listPopupWindow.setWidth(UtilsKt.getDp((int)80));
            listPopupWindow.setHeight(-2);
            listPopupWindow.setAnchorView((View)this.rateTv);
            listPopupWindow.setHorizontalOffset(-(UtilsKt.getDp((int)80) - this.rateTv.getMeasuredWidth()) / 2);
            listPopupWindow.setVerticalOffset(-UtilsKt.getDp((int)6));
            listPopupWindow.setModal(true);
            listPopupWindow.setOnItemClickListener((parent, view, position, id2) -> {
                this.rateTv.setText((CharSequence)rateList.get(position));
                switch (position) {
                    case 0: {
                        this.playRate = 0.75f;
                        this.player.setRateOfRtmpStream(this.currentMediaCourseware.videoInfo.fid, 0.75f);
                        break;
                    }
                    case 1: {
                        this.playRate = 1.0f;
                        this.rateTv.setText((CharSequence)this.context.getString(R.string.bjy_group_media_rate));
                        this.player.setRateOfRtmpStream(this.currentMediaCourseware.videoInfo.fid, 1.0f);
                        break;
                    }
                    case 2: {
                        this.playRate = 1.25f;
                        this.player.setRateOfRtmpStream(this.currentMediaCourseware.videoInfo.fid, 1.25f);
                        break;
                    }
                    case 3: {
                        this.playRate = 1.5f;
                        this.player.setRateOfRtmpStream(this.currentMediaCourseware.videoInfo.fid, 1.5f);
                        break;
                    }
                    case 4: {
                        this.playRate = 2.0f;
                        this.player.setRateOfRtmpStream(this.currentMediaCourseware.videoInfo.fid, 2.0f);
                        break;
                    }
                }
                this.iRouter.getLiveRoom().getMediaVM().sendBroadcastOfCloudVideoSpeed(this.currentMediaCourseware.videoInfo.fid, this.playRate);
                listPopupWindow.dismiss();
            });
            listPopupWindow.show();
        });
        this.loopIv.setOnClickListener(v -> {
            PopupWindow popupWindow = new PopupWindow(this.context);
            View contentView = LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_group_media_player_loop_layout, null);
            QueryPlus $ = QueryPlus.with((View)contentView);
            $.id(R.id.bjy_group_player_no_loop_ll).clicked(view -> {
                LOOP_TYPE = LoopType.NO_LOOP;
                this.loopIv.setImageResource(R.drawable.bjy_group_ic_media_player_no_loop);
                popupWindow.dismiss();
            }).id(R.id.bjy_group_player_loop_in_order_ll).clicked(view -> {
                LOOP_TYPE = LoopType.LOOP_IN_ORDER;
                this.loopIv.setImageResource(R.drawable.bjy_group_ic_media_player_loop_in_order);
                popupWindow.dismiss();
            }).id(R.id.bjy_group_player_loop_ll).clicked(view -> {
                LOOP_TYPE = LoopType.LOOP_SELF;
                this.loopIv.setImageResource(R.drawable.bjy_group_ic_media_player_loop_one);
                popupWindow.dismiss();
            });
            int[] viewSize = DisplayUtils.getUnDisplayViewSize((View)contentView);
            popupWindow.setContentView(contentView);
            popupWindow.setWidth(-2);
            popupWindow.setHeight(-2);
            popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            popupWindow.setOutsideTouchable(true);
            popupWindow.setFocusable(true);
            popupWindow.showAsDropDown((View)this.loopIv, -(viewSize[0] - this.loopIv.getMeasuredWidth()) / 2, -viewSize[1] - this.loopIv.getMeasuredHeight() - UtilsKt.getDp((int)8));
        });
        this.menuIv.setOnClickListener(v -> {
            this.isShowPlayList = !this.isShowPlayList;
            this.playerListRv.setVisibility(this.isShowPlayList ? 0 : 8);
        });
        this.seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                MediaCoursewarePlayerWindow.this.player.seekRtmpStream(((MediaCoursewarePlayerWindow)MediaCoursewarePlayerWindow.this).currentMediaCourseware.videoInfo.fid, seekBar.getProgress());
                MediaCoursewarePlayerWindow.this.iRouter.getLiveRoom().getMediaVM().sendBroadcastOfCloudVideoTime(((MediaCoursewarePlayerWindow)MediaCoursewarePlayerWindow.this).currentMediaCourseware.videoInfo.fid, seekBar.getProgress());
                if (!MediaCoursewarePlayerWindow.this.isPlaying) {
                    MediaCoursewarePlayerWindow.this.player.resumeRtmpStream(((MediaCoursewarePlayerWindow)MediaCoursewarePlayerWindow.this).currentMediaCourseware.videoInfo.fid);
                    MediaCoursewarePlayerWindow.this.startInterval();
                }
            }
        });
    }

    public void startPlay(LPMediaCoursewareModel mediaCoursewareModel) {
        int index = this.mediaCoursewareModelList.indexOf(mediaCoursewareModel);
        if (index == -1) {
            this.mediaCoursewareModelList.add(mediaCoursewareModel);
            this.coursewareListAdapter.notifyItemChanged(this.selectedItemPosition);
            this.selectedItemPosition = this.mediaCoursewareModelList.size() - 1;
            this.coursewareListAdapter.notifyItemInserted(this.selectedItemPosition);
        } else {
            this.coursewareListAdapter.notifyItemChanged(this.selectedItemPosition);
            this.selectedItemPosition = index;
            this.coursewareListAdapter.notifyItemChanged(this.selectedItemPosition);
        }
        this.pause();
        this.currentMediaCourseware = mediaCoursewareModel;
        this.startPlay();
    }

    private void startPlay() {
        if (this.currentMediaCourseware != null) {
            this.setEmptyViewVisibility(false);
            this.playIv.setVisibility(0);
            this.playTimeTv.setVisibility(0);
            this.player.playVideoOfRtmpStream(this.currentMediaCourseware.videoInfo.fid, this.videoView);
            this.player.setRateOfRtmpStream(this.currentMediaCourseware.videoInfo.fid, this.playRate);
            this.iRouter.getLiveRoom().getMediaVM().sendBroadcastOfCloudVideoStatus(this.currentMediaCourseware.videoInfo.fid, LPConstants.LPCloudVideoStatus.PLAYING);
            this.iRouter.getLiveRoom().getMediaVM().sendBroadcastOfCloudVideoSpeed(this.currentMediaCourseware.videoInfo.fid, this.playRate);
            this.playIv.setImageResource(R.drawable.bjy_group_ic_media_player_pause);
            this.isPlaying = true;
        }
    }

    private void startInterval() {
        RxUtils.dispose((Disposable)this.disposableOfInterval);
        this.disposableOfInterval = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            this.currentTime = this.player.getCurrentPositionOfRtmpStream(this.currentMediaCourseware.videoInfo.fid);
            int duration = this.player.getDurationOfRtmpStream(this.currentMediaCourseware.videoInfo.fid);
            this.playTimeTv.setText((CharSequence)this.context.getString(R.string.bjy_group_media_time, new Object[]{InteractiveUtils.formatDuration(this.currentTime), InteractiveUtils.formatDuration(duration)}));
            this.seekBar.setProgress(this.currentTime);
            this.seekBar.setMax(duration);
            this.iRouter.getLiveRoom().getMediaVM().sendBroadcastOfCloudVideoTime(this.currentMediaCourseware.videoInfo.fid, this.currentTime);
        });
    }

    private void setEmptyViewVisibility(boolean visible) {
        if (visible) {
            if (this.emptyView == null) {
                ViewStub viewStub = (ViewStub)this.$.id(R.id.media_player_empty_viewStub).view();
                this.emptyView = viewStub.inflate();
            } else {
                this.emptyView.setVisibility(0);
            }
        } else if (this.emptyView != null) {
            this.emptyView.setVisibility(8);
        }
    }

    private int getNextMediaId(String mediaId) {
        for (int i = 0; i < this.mediaCoursewareModelList.size(); ++i) {
            if (!mediaId.equals(this.mediaCoursewareModelList.get((int)i).videoInfo.fid)) continue;
            return (i + 1) % this.mediaCoursewareModelList.size();
        }
        return 0;
    }

    @Override
    public LPPlayerViewUpdateModel.PlayerPosition getPlayerPosition() {
        LPPlayerViewUpdateModel.PlayerPosition playerPosition = super.getPlayerPosition();
        playerPosition.id = playerPosition.mediaId = FECompatUtil.getIOSMediaIdFromMediaId(FECompatUtil.getMediaId(this.iRouter.getLiveRoom().getCurrentUser().getUserId(), LPConstants.MediaSourceType.Media.getValue()));
        return playerPosition;
    }

    public void pause() {
        if (this.currentMediaCourseware != null) {
            this.iRouter.getLiveRoom().getPlayer().stopRtmpStream(this.currentMediaCourseware.videoInfo.fid);
            this.iRouter.getLiveRoom().getMediaVM().sendBroadcastOfCloudVideoStatus(this.currentMediaCourseware.videoInfo.fid, LPConstants.LPCloudVideoStatus.NOT_PLAY);
            RxUtils.dispose((Disposable)this.disposableOfInterval);
        }
        this.currentMediaCourseware = null;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.pause();
        this.player.removePlayerListener((LPPlayerListener)this.rtmpPlayerListener);
    }

    class CoursewareListAdapter
    extends RecyclerView.Adapter<PlayerItemViewHolder> {
        CoursewareListAdapter() {
        }

        @NonNull
        public PlayerItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            return new PlayerItemViewHolder(LayoutInflater.from((Context)MediaCoursewarePlayerWindow.this.context).inflate(R.layout.bjy_group_media_player_list_item_layout, parent, false));
        }

        public void onBindViewHolder(@NonNull PlayerItemViewHolder holder, int position) {
            holder.itemTv.setText((CharSequence)((LPMediaCoursewareModel)((MediaCoursewarePlayerWindow)MediaCoursewarePlayerWindow.this).mediaCoursewareModelList.get((int)position)).name);
            if (MediaCoursewarePlayerWindow.this.selectedItemPosition == position) {
                holder.itemView.setBackground((Drawable)new ColorDrawable(MediaCoursewarePlayerWindow.this.context.getResources().getColor(R.color.base_item_foreground_color)));
            } else {
                holder.itemView.setBackground(null);
            }
            holder.itemView.setOnClickListener(v -> {
                holder.itemView.setBackground((Drawable)new ColorDrawable(MediaCoursewarePlayerWindow.this.context.getResources().getColor(R.color.base_item_foreground_color)));
                this.notifyItemChanged(MediaCoursewarePlayerWindow.this.selectedItemPosition);
                MediaCoursewarePlayerWindow.this.selectedItemPosition = holder.getAdapterPosition();
                this.notifyItemChanged(MediaCoursewarePlayerWindow.this.selectedItemPosition);
                if (MediaCoursewarePlayerWindow.this.currentMediaCourseware != null) {
                    MediaCoursewarePlayerWindow.this.player.stopRtmpStream(((MediaCoursewarePlayerWindow)MediaCoursewarePlayerWindow.this).currentMediaCourseware.videoInfo.fid);
                }
                MediaCoursewarePlayerWindow.this.currentMediaCourseware = (LPMediaCoursewareModel)MediaCoursewarePlayerWindow.this.mediaCoursewareModelList.get(position);
                MediaCoursewarePlayerWindow.this.startPlay();
            });
        }

        public int getItemCount() {
            return MediaCoursewarePlayerWindow.this.mediaCoursewareModelList.size();
        }

        class PlayerItemViewHolder
        extends RecyclerView.ViewHolder {
            TextView itemTv;

            public PlayerItemViewHolder(View itemView) {
                super(itemView);
                this.itemTv = (TextView)itemView.findViewById(R.id.bjy_group_player_item_tv);
            }
        }
    }

    private static enum LoopType {
        NO_LOOP,
        LOOP_IN_ORDER,
        LOOP_SELF;

    }
}

