/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import com.baijiayun.groupclassui.R;
import java.util.List;

public class AutoScrollAdapter
extends BaseAdapter
implements AbsListView.OnScrollListener,
View.OnTouchListener {
    private Context context;
    private AbsListView listView;
    private List<String> dataList;
    private OnAutoScrollListener onAutoScrollListener;
    private int maxNum = 5;
    private int nowFirstPosition;
    private float normalTextSize;
    private float selectTextSize;
    @ColorInt
    private int normalTextColor;
    @ColorInt
    private int selectTextColor;
    private int listViewVisibleHeight;
    private int itemHeight;
    private int listViewPaddingTop;
    private static final int MIN_SCROLL_NUM = 30;
    private int targetFirstPosition = -1;
    private double remainLength = 0.0;
    private boolean isMakeUpDeviation = false;

    private AutoScrollAdapter(Context context) {
        this.context = context;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public static AutoScrollAdapter initListView(AbsListView listView, Context context) {
        AutoScrollAdapter autoScrollAdapter = new AutoScrollAdapter(context);
        listView.setOnTouchListener((View.OnTouchListener)autoScrollAdapter);
        listView.setOnScrollListener((AbsListView.OnScrollListener)autoScrollAdapter);
        listView.setAdapter((ListAdapter)autoScrollAdapter);
        autoScrollAdapter.listViewPaddingTop = listView.getPaddingTop();
        autoScrollAdapter.initParams(listView.getLayoutParams().height - listView.getPaddingTop() - listView.getPaddingBottom());
        autoScrollAdapter.nowFirstPosition = 0x3FFFFFFF;
        listView.setSelection(autoScrollAdapter.nowFirstPosition);
        autoScrollAdapter.listView = listView;
        autoScrollAdapter.normalTextSize = context.getResources().getDimensionPixelSize(R.dimen.bjysc_random_select_normal_text_size);
        autoScrollAdapter.selectTextSize = context.getResources().getDimensionPixelSize(R.dimen.bjysc_random_select_select_text_size);
        return autoScrollAdapter;
    }

    private void initParams(int listViewVisibleHeight) {
        this.listViewVisibleHeight = listViewVisibleHeight;
        this.itemHeight = listViewVisibleHeight / this.maxNum;
    }

    public void initValues(List<String> dataList) {
        this.dataList = dataList;
        this.notifyDataSetChanged();
    }

    public void setMaxNum(int maxNum) {
        this.maxNum = maxNum;
        this.initParams(this.listViewVisibleHeight);
        this.listView.setSelection(this.nowFirstPosition);
    }

    public void setTextColor(@ColorInt int normalTextColor, @ColorInt int selectTextColor) {
        this.normalTextColor = normalTextColor;
        this.selectTextColor = selectTextColor;
    }

    public void updateSelect(int targetPosition) {
        if (this.remainLength != 0.0) {
            return;
        }
        int targetOffset = targetPosition - this.maxNum / 2;
        int now2targetOffset = (targetOffset - this.nowFirstPosition % this.dataList.size() + this.dataList.size()) % this.dataList.size();
        int minRemainDistance = 30 - now2targetOffset;
        int remainDistance = (minRemainDistance / this.dataList.size() + 1) * this.dataList.size();
        this.targetFirstPosition = this.nowFirstPosition + remainDistance + now2targetOffset;
        this.remainLength = (remainDistance + now2targetOffset) * (this.itemHeight + 1);
        this.startScrollStep();
    }

    public void setOnAutoScrollListener(OnAutoScrollListener onAutoScrollListener) {
        this.onAutoScrollListener = onAutoScrollListener;
    }

    private void startScrollStep() {
        int length = (this.isMakeUpDeviation ? 1 : (int)Math.ceil(Math.min(Math.abs(this.remainLength) / 20.0, (double)this.itemHeight / 2.0))) * (this.remainLength > 0.0 ? 1 : -1);
        this.listView.scrollListBy(length);
        this.remainLength -= (double)length;
        this.listView.postDelayed(() -> {
            if (Math.abs(this.remainLength) > 1.0) {
                this.startScrollStep();
            } else {
                if (this.checkCalcDeviation()) {
                    this.startScrollStep();
                    return;
                }
                this.listView.setSelection(this.targetFirstPosition);
                this.targetFirstPosition = -1;
                if (this.onAutoScrollListener != null) {
                    this.onAutoScrollListener.onStateIdle();
                }
            }
        }, 10L);
    }

    private boolean checkCalcDeviation() {
        if (this.listView == null || this.listView.getChildAt(0) == null) {
            return false;
        }
        double calcDeviation = 0.0;
        if (this.listView.getFirstVisiblePosition() > this.targetFirstPosition) {
            calcDeviation = this.listView.getTop() > this.listView.getChildAt(0).getTop() ? (double)(this.listView.getChildAt(0).getTop() - this.listView.getTop()) : (double)this.itemHeight;
        } else if (this.listView.getFirstVisiblePosition() == this.targetFirstPosition) {
            if (this.listView.getTop() > this.listView.getChildAt(0).getTop()) {
                calcDeviation = this.listView.getChildAt(0).getTop() - this.listView.getTop();
            }
        } else {
            calcDeviation = this.itemHeight - (this.listView.getTop() - this.listView.getChildAt(0).getTop());
        }
        this.remainLength = calcDeviation;
        this.isMakeUpDeviation = calcDeviation != 0.0;
        return this.isMakeUpDeviation;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View v, MotionEvent event) {
        return event.getAction() == 2;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (view.getChildAt(0) == null) {
            return;
        }
        int selectPosition = view.getTop() + this.listViewPaddingTop + this.maxNum / 2 * this.itemHeight;
        int newTopPosition = 0;
        for (int i = 0; i < visibleItemCount; ++i) {
            View item = view.getChildAt(i);
            if (item == null) {
                return;
            }
            int itemPosition = item.getTop();
            double normal2selRatio = ((double)this.itemHeight - (double)Math.min(Math.abs(itemPosition - selectPosition), this.itemHeight)) / (double)this.itemHeight;
            if (normal2selRatio < 0.5) {
                newTopPosition = firstVisibleItem;
            }
            double textSize = (double)this.normalTextSize + (double)(this.selectTextSize - this.normalTextSize) * normal2selRatio;
            Object viewHolder = item.getTag();
            if (!(viewHolder instanceof ViewHolder)) continue;
            ((ViewHolder)viewHolder).tvName.setTextSize(0, (float)textSize);
            ((ViewHolder)viewHolder).tvName.setTextColor(normal2selRatio < 0.5 ? this.normalTextColor : this.selectTextColor);
            if (newTopPosition == this.nowFirstPosition) continue;
            this.nowFirstPosition = newTopPosition;
            ((ViewHolder)viewHolder).tvName.requestLayout();
        }
    }

    public int getCount() {
        return Integer.MAX_VALUE;
    }

    public Object getItem(int position) {
        return this.dataList.get(position % this.dataList.size());
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        if (convertView == null) {
            convertView = View.inflate((Context)this.context, (int)R.layout.bjysc_auto_scroll_item, null);
            viewHolder = new ViewHolder();
            viewHolder.tvName = (TextView)convertView.findViewById(R.id.bjysc_auto_scroll_item_name);
            convertView.setTag((Object)viewHolder);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)viewHolder.tvName.getLayoutParams();
            params.height = this.itemHeight;
            viewHolder.tvName.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
        }
        viewHolder.tvName.setText((CharSequence)this.dataList.get(position % this.dataList.size()));
        viewHolder.tvName.setTextSize(this.normalTextSize);
        viewHolder.tvName.setTextColor(this.normalTextColor);
        return convertView;
    }

    static class ViewHolder {
        TextView tvName;

        ViewHolder() {
        }
    }

    public static interface OnAutoScrollListener {
        public void onStateIdle();
    }
}

