/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.user;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiahulian.common.cropperv2.uikit.CircleColorView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.load.Transformation;
import com.baijiayun.glide.load.resource.bitmap.CircleCrop;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventCode;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.global.RouterListener;
import com.baijiayun.groupclassui.user.IUserInteractionListener;
import com.baijiayun.groupclassui.user.OnlineUserPresenter;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPGroupItem;

public class HandsUpUserListFragment
extends Fragment
implements IUserInteractionListener {
    private RecyclerView recyclerView;
    private OnlineUserPresenter userPresenter;
    private HandsUpUserListRecyclerViewAdapter handsUpAdapter;
    private LinearLayout showForbidHandsUp;
    private TextView btnForbidHandsUp;
    private boolean isForbidHandUp = false;
    private IRouter iRouter;
    private final String[] color = new String[]{"#FF607D", "#BE21E9", "#35CD3B", "#EE87FF", "#775FCF", "#AB8678", "#3D5AFE", "#03A9F4", "#C3FFA6", "#F44336", "#7ED321", "#FB9D3E", "#795548", "#FFEB3B", "#FFAE8E", "#E91E63"};

    public static HandsUpUserListFragment newInstance() {
        return new HandsUpUserListFragment();
    }

    private void setPresenter(OnlineUserPresenter onlineUserPresenter) {
        this.userPresenter = onlineUserPresenter;
        this.userPresenter.setRouter(this.iRouter);
        this.userPresenter.subscribe();
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof RouterListener) {
            this.iRouter = ((RouterListener)context).getRouter();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container2, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.bjysc_fragment_handup, container2, false);
        Context context = view.getContext();
        this.recyclerView = (RecyclerView)view.findViewById(R.id.bjysc_hands_up_list);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.setPresenter(new OnlineUserPresenter(this));
        this.handsUpAdapter = new HandsUpUserListRecyclerViewAdapter();
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.handsUpAdapter);
        this.showForbidHandsUp = (LinearLayout)view.findViewById(R.id.bjysc_show_forbid_handsUp);
        this.btnForbidHandsUp = (TextView)view.findViewById(R.id.bjysc_btn_handUp);
        this.btnForbidHandsUp.setOnClickListener(v -> this.userPresenter.requestForbidRaiseHand(!this.isForbidHandUp));
        if (this.userPresenter != null) {
            this.userPresenter.getForbidRaiseHandUp();
        }
        return view;
    }

    void agreeSpeakApply(IUserModel requestUser) {
        this.userPresenter.agreeSpeakApply(requestUser);
    }

    void disagreeSpeakApply(String userId) {
        this.userPresenter.disagreeSpeakApply(userId);
    }

    public void notifyDataChange() {
        this.handsUpAdapter.notifyDataSetChanged();
    }

    @Override
    public void notifyOnlineUserDataSetChange() {
    }

    @Override
    public void notifyOnlineUserCountChange() {
    }

    @Override
    public void notifyHandsUpUserDataSetChange() {
        this.notifyDataChange();
    }

    @Override
    public void notifyActiveUserDataChange() {
    }

    @Override
    public void notifySpeakApplyResult() {
    }

    @Override
    public void notifyForbidStatus() {
    }

    @Override
    public void notifyUserDataChange() {
    }

    @Override
    public void notifyForbidHandUp(boolean isForbid) {
        if (this.getActivity() == null || this.getContext() == null) {
            return;
        }
        Drawable drawable2 = isForbid ? ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_not_forbid_hand_up) : ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_forbid_hand_up);
        this.getActivity().runOnUiThread(() -> {
            this.isForbidHandUp = isForbid;
            if (isForbid) {
                this.recyclerView.setVisibility(8);
                this.showForbidHandsUp.setVisibility(8);
                this.btnForbidHandsUp.setText((CharSequence)this.getString(R.string.bjysc_un_forbid_hands_up));
                this.btnForbidHandsUp.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_live_product_color));
            } else {
                this.showForbidHandsUp.setVisibility(8);
                this.recyclerView.setVisibility(0);
                this.btnForbidHandsUp.setText((CharSequence)this.getString(R.string.bjysc_forbid_hands_up));
                this.btnForbidHandsUp.setTextColor(this.getResources().getColor(R.color.bjysc_red));
            }
            if (drawable2 != null) {
                drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
                this.btnForbidHandsUp.setCompoundDrawables(drawable2, null, null, null);
            }
        });
    }

    @Override
    public void notifyCurrentSeatFull() {
        if (this.iRouter != null) {
            this.iRouter.getPublishSubjectByKey(EventCode.NotifyCurrentSeatFull).onNext((Object)true);
        }
    }

    @Override
    public void showBlockedUserFreeAllUI() {
    }

    @Override
    public void notifyStudyRoomSwitch() {
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.userPresenter != null) {
            this.userPresenter.destroy();
        }
    }

    class HandsUpUserListRecyclerViewAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        HandsUpUserListRecyclerViewAdapter() {
        }

        @NonNull
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
            View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_hands_up_user, viewGroup, false);
            return new ViewHolder(view);
        }

        public void onBindViewHolder(@NonNull ViewHolder viewHolder, int i) {
            IUserModel userModel = HandsUpUserListFragment.this.userPresenter.getHandsUpUser(i);
            if (userModel == null) {
                return;
            }
            viewHolder.userNameTv.setText((CharSequence)UtilsKt.getEncodePhoneNumber((String)userModel.getName()));
            if (!TextUtils.isEmpty((CharSequence)userModel.getAvatar()) && HandsUpUserListFragment.this.getContext() != null) {
                Glide.with((Context)HandsUpUserListFragment.this.getContext()).load(userModel.getAvatar()).apply(new RequestOptions().transform((Transformation)new CircleCrop())).into(viewHolder.userAvatarIv);
            }
            viewHolder.handsUpIv.setOnClickListener(v -> HandsUpUserListFragment.this.agreeSpeakApply(userModel));
            viewHolder.disagreeHandsUpIv.setOnClickListener(v -> HandsUpUserListFragment.this.disagreeSpeakApply(userModel.getUserId()));
            if (userModel.getGroup() == 0) {
                viewHolder.groupContainer.setVisibility(8);
            } else {
                viewHolder.groupContainer.setVisibility(0);
                LPGroupItem groupItem = HandsUpUserListFragment.this.userPresenter.getGroupItem(userModel.getGroup());
                if (groupItem != null && groupItem.groupItemModel != null) {
                    viewHolder.groupNameTv.setText((CharSequence)groupItem.groupItemModel.name);
                    if (TextUtils.isEmpty((CharSequence)groupItem.groupItemModel.color)) {
                        viewHolder.groupColorView.setColor(Color.parseColor((String)HandsUpUserListFragment.this.color[(groupItem.id - 1) % 16]));
                    } else {
                        viewHolder.groupColorView.setColor(Color.parseColor((String)groupItem.groupItemModel.color));
                    }
                }
            }
        }

        public int getItemCount() {
            return HandsUpUserListFragment.this.userPresenter.getHandsUpUserCount();
        }

        class ViewHolder
        extends RecyclerView.ViewHolder {
            ImageView userAvatarIv;
            TextView userNameTv;
            ImageView handsUpIv;
            ImageView disagreeHandsUpIv;
            View groupContainer;
            TextView groupNameTv;
            CircleColorView groupColorView;

            ViewHolder(View itemView) {
                super(itemView);
                this.userAvatarIv = (ImageView)itemView.findViewById(R.id.user_avatar_iv);
                this.userNameTv = (TextView)itemView.findViewById(R.id.tv_user_name);
                this.handsUpIv = (ImageView)itemView.findViewById(R.id.agree_hand_up_iv);
                this.disagreeHandsUpIv = (ImageView)itemView.findViewById(R.id.disagree_hand_up_iv);
                this.groupContainer = itemView.findViewById(R.id.ll_group_container);
                this.groupNameTv = (TextView)itemView.findViewById(R.id.tv_group_name);
                this.groupColorView = (CircleColorView)itemView.findViewById(R.id.view_group_color);
            }
        }
    }
}

