/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.studyreport;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.studyreport.StudyReportActivity;
import com.baijiayun.livecore.models.LPStudyReportModel;
import com.baijiayun.livecore.utils.LPRecyclerItemClickSupport;
import java.util.List;

public class StudyReportListDialog
extends Dialog {
    private Context context;
    private View view;
    private ReportItemClickListener listener;
    private ImageView closeDialogIv;
    private RecyclerView reportStudentListRv;
    private ReportStudnetListAdapter adapter;
    private int mWidth = -1;
    private int mHeight = -2;

    public StudyReportListDialog(@NonNull Context context, ReportItemClickListener listener) {
        super(context);
        this.context = context;
        this.adapter = new ReportStudnetListAdapter();
        this.listener = listener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setBackgroundDrawableResource(17170445);
        this.getWindow().setGravity(80);
        this.getWindow().setWindowAnimations(R.style.BJYGroupShareAnimation);
        LayoutInflater inflater = ((StudyReportActivity)this.context).getLayoutInflater();
        this.view = inflater.inflate(R.layout.dialog_share_user_list_group_class, null);
        this.setContentView(this.view);
        this.getWindow().setLayout(this.mWidth, this.mHeight);
        this.initView();
    }

    private void initView() {
        this.closeDialogIv = (ImageView)this.findViewById(R.id.iv_gc_user_list_cancle);
        this.reportStudentListRv = (RecyclerView)this.findViewById(R.id.rl_gc_user_list);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.context);
        this.reportStudentListRv.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.reportStudentListRv.setAdapter((RecyclerView.Adapter)this.adapter);
        LPRecyclerItemClickSupport.addTo((RecyclerView)this.reportStudentListRv).setOnItemClickListener((recyclerView, position, v) -> {
            if (this.adapter == null || this.adapter.getItemCount() <= 0 || this.listener == null) {
                this.dismiss();
                return;
            }
            LPStudyReportModel studyReportModel = this.adapter.list.get(position);
            if (!studyReportModel.userNumber.equals(this.adapter.currentStudyReport.userNumber)) {
                this.adapter.currentStudyReport = studyReportModel;
                this.listener.onLoad(studyReportModel);
            }
            this.dismiss();
        });
        this.closeDialogIv.setOnClickListener(v -> this.dismiss());
    }

    public void setLayout(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.getWindow().setLayout(width, height);
    }

    public StudyReportListDialog setCurrReportItem(LPStudyReportModel studyReportModel) {
        this.adapter.currentStudyReport = studyReportModel;
        return this;
    }

    public StudyReportListDialog setAllReport(List<LPStudyReportModel> list) {
        this.adapter.list = list.isEmpty() ? null : list;
        return this;
    }

    public void show() {
        super.show();
        this.adapter.notifyDataSetChanged();
    }

    public static interface ReportItemClickListener {
        public void onLoad(LPStudyReportModel var1);
    }

    public static class ReportStudentViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout reportStudentRl;
        private ImageView reportStateIv;
        private TextView reportStudentNameTv;

        public ReportStudentViewHolder(@NonNull View itemView) {
            super(itemView);
            this.reportStudentRl = (RelativeLayout)itemView.findViewById(R.id.rl_gc_item_user_list);
            this.reportStateIv = (ImageView)itemView.findViewById(R.id.iv_gc_item_user_list_state);
            this.reportStudentNameTv = (TextView)itemView.findViewById(R.id.tv_gc_item_user_list_title);
        }
    }

    public class ReportStudnetListAdapter
    extends RecyclerView.Adapter<ReportStudentViewHolder> {
        public LPStudyReportModel currentStudyReport;
        public List<LPStudyReportModel> list;

        @NonNull
        public ReportStudentViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_gc_share_user_list, parent, false);
            return new ReportStudentViewHolder(view);
        }

        public void onBindViewHolder(@NonNull ReportStudentViewHolder viewHolder, int position) {
            LPStudyReportModel model = this.list.get(position);
            if (model.userNumber.equals(this.currentStudyReport.userNumber)) {
                viewHolder.reportStudentRl.setBackgroundColor(Color.parseColor((String)"#FFF6FBFF"));
                viewHolder.reportStateIv.setVisibility(0);
            } else {
                viewHolder.reportStudentRl.setBackgroundColor(-1);
                viewHolder.reportStateIv.setVisibility(4);
            }
            viewHolder.reportStudentNameTv.setText((CharSequence)model.userName);
        }

        public int getItemCount() {
            if (this.list.isEmpty()) {
                return 0;
            }
            return this.list.size();
        }
    }
}

