/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.video;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventCode;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.util.KUtilsKt;
import com.baijiayun.groupclassui.window.video.VideoWindow;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.widgets.dialog.NoteDialog;
import com.baijiayun.livecore.listener.OnCountDownListener;
import com.baijiayun.livecore.models.LPStudyRoomTutorModel;
import com.baijiayun.livecore.models.imodels.IMediaModel;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class StudyVideoWindow
extends VideoWindow {
    private boolean isLeave = false;
    private long selfStudyDuration = 0L;
    private Disposable disposableOfStudyRoomSwitch;
    private Disposable disposableOfPublishDefaultStream;
    private Disposable disposableOfStudyRank;
    private Disposable disposableOfActiveUserStatus;
    private Disposable disposableOfTutorApplyReq;
    private Disposable disposableOfTutorApplyRes;
    private Disposable disposableOfTutorStart;
    private Disposable disposableOfTutorEnd;
    private Disposable disposableOfTutorGroup;
    private Disposable disposableOfForHelp;
    private Disposable disposableOfUserAdd;
    private Disposable disposableOfUserRemove;
    private Disposable disposableOfDurationTimer;
    private TextView tvTutorAgree;
    private TextView tvTutorDisagree;
    private ImageView ivTutorHelp;
    private boolean isWaitingHelp = false;
    private boolean isTutorHelping = false;
    private boolean isSelfTutor = false;
    private LPStudyRoomTutorModel lpStudyRoomTutorModel;
    private static final int TUTOR_HELP_WAITING_DURATION = 30;

    protected StudyVideoWindow(Context context) {
        super(context);
        if (this.enableSingleTutor()) {
            this.initSingleTutorViews();
        }
    }

    private void initSingleTutorViews() {
        this.tvTutorAgree = (TextView)this.$.id(R.id.window_video_tutor_agree).view();
        this.tvTutorDisagree = (TextView)this.$.id(R.id.window_video_tutor_disagree).view();
        this.ivTutorHelp = (ImageView)this.$.id(R.id.window_video_tutor_help_him).view();
        this.ivTutorHelp.setOnClickListener(v -> {
            this.showTutorHandleIcon(true);
            this.showTutorHelpIcon(false);
        });
        this.tvTutorAgree.setOnClickListener(v -> {
            this.showTutorHandleIcon(false);
            this.iRouter.getLiveRoom().getStudyRoomVM().agreeTutorApply(this.getUserId());
        });
        this.tvTutorDisagree.setOnClickListener(v -> {
            this.showTutorHandleIcon(false);
            this.iRouter.getLiveRoom().getStudyRoomVM().disagreeTutorApply(this.getUserId());
        });
        this.$.id(R.id.window_video_tutor_help).clicked(v -> {
            if (this.isWaitingHelp) {
                this.endForHelp();
            } else {
                this.startForHelp();
            }
        });
        this.$.id(R.id.window_video_tutor_help_waiting).background(new DrawableBuilder().cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).solidColor(0x66000000).build());
        this.$.id(R.id.cl_top_left_tutor).background(new DrawableBuilder().cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).solidColor(-57527).build());
        this.$.id(R.id.window_tutor_close).clicked(v -> this.endTutorHelp());
    }

    private boolean enableSingleTutor() {
        return this.iRouter != null && this.iRouter.getLiveRoom().getStudyRoomVM().enableSingleTutor();
    }

    @Override
    public void setMediaModel(IMediaModel iMediaModel) {
        super.setMediaModel(iMediaModel);
        this.initStudyStatus(iMediaModel);
        RxUtils.dispose((Disposable)this.disposableOfStudyRoomSwitch);
        RxUtils.dispose((Disposable)this.disposableOfPublishDefaultStream);
        RxUtils.dispose((Disposable)this.disposableOfStudyRank);
        RxUtils.dispose((Disposable)this.disposableOfActiveUserStatus);
        RxUtils.dispose((Disposable)this.disposableOfTutorApplyReq);
        RxUtils.dispose((Disposable)this.disposableOfTutorApplyRes);
        RxUtils.dispose((Disposable)this.disposableOfTutorStart);
        RxUtils.dispose((Disposable)this.disposableOfTutorEnd);
        RxUtils.dispose((Disposable)this.disposableOfTutorGroup);
        RxUtils.dispose((Disposable)this.disposableOfForHelp);
        RxUtils.dispose((Disposable)this.disposableOfUserAdd);
        RxUtils.dispose((Disposable)this.disposableOfUserRemove);
        this.disposableOfStudyRoomSwitch = this.iRouter.getSubjectByKey(EventKey.StudyRoomSwitch).ofType(LPConstants.StudyRoomMode.class).doOnNext(studyRoomMode -> {
            if (this.isLocalVideo() && !this.isLeave) {
                this.detachAVideo();
                this.publishLocalStream();
                this.changePlaceholderState(this.ivPlaceholder.getVisibility() != 0);
            }
        }).subscribe(studyRoomMode -> this.updateUserStatus((LPConstants.StudyRoomMode)studyRoomMode, false));
        this.disposableOfPublishDefaultStream = this.iRouter.getPublishSubjectByKey(EventCode.PublishDefaultStream).observeOn(AndroidSchedulers.mainThread()).filter(o -> this.isLocalVideo()).subscribe(o -> this.publishLocalStream());
        this.disposableOfActiveUserStatus = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfActiveUserStatus().observeOn(AndroidSchedulers.mainThread()).flatMap(Observable::fromIterable).filter(lpStudyUserStatus -> TextUtils.equals((CharSequence)lpStudyUserStatus.userNumber, (CharSequence)iMediaModel.getUser().getNumber())).subscribe(lpStudyUserStatus -> {
            if (!this.isAdminWindow()) {
                this.isLeave = lpStudyUserStatus.isLeave == 1 || lpStudyUserStatus.isHangUp == 1;
            }
            this.isTutorHelping = lpStudyUserStatus.isTutor == 1;
            this.selfStudyDuration = lpStudyUserStatus.duration;
            this.updateUserStatus(this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode(), true);
        });
        BehaviorSubject subjectByKey = this.iRouter.getSubjectByKey(EventKey.StudyRankList);
        this.disposableOfStudyRank = subjectByKey.flatMap(Observable::fromIterable).filter(lpStudyUserStatus -> TextUtils.equals((CharSequence)lpStudyUserStatus.userNumber, (CharSequence)iMediaModel.getUser().getNumber())).observeOn(AndroidSchedulers.mainThread()).subscribe(lpStudyUserStatus -> {
            ImageView imageView = (ImageView)this.$.id(R.id.window_study_rank).view();
            int visibility = this.$.id(R.id.cl_top_left).view().getVisibility();
            imageView.setVisibility(lpStudyUserStatus.rank <= 3 && this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout() && iMediaModel.getUser().getType() == LPConstants.LPUserType.Student && visibility == 0 ? 0 : 8);
            switch (lpStudyUserStatus.rank) {
                case 1: {
                    imageView.setImageResource(R.drawable.uibase_ic_study_rank_1);
                    break;
                }
                case 2: {
                    imageView.setImageResource(R.drawable.uibase_ic_study_rank_2);
                    break;
                }
                case 3: {
                    imageView.setImageResource(R.drawable.uibase_ic_study_rank_3);
                    break;
                }
                default: {
                    imageView.setVisibility(8);
                }
            }
        });
        this.disposableOfTutorApplyReq = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfStuTutorApply().filter(lpStudyRoomTutorModel -> TextUtils.equals((CharSequence)lpStudyRoomTutorModel.to, (CharSequence)this.iRouter.getLiveRoom().getCurrentUser().getUserId())).filter(lpStudyRoomTutorModel -> TextUtils.equals((CharSequence)lpStudyRoomTutorModel.from, (CharSequence)this.getUserId())).observeOn(AndroidSchedulers.mainThread()).subscribe(lpStudyRoomTutorModel -> this.showTutorHelpIcon(true));
        this.disposableOfTutorApplyRes = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfTutorApplyResponse().filter(this::isTargetVideoWindow).observeOn(AndroidSchedulers.mainThread()).subscribe(lpStudyRoomTutorModel -> {
            if (lpStudyRoomTutorModel.tutorState == 0 && !this.isAdmin() && this.isLocalVideo() && !TextUtils.equals((CharSequence)lpStudyRoomTutorModel.from, (CharSequence)this.iRouter.getLiveRoom().getCurrentUser().getUserId())) {
                this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getString(R.string.bjysc_study_room_for_help_deny));
            }
            if (this.isAdmin()) {
                this.showTutorHelpIcon(false);
                this.showTutorHandleIcon(false);
            } else {
                this.showEndForHelp();
            }
        });
        this.disposableOfTutorStart = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfStudyRoomTutorStart().observeOn(AndroidSchedulers.mainThread()).subscribe(this::handleTutorHelpStart);
        this.disposableOfTutorEnd = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfStudyRoomTutorEnd().observeOn(AndroidSchedulers.mainThread()).subscribe(this::handleTutorHelpEnd);
        this.disposableOfTutorGroup = this.iRouter.getLiveRoom().getStudyRoomVM().getObservableOfStudyRoomTutorGroup().flatMap(Observable::fromIterable).observeOn(AndroidSchedulers.mainThread()).subscribe(this::handleTutorHelpStart);
        this.disposableOfForHelp = this.iRouter.getSubjectByKey(EventKey.StudyStatusForHelping).ofType(Boolean.class).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                if (!this.isWaitingHelp) {
                    this.hideStuTutorHelpBtn();
                }
            } else {
                this.showStuTutorHelpBtn();
            }
        });
        this.disposableOfUserAdd = this.iRouter.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserAdd().filter(lpResRoomUserInModel -> this.isAdminWindow()).filter(lpResRoomUserInModel -> TextUtils.equals((CharSequence)lpResRoomUserInModel.getUser().getUserId(), (CharSequence)this.iRouter.getLiveRoom().getCurrentUser().getUserId())).observeOn(AndroidSchedulers.mainThread()).subscribe(lpResRoomUserInModel -> this.showStuTutorHelpBtn());
        this.disposableOfUserRemove = this.iRouter.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserRemove().filter(lpResRoomUserInModel -> this.isAdminWindow()).filter(lpResRoomUserInModel -> TextUtils.equals((CharSequence)lpResRoomUserInModel.getUser().getUserId(), (CharSequence)this.iRouter.getLiveRoom().getCurrentUser().getUserId())).observeOn(AndroidSchedulers.mainThread()).subscribe(lpResRoomUserInModel -> this.showStuTutorHelpBtn());
        this.disposables.add(this.disposableOfTutorStart);
        this.disposables.add(this.disposableOfTutorEnd);
        this.disposables.add(this.disposableOfTutorGroup);
        this.disposables.add(this.disposableOfTutorApplyRes);
        this.disposables.add(this.disposableOfTutorApplyReq);
        this.disposables.add(this.disposableOfStudyRoomSwitch);
        this.disposables.add(this.disposableOfStudyRank);
        this.disposables.add(this.disposableOfPublishDefaultStream);
        this.disposables.add(this.disposableOfActiveUserStatus);
        this.disposables.add(this.disposableOfForHelp);
        this.disposables.add(this.disposableOfUserAdd);
        this.disposables.add(this.disposableOfUserRemove);
    }

    private boolean isTargetVideoWindow(LPStudyRoomTutorModel lpStudyRoomTutorModel) {
        if (lpStudyRoomTutorModel == null) {
            return false;
        }
        return TextUtils.equals((CharSequence)this.getUserId(), (CharSequence)lpStudyRoomTutorModel.from) || TextUtils.equals((CharSequence)this.getUserId(), (CharSequence)lpStudyRoomTutorModel.to);
    }

    private boolean isSelfSingleTutorHelping(LPStudyRoomTutorModel lpStudyRoomTutorModel) {
        if (lpStudyRoomTutorModel == null) {
            return false;
        }
        String selfId = this.iRouter.getLiveRoom().getCurrentUser().getUserId();
        return TextUtils.equals((CharSequence)selfId, (CharSequence)lpStudyRoomTutorModel.from) || TextUtils.equals((CharSequence)selfId, (CharSequence)lpStudyRoomTutorModel.to);
    }

    @Override
    public boolean isSelfSingleTutorHelping() {
        return this.isSelfSingleTutorHelping(this.lpStudyRoomTutorModel);
    }

    @Override
    public boolean isSingleTutorHelping() {
        return this.isTutorHelping;
    }

    private void handleTutorHelpStart(LPStudyRoomTutorModel lpStudyRoomTutorModel) {
        boolean isTargetVideoWindow = this.isTargetVideoWindow(lpStudyRoomTutorModel);
        if (isTargetVideoWindow) {
            this.lpStudyRoomTutorModel = lpStudyRoomTutorModel;
            this.isTutorHelping = true;
            if (this.isLocalVideo() && !this.isSelfTutor) {
                this.isSelfTutor = true;
                this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getString(R.string.bjysc_study_room_tutor_enter));
                this.iRouter.getPublishSubjectByKey(EventCode.AttachVideo).onNext((Object)true);
                this.iRouter.getPublishSubjectByKey(EventCode.AttachAudio).onNext((Object)true);
            }
        }
        if (!this.isSelfSingleTutorHelping(lpStudyRoomTutorModel)) {
            if (isTargetVideoWindow) {
                this.showTutorPlaceholder();
                this.closeRemoteStreaming();
            }
        } else {
            this.iRouter.getSubjectByKey(EventKey.StudyStatusTutor).onNext((Object)lpStudyRoomTutorModel.tutorId);
            if (!isTargetVideoWindow) {
                this.showTutorPlaceholder();
                this.closeRemoteStreaming();
            }
        }
        this.showLabelChange();
    }

    private void showLabelChange() {
        this.showStuTutorHelpBtn();
        this.showUserLabel();
        this.showLeftLabelContainer(this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode());
    }

    private void showTutorPlaceholder() {
        if (this.isTutorHelping) {
            this.ivPlaceholder.setImageResource(R.drawable.base_ic_video_tutoring);
            this.$.id(R.id.tv_video_placeholder).text(R.string.bjysc_study_room_tutor_helping);
            this.$.id(R.id.tv_video_placeholder).visible();
        } else {
            this.ivPlaceholder.setImageResource(R.drawable.base_ic_video_studying);
            this.$.id(R.id.tv_video_placeholder).text(R.string.bjysc_study_room_tutor_studying);
            this.$.id(R.id.tv_video_placeholder).visible();
        }
        this.ivPlaceholderOnlyAudio.setVisibility(8);
        this.ivPlaceholder.setVisibility(0);
    }

    private void handleTutorHelpEnd(LPStudyRoomTutorModel lpStudyRoomTutorModel) {
        String tutorId;
        if (this.isLocalVideo() && this.lpStudyRoomTutorModel != null && TextUtils.equals((CharSequence)lpStudyRoomTutorModel.tutorId, (CharSequence)this.lpStudyRoomTutorModel.tutorId)) {
            this.detachAVideo();
            this.iRouter.getPublishSubjectByKey(EventCode.PublishDefaultStream).onNext((Object)true);
            this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getString(R.string.bjysc_study_room_tutor_exit));
            this.isSelfTutor = false;
        }
        if (TextUtils.equals((CharSequence)lpStudyRoomTutorModel.tutorId, (CharSequence)(tutorId = this.getSelfTutorId()))) {
            this.iRouter.getSubjectByKey(EventKey.StudyStatusTutor).onNext((Object)"");
            if (this.lpStudyRoomTutorModel != null && TextUtils.equals((CharSequence)lpStudyRoomTutorModel.tutorId, (CharSequence)this.lpStudyRoomTutorModel.tutorId)) {
                this.lpStudyRoomTutorModel = null;
                this.isTutorHelping = false;
            } else if (!this.isTutorHelping) {
                this.openRemoteStreaming();
                this.lpStudyRoomTutorModel = null;
            }
        } else {
            if (this.lpStudyRoomTutorModel != null && TextUtils.equals((CharSequence)lpStudyRoomTutorModel.tutorId, (CharSequence)this.lpStudyRoomTutorModel.tutorId)) {
                this.isTutorHelping = false;
            }
            if (TextUtils.isEmpty((CharSequence)tutorId) && !this.isTutorHelping) {
                this.openRemoteStreaming();
                this.lpStudyRoomTutorModel = null;
            }
        }
        this.showLabelChange();
    }

    private void closeRemoteStreaming() {
        if (this.isLocalVideo()) {
            return;
        }
        this.remoteVideoStatus = 4;
        this.placeHolderContainer.setVisibility(0);
        this.videoView.setVisibility(8);
        this.ivPlaceholderOnlyAudio.setVisibility(8);
        this.stopStreaming(this.getMediaId());
    }

    private void openRemoteStreaming() {
        if (this.isLocalVideo()) {
            return;
        }
        this.remoteVideoStatus = 2;
        this.placeHolderContainer.setVisibility(8);
        this.ivPlaceholderOnlyAudio.setVisibility(8);
        this.videoView.setVisibility(0);
        this.stopStreaming(this.getMediaId());
        this.streamVideo(this.getMediaId());
    }

    private void showLeftLabelContainer(LPConstants.StudyRoomMode studyRoomMode) {
        this.$.id(R.id.cl_top_left).visibility(studyRoomMode.isGalleryLayout() ? 0 : 8);
        if (!studyRoomMode.isGalleryLayout()) {
            this.$.id(R.id.window_study_rank).gone();
        }
        if (!this.isAdminWindow() && this.isTutorHelping && this.isSelfSingleTutorHelping()) {
            this.$.id(R.id.cl_top_left_tutor).visible();
            this.$.id(R.id.cl_top_left).gone();
            this.$.id(R.id.window_study_rank).gone();
        } else {
            this.$.id(R.id.cl_top_left_tutor).gone();
        }
    }

    private void updateUserStatus(LPConstants.StudyRoomMode studyRoomMode, boolean startTimer2) {
        this.showLeftLabelContainer(studyRoomMode);
        String tutorId = this.iRouter.getSubjectValueByKey(EventKey.StudyStatusTutor, String.class, "");
        this.$.id(R.id.cl_top_right).visibility(TextUtils.isEmpty((CharSequence)tutorId) && !this.isTutorHelping && this.isAdmin() && !this.isAdminWindow() && this.isLeave && studyRoomMode.isGalleryLayout() ? 0 : 8);
        this.showUserLabel();
        this.showStuTutorHelpBtn();
        if (startTimer2) {
            this.$.id(R.id.window_study_duration).text((CharSequence)KUtilsKt.convertTime(this.selfStudyDuration));
            this.$.id(R.id.window_study_duration_tutor).text((CharSequence)KUtilsKt.convertTime(this.selfStudyDuration));
            this.startStudyTimer(this.selfStudyDuration);
        }
    }

    private void showUserLabel() {
        if (this.mediaModel.getUser().getType() == LPConstants.LPUserType.Teacher || this.mediaModel.getUser().getType() == LPConstants.LPUserType.Assistant) {
            this.showAssistantLabel();
        } else if (this.isLeave) {
            this.$.id(R.id.window_study_status).text(R.string.bjysc_study_room_status_leave);
            this.ivPlaceholder.setImageResource(R.drawable.base_ic_video_leave);
            this.$.id(R.id.tv_video_placeholder).text(R.string.bjysc_study_room_study_status_leave);
            this.$.id(R.id.window_study_status).view().setBackground(new DrawableBuilder().solidColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_warning_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        } else if (this.isTutorHelping) {
            this.$.id(R.id.window_study_status).view().setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
            this.$.id(R.id.window_study_status).text(R.string.bjysc_study_room_tutor_status_helping);
        } else {
            this.$.id(R.id.window_study_status).view().setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
            this.$.id(R.id.window_study_status).text(R.string.bjysc_study_room_status_study);
        }
    }

    private void showAssistantLabel() {
        this.$.id(R.id.window_study_duration).gone();
        TextView tvStatus = (TextView)this.$.id(R.id.window_study_status).view();
        RelativeLayout.LayoutParams tvParams = (RelativeLayout.LayoutParams)tvStatus.getLayoutParams();
        tvStatus.setBackground(new DrawableBuilder().solidColor(872047616).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        tvStatus.setTextColor(-367616);
        if (this.isTutorHelping) {
            tvStatus.setTextSize(12.0f);
            tvParams.width = -2;
            tvParams.height = UtilsKt.getDp((int)24);
            tvStatus.setLayoutParams((ViewGroup.LayoutParams)tvParams);
            int padding = UtilsKt.getDp((int)8);
            tvStatus.setPadding(padding, 0, padding, 0);
            tvStatus.setText((CharSequence)this.context.getString(R.string.bjysc_study_room_tutor_assistant_helping));
        } else {
            tvParams.width = UtilsKt.getDp((int)36);
            tvParams.height = UtilsKt.getDp((int)24);
            tvStatus.setTextSize(12.0f);
            tvStatus.setPadding(0, 0, 0, 0);
            tvStatus.setLayoutParams((ViewGroup.LayoutParams)tvParams);
            tvStatus.setText((CharSequence)this.context.getString(R.string.bjysc_role_assistant));
        }
    }

    @Override
    protected void changePlaceholderState(boolean checked) {
        super.changePlaceholderState(checked);
        this.$.id(R.id.tv_video_placeholder).visibility(this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout() && (!this.isVideoOn || this.isLeave || this.isRemoteVideoClose()) ? 0 : 8);
        if (this.isLeave) {
            ImageView ivPlaceholder = (ImageView)this.$.id(R.id.iv_video_placeholder).view();
            ivPlaceholder.setImageResource(R.drawable.base_ic_video_leave);
            this.$.id(R.id.tv_video_placeholder).text(R.string.bjysc_study_room_study_status_leave);
        } else {
            if (this.isRemoteVideoClose()) {
                if (!this.isLocalVideo()) {
                    this.showTutorPlaceholder();
                }
            } else if (this.videoState == LPConstants.MediaState.Normal) {
                ImageView ivPlaceholder = (ImageView)this.$.id(R.id.iv_video_placeholder).view();
                ivPlaceholder.setImageResource(R.drawable.base_ic_video_camera_mute);
                this.$.id(R.id.tv_video_placeholder).text(R.string.bjysc_study_room_study_status_camera_mute);
            }
            if (this.remoteVideoStatus == 3 && this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout()) {
                this.$.id(R.id.tv_video_placeholder).text(R.string.bjysc_study_room_study_status_only_audio);
            }
        }
    }

    @Override
    public void setRemoteVideoStatus(int remoteVideoStatus) {
        super.setRemoteVideoStatus(remoteVideoStatus);
        if (remoteVideoStatus == 3 && this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout()) {
            this.$.id(R.id.tv_video_placeholder).visible().text(R.string.bjysc_study_room_study_status_only_audio);
        }
    }

    private boolean isAdminWindow() {
        return this.getUserModel().getType() == LPConstants.LPUserType.Assistant || this.getUserModel().getType() == LPConstants.LPUserType.Teacher;
    }

    private boolean canShowTutorHelp() {
        String tutorId = this.getSelfTutorId();
        return !this.isTutorHelping && !this.isAdmin() && this.isAdminWindow() && this.enableSingleTutor() && TextUtils.isEmpty((CharSequence)tutorId) && this.iRouter.getLiveRoom().getOnlineUserVM().isActiveUser(this.iRouter.getLiveRoom().getCurrentUser()) && this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout();
    }

    private void showStuTutorHelpBtn() {
        this.$.id(R.id.window_video_tutor_help).visibility(this.canShowTutorHelp() ? 0 : 8);
    }

    private void hideStuTutorHelpBtn() {
        this.$.id(R.id.window_video_tutor_help).gone();
    }

    private void initStudyStatus(IMediaModel iMediaModel) {
        if (!this.iRouter.getLiveRoom().getStudyRoomVM().isStudyRoom()) {
            return;
        }
        this.showStuTutorHelpBtn();
        this.showLeftLabelContainer(this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode());
        if (iMediaModel.getUser().getType() == LPConstants.LPUserType.Teacher || iMediaModel.getUser().getType() == LPConstants.LPUserType.Assistant) {
            this.showAssistantLabel();
        } else {
            this.$.id(R.id.cl_top_left).view().setBackground(new DrawableBuilder().solidColor(0x33000000).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
            this.$.id(R.id.window_study_kickout).view().setBackground(new DrawableBuilder().solidColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_warning_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
            this.$.id(R.id.window_study_seat_down).view().setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
            this.$.id(R.id.window_study_kickout).clicked(v -> this.iRouter.getSubjectByKey(EventKey.KickOutConfirm).onNext((Object)iMediaModel.getUser()));
            this.$.id(R.id.window_study_seat_down).clicked(v -> this.iRouter.getLiveRoom().getOnlineUserVM().requestRemoveActiveUser(iMediaModel.getUser()));
        }
        List tutorGroup = this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomCurrentTutorGroup();
        for (LPStudyRoomTutorModel lpStudyRoomTutorModel : tutorGroup) {
            this.handleTutorHelpStart(lpStudyRoomTutorModel);
        }
    }

    private void endTutorHelp() {
        NoteDialog noteDialog = new NoteDialog();
        noteDialog.setMainText(this.context.getString(R.string.bjysc_study_room_tutor_end_tip));
        noteDialog.setHideAssistantText(true);
        noteDialog.setOnPositiveClickListener((dialog, checked) -> {
            if (this.lpStudyRoomTutorModel != null) {
                this.iRouter.getLiveRoom().getStudyRoomVM().requestTutorEnd(this.lpStudyRoomTutorModel.tutorId);
            } else {
                LPLogger.e((String)"lpStudyRoomTutorModel == null");
            }
            dialog.dismissAllowingStateLoss();
        });
        noteDialog.setOnNegativeClickListener((dialog, checked) -> dialog.dismissAllowingStateLoss());
        noteDialog.setWidth(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_dialog_container_width));
        noteDialog.setHeight(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_dialog_container_height));
        FragmentActivity activity = (FragmentActivity)this.context;
        noteDialog.show(activity.getSupportFragmentManager(), "endTutorHelp");
    }

    private void startForHelp() {
        if (this.isWaitingHelp) {
            return;
        }
        boolean isForHelping = this.iRouter.getSubjectValueByKey(EventKey.StudyStatusForHelping, Boolean.class, false);
        if (isForHelping) {
            return;
        }
        this.isWaitingHelp = true;
        this.iRouter.getSubjectByKey(EventKey.StudyStatusForHelping).onNext((Object)true);
        ImageView imageView = (ImageView)this.$.id(R.id.window_video_tutor_help).view();
        imageView.setImageResource(R.drawable.bjysc_ic_help_waiting);
        this.$.id(R.id.window_video_tutor_help_waiting).visible();
        this.iRouter.getLiveRoom().getStudyRoomVM().requestTutorApply(this.getUserId(), 30, new OnCountDownListener(){

            public void onTimeOut() {
                if (StudyVideoWindow.this.isDestroyed()) {
                    return;
                }
                StudyVideoWindow.this.endForHelp();
            }

            public void onTimeCountDown(int counter, int timeOut) {
                if (StudyVideoWindow.this.isDestroyed()) {
                    return;
                }
                StudyVideoWindow.this.$.id(R.id.window_video_tutor_help_waiting).text((CharSequence)StudyVideoWindow.this.context.getString(R.string.bjysc_study_room_tutor_waiting_seconds, new Object[]{timeOut - counter}));
            }
        });
    }

    private void showEndForHelp() {
        if (!this.isWaitingHelp) {
            return;
        }
        this.isWaitingHelp = false;
        this.iRouter.getSubjectByKey(EventKey.StudyStatusForHelping).onNext((Object)false);
        ImageView imageView = (ImageView)this.$.id(R.id.window_video_tutor_help).view();
        imageView.setImageResource(R.drawable.bjysc_ic_help);
        this.$.id(R.id.window_video_tutor_help_waiting).invisible();
    }

    private void endForHelp() {
        this.showEndForHelp();
        this.iRouter.getLiveRoom().getStudyRoomVM().cancelTutorApply(this.iRouter.getLiveRoom().getCurrentUser().getUserId());
    }

    @SuppressLint(value={"DefaultLocale"})
    private void startStudyTimer(long seconds) {
        RxUtils.dispose((Disposable)this.disposableOfDurationTimer);
        this.disposableOfDurationTimer = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            this.$.id(R.id.window_study_duration).text((CharSequence)KUtilsKt.convertTime(aLong + seconds));
            this.$.id(R.id.window_study_duration_tutor).text((CharSequence)KUtilsKt.convertTime(aLong + seconds));
        });
    }

    @Override
    public void publishLocalStream() {
        boolean audioOn = false;
        if (this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode() == LPConstants.StudyRoomMode.Discuss) {
            audioOn = true;
        } else if (this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode() == LPConstants.StudyRoomMode.Tutor) {
            audioOn = this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher;
        }
        this.publishLocalStream(audioOn);
    }

    @Override
    public void publishLocalStream(boolean audioOn) {
        Boolean isHangUp = this.iRouter.getValueByKey(EventKey.StudyStatusHangUp, Boolean.class);
        if (isHangUp != null && isHangUp.equals(true)) {
            return;
        }
        LPConstants.StudyRoomMode studyRoomMode = this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode();
        if (studyRoomMode == LPConstants.StudyRoomMode.SelfStudy) {
            audioOn = false;
        }
        if (studyRoomMode == LPConstants.StudyRoomMode.Discuss) {
            audioOn = true;
        }
        super.publishLocalStream(audioOn);
    }

    @Override
    public boolean isGalleryLayout() {
        return super.isGalleryLayout() || this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout();
    }

    @Override
    public boolean isTouchAble() {
        return !this.isLeave && (super.isTouchAble() || this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout());
    }

    @Override
    protected boolean canAttachAudio() {
        return this.isTutorHelping || this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode() == LPConstants.StudyRoomMode.Discuss || this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode() == LPConstants.StudyRoomMode.Tutor;
    }

    @Override
    public void showTutorHelpIcon(boolean isShow) {
        if (!this.isAdmin()) {
            return;
        }
        if (this.ivTutorHelp != null) {
            this.ivTutorHelp.setVisibility(isShow ? 0 : 8);
        }
    }

    @Override
    public void showTutorHandleIcon(boolean isShow) {
        if (!this.isAdmin()) {
            return;
        }
        if (this.tvTutorAgree != null) {
            this.tvTutorAgree.setVisibility(isShow ? 0 : 8);
        }
        if (this.tvTutorDisagree != null) {
            this.tvTutorDisagree.setVisibility(isShow ? 0 : 8);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RxUtils.dispose((Disposable)this.disposableOfDurationTimer);
    }
}

