/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.user;

import android.text.TextUtils;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.groupclassui.base.BaseGroupPresenter;
import com.baijiayun.groupclassui.dialog.FullAndReplaceListener;
import com.baijiayun.groupclassui.global.EventCode;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.user.IUserInteractionListener;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livecore.models.imodels.IMediaControlModel;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;

public class ReplacePresenter
implements BaseGroupPresenter {
    CompositeDisposable disposables;
    private IRouter router;
    private IUserInteractionListener listener;
    private int lastOnlineUserCount = -1;
    private int lastActiveUserCount = 0;
    private IMediaControlModel iMediaControlModel;

    public ReplacePresenter(IUserInteractionListener iUserInteractionListener, IRouter iRouter) {
        this.listener = (FullAndReplaceListener)iUserInteractionListener;
        this.router = iRouter;
    }

    @Override
    public void setRouter(IRouter router) {
        this.router = router;
    }

    public IRouter getRouter() {
        return this.router;
    }

    public void subscribe() {
        this.disposables = new CompositeDisposable();
        this.disposables.add(this.router.getLiveRoom().getOnlineUserVM().getObservableOfOnlineUser().observeOn(AndroidSchedulers.mainThread()).subscribe(iUserModels -> {
            IUserModel tea = null;
            for (IUserModel iUserModel : iUserModels) {
                if (iUserModel.getType() != LPConstants.LPUserType.Teacher) continue;
                tea = iUserModel;
                break;
            }
            iUserModels.remove(tea);
            if (this.listener != null) {
                if (this.lastOnlineUserCount > iUserModels.size()) {
                    this.listener.notifyActiveUserDataChange();
                } else if (this.lastOnlineUserCount == iUserModels.size()) {
                    this.listener.notifyActiveUserDataChange();
                }
            }
            this.lastOnlineUserCount = iUserModels.size();
        }));
        this.disposables.add(this.router.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserAdd().observeOn(AndroidSchedulers.mainThread()).subscribe(userModel -> {
            int activeUserCount;
            if (this.listener != null && userModel.getUser().getType() != LPConstants.LPUserType.Teacher && this.lastActiveUserCount < (activeUserCount = this.router.getLiveRoom().getOnlineUserVM().getActiveUserList().size())) {
                this.listener.notifyActiveUserDataChange();
                this.lastActiveUserCount = activeUserCount;
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getOnlineUserVM().getPublishSubjectOfActiveUserRemove().observeOn(AndroidSchedulers.mainThread()).subscribe(userModel -> {
            int activeUserCount;
            if (this.listener != null && userModel.getUser().getType() != LPConstants.LPUserType.Teacher && this.lastActiveUserCount > (activeUserCount = this.router.getLiveRoom().getOnlineUserVM().getActiveUserList().size())) {
                this.listener.notifyActiveUserDataChange();
                this.lastActiveUserCount = activeUserCount;
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getSpeakQueueVM().getObservableOfSpeakResponse().observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaControlModel -> {
            if (!iMediaControlModel.isApplyAgreed()) {
                this.router.getLiveRoom().getOnlineUserVM().loadMoreUser();
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getSpeakQueueVM().getObservableOfMediaPublish().observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaModel -> {
            int curActiveCount = this.router.getLiveRoom().getOnlineUserVM().getActiveUserList().size();
            if (this.lastActiveUserCount < curActiveCount) {
                this.listener.notifyActiveUserDataChange();
            }
            this.lastActiveUserCount = curActiveCount;
            if (iMediaModel.getUser().getType() != LPConstants.LPUserType.Teacher) {
                this.listener.notifyUserDataChange();
            }
        }));
        this.disposables.add(this.router.getLiveRoom().getSpeakQueueVM().getObservableOfMediaControl().observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaControlModel -> {
            if (iMediaControlModel.getUser().getUserId().equals(this.router.getLiveRoom().getCurrentUser().getUserId())) {
                this.iMediaControlModel = iMediaControlModel;
            }
        }));
        this.disposables.add(this.router.getPublishSubjectByKey(EventCode.AttachVideo).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> {
            if (this.iMediaControlModel != null && this.iMediaControlModel.getUser().getUserId().equals(this.router.getLiveRoom().getCurrentUser().getUserId()) && this.listener != null) {
                this.listener.notifyUserDataChange();
            }
        }));
        this.disposables.add(this.router.getPublishSubjectByKey(EventCode.AttachAudio).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> {
            if (this.iMediaControlModel != null && this.iMediaControlModel.getUser().getUserId().equals(this.router.getLiveRoom().getCurrentUser().getUserId()) && this.listener != null) {
                this.listener.notifyUserDataChange();
            }
        }));
        this.router.getLiveRoom().getOnlineUserVM().loadMoreUser();
        this.lastActiveUserCount = this.router.getLiveRoom().getOnlineUserVM().getActiveUserList().size();
    }

    public void unSubscribe() {
    }

    public void destroy() {
        RxUtils.dispose((Disposable)this.disposables);
    }

    public boolean isSelfVideoOn() {
        return this.router.getLiveRoom().getRecorder().isVideoAttached() || this.iMediaControlModel != null && this.iMediaControlModel.getUser().getUserId().equals(this.router.getLiveRoom().getCurrentUser().getUserId()) && this.iMediaControlModel.isVideoOn();
    }

    public boolean isSelfAudioOn() {
        return this.router.getLiveRoom().getRecorder().isAudioAttached() || this.iMediaControlModel != null && this.iMediaControlModel.getUser().getUserId().equals(this.router.getLiveRoom().getCurrentUser().getUserId()) && this.iMediaControlModel.isAudioOn();
    }

    public String getAssistantCustomLabelText() {
        return TextUtils.isEmpty((CharSequence)this.router.getLiveRoom().getCustomizeAssistantLabel()) ? "\u52a9\u6559" : this.router.getLiveRoom().getCustomizeAssistantLabel();
    }
}

