/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.container;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.container.VideoContainerListener;
import com.baijiayun.groupclassui.layer.BaseLayerOfProfessionalClass;
import com.baijiayun.groupclassui.layer.SeatLayer;
import com.baijiayun.groupclassui.layer.VideoDragLayer;
import com.baijiayun.livebase.context.LPConstants;

public class SeatContainer
extends BaseLayerOfProfessionalClass
implements VideoContainerListener {
    private final String TAG = SeatContainer.class.getCanonicalName();
    private SeatLayer seatLayer;
    private VideoDragLayer videoDragLayer;

    public SeatContainer(@NonNull Context context) {
        super(context);
    }

    public SeatContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SeatContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public SeatContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public boolean onRoomStatusChange(boolean isRoomActive) {
        boolean isLayerInit = super.onRoomStatusChange(isRoomActive);
        if (isLayerInit && !isRoomActive) {
            this.release();
        }
        return true;
    }

    @Override
    public void initVideo() {
        this.seatLayer = new SeatLayer(this.getContext());
        this.videoDragLayer = new VideoDragLayer(this.getContext());
        this.seatLayer.setVideoDragLayer(this.videoDragLayer);
        if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
            this.post(() -> {
                if (this.videoDragLayer != null) {
                    this.videoDragLayer.setSeatContainerWidth(this.getMeasuredWidth());
                }
            });
        } else {
            this.post(() -> {
                if (this.videoDragLayer != null) {
                    this.videoDragLayer.setSeatContainerHeight(this.getMeasuredHeight());
                }
            });
        }
        this.addView((View)this.seatLayer, new ViewGroup.LayoutParams(-1, -1));
    }

    @Override
    public VideoDragLayer getVideoDragLayer() {
        return this.videoDragLayer;
    }

    @Override
    public void switchLayoutMode(boolean isBoardLayout) {
        this.seatLayer.switchLayoutMode(isBoardLayout);
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.getLayoutParams();
        if (isBoardLayout) {
            if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.DEFAULT) {
                layoutParams.bottomToTop = R.id.activity_group_class_sync_container;
                layoutParams.bottomToBottom = -1;
            } else {
                layoutParams.topToBottom = R.id.activity_group_class_status_bar_container;
                layoutParams.bottomToBottom = 0;
                layoutParams.endToEnd = 0;
                this.setBackgroundColor(0);
            }
        } else if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.DEFAULT) {
            layoutParams.bottomToTop = -1;
            layoutParams.bottomToBottom = 0;
        } else {
            layoutParams.topToBottom = -1;
            layoutParams.topToTop = 0;
        }
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public void switchStudyRoomMode(LPConstants.StudyRoomMode roomMode) {
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.release();
    }

    @Override
    public void release() {
        if (this.videoDragLayer != null) {
            this.videoDragLayer.onDestroy();
        }
        if (this.seatLayer != null) {
            this.removeAndDestroy(this.seatLayer);
        }
    }
}

