/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.status;

import android.content.Context;
import com.baijiayun.bjyrtcengine.BJYRtcEventObserver;
import com.baijiayun.bjyutils.TimeUtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.window.status.StatusBarContract;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.wrapper.LPRecorder;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public class StatusBarPresenter
implements StatusBarContract.Presenter {
    private IRouter iRouter;
    private StatusBarContract.View view;
    private Context context;
    private Disposable disposableOfUpLinkLossRate;
    private Disposable disposableOfDownLinkLossRate;
    private Disposable disposableOfTimer;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();
    private long startTimeTs = 0L;
    private long realStartTime = 0L;
    private boolean classIsStart = false;
    private boolean isStudyRoom = false;
    private String courseDuration = TimeUtilsKt.format24HoursTime((int)0);
    private boolean isUpLinkChanged;
    private boolean isDownLinkChanged;
    private LPConstants.MediaNetworkQuality worstUpNetworkQuality;
    private LPConstants.MediaNetworkQuality worstDownNetworkQuality;

    StatusBarPresenter(StatusBarContract.View view, Context context) {
        this.view = view;
        this.context = context;
    }

    public void subscribe() {
        this.view.showClassName(this.iRouter.getLiveRoom().getRoomInfo().title);
        this.realStartTime = this.startTimeTs = this.iRouter.getLiveRoom().getRoomInfo().startTimets / 1000L;
        this.isStudyRoom = this.iRouter.getLiveRoom().getStudyRoomVM().isStudyRoom();
        if (this.iRouter.getLiveRoom().isClassStarted()) {
            this.startRateDisposable();
        }
        this.compositeDisposable.add(this.iRouter.getLiveRoom().getObservableOfClassStart().observeOn(AndroidSchedulers.mainThread()).subscribe(stats -> this.startRateDisposable()));
        this.compositeDisposable.add(this.iRouter.getLiveRoom().getObservableOfClassEnd().observeOn(AndroidSchedulers.mainThread()).subscribe(stats -> {
            this.stopRateDisposable();
            this.classIsStart = false;
            this.view.showResetStatusBarText();
        }));
        this.compositeDisposable.add(this.iRouter.getLiveRoom().getObservableOfRealStartTime().observeOn(AndroidSchedulers.mainThread()).subscribe(realTime -> {
            this.realStartTime = realTime / 1000L;
        }));
        this.compositeDisposable.add(Observable.interval((long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            String classTimeStr;
            long nowTime = System.currentTimeMillis() / 1000L;
            if (this.realStartTime != this.startTimeTs && !this.classIsStart) {
                classTimeStr = this.context.getString(R.string.bjysc_status_bar_class_has_end) + " " + this.courseDuration;
            } else if (this.realStartTime != this.startTimeTs) {
                this.courseDuration = TimeUtilsKt.format24HoursTime((long)(nowTime - this.realStartTime));
                String classStartStr = this.isStudyRoom ? this.context.getString(R.string.bjysc_status_bar_class_has_use) : this.context.getString(R.string.bjysc_status_bar_class_has_start);
                classTimeStr = classStartStr + " " + this.courseDuration;
            } else if (!this.classIsStart) {
                classTimeStr = this.startTimeTs < nowTime ? this.context.getString(R.string.bjysc_status_bar_overtime) + " " + TimeUtilsKt.format24HoursTime((long)(nowTime - this.startTimeTs)) : this.context.getString(R.string.bjysc_status_bar_distance_from_class) + " " + TimeUtilsKt.format24HoursTime((long)(this.startTimeTs - nowTime));
            } else if (this.realStartTime != 0L && nowTime > this.realStartTime) {
                this.courseDuration = TimeUtilsKt.format24HoursTime((long)(nowTime - this.realStartTime));
                String classStartStr = this.isStudyRoom ? this.context.getString(R.string.bjysc_status_bar_class_has_use) : this.context.getString(R.string.bjysc_status_bar_class_has_start);
                classTimeStr = classStartStr + " " + this.courseDuration;
            } else {
                String classStartStr = this.isStudyRoom ? this.context.getString(R.string.bjysc_status_bar_class_has_use) : this.context.getString(R.string.bjysc_status_bar_class_has_start);
                classTimeStr = classStartStr + " " + TimeUtilsKt.format24HoursTime((int)0);
            }
            this.view.showClassTime(classTimeStr);
        }));
    }

    private void startRateDisposable() {
        this.classIsStart = true;
        this.stopRateDisposable();
        this.disposableOfUpLinkLossRate = this.iRouter.getLiveRoom().getRecorder().getObservableOfUpPacketLossRate().observeOn(AndroidSchedulers.mainThread()).subscribe(localStreamStats -> {
            this.isUpLinkChanged = true;
            LPRecorder recorder = this.iRouter.getLiveRoom().getRecorder();
            if (recorder != null) {
                boolean isVideoOn = recorder.isVideoAttached();
                boolean isAudioOn = recorder.isAudioAttached();
                double lossRate = isVideoOn ? localStreamStats.videoPacketsLostRateSent : localStreamStats.audioPacketsLostRateSent;
                LPConstants.MediaNetworkQuality upLinkNetStatus = this.getNetworkQualityByLossRate(lossRate);
                this.view.showUpLinkLossRate(lossRate, upLinkNetStatus);
                double videoUpBitrate = localStreamStats.videoBitrateSent;
                double audioUpBitrate = localStreamStats.audioBitrateSent;
                LPConstants.MediaNetworkQuality videoUpStatus = this.getNetworkQualityByVideoBitRate(videoUpBitrate);
                LPConstants.MediaNetworkQuality audioUpStatus = this.getNetworkQualityByAudioBitRate(audioUpBitrate);
                this.view.showUpVideoBitrate(videoUpBitrate, videoUpStatus);
                this.view.showUpAudioBitrate(audioUpBitrate, audioUpStatus);
                this.worstUpNetworkQuality = this.getWorseNetworkQuality(upLinkNetStatus, this.getWorseNetworkQuality(videoUpStatus, audioUpStatus));
                this.view.updateWorstNetworkQuality(this.worstUpNetworkQuality, this.worstDownNetworkQuality);
            }
        });
        this.disposableOfDownLinkLossRate = this.iRouter.getLiveRoom().getPlayer().getObservableOfDownLinkLossRate().buffer(1L, TimeUnit.SECONDS).filter(maps -> maps.size() > 0).observeOn(AndroidSchedulers.mainThread()).subscribe(stats -> {
            this.isDownLinkChanged = true;
            double sum = 0.0;
            double videoSum = 0.0;
            double audioSum = 0.0;
            for (BJYRtcEventObserver.RemoteStreamStats streamStats : stats) {
                sum += streamStats.receivedVideoLostRate;
                videoSum += streamStats.receivedVideoBitrate;
                audioSum += streamStats.receivedAudioBitrate;
            }
            int size = stats.size();
            double average = sum / (double)size;
            double videoAvg = videoSum / (double)size;
            double audioAvg = audioSum / (double)size;
            LPConstants.MediaNetworkQuality videoDownStatus = this.getNetworkQualityByVideoBitRate(videoAvg);
            LPConstants.MediaNetworkQuality audioDownStatus = this.getNetworkQualityByAudioBitRate(audioAvg);
            LPConstants.MediaNetworkQuality downLinkNetStatus = this.getNetworkQualityByLossRate(average);
            this.view.showDownLinkLossRate(average, downLinkNetStatus);
            this.view.showDownVideoBitrate(videoAvg, videoDownStatus);
            this.view.showDownAudioBitrate(audioAvg, audioDownStatus);
            this.worstDownNetworkQuality = this.getWorseNetworkQuality(downLinkNetStatus, this.getWorseNetworkQuality(videoDownStatus, audioDownStatus));
            this.view.updateWorstNetworkQuality(this.worstUpNetworkQuality, this.worstDownNetworkQuality);
        });
        this.disposableOfTimer = Observable.interval((long)5L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            if (!this.isUpLinkChanged) {
                this.view.showUpLinkLossRate(-1.0, LPConstants.MediaNetworkQuality.EXCELLENT);
                this.view.showUpVideoBitrate(-1.0, LPConstants.MediaNetworkQuality.EXCELLENT);
                this.view.showUpAudioBitrate(-1.0, LPConstants.MediaNetworkQuality.EXCELLENT);
                this.worstUpNetworkQuality = null;
                this.view.updateWorstNetworkQuality(this.worstUpNetworkQuality, this.worstDownNetworkQuality);
            }
            if (!this.isDownLinkChanged) {
                this.view.showDownLinkLossRate(-1.0, LPConstants.MediaNetworkQuality.EXCELLENT);
                this.view.showDownVideoBitrate(-1.0, LPConstants.MediaNetworkQuality.EXCELLENT);
                this.view.showDownAudioBitrate(-1.0, LPConstants.MediaNetworkQuality.EXCELLENT);
                this.worstDownNetworkQuality = null;
                this.view.updateWorstNetworkQuality(this.worstUpNetworkQuality, this.worstDownNetworkQuality);
            }
            this.isUpLinkChanged = false;
            this.isDownLinkChanged = false;
        });
    }

    private void stopRateDisposable() {
        RxUtils.dispose((Disposable)this.disposableOfUpLinkLossRate);
        RxUtils.dispose((Disposable)this.disposableOfDownLinkLossRate);
        RxUtils.dispose((Disposable)this.disposableOfTimer);
    }

    @Override
    public void help() {
        this.iRouter.getSubjectByKey(EventKey.HelpWindow).onNext((Object)true);
    }

    @Override
    public void setting() {
        this.iRouter.getSubjectByKey(EventKey.SettingWindow).onNext((Object)true);
    }

    @Override
    public void exit() {
        this.iRouter.getSubjectByKey(EventKey.CloseDialog).onNext((Object)true);
    }

    @Override
    public void report() {
        this.iRouter.getSubjectByKey(EventKey.ReportDialog).onNext((Object)true);
    }

    @Override
    public void setRouter(IRouter router) {
        this.iRouter = router;
    }

    @Override
    public void unSubscribe() {
        RxUtils.dispose((Disposable)this.disposableOfUpLinkLossRate);
        RxUtils.dispose((Disposable)this.disposableOfDownLinkLossRate);
        RxUtils.dispose((Disposable)this.disposableOfTimer);
        this.compositeDisposable.clear();
    }

    public void destroy() {
        this.unSubscribe();
        this.compositeDisposable.dispose();
        this.view = null;
    }

    private LPConstants.MediaNetworkQuality getNetworkQualityByLossRate(double lossRate) {
        LPConstants.MediaNetworkQuality quality = LPConstants.MediaNetworkQuality.EXCELLENT;
        if (lossRate > 0.0 && lossRate < 1.0) {
            quality = LPConstants.MediaNetworkQuality.EXCELLENT;
        } else if (lossRate >= 1.0 && lossRate < 5.0) {
            quality = LPConstants.MediaNetworkQuality.GOOD;
        } else if (lossRate >= 5.0 && lossRate < 10.0) {
            quality = LPConstants.MediaNetworkQuality.BAD;
        } else if (lossRate >= 10.0) {
            quality = LPConstants.MediaNetworkQuality.TERRIBLE;
        }
        return quality;
    }

    private LPConstants.MediaNetworkQuality getNetworkQualityByVideoBitRate(double videoBitRate) {
        LPConstants.MediaNetworkQuality quality = LPConstants.MediaNetworkQuality.EXCELLENT;
        if (videoBitRate > 0.0 && videoBitRate < 50.0) {
            quality = LPConstants.MediaNetworkQuality.TERRIBLE;
        } else if (videoBitRate >= 50.0 && videoBitRate < 100.0) {
            quality = LPConstants.MediaNetworkQuality.BAD;
        } else if (videoBitRate >= 100.0 && videoBitRate < 300.0) {
            quality = LPConstants.MediaNetworkQuality.GOOD;
        } else if (videoBitRate >= 300.0) {
            quality = LPConstants.MediaNetworkQuality.EXCELLENT;
        }
        return quality;
    }

    private LPConstants.MediaNetworkQuality getNetworkQualityByAudioBitRate(double audioBitRate) {
        LPConstants.MediaNetworkQuality quality = LPConstants.MediaNetworkQuality.EXCELLENT;
        if (audioBitRate > 0.0 && audioBitRate < 10.0) {
            quality = LPConstants.MediaNetworkQuality.TERRIBLE;
        } else if (audioBitRate >= 10.0 && audioBitRate < 15.0) {
            quality = LPConstants.MediaNetworkQuality.BAD;
        } else if (audioBitRate >= 15.0 && audioBitRate < 20.0) {
            quality = LPConstants.MediaNetworkQuality.GOOD;
        } else if (audioBitRate >= 20.0) {
            quality = LPConstants.MediaNetworkQuality.EXCELLENT;
        }
        return quality;
    }

    private LPConstants.MediaNetworkQuality getWorseNetworkQuality(LPConstants.MediaNetworkQuality quality1, LPConstants.MediaNetworkQuality quality2) {
        if (quality1.getQuality() > quality2.getQuality()) {
            return quality1;
        }
        return quality2;
    }
}

