/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.layer;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.layer.BaseLayerOfProfessionalClass;
import com.baijiayun.groupclassui.window.coursewaremanage.CourseManageWindow;

public class CoursewareLayer
extends BaseLayerOfProfessionalClass {
    private CourseManageWindow courseManageWindow;

    public CoursewareLayer(@NonNull Context context) {
        super(context);
    }

    public CoursewareLayer(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CoursewareLayer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public CoursewareLayer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public boolean onRoomStatusChange(boolean isRoomActive) {
        boolean layerInit = super.onRoomStatusChange(isRoomActive);
        if (layerInit && isRoomActive) {
            this.subscribe();
        }
        return layerInit;
    }

    private void subscribe() {
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.CoursewareManageEnable).ofType(Boolean.class).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                this.showCoursewareWindow();
                this.setVisibility(0);
            } else {
                this.hideCoursewareWindow();
                this.setVisibility(8);
            }
        }));
    }

    private void showCoursewareWindow() {
        if (this.courseManageWindow == null) {
            this.courseManageWindow = new CourseManageWindow();
        }
        FragmentTransaction transaction = ((AppCompatActivity)this.getContext()).getSupportFragmentManager().beginTransaction();
        if (!this.courseManageWindow.isAdded()) {
            if (this.getId() == -1) {
                this.setId(View.generateViewId());
            }
            transaction.add(this.getId(), (Fragment)this.courseManageWindow);
        }
        if (this.courseManageWindow.isHidden()) {
            transaction.show((Fragment)this.courseManageWindow);
        }
        transaction.commitAllowingStateLoss();
    }

    private void hideCoursewareWindow() {
        FragmentTransaction transaction = ((AppCompatActivity)this.getContext()).getSupportFragmentManager().beginTransaction();
        if (this.courseManageWindow != null && this.courseManageWindow.isVisible()) {
            transaction.hide((Fragment)this.courseManageWindow);
        }
        transaction.commitAllowingStateLoss();
    }

    @Override
    public void onDestroy() {
        if (this.courseManageWindow != null) {
            this.courseManageWindow.onDestroy();
        }
        this.courseManageWindow = null;
        super.onDestroy();
    }
}

