/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.blackboard;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ScrollView;

public class BlackboardScrollView
extends ScrollView {
    private boolean isSingleFingerScrollEnable = true;
    private boolean forbidScroll = false;
    private Runnable scrollerTask;
    private int initialPosition;
    private int newCheckTime = 100;
    private GestureDetector gestureDetector;
    private GestureDetector.OnGestureListener gestureListener;
    private ScrollViewListener scrollViewListener;
    private boolean doubleFingerConfirmed = false;
    private boolean isFling = false;

    public BlackboardScrollView(Context context) {
        this(context, null);
    }

    public BlackboardScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BlackboardScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.gestureListener = new GestureDetector.OnGestureListener(){

            public boolean onDown(MotionEvent e) {
                return false;
            }

            public void onShowPress(MotionEvent e) {
            }

            public boolean onSingleTapUp(MotionEvent e) {
                return false;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (BlackboardScrollView.this.doubleFingerConfirmed) {
                    BlackboardScrollView.this.onTouchEvent(e1);
                    BlackboardScrollView.this.onTouchEvent(e2);
                }
                return false;
            }

            public void onLongPress(MotionEvent e) {
            }

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                return false;
            }
        };
        this.scrollerTask = () -> {
            int newPosition = this.getScrollY();
            if (this.initialPosition - newPosition == 0) {
                float ratio = (float)newPosition / (float)this.getScrollViewHeight();
                if (this.scrollViewListener != null) {
                    this.scrollViewListener.onScrollStopped(ratio);
                }
            } else {
                this.initialPosition = this.getScrollY();
                this.postDelayed(this.scrollerTask, this.newCheckTime);
            }
        };
        this.gestureDetector = new GestureDetector(context, this.gestureListener);
    }

    @TargetApi(value=21)
    public BlackboardScrollView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (this.forbidScroll) {
            return false;
        }
        if (event.getActionMasked() == 5) {
            this.doubleFingerConfirmed = true;
        } else if (event.getActionMasked() == 6) {
            this.doubleFingerConfirmed = false;
        }
        this.gestureDetector.onTouchEvent(event);
        if (this.isSingleFingerScrollEnable || this.doubleFingerConfirmed) {
            return super.onInterceptTouchEvent(event);
        }
        return false;
    }

    public void startScrollTask() {
        this.initialPosition = this.getScrollY();
        this.postDelayed(this.scrollerTask, this.newCheckTime);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.forbidScroll) {
            return false;
        }
        if (event.getAction() == 1) {
            this.doubleFingerConfirmed = false;
            this.startScrollTask();
        }
        return super.onTouchEvent(event);
    }

    public void setScrollViewListener(ScrollViewListener scrollViewListener) {
        this.scrollViewListener = scrollViewListener;
    }

    public void setScrollEnable(boolean scrollEnable) {
        this.isSingleFingerScrollEnable = scrollEnable;
    }

    public void setForbidScroll() {
        this.forbidScroll = true;
    }

    public int getScrollViewHeight() {
        View view = this.getChildAt(this.getChildCount() - 1);
        return view.getBottom() - this.getHeight();
    }

    public static interface ScrollViewListener {
        public void onScrollChanged(ScrollView var1, int var2, int var3, int var4, int var5);

        public void onScrollStopped(float var1);
    }
}

