/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.layer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.layer.BaseLayerOfProfessionalClass;
import com.baijiayun.groupclassui.window.group.GroupManageWindow;
import com.baijiayun.groupclassui.window.group.SetGroupCountWindow;
import com.baijiayun.livebase.widgets.dialog.CommonDialog;
import com.baijiayun.livecore.models.LPDivideGroupModel;
import com.baijiayun.liveuibase.base.IWindow;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GroupLayer
extends BaseLayerOfProfessionalClass {
    private final String TAG = GroupLayer.class.getCanonicalName();
    private SetGroupCountWindow setGroupCountWindow;
    private GroupManageWindow groupManageWindow;
    private CommonDialog dissolveDialog;
    private List<Disposable> disposables;

    public GroupLayer(@NonNull Context context) {
        super(context);
    }

    public GroupLayer(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public GroupLayer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public GroupLayer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void init() {
        super.init();
        Disposable disposableDisplayAllDissolve = this.router.getSubjectByKey(EventKey.DisplayWindowAllDissolve).ofType(Boolean.class).filter(aBoolean -> aBoolean).subscribe(aBoolean -> {
            Log.d((String)this.TAG, (String)("DisplayWindowAllDissolve: " + aBoolean));
            this.showAllDissolve();
        });
        Disposable disposableDissolveAllEnable = this.router.getSubjectByKey(EventKey.GroupDissolveAllEnable).ofType(Boolean.class).subscribe(aBoolean -> {
            Log.d((String)this.TAG, (String)("GroupDissolveAllEnable: " + aBoolean));
            if (aBoolean.booleanValue()) {
                this.router.getSubjectByKey(EventKey.GroupManageLayout).onNext((Object)false);
                LPDivideGroupModel model = new LPDivideGroupModel();
                model.groups = new HashMap();
                this.router.getLiveRoom().requestDivideGroup(model);
            } else if (this.groupManageWindow != null) {
                this.groupManageWindow.getView().setVisibility(0);
            }
        });
        this.disposables = new ArrayList<Disposable>();
        this.disposables.add(disposableDisplayAllDissolve);
        this.disposables.add(disposableDissolveAllEnable);
        this.showSetGroupCount();
    }

    private void showSetGroupCount() {
        this.setGroupCountWindow = new SetGroupCountWindow(this.getContext());
        this.setGroupCountWindow.setOnNextStepListener(groupCount -> this.showGroupManage(groupCount));
    }

    private void showGroupManage(int groupCount) {
        if (this.setGroupCountWindow != null) {
            this.removeWindow((IWindow)this.setGroupCountWindow);
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.groupManageWindow = new GroupManageWindow(this.getContext(), groupCount);
        this.addWindow((IWindow)this.groupManageWindow, params);
    }

    private void showAllDissolve() {
        if (this.groupManageWindow != null) {
            this.groupManageWindow.getView().setVisibility(4);
        }
        if (this.dissolveDialog == null) {
            this.dissolveDialog = new CommonDialog(this.getContext(), CommonDialog.ChoiceMode.Double_Red).setMainDisplayText(this.getContext().getResources().getString(R.string.bjysc_group_all_dissolve_tips)).setNegative(this.getContext().getResources().getString(R.string.bjysc_cancel), (dialog, which) -> {
                this.router.getSubjectByKey(EventKey.GroupDissolveAllEnable).onNext((Object)false);
                dialog.dismiss();
            }).setPositive(this.getContext().getResources().getString(R.string.bjysc_cancel), (dialog, which) -> {
                this.router.getSubjectByKey(EventKey.GroupDissolveAllEnable).onNext((Object)true);
                dialog.dismiss();
            });
        }
        this.dissolveDialog.show();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.disposables != null) {
            for (Disposable disposable : this.disposables) {
                RxUtils.dispose((Disposable)disposable);
            }
            this.disposables.clear();
            this.disposables = null;
        }
    }
}

