/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.container;

import com.baijiayun.groupclassui.window.toolbar.DrawWidthSettingWindow;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.liveuibase.base.BaseUIConstant;
import com.baijiayun.liveuibase.widgets.toolbar.ColorSelectData;
import com.baijiayun.liveuibase.widgets.toolbar.WidthSelectData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ShapePaint {
    private HashMap<BaseUIConstant.SelectSrc, Integer> mShapeColor;
    private HashMap<BaseUIConstant.SelectSrc, Float> mDoodleStrokeWidth;
    private float mCustomStrokeWidth;
    private int mTextSize = 20;
    private LPConstants.ShapeType shapeType;
    private BaseUIConstant.SelectSrc shapeSelectSrc;
    private LPConstants.PPTEditMode pptEditMode = LPConstants.PPTEditMode.Normal;
    private final List<IShapePaintListener> shapePaintListeners = new ArrayList<IShapePaintListener>();

    public ShapePaint(int mShapeColor, float mCustomStrokeWidth) {
        this.setCustomStrokeWidth(mCustomStrokeWidth);
        this.setDoodleStrokeWidth(new WidthSelectData(BaseUIConstant.SelectSrc.Brush, DrawWidthSettingWindow.pencilPaintSize[1]));
        this.setDoodleStrokeWidth(new WidthSelectData(BaseUIConstant.SelectSrc.Marker, DrawWidthSettingWindow.markerPaintSize[1]));
        this.setShapeColor(new ColorSelectData(BaseUIConstant.SelectSrc.Graph, mShapeColor));
        this.setShapeColor(new ColorSelectData(BaseUIConstant.SelectSrc.Text, mShapeColor));
        this.setShapeColor(new ColorSelectData(BaseUIConstant.SelectSrc.Brush, mShapeColor));
        this.setShapeColor(new ColorSelectData(BaseUIConstant.SelectSrc.Marker, mShapeColor));
    }

    public void setCustomStrokeWidth(float mCustomStrokeWidth) {
        this.mCustomStrokeWidth = mCustomStrokeWidth;
        for (IShapePaintListener shapePaintListener : this.shapePaintListeners) {
            shapePaintListener.onShapeCustomStrokeWidthChange(mCustomStrokeWidth);
        }
    }

    public void setShapeColor(ColorSelectData colorSelectData) {
        if (this.mShapeColor == null) {
            this.mShapeColor = new HashMap();
        }
        this.mShapeColor.put(colorSelectData.getSelectSrc(), colorSelectData.getSelectColor());
        for (IShapePaintListener shapePaintListener : this.shapePaintListeners) {
            shapePaintListener.onShapeColorChange(colorSelectData.getSelectColor());
        }
    }

    public void setDoodleStrokeWidth(WidthSelectData widthSelectData) {
        if (this.mDoodleStrokeWidth == null) {
            this.mDoodleStrokeWidth = new HashMap();
        }
        this.mDoodleStrokeWidth.put(widthSelectData.getSelectSrc(), Float.valueOf(widthSelectData.getWidth()));
        for (IShapePaintListener shapePaintListener : this.shapePaintListeners) {
            shapePaintListener.onShapeDoodleStrokeWidthChange(widthSelectData.getWidth());
        }
    }

    public LPConstants.ShapeType getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(BaseUIConstant.SelectSrc selectSrc, LPConstants.ShapeType shapeType) {
        this.shapeType = shapeType;
        this.shapeSelectSrc = selectSrc;
        for (IShapePaintListener shapePaintListener : this.shapePaintListeners) {
            Float width;
            shapePaintListener.onShapeTypeChange(shapeType);
            Integer shapeColor = this.mShapeColor.get(selectSrc);
            if (shapeColor != null) {
                shapePaintListener.onShapeColorChange(shapeColor);
            }
            if ((width = this.mDoodleStrokeWidth.get(selectSrc)) == null) continue;
            shapePaintListener.onShapeDoodleStrokeWidthChange(width.floatValue());
        }
    }

    public void setPPtEditMode(LPConstants.PPTEditMode pptEditMode) {
        this.pptEditMode = pptEditMode;
        for (IShapePaintListener shapePaintListener : this.shapePaintListeners) {
            shapePaintListener.onShapeEditModeChange(pptEditMode);
        }
    }

    public LPConstants.PPTEditMode getPPtEditMode() {
        return this.pptEditMode;
    }

    public void setTextSize(int textSize) {
        this.mTextSize = textSize;
        for (IShapePaintListener shapePaintListener : this.shapePaintListeners) {
            shapePaintListener.onShapeTextSizeChange(textSize);
        }
    }

    public void sendTextConfirmed(String beforeText, String textContent) {
        for (IShapePaintListener shapePaintListener : this.shapePaintListeners) {
            shapePaintListener.onSendDrawTextConfirmed(beforeText, textContent);
        }
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public float getCustomStrokeWidth() {
        return this.mCustomStrokeWidth;
    }

    public float getDoodleStrokeWidth() {
        Float width = this.mDoodleStrokeWidth.get(this.shapeSelectSrc);
        return width == null ? 0.0f : width.floatValue();
    }

    public int getShapeColor() {
        Integer color2 = this.mShapeColor.get(this.shapeSelectSrc);
        return color2 == null ? 0 : color2;
    }

    public BaseUIConstant.SelectSrc getShapeSelectSrc() {
        return this.shapeSelectSrc;
    }

    public void registerShapePaintListener(IShapePaintListener shapePaintListener) {
        this.shapePaintListeners.add(shapePaintListener);
    }

    public void unregisterShapePaintListener(IShapePaintListener shapePaintListener) {
        this.shapePaintListeners.remove(shapePaintListener);
    }

    public void removeAllListener() {
        this.shapePaintListeners.clear();
    }

    public static interface IShapePaintListener {
        public void onShapeCustomStrokeWidthChange(float var1);

        public void onShapeDoodleStrokeWidthChange(float var1);

        public void onShapeColorChange(int var1);

        public void onShapeTypeChange(LPConstants.ShapeType var1);

        public void onShapeEditModeChange(LPConstants.PPTEditMode var1);

        public void onShapeTextSizeChange(int var1);

        public void onSendDrawTextConfirmed(String var1, String var2);
    }
}

