/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbar;

import android.content.Context;
import android.view.View;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.liveuibase.widgets.toolbar.BaseDrawTextSettingWindow;
import com.baijiayun.liveuibase.widgets.toolbar.ColorSelectData;
import io.reactivex.disposables.Disposable;

public class DrawTextSettingWindow
extends BaseDrawTextSettingWindow {
    private Disposable disposableOfColorAllChange;
    IRouter iRouter;

    public DrawTextSettingWindow(Context context, IRouter iRouter) {
        super(context);
        this.iRouter = iRouter;
    }

    protected boolean initColorsSelect() {
        boolean rst = super.initColorsSelect();
        if (rst) {
            if (this.disposableOfColorAllChange != null) {
                this.disposableOfColorAllChange.dispose();
            }
            this.disposableOfColorAllChange = this.iRouter.getSubjectByKey(EventKey.DrawColorAllChange).ofType(String.class).subscribe(arg_0 -> ((DrawTextSettingWindow)this).handleColorAllChangeRst(arg_0));
        }
        return rst;
    }

    protected void onChangeColor(ColorSelectData colorSelectData) {
        this.iRouter.setObjectByKey(EventKey.IsChangedPaintColor, true);
        this.iRouter.getSubjectByKey(EventKey.DrawColorChange).onNext((Object)colorSelectData);
    }

    protected void onChangeTextSize(int textSize) {
        this.iRouter.getSubjectByKey(EventKey.DrawTextSizeChange).onNext((Object)textSize);
    }

    public void show(View anchor) {
        super.show(anchor);
        if (this.iRouter != null) {
            this.iRouter.getSubjectByKey(EventKey.DrawTextEnable).onNext((Object)true);
        }
    }

    public void onDestroy() {
        if (this.disposableOfColorAllChange != null) {
            this.disposableOfColorAllChange.dispose();
            this.disposableOfColorAllChange = null;
        }
    }
}

