/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.setting;

import android.content.Context;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.GroupClassActivity;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.livecore.LiveSDK;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPMirrorModeModel;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.widgets.SettingSwitch;
import com.baijiayun.liveuibase.widgets.setting.BaseSettingContract;
import com.baijiayun.liveuibase.widgets.setting.BaseSettingPresenter;
import com.baijiayun.liveuibase.widgets.setting.BaseSettingWindow;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.List;

public class SettingWindow
extends BaseSettingWindow {
    private IRouter iRouter;
    protected Disposable disposableOfOtherStudentVideo;
    protected Disposable disposableOfMirrorMode;
    protected Disposable disposableOfAudioBitrate;

    public SettingWindow(Context context) {
        super(context);
    }

    protected void initCameraContainer() {
        this.$camera.clearRefCache();
        this.updateCameraContainer();
        SettingSwitch definitionSwitch = (SettingSwitch)this.$camera.id(R.id.bjy_base_setting_camera_quality_switch).view();
        List resolutionTypeList = BaseUtilsKt.getResolutionList((LiveRoom)this.iRouter.getLiveRoom());
        List optionArray = BaseUtilsKt.getResolutionList((Context)this.context, (LiveRoom)this.iRouter.getLiveRoom());
        definitionSwitch.setSubOptionList(optionArray);
        definitionSwitch.setCheckedPosition(resolutionTypeList.indexOf(this.presenter.getVideoDefinition()));
        definitionSwitch.setOnCheckedChangeListener((buttonView, checkedPosition) -> {
            LPError lpError = this.presenter.setCaptureVideoDefinition((LPConstants.LPResolutionType)resolutionTypeList.get(checkedPosition));
            if (lpError != null) {
                this.showToastMessage(lpError.getMessage());
            }
        });
    }

    private void updateCameraContainer() {
        this.$camera.id(R.id.bjy_base_setting_camera_open_text).visibility(8);
        this.$camera.id(R.id.bjy_base_setting_camera_open_switch).visibility(8);
        this.$camera.id(R.id.bjy_base_setting_camera_orientation_text).visibility(8);
        this.$camera.id(R.id.bjy_base_setting_camera_orientation_switch).visibility(8);
    }

    protected void initBeautyContainer() {
        super.initBeautyContainer();
    }

    protected void initMicContainer() {
    }

    protected void initPPTContainer() {
        this.$ppt.clearRefCache();
        this.updatePPTContainer();
        ((SettingSwitch)this.$ppt.id(R.id.bjy_base_setting_ppt_quality_switch).view()).setCheckedStatus(LiveSDK.SHOW_STATIC_PPT_ORIGIN_SIZE);
        ((SettingSwitch)this.$ppt.id(R.id.bjy_base_setting_ppt_quality_switch).view()).setOnCheckedChangeListener((buttonView, checkedPosition) -> {
            if (checkedPosition == 0) {
                LiveSDK.SHOW_STATIC_PPT_ORIGIN_SIZE = true;
                this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getString(R.string.setting_ppt_definition_switch_to_original_tip));
                this.iRouter.getSubjectByKey(EventKey.UpdatePPTView).onNext((Object)true);
            } else {
                LiveSDK.SHOW_STATIC_PPT_ORIGIN_SIZE = false;
                this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getString(R.string.setting_ppt_definition_switch_to_smooth_tip));
                this.iRouter.getSubjectByKey(EventKey.UpdatePPTView).onNext((Object)false);
            }
        });
    }

    private void updatePPTContainer() {
        this.$ppt.id(R.id.bjy_base_setting_ppt_remark_text).visibility(8);
        this.$ppt.id(R.id.bjy_base_setting_ppt_remark_switch).visibility(8);
        this.$ppt.id(R.id.bjy_base_setting_ppt_show_way_text).visibility(8);
        this.$ppt.id(R.id.bjy_base_setting_ppt_show_way_switch).visibility(8);
        this.$ppt.id(R.id.bjy_base_setting_ppt_view_type_text).visibility(8);
        this.$ppt.id(R.id.bjy_base_setting_ppt_view_type_switch).visibility(8);
        this.$ppt.id(R.id.bjy_base_setting_student_preview_text).visibility(8);
        this.$ppt.id(R.id.bjy_base_setting_student_preview_switch).visibility(8);
        this.$ppt.id(R.id.bjy_base_setting_ppt_quality_text).visibility(0);
        this.$ppt.id(R.id.bjy_base_setting_ppt_quality_switch).visibility(0);
        this.$ppt.id(R.id.bjy_base_setting_ppt_quality_tip_text).visibility(0);
    }

    protected void initOtherContainer() {
        super.initOtherContainer();
        this.disposableOfAudioBitrate = this.iRouter.getLiveRoom().getRecorder().getObservableOfUpPacketLossRate().observeOn(AndroidSchedulers.mainThread()).subscribe(localStreamStats -> this.$other.id(R.id.bjy_base_setting_music_mode_debug_tv).text((CharSequence)("\u672c\u5730\u97f3\u9891\u7801\u7387\uff1a" + localStreamStats.audioBitrateSent + "Kbps")));
    }

    protected void initRoomControlContainer() {
        this.$roomControl.clearRefCache();
        this.updateRoomControlContainer();
        boolean hideOtherStudentVideo = this.iRouter.getSubjectValueByKey(EventKey.HideOtherStudentVideo, Boolean.class, false);
        ((SettingSwitch)this.$roomControl.id(R.id.bjy_base_setting_see_teacher_switch).view()).setCheckedStatus(hideOtherStudentVideo);
        this.disposableOfOtherStudentVideo = this.iRouter.getLiveRoom().getObservableOfDisableOtherStudentVideo().observeOn(AndroidSchedulers.mainThread()).subscribe(lpDisableOtherStuVideoModel -> ((SettingSwitch)this.$roomControl.id(R.id.bjy_base_setting_see_teacher_switch).view()).setCheckedStatus(lpDisableOtherStuVideoModel.isDisable(), true));
        ((SettingSwitch)this.$roomControl.id(R.id.bjy_base_setting_see_teacher_switch).view()).setOnCheckedChangeListener((buttonView, checkedPosition) -> this.iRouter.getSubjectByKey(EventKey.HideOtherStudentVideo).onNext((Object)(checkedPosition == 0 ? 1 : 0)));
        this.onMirrorModeChange(null, this.presenter.getHorizontalMirrorModeSet(), this.presenter.getVerticalMirrorModeSet());
        this.disposableOfMirrorMode = this.iRouter.getLiveRoom().getSpeakQueueVM().getObservableOfMirrorMode().observeOn(AndroidSchedulers.mainThread()).subscribe(lpMirrorModeModel -> this.onMirrorModeChange((LPMirrorModeModel)lpMirrorModeModel, this.iRouter.getLiveRoom().getSpeakQueueVM().getHorizontalMirrorModeSet(), this.iRouter.getLiveRoom().getSpeakQueueVM().getVerticalMirrorModeSet()));
        this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_open).clicked(v -> {
            this.iRouter.getLiveRoom().requestMirrorMode(true, this.iRouter.getLiveRoom().getSpeakQueueVM().getVerticalMirrorModeSet().contains(this.iRouter.getLiveRoom().getCurrentUser().getNumber()));
            this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getResources().getString(R.string.bjy_group_open_horizontal_mirror_mode_tip));
        });
        this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_open).clicked(v -> {
            this.iRouter.getLiveRoom().requestMirrorMode(this.iRouter.getLiveRoom().getSpeakQueueVM().getHorizontalMirrorModeSet().contains(this.iRouter.getLiveRoom().getCurrentUser().getNumber()), true);
            this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getResources().getString(R.string.bjy_group_open_vertical_mirror_mode_tip));
        });
        this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_close).clicked(v -> {
            this.iRouter.getLiveRoom().requestMirrorMode(false, this.iRouter.getLiveRoom().getSpeakQueueVM().getVerticalMirrorModeSet().contains(this.iRouter.getLiveRoom().getCurrentUser().getNumber()));
            this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getResources().getString(R.string.bjy_group_close_horizontal_mirror_mode_tip));
        });
        this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_close).clicked(v -> {
            this.iRouter.getLiveRoom().requestMirrorMode(this.iRouter.getLiveRoom().getSpeakQueueVM().getHorizontalMirrorModeSet().contains(this.iRouter.getLiveRoom().getCurrentUser().getNumber()), false);
            this.iRouter.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.context.getResources().getString(R.string.bjy_group_close_vertical_mirror_mode_tip));
        });
    }

    private void updateRoomControlContainer() {
        this.$roomControl.id(R.id.bjy_base_setting_forbid_raise_hands_text).visibility(8);
        this.$roomControl.id(R.id.bjy_base_setting_forbid_raise_hands_switch).visibility(8);
        this.$roomControl.id(R.id.bjy_base_setting_forbid_all_text).visibility(8);
        this.$roomControl.id(R.id.bjy_base_setting_forbid_all_switch).visibility(8);
        this.$roomControl.id(R.id.bjy_base_setting_auto_pip_text).visibility(8);
        this.$roomControl.id(R.id.bjy_base_setting_auto_pip_switch).visibility(8);
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
            this.$roomControl.id(R.id.bjy_base_setting_see_teacher_text).visibility(0);
            this.$roomControl.id(R.id.bjy_base_setting_see_teacher_switch).visibility(0);
            this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_text).visibility(8);
            this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_open).visibility(8);
            this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_close).visibility(8);
            this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_text).visibility(8);
            this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_open).visibility(8);
            this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_close).visibility(8);
        }
    }

    protected BaseSettingPresenter initPresenter() {
        return new BaseSettingPresenter((BaseSettingContract.BaseSettingView)this){

            public void showBleDialog() {
                SettingWindow.this.iRouter.getSubjectByKey(EventKey.DisPlayBleDialog).onNext((Object)true);
            }
        };
    }

    protected void initChildData() {
        this.iRouter = ((GroupClassActivity)this.context).getRouter();
        this.presenter.subscribe(this.iRouter.getLiveRoom());
    }

    public void onDestroy() {
        RxUtils.dispose((Disposable)this.disposableOfMirrorMode);
        RxUtils.dispose((Disposable)this.disposableOfOtherStudentVideo);
        RxUtils.dispose((Disposable)this.disposableOfAudioBitrate);
        super.onDestroy();
    }

    protected void onCloseWindow() {
        this.routerListener.onDismissSetting();
    }
}

