/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.layer;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.layer.BaseLayerOfProfessionalClass;
import com.baijiayun.groupclassui.util.FECompatUtil;
import com.baijiayun.groupclassui.window.video.VideoContainerWindow;
import com.baijiayun.groupclassui.window.video.VideoWindow;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.models.LPPlayerViewUpdateModel;
import com.baijiayun.liveuibase.base.IWindow;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VideoDragLayer
extends BaseLayerOfProfessionalClass {
    private static final String TAG = VideoDragLayer.class.getCanonicalName();
    private float videoOriginX;
    private float videoOriginY;
    private OnVideoResetListener onVideoResetListener;
    private List<VideoContainerWindow> videoContainerWindows;
    private int seatContainerWidth;
    private int seatContainerHeight;

    public void setSeatContainerWidth(int measuredWidth) {
        this.seatContainerWidth = measuredWidth;
    }

    public void setSeatContainerHeight(int measuredHeight) {
        this.seatContainerHeight = measuredHeight;
    }

    public VideoDragLayer(@NonNull Context context) {
        super(context);
    }

    public VideoDragLayer(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public VideoDragLayer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public VideoDragLayer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void init() {
        super.init();
        this.videoContainerWindows = new ArrayList<VideoContainerWindow>();
    }

    public void startEnlarge(float scale, VideoContainerWindow pressedContainerWindow, float startX, float startY) {
        Log.d((String)TAG, (String)("startEnlarge: " + startX + "..." + startY));
        this.videoOriginX = startX;
        this.videoOriginY = startY;
        View view = pressedContainerWindow.getView();
        int[] viewPositions = new int[2];
        view.getLocationOnScreen(viewPositions);
        if (pressedContainerWindow.getVideoWindow().getView().getParent() != null) {
            FrameLayout parent = (FrameLayout)pressedContainerWindow.getVideoWindow().getView().getParent();
            parent.removeView(view);
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.width = (int)((float)view.getMeasuredWidth() * scale);
        params.height = (int)((float)view.getMeasuredHeight() * scale);
        if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.DEFAULT) {
            params.leftMargin = view.getLeft() - (params.width - view.getMeasuredWidth()) / 2;
            params.topMargin = view.getTop() - (params.height - view.getMeasuredHeight()) / 2;
        } else if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
            params.leftMargin = this.getMeasuredWidth() - view.getMeasuredWidth() - (params.width - view.getMeasuredWidth()) / 2;
            params.topMargin = view.getTop() - (params.height - view.getMeasuredHeight()) / 2;
        } else {
            params.leftMargin = view.getLeft() - (params.width - view.getMeasuredWidth()) / 2;
            int[] containerPositions = new int[2];
            this.getLocationOnScreen(containerPositions);
            params.topMargin = viewPositions[1] - containerPositions[1] - (params.height - view.getMeasuredHeight());
        }
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        VideoContainerWindow videoContainerWindow = new VideoContainerWindow(this.getContext(), pressedContainerWindow.getVideoWindow());
        videoContainerWindow.showScaleIcon(false);
        this.addWindow((IWindow)videoContainerWindow, params);
        this.videoContainerWindows.add(videoContainerWindow);
    }

    public void scrollVideo(float currX, float currY) {
        Log.d((String)TAG, (String)("draggingVideo: " + currX + "..." + currY + "...count=" + this.getChildCount()));
        if (this.getChildCount() == 0) {
            return;
        }
        View child = this.getChildAt(this.getChildCount() - 1);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)child.getLayoutParams();
        params.leftMargin += (int)(currX - this.videoOriginX);
        params.topMargin += (int)(currY - this.videoOriginY);
        if (params.leftMargin < 0) {
            params.leftMargin = 0;
        }
        if (params.topMargin < 0) {
            params.topMargin = 0;
        }
        if (params.leftMargin > this.getMeasuredWidth() - child.getMeasuredWidth()) {
            params.leftMargin = this.getMeasuredWidth() - child.getMeasuredWidth();
        }
        if (params.topMargin > this.getMeasuredHeight() - child.getMeasuredHeight()) {
            params.topMargin = this.getMeasuredHeight() - child.getMeasuredHeight();
        }
        child.setLayoutParams((ViewGroup.LayoutParams)params);
        this.videoOriginX = currX;
        this.videoOriginY = currY;
    }

    public void scrollEndEnlarge(float scale) {
        boolean isReset;
        if (this.getChildCount() == 0) {
            return;
        }
        VideoContainerWindow videoContainerWindow = this.videoContainerWindows.get(this.getChildCount() - 1);
        if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
            isReset = (float)videoContainerWindow.getView().getRight() > (float)this.getRight() - (float)videoContainerWindow.getView().getMeasuredWidth() * scale;
        } else {
            boolean bl = isReset = videoContainerWindow.getView().getTop() < videoContainerWindow.getView().getMeasuredHeight();
        }
        if (videoContainerWindow.getView().getMeasuredWidth() == 0) {
            isReset = true;
        }
        if (isReset) {
            if (this.onVideoResetListener != null) {
                this.onVideoResetListener.onReset(videoContainerWindow.getVideoWindow().getUserId(), videoContainerWindow.getVideoWindow());
                this.removeWindow((IWindow)videoContainerWindow);
                this.videoContainerWindows.remove(videoContainerWindow);
                Log.d((String)TAG, (String)("scrollEndEnlarge: reset video...video count =" + this.getChildCount()));
            }
        } else {
            this.removeWindow((IWindow)videoContainerWindow);
            this.videoContainerWindows.remove(videoContainerWindow);
            Set<LPPlayerViewUpdateModel.PlayerPosition> allList = this.router.getSetByKey(EventKey.AllPlayerViewList, LPPlayerViewUpdateModel.PlayerPosition.class);
            LPPlayerViewUpdateModel model = new LPPlayerViewUpdateModel();
            model.action = LPConstants.LPPlayerAction.ADD;
            model.id = model.mediaId = FECompatUtil.getIOSMediaIdFromMediaId(videoContainerWindow.getVideoWindow().getMediaId());
            LPPlayerViewUpdateModel.PlayerPosition playerPosition = new LPPlayerViewUpdateModel.PlayerPosition();
            int containerWidth = this.getMeasuredWidth();
            int containerHeight = this.getMeasuredHeight();
            int videoWindowLeft = videoContainerWindow.getView().getLeft();
            int videoWindowTop = videoContainerWindow.getView().getTop();
            int videoWindowWidth = videoContainerWindow.getVideoWindow().getView().getMeasuredWidth();
            int videoWindowHeight = videoContainerWindow.getVideoWindow().getView().getMeasuredHeight();
            if ((float)videoWindowLeft + (float)videoWindowWidth * scale > (float)this.getRight()) {
                videoWindowLeft = (int)((float)this.getRight() - (float)videoWindowWidth * scale);
            }
            if ((float)videoWindowTop + (float)videoWindowHeight * scale > (float)this.getBottom()) {
                videoWindowTop = (int)((float)this.getBottom() - (float)videoWindowHeight * scale);
            }
            if (this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
                if (this.seatContainerWidth != 0) {
                    containerWidth -= this.seatContainerWidth;
                }
            } else if (this.seatContainerHeight != 0) {
                containerHeight -= this.seatContainerHeight;
                videoWindowTop -= this.seatContainerHeight;
            }
            playerPosition.id = model.id;
            playerPosition.width = String.valueOf((float)videoWindowWidth * scale / (float)containerWidth);
            playerPosition.height = String.valueOf((float)videoWindowHeight * scale / (float)containerHeight);
            playerPosition.x = String.valueOf((float)videoWindowLeft * 1.0f / (float)containerWidth);
            playerPosition.y = String.valueOf((float)videoWindowTop * 1.0f / (float)containerHeight);
            if (null == allList) {
                allList = new HashSet<LPPlayerViewUpdateModel.PlayerPosition>();
            }
            allList.add(playerPosition);
            this.router.setObjectByKey(EventKey.AllPlayerViewList, allList);
            model.all = allList;
            this.router.getLiveRoom().getMediaVM().requestPlayerViewUpdate(model);
            Log.d((String)TAG, (String)("scrollEndEnlarge: join to blackboard...video count=" + this.getChildCount()));
        }
    }

    public void setOnVideoResetListener(OnVideoResetListener onVideoResetListener) {
        this.onVideoResetListener = onVideoResetListener;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (this.videoContainerWindows != null) {
            for (VideoContainerWindow window : this.videoContainerWindows) {
                window.onDestroy();
            }
            this.videoContainerWindows.clear();
        }
    }

    public static interface OnVideoResetListener {
        public void onReset(String var1, VideoWindow var2);
    }
}

