/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.layer;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.layer.BaseLayerOfProfessionalClass;
import com.baijiayun.groupclassui.util.InteractiveUtils;
import com.baijiayun.groupclassui.widget.DragRelativeLayout;
import com.baijiayun.groupclassui.window.BaseTitledWindow;
import com.baijiayun.groupclassui.window.bottommenu.SpeakApplyStatus;
import com.baijiayun.groupclassui.window.ppt.PPTTabLayer;
import com.baijiayun.groupclassui.window.ppt.PPTWindow;
import com.baijiayun.groupclassui.window.toolbar.ToolbarWindow;
import com.baijiayun.groupclassui.window.toolbox.browser.BrowserWindow2;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.listener.OnSpeakApplyCountDownListener;
import com.baijiayun.livecore.models.LPWebPageInfoModel;
import com.baijiayun.livecore.ppt.whiteboard.LaserShapeLayer;
import com.baijiayun.liveuibase.base.BaseWindow;
import com.baijiayun.liveuibase.base.IWindow;
import com.baijiayun.liveuibase.toolbox.browser.Tuple;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.widgets.common.ProgressCircleView;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import java.util.ArrayList;
import java.util.List;

public class FullScreenLayer
extends BaseLayerOfProfessionalClass {
    private BaseTitledWindow fullScreenWindow;
    private List<PPTWindow> pptWindows;
    private BaseWindow fullBrowserWindow;
    private ToolbarWindow toolbarWindow;
    private DragRelativeLayout.OnUpdateLayoutParamsListener listener;
    private FrameLayout handsUpContainer;
    private boolean isNeedRemoveSwitchWindow = true;
    private SpeakApplyStatus speakApplyStatus = SpeakApplyStatus.None;
    private LaserShapeLayer laserShapeLayer;
    private BaseLayerOfProfessionalClass pptTabLayer;
    private View.OnLayoutChangeListener onLayoutChangeListener = (v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> {
        if (this.toolbarWindow != null) {
            this.toolbarWindow.setDragParam(right - left, bottom - top);
        }
    };

    public FullScreenLayer(@NonNull Context context) {
        super(context);
    }

    public ToolbarWindow getToolBarWindow() {
        return this.toolbarWindow;
    }

    @Override
    public boolean onRoomStatusChange(boolean isRoomActive) {
        boolean isLayerInit = super.onRoomStatusChange(isRoomActive);
        if (isLayerInit) {
            if (isRoomActive) {
                this.subscribe();
            } else {
                this.removeAllViews();
            }
        }
        return true;
    }

    private void subscribe() {
        this.pptWindows = new ArrayList<PPTWindow>();
        if (this.toolbarWindow == null) {
            this.toolbarWindow = new ToolbarWindow(this.getContext(), true);
            this.addOnLayoutChangeListener(this.onLayoutChangeListener);
            this.toolbarWindow.setDragParam(this.getWidth(), this.getHeight());
        }
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.SetFullScreenWindowOn).observeOn(AndroidSchedulers.mainThread()).subscribe(c -> {
            if (c instanceof BrowserWindow2) {
                this.fullBrowserWindow = (BrowserWindow2)((Object)((Object)c));
                UtilsKt.removeViewFromParent((View)this.fullBrowserWindow.getView());
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
                this.addWindow((IWindow)this.fullBrowserWindow, layoutParams);
                if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                    this.showHansUp();
                }
            } else if (c instanceof BaseTitledWindow) {
                PPTTabLayer pptTabLayer;
                if (this.fullScreenWindow != null && !(this.fullScreenWindow instanceof PPTWindow)) {
                    UtilsKt.removeViewFromParent((View)this.fullScreenWindow.getView());
                }
                this.fullScreenWindow = (BaseTitledWindow)c;
                UtilsKt.removeViewFromParent((View)this.fullScreenWindow.getView());
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
                this.addWindow((IWindow)this.fullScreenWindow, layoutParams);
                if (c instanceof PPTWindow && BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom()) && (pptTabLayer = this.router.getValueByKey(EventKey.PPTTabLayer, PPTTabLayer.class)) != null) {
                    UtilsKt.removeViewFromParent((View)pptTabLayer);
                    int fullScreenWindowIndex = this.indexOfChild(this.fullScreenWindow.getView()) + 1;
                    if (fullScreenWindowIndex < this.getChildCount()) {
                        this.addView((View)pptTabLayer, fullScreenWindowIndex);
                    } else {
                        this.addView((View)pptTabLayer);
                    }
                }
                if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                    this.showHansUp();
                }
                if (c instanceof PPTWindow) {
                    this.pptWindows.remove(c);
                    this.pptWindows.add((PPTWindow)this.fullScreenWindow);
                    if (this.laserShapeLayer != null) {
                        this.laserShapeLayer.bringToFront();
                    }
                    if (InteractiveUtils.hasDrawingAuth(this.router.getLiveRoom(), this.router.getLiveRoom().getCurrentUser()) || InteractiveUtils.hasPPTAuth(this.router.getLiveRoom(), this.router.getLiveRoom().getCurrentUser()) || InteractiveUtils.hasScreenShareAuth(this.router.getLiveRoom(), this.router.getLiveRoom().getCurrentUser())) {
                        this.initListener();
                        if (this.toolbarWindow.getView().getParent() == null) {
                            this.addView(this.toolbarWindow.getView());
                        } else {
                            this.toolbarWindow.getView().bringToFront();
                        }
                    }
                }
            } else if (this.fullScreenWindow != null) {
                if (c instanceof Boolean) {
                    this.isNeedRemoveSwitchWindow = (Boolean)c;
                }
                this.removeWindow((IWindow)this.fullScreenWindow);
                if (this.fullScreenWindow instanceof PPTWindow) {
                    ((PPTWindow)this.fullScreenWindow).resetInFull(false);
                }
                this.fullScreenWindow = null;
            }
            if (this.laserShapeLayer != null) {
                this.laserShapeLayer.bringToFront();
            }
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.PPTWindowBringToFront).ofType(String.class).mergeWith((ObservableSource)this.router.getSubjectByKey(EventKey.PPTWindowBringToFrontLocal).ofType(String.class)).subscribe(s -> {
            if (this.toolbarWindow != null && this.toolbarWindow.getView().getParent() instanceof FullScreenLayer) {
                this.toolbarWindow.getView().bringToFront();
            }
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.SetFullScreenWindowOff).subscribe(c -> {
            if (c == this.fullBrowserWindow) {
                this.fullBrowserWindow = null;
            }
            if (c == this.fullScreenWindow) {
                this.fullScreenWindow = null;
            }
            if (this.isNeedRemoveSwitchWindow && this.fullBrowserWindow != null) {
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
                this.addWindow((IWindow)this.fullBrowserWindow, layoutParams);
            }
            this.isNeedRemoveSwitchWindow = true;
            this.pptWindows.clear();
            this.removeAllViews();
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.RemoveFullScreenWindow).subscribe(o -> this.removeAllViews()));
        this.compositeDisposable.add(this.router.getLiveRoom().getMediaVM().getObservableOfPlayerViewUpdate().observeOn(AndroidSchedulers.mainThread()).subscribe(lpPlayerViewUpdateModel -> {
            if (lpPlayerViewUpdateModel.action == LPConstants.LPPlayerAction.REMOVE) {
                this.hideHandsUp();
            }
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.LaserLayerFullScreen).ofType(LaserShapeLayer.class).subscribe(laserShapeLayer -> {
            UtilsKt.removeViewFromParent((View)laserShapeLayer);
            int fullScreenWindowIndex = 0;
            if (this.fullScreenWindow != null && this.fullScreenWindow.getParentViewGroup() == this) {
                fullScreenWindowIndex = this.indexOfChild(this.fullScreenWindow.getView()) + 1;
            }
            if (this.fullScreenWindow != null && this.fullScreenWindow instanceof PPTWindow && ((PPTWindow)this.fullScreenWindow).getPPTView() != null) {
                laserShapeLayer.setDocInfo(((PPTWindow)this.fullScreenWindow).getRealDocId(), ((PPTWindow)this.fullScreenWindow).getPPTView().getCurrentPageIndex());
            }
            this.addView((View)laserShapeLayer, fullScreenWindowIndex, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.laserShapeLayer = laserShapeLayer;
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.ClosePPTWindow).ofType(Tuple.class).subscribe(s -> {
            if (this.fullScreenWindow == null) {
                return;
            }
            for (PPTWindow pptWindow : this.pptWindows) {
                if (!s.docId.equals(pptWindow.getId())) continue;
                this.removePPTWindow(pptWindow);
                break;
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getDocListVM().getObservableOfDocViewUpdate().observeOn(AndroidSchedulers.mainThread()).subscribe(lpDocViewUpdateModel -> {
            if ("remove".equals(lpDocViewUpdateModel.action)) {
                for (PPTWindow pptWindow : this.pptWindows) {
                    if (!lpDocViewUpdateModel.docId.equals(pptWindow.getId())) continue;
                    this.removePPTWindow(pptWindow);
                    break;
                }
            }
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.OpenBrowserWindow).ofType(Boolean.class).subscribe(aBoolean -> {
            if (this.fullBrowserWindow == null) {
                return;
            }
            if (!aBoolean.booleanValue()) {
                this.removeWindow((IWindow)this.fullBrowserWindow);
                this.fullBrowserWindow = null;
            }
        }));
        this.compositeDisposable.add(this.router.getSubjectByKey(EventKey.CloseBrowserWindow).ofType(Boolean.class).subscribe(aBoolean -> {
            this.removeWindow((IWindow)this.fullBrowserWindow);
            if (this.fullBrowserWindow != null) {
                LPWebPageInfoModel webPageInfoModel = new LPWebPageInfoModel();
                webPageInfoModel.status = 0;
                webPageInfoModel.id = ((BrowserWindow2)this.fullBrowserWindow).getId();
                webPageInfoModel.actionType = 0;
                this.router.getLiveRoom().getToolBoxVM().requestOpenWebPage(webPageInfoModel);
                ((BrowserWindow2)this.fullBrowserWindow).isAdd = false;
                this.router.getSubjectByKey(EventKey.AddWebpage).onNext((Object)this.fullBrowserWindow);
                ((BrowserWindow2)this.fullBrowserWindow).clearBroadcastCache();
                ((BrowserWindow2)this.fullBrowserWindow).onDestroy();
                this.fullBrowserWindow = null;
                if (this.pptWindows == null || this.pptWindows.isEmpty()) {
                    this.router.getSubjectByKey(EventKey.ResetFullScreen).onNext((Object)true);
                }
            }
        }));
        this.compositeDisposable.add(this.router.getLiveRoom().getToolBoxVM().getObservableOfWebPageInfo().observeOn(AndroidSchedulers.mainThread()).subscribe(webPageInfoModel -> {
            if (this.fullBrowserWindow == null) {
                return;
            }
            if (this.pptWindows == null || this.pptWindows.isEmpty()) {
                this.router.getSubjectByKey(EventKey.ResetFullScreen).onNext((Object)true);
            }
            if (!webPageInfoModel.isOpenStatus()) {
                if (!BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())) {
                    this.removeWindow((IWindow)this.fullBrowserWindow);
                    this.fullBrowserWindow.onDestroy();
                    this.fullBrowserWindow = null;
                }
                this.hideHandsUp();
            }
        }));
    }

    private void initListener() {
        this.toolbarWindow.setOnUpdateLayoutParamsListener(new DragRelativeLayout.OnUpdateLayoutParamsListener(){

            @Override
            public void onUpdateLayoutParams(int left, int top, int right, int bottom) {
            }

            @Override
            public void onActionDown() {
                if (FullScreenLayer.this.listener != null) {
                    FullScreenLayer.this.listener.onActionDown();
                }
            }
        });
    }

    private void removePPTWindow(PPTWindow pptWindow) {
        this.removeWindow((IWindow)pptWindow);
        if (this.fullScreenWindow instanceof PPTWindow && pptWindow == this.fullScreenWindow) {
            this.removeAllViews();
            this.fullScreenWindow = null;
        }
    }

    private void showHansUp() {
        this.hideHandsUp();
        ImageView iv = new ImageView(this.getContext());
        iv.setImageResource(R.drawable.ic_interactive_hand_up);
        iv.setSelected(false);
        iv.setEnabled(this.speakApplyStatus == SpeakApplyStatus.None);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        iv.setLayoutParams((ViewGroup.LayoutParams)params);
        final ProgressCircleView circleView = new ProgressCircleView(this.getContext());
        circleView.setVisibility(4);
        this.handsUpContainer = new FrameLayout(this.getContext());
        this.handsUpContainer.addView((View)iv, (ViewGroup.LayoutParams)params);
        this.handsUpContainer.addView((View)circleView, (ViewGroup.LayoutParams)params);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(UtilsKt.getDp((int)40), UtilsKt.getDp((int)40));
        layoutParams.gravity = 0x800055;
        layoutParams.rightMargin = UtilsKt.getDp((int)15);
        layoutParams.bottomMargin = UtilsKt.getDp((int)15);
        this.addView((View)this.handsUpContainer, (ViewGroup.LayoutParams)layoutParams);
        iv.setOnClickListener(view -> {
            if (!this.router.getLiveRoom().isClassStarted()) {
                this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getContext().getString(R.string.bjysc_closed_class_not_start_error));
                return;
            }
            if (this.speakApplyStatus == SpeakApplyStatus.None) {
                if (this.router.getLiveRoom().getForbidRaiseHandStatus()) {
                    this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getContext().getString(R.string.bjysc_forbid_send_message));
                    return;
                }
                this.router.getLiveRoom().getSpeakQueueVM().requestSpeakApply(new OnSpeakApplyCountDownListener(){

                    public void onTimeOut() {
                        FullScreenLayer.this.speakApplyStatus = SpeakApplyStatus.None;
                        FullScreenLayer.this.router.getLiveRoom().getSpeakQueueVM().cancelSpeakApply();
                        FullScreenLayer.this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)FullScreenLayer.this.getContext().getString(R.string.bjysc_speak_apply_disagree));
                    }

                    public void onTimeCountDown(int counter, int timeOut) {
                        circleView.setVisibility(0);
                        circleView.setRatio((float)(timeOut - counter) / (float)timeOut);
                    }
                });
                this.speakApplyStatus = SpeakApplyStatus.Applying;
            } else if (this.speakApplyStatus == SpeakApplyStatus.Applying) {
                this.speakApplyStatus = SpeakApplyStatus.None;
                this.router.getLiveRoom().getSpeakQueueVM().cancelSpeakApply();
                iv.setSelected(false);
                iv.setEnabled(true);
                circleView.setVisibility(4);
            } else if (this.speakApplyStatus == SpeakApplyStatus.Speaking) {
                // empty if block
            }
        });
        this.compositeDisposable.add(this.router.getLiveRoom().getSpeakQueueVM().getObservableOfSpeakResponse().filter(iMediaControlModel -> iMediaControlModel.getUser().getUserId().equals(this.router.getLiveRoom().getCurrentUser().getUserId()) && !BaseUtilsKt.isAdmin((LiveRoom)this.router.getLiveRoom())).observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaControlModel -> {
            if (iMediaControlModel.isApplyAgreed()) {
                iv.setEnabled(false);
                circleView.setVisibility(4);
                this.speakApplyStatus = SpeakApplyStatus.Speaking;
            } else {
                this.speakApplyStatus = SpeakApplyStatus.None;
                if (!iMediaControlModel.getSenderUserId().equals(this.router.getLiveRoom().getCurrentUser().getUserId())) {
                    iv.setEnabled(true);
                    iv.setSelected(false);
                    circleView.setVisibility(4);
                }
            }
        }));
    }

    private void hideHandsUp() {
        if (this.handsUpContainer != null) {
            this.removeView((View)this.handsUpContainer);
        }
        this.handsUpContainer = null;
    }

    public void setOnUpdateLayoutParamsListener(DragRelativeLayout.OnUpdateLayoutParamsListener listener) {
        this.listener = listener;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.fullScreenWindow = null;
    }
}

