/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.utils.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;

public class NetUtils {
    public static String getAPNType(Context context) {
        String netType = "";
        ConnectivityManager manager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (manager == null) {
            return "Unknown";
        }
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return "Unknown";
        }
        int nType = networkInfo.getType();
        if (nType == 1) {
            netType = "WI-FI";
        } else if (nType == 0) {
            int nSubType = networkInfo.getSubtype();
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager == null) {
                return "Unknown";
            }
            netType = nSubType >= 13 && nSubType <= 19 && !telephonyManager.isNetworkRoaming() ? "4G" : ((nSubType == 3 || nSubType == 8 || nSubType == 5) && !telephonyManager.isNetworkRoaming() ? "3G" : ((nSubType == 1 || nSubType == 2 || nSubType == 4) && !telephonyManager.isNetworkRoaming() ? "2G" : "Unknown"));
        }
        return netType;
    }

    public static int getNetworkType(Context context) {
        if (context == null) {
            return -1;
        }
        ConnectivityManager connectMgr = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (connectMgr == null) {
            return 0;
        }
        NetworkInfo networkInfo = connectMgr.getActiveNetworkInfo();
        if (networkInfo == null) {
            return 0;
        }
        if (!networkInfo.isConnected()) {
            return 1;
        }
        if (networkInfo.getType() == 9) {
            return 2;
        }
        if (networkInfo.getType() == 1) {
            return 3;
        }
        if (networkInfo.getType() == 0) {
            return 4;
        }
        return -1;
    }

    public static int getSpecificNet(Context context) {
        ConnectivityManager connectMgr = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectMgr == null) {
            return -1;
        }
        NetworkInfo networkInfo = connectMgr.getActiveNetworkInfo();
        if (networkInfo == null) {
            return -1;
        }
        return networkInfo.getType();
    }
}

