/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livebase.widgets.view.webview;

import android.app.AlertDialog;
import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.baijiayun.livebase.network.alilog.AliYunLogHelper;
import com.tencent.smtt.export.external.interfaces.SslError;
import com.tencent.smtt.export.external.interfaces.SslErrorHandler;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import org.jetbrains.annotations.NotNull;

public class BJWebViewImpl
extends WebView {
    public BJWebViewImpl(@NotNull Context context) {
        this(context, null);
    }

    public BJWebViewImpl(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public BJWebViewImpl(@NotNull Context context, @Nullable AttributeSet attributeSet, int defStyle) {
        super(context, attributeSet, defStyle);
        this.init();
    }

    private void init() {
        this.setVerticalScrollbarOverlay(false);
        this.enableCache();
        this.getSettings().setJavaScriptEnabled(true);
        BJWebViewImpl.setWebContentsDebuggingEnabled((boolean)false);
    }

    public void enableCache() {
        this.getSettings().setCacheMode(-1);
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setDatabaseEnabled(true);
    }

    public void enableJavaScript(Object obj, String interfaceName) {
        this.addJavascriptInterface(obj, interfaceName);
    }

    public static class BJWebViewClient
    extends WebViewClient {
        public boolean shouldOverrideUrlLoading(WebView webView, String url) {
            return !url.startsWith("http://") && !url.startsWith("https://");
        }

        public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
            AliYunLogHelper.getInstance().addDebugLog("onReceivedSslError " + sslError.getUrl());
            AlertDialog.Builder builder = new AlertDialog.Builder(webView.getContext());
            builder.setMessage((CharSequence)"SSL\u8ba4\u8bc1\u5931\u8d25\uff0c\u662f\u5426\u7ee7\u7eed\u8bbf\u95ee\uff1f").setPositiveButton((CharSequence)"\u786e\u5b9a", (dialog, which) -> sslErrorHandler.proceed()).setNegativeButton((CharSequence)"\u53d6\u6d88", (dialog, which) -> sslErrorHandler.cancel());
            AlertDialog dialog2 = builder.create();
            dialog2.show();
        }
    }
}

